/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.sys.ricc.common.util.StringUtils;

public class OpenFilterFormUtil {
    private OpenFilterFormUtil() {
    }

    public static void showConditionForm(IFormView view, String conditionJson, String entityNumber, String fieldNodes, String plugin, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_exportall_filter");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void receiveCondition(IDataModel module, String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey, String descFldLKey) {
        if (StringUtils.isNotBlank(conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            exprTran = StringUtils.limitStringLength(2000, exprTran);
            if (StringUtils.isBlank(entryEntityKey)) {
                module.setValue(conditionFldKey, (Object)conditionJson);
                module.setValue(descFldKey, (Object)exprTran);
                module.setValue(descFldLKey, (Object)exprTran);
            } else {
                int row = module.getEntryCurrentRowIndex(entryEntityKey);
                module.setValue(conditionFldKey, (Object)conditionJson, row);
                module.setValue(descFldKey, (Object)exprTran, row);
                module.setValue(descFldLKey, (Object)exprTran, row);
            }
        }
    }
}

