/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.enums.BaseDataRightEnum;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.SqlImportUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class PermissionUtil {
    private static final Log logger = LogFactory.getLog(PermissionUtil.class);
    public static final String PERM_COMMROLE = "perm_role";
    public static final String PERM_BUSIROLE = "perm_busirole";
    public static final String RICC_COMMROLE = "RICC_COMMON_ROLE_S";
    public static final String RICC_COMMROLE_FID = "2DXP5S==O1VR";
    public static final String RICC_BIZROLE_FORBIDNEW = "RICC_FORBIDNEW_S";
    public static final long RICC_BIZROLE_FORBIDNEW_FID = 1407814994422136832L;
    public static final String RICC_BIZROLE_FORBIDMODIFY = "RICC_FORBIDMODIFY_S";
    public static final long RICC_BIZROLE_FORBIDMODIFY_FID = 1407809474541912064L;
    public static final String BIZROLEDISPERM = "bizroledisperm";
    public static final String GROUP = "2VTQI5A5IQD7";
    public static final String BIZ_ROLE = "bizrole";
    public static final String PERM_USER_BIZ_ROLE = "perm_userbizrole";
    public static final String PERM_USER_BIZROLE_TABLE = "t_perm_userbizrole";
    public static final String PERMISSION = "permission";
    private static final long[] SYSTEM_PREINS_USERIDS = new long[]{1L, 2L, 3L, 10L, 43007523L};

    private PermissionUtil() {
    }

    public static Map<String, Map<String, List<String>>> getControlledAppList() {
        logger.info("\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u6743\u9650\u9ed1\u540d\u5355\u5e94\u7528\u5f00\u59cb");
        HashMap<String, Map<String, List<String>>> blackMap = new HashMap<String, Map<String, List<String>>>(10);
        String basicDataPerm = SysParaUtil.getChangePermType();
        logger.info("\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3->\u53c2\u6570\u8bbe\u7f6e->\u57fa\u7840\u8bbe\u7f6e\u65b0\u589e\u53ca\u4fee\u6539\u53c2\u6570\u4e3a\uff1a" + basicDataPerm);
        if (BaseDataRightEnum.NO_DATA.getVal().equals(basicDataPerm) || BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal().equals(basicDataPerm)) {
            logger.info("\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u6682\u65e0\u9700\u8981\u505a\u6743\u9650\u9ed1\u540d\u5355\u5e94\u7528\uff01");
            return blackMap;
        }
        DynamicObject[] guideList = CommonQuery.getControlledItems();
        int guideSize = guideList.length;
        ArrayList<String> guidePageList = new ArrayList<String>(guideSize);
        for (int i = 0; i < guideSize; ++i) {
            DynamicObject guide = guideList[i];
            String number = guide.getString("number");
            guidePageList.add(number);
        }
        QFilter controlledFilter = new QFilter("page", "in", guidePageList);
        DynamicObject[] appcontrolledCollection = BusinessDataServiceHelper.load((String)"ricc_appcontrolledlist", (String)"id,app,page,perm,opuser,createtime", (QFilter[])controlledFilter.toArray());
        logger.info("\u67e5\u8be2\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u6743\u9650\u9ed1\u540d\u5355\u9875\u9762\u4e2a\u6570\uff1a" + appcontrolledCollection.length);
        DynamicObject[] bizObjAppCollection = PermissionUtil.getPublishAppCollection(guidePageList);
        for (DynamicObject dy : appcontrolledCollection) {
            String appid = dy.getString("app");
            String page = dy.getString("page");
            String perm = dy.getString("perm");
            HashMap<String, List<String>> permMap = new HashMap<String, List<String>>();
            List<String> permList = null;
            ArrayList<String> blackPermList = new ArrayList<String>();
            permList = Arrays.asList(perm.split(","));
            permList = new ArrayList<String>(permList);
            if (BaseDataRightEnum.HAVE_CHANGE_NONEW_PERM.getVal().equals(basicDataPerm)) {
                if (permList.contains("47156aff000000ac")) {
                    blackPermList.add("47156aff000000ac");
                }
                PermissionUtil.importExportPermBlackList(permList, blackPermList);
            } else if (BaseDataRightEnum.NO_NEWANDCHANGE_PERM.getVal().equals(basicDataPerm)) {
                if (permList.contains("47156aff000000ac")) {
                    blackPermList.add("47156aff000000ac");
                }
                if (permList.contains("4715a0df000000ac")) {
                    blackPermList.add("4715a0df000000ac");
                }
                PermissionUtil.importExportPermBlackList(permList, blackPermList);
            }
            permMap.put(page, blackPermList);
            PermissionUtil.putPermToBlackMap(blackMap, appid, permMap);
            PermissionUtil.bizObjPublishAppToBlack(blackMap, appid, page, bizObjAppCollection, blackPermList);
        }
        logger.info("\u5b9e\u9645\u751f\u6210\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u6743\u9650\u9ed1\u540d\u5355\u5e94\u7528\u4e2a\u6570\uff1a" + blackMap.size());
        return blackMap;
    }

    private static void bizObjPublishAppToBlack(Map<String, Map<String, List<String>>> blackMap, String appId, String pageId, DynamicObject[] bizObjAppCollection, List<String> blackPermList) {
        for (int i = 0; i < bizObjAppCollection.length; ++i) {
            HashMap<String, List<String>> permMap;
            DynamicObject bizObjApp = bizObjAppCollection[i];
            String publishPageId = bizObjApp.getString("bizobj.id");
            String publishAppId = bizObjApp.getString("bizapp.id");
            if (pageId.equals(publishPageId) && !appId.equals(publishAppId)) {
                ArrayList<String> copyBlackPermList = new ArrayList<String>();
                copyBlackPermList.addAll(blackPermList);
                HashMap<String, List<String>> permMap2 = new HashMap<String, List<String>>();
                permMap2.put(pageId, copyBlackPermList);
                PermissionUtil.putPermToBlackMap(blackMap, publishAppId, permMap2);
            }
            if ("botp_writebackrule".equals(pageId) && "botp_wrlistcheckin".equals(publishPageId)) {
                permMap = new HashMap<String, List<String>>();
                permMap.put("botp_wrlistcheckin", blackPermList);
                PermissionUtil.putPermToBlackMap(blackMap, publishAppId, permMap);
                PermissionUtil.putPermToBlackMap(blackMap, appId, permMap);
            }
            if (!"botp_crlist".equals(pageId) || !"botp_crlistcheckin".equals(publishPageId)) continue;
            permMap = new HashMap();
            permMap.put("botp_crlistcheckin", blackPermList);
            PermissionUtil.putPermToBlackMap(blackMap, publishAppId, permMap);
            PermissionUtil.putPermToBlackMap(blackMap, appId, permMap);
        }
    }

    public static void putPermToBlackMap(Map<String, Map<String, List<String>>> blackMap, String appId, Map<String, List<String>> permMap) {
        Map<String, List<String>> appIdValMap = blackMap.get(appId);
        if (appIdValMap != null) {
            appIdValMap.putAll(permMap);
        } else {
            blackMap.put(appId, permMap);
        }
    }

    private static void importExportPermBlackList(List<String> permList, List<String> blackPermList) {
        if (permList.contains("4730fc9f000003ae")) {
            blackPermList.add("4730fc9f000003ae");
        }
        if (permList.contains("4730fc9f000004ae")) {
            blackPermList.add("4730fc9f000004ae");
        }
    }

    public static DynamicObject getRiccCommonRole() {
        QFilter qFilter = new QFilter("number", "=", (Object)RICC_COMMROLE);
        DynamicObject commRole = BusinessDataServiceHelper.loadSingleFromCache((String)PERM_COMMROLE, (QFilter[])qFilter.toArray());
        if (commRole != null) {
            return commRole;
        }
        return PermissionUtil.initRiccCommonRole();
    }

    public static DynamicObject initRiccCommonRole() {
        DynamicObject commRole = BusinessDataServiceHelper.newDynamicObject((String)PERM_COMMROLE);
        commRole.set("number", (Object)RICC_COMMROLE);
        commRole.set("name.zh_CN", (Object)ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u9884\u7f6e\u89d2\u8272\uff08\u52ff\u4fee\u6539\uff09", (String)"PermissionUtil_37", (String)"sys-ricc-common", (Object[])new Object[0]));
        commRole.set("roletype", (Object)1);
        commRole.set("issystem", (Object)1);
        commRole.set("status", (Object)"C");
        commRole.set("enable", (Object)1);
        commRole.set("remark.zh_CN", (Object)ResManager.loadKDString((String)"\u7528\u4e8e\u914d\u7f6e\u7ba1\u63a7\u73af\u5883\u6743\u9650\u7ba1\u63a7\uff0c\u540e\u53f0\u7a0b\u5e8f\u5904\u7406\u4f7f\u7528", (String)"PermissionUtil_32", (String)"sys-ricc-common", (Object[])new Object[0]));
        commRole.set("createtime", (Object)1533722888L);
        commRole.set("creator", (Object)1L);
        commRole.set("modifytime", (Object)1533722888L);
        commRole.set("modifier", (Object)1L);
        commRole.set("group_id", (Object)GROUP);
        commRole.set("usescope", (Object)2);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)PERM_COMMROLE, (DynamicObject[])new DynamicObject[]{commRole}, (OperateOption)null);
        if (!operationResult.isSuccess()) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u901a\u7528\u89d2\u8272\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s%2$s", (String)"PermissionUtil_23", (String)"sys-ricc-common", (Object[])new Object[0]), operationResult.getMessage(), operationResult.getAllErrorOrValidateInfo().isEmpty() ? "" : operationResult.getAllErrorOrValidateInfo().toString()));
        }
        return commRole;
    }

    public static void initOrUpdateRiccBizDisabledPerm(Set<RiccBizPerm> riccBizPermSet) {
        DynamicObject[] guideList = CommonQuery.getControlledItems();
        int guideLength = guideList.length;
        if (guideLength <= 0) {
            return;
        }
        ArrayList<String> guidePageList = new ArrayList<String>(guideLength);
        for (DynamicObject oneGuide : guideList) {
            guidePageList.add(oneGuide.getString("rightpage.number"));
        }
        DynamicObject[] bizPublishAppCollection = PermissionUtil.getPublishAppCollection(guidePageList);
        ArrayList<DynamicObject> bizRoleList = new ArrayList<DynamicObject>(riccBizPermSet.size());
        Iterator<RiccBizPerm> it = riccBizPermSet.iterator();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        while (it.hasNext()) {
            DynamicObjectCollection bizroledispermCollecction;
            RiccBizPerm riccBizPerm = it.next();
            long permId = riccBizPerm.getId();
            String permNumber = riccBizPerm.getNumber();
            String nameCn = riccBizPerm.getName();
            String perm = riccBizPerm.getPerm();
            DynamicObject busiRole = BusinessDataServiceHelper.newDynamicObject((String)PERM_BUSIROLE);
            busiRole.set("id", (Object)permId);
            busiRole.set("number", (Object)permNumber);
            busiRole.set("name.zh_CN", (Object)nameCn);
            busiRole.set("usertype", (Object)1);
            busiRole.set("status", (Object)"A");
            busiRole.set("enable", (Object)1);
            busiRole.set("createtime", (Object)1533722888L);
            busiRole.set("creator", (Object)1L);
            DynamicObjectCollection roleCollecction = busiRole.getDynamicObjectCollection("role_entry");
            if (roleCollecction.isEmpty()) {
                DynamicObject commRoleEntry = new DynamicObject(roleCollecction.getDynamicObjectType());
                commRoleEntry.set("isenable_visible", (Object)1);
                commRoleEntry.set("seq", (Object)1);
                DynamicObject commRole = PermissionUtil.getRiccCommonRole();
                commRoleEntry.set("role_visible", (Object)commRole);
                roleCollecction.add(0, commRoleEntry);
                busiRole.set("role_entry", (Object)roleCollecction);
            }
            if (!(bizroledispermCollecction = busiRole.getDynamicObjectCollection(BIZROLEDISPERM)).isEmpty()) {
                bizroledispermCollecction.clear();
            }
            for (int i = 0; i < guideLength; ++i) {
                DynamicObject oneGuide = guideList[i];
                String pageId = oneGuide.getString("rightpage.number");
                String appId = oneGuide.getString("rightpage.bizappid");
                if (StringUtils.isEmpty(pageId)) continue;
                PermissionUtil.addOneGuideToDisablePerm(pageId, appId, bizroledispermCollecction, perm);
                PermissionUtil.bizObjPublishAppToDisblePerm(pageId, appId, bizPublishAppCollection, bizroledispermCollecction, perm);
            }
            DynamicObjectCollection bizroleOrgCollecction = busiRole.getDynamicObjectCollection("org_entry");
            if (bizroleOrgCollecction.isEmpty()) {
                DynamicObject orgEntry = new DynamicObject(bizroleOrgCollecction.getDynamicObjectType());
                orgEntry.set("isincludesuborg_visible", (Object)1);
                orgEntry.set("seq", (Object)1);
                orgEntry.set("dim_num", (Object)rootOrgId);
                orgEntry.set("dimentitynum", (Object)"bos_org");
                bizroleOrgCollecction.add(0, orgEntry);
                busiRole.set("org_entry", (Object)bizroleOrgCollecction);
            }
            busiRole.set(BIZROLEDISPERM, (Object)bizroledispermCollecction);
            bizRoleList.add(busiRole);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)PERM_BUSIROLE, (DynamicObject[])bizRoleList.toArray(new DynamicObject[bizRoleList.size()]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u521d\u59cb\u5316\u7981\u7528\u4e1a\u52a1\u89d2\u8272\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9519\u8bef\u539f\u56e0\uff1a%1$s%2$s", (String)"PermissionUtil_24", (String)"sys-ricc-common", (Object[])new Object[0]), operationResult.getMessage(), operationResult.getAllErrorOrValidateInfo().isEmpty() ? "" : operationResult.getAllErrorOrValidateInfo().toString()));
        }
    }

    public static void addOneGuideToDisablePerm(String pageId, String appId, DynamicObjectCollection bizroledispermCollecction, String perm) {
        for (DynamicObject oneEntry : bizroledispermCollecction) {
            String entitytypeforbid = oneEntry.getString("entitytypeforbid.id");
            if (!pageId.equals(entitytypeforbid)) continue;
            return;
        }
        DynamicObject bizroledispermEntry = new DynamicObject(bizroledispermCollecction.getDynamicObjectType());
        long entryId = DB.genLongId((String)"t_perm_bizroledisperm");
        bizroledispermEntry.set("id", (Object)entryId);
        bizroledispermEntry.set("permitemforbid", (Object)perm);
        bizroledispermEntry.set("entitytypeforbid", (Object)pageId);
        bizroledispermEntry.set("bizappforbid", (Object)appId);
        bizroledispermCollecction.add((Object)bizroledispermEntry);
    }

    public static void removeoneGuideFromDisablePerm(String pageId, DynamicObjectCollection bizroledispermCollecction) {
        Iterator bizroledispermIterator = bizroledispermCollecction.iterator();
        while (bizroledispermIterator.hasNext()) {
            DynamicObject bizroledisperm = (DynamicObject)bizroledispermIterator.next();
            String entitytypeforbid = bizroledisperm.getString("entitytypeforbid.id");
            if (!pageId.equals(entitytypeforbid)) continue;
            bizroledispermIterator.remove();
        }
    }

    public static void initOrUpdateRiccBizDisabledPerm() {
        RiccBizPerm riccBizPerm;
        Map<Object, DynamicObject> busRoleMap = PermissionUtil.getRiccBizRole();
        HashSet<RiccBizPerm> riccBizPermSet = new HashSet<RiccBizPerm>(2);
        if (!busRoleMap.containsKey(1407814994422136832L)) {
            riccBizPerm = new RiccBizPerm();
            riccBizPerm.setId(1407814994422136832L);
            riccBizPerm.setName(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u65b0\u589e\u6743\u9650\u7ba1\u63a7\u89d2\u8272\uff08\u52ff\u4fee\u6539\uff09", (String)"PermissionUtil_33", (String)"sys-ricc-common", (Object[])new Object[0]));
            riccBizPerm.setNumber(RICC_BIZROLE_FORBIDNEW);
            riccBizPerm.setPerm("47156aff000000ac");
            riccBizPerm.setDescription(ResManager.loadKDString((String)"\u7528\u4e8e\u914d\u7f6e\u7ba1\u63a7\u73af\u5883\u65b0\u589e\u6743\u9650\u7ba1\u63a7\uff0c\u540e\u53f0\u7a0b\u5e8f\u5904\u7406\u4f7f\u7528", (String)"PermissionUtil_34", (String)"sys-ricc-common", (Object[])new Object[0]));
            riccBizPermSet.add(riccBizPerm);
        }
        if (!busRoleMap.containsKey(1407809474541912064L)) {
            riccBizPerm = new RiccBizPerm();
            riccBizPerm.setId(1407809474541912064L);
            riccBizPerm.setName(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u4fee\u6539\u6743\u9650\u7ba1\u63a7\u89d2\u8272\uff08\u52ff\u4fee\u6539\uff09", (String)"PermissionUtil_35", (String)"sys-ricc-common", (Object[])new Object[0]));
            riccBizPerm.setNumber(RICC_BIZROLE_FORBIDMODIFY);
            riccBizPerm.setPerm("4715a0df000000ac");
            riccBizPerm.setDescription(ResManager.loadKDString((String)"\u7528\u4e8e\u914d\u7f6e\u7ba1\u63a7\u73af\u5883\u4fee\u6539\u6743\u9650\u7ba1\u63a7\uff0c\u540e\u53f0\u7a0b\u5e8f\u5904\u7406\u4f7f\u7528", (String)"PermissionUtil_36", (String)"sys-ricc-common", (Object[])new Object[0]));
            riccBizPermSet.add(riccBizPerm);
        }
        if (!riccBizPermSet.isEmpty()) {
            PermissionUtil.initOrUpdateRiccBizDisabledPerm(riccBizPermSet);
        }
    }

    public static Map<Object, DynamicObject> getRiccBizRole() {
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", (Object)new Long[]{1407809474541912064L, 1407814994422136832L})};
        return BusinessDataServiceHelper.loadFromCache((String)PERM_BUSIROLE, (QFilter[])qFilter);
    }

    public static DynamicObject[] getPublishAppCollection(List<String> guideList) {
        QFilter bizObjAppFilter = new QFilter("bizobj", "in", guideList);
        return BusinessDataServiceHelper.load((String)"perm_bizobjapp", (String)"bizobj, bizapp", (QFilter[])bizObjAppFilter.toArray());
    }

    public static void bizObjPublishAppToDisblePerm(String pageId, String appId, DynamicObject[] bizPublishAppCollection, DynamicObjectCollection bizroledispermCollecction, String perm) {
        for (int i = 0; i < bizPublishAppCollection.length; ++i) {
            DynamicObject bizObjApp = bizPublishAppCollection[i];
            String publishPageId = bizObjApp.getString("bizobj.id");
            String publishAppId = bizObjApp.getString("bizapp.id");
            if (StringUtils.isEmpty(publishPageId) || StringUtils.isEmpty(publishAppId)) {
                logger.info(String.format("\u53d1\u5e03\u5e94\u7528\uff0c\u9875\u9762\u6216\u8005\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0cpublishPageId:%s , publishAppId:%s", publishPageId, publishAppId));
                continue;
            }
            if (publishPageId.equals(pageId) && !publishAppId.equals(appId)) {
                PermissionUtil.addOneGuideToDisablePerm(publishPageId, publishAppId, bizroledispermCollecction, perm);
            }
            if ("botp_writebackrule".equals(pageId) && "botp_wrlistcheckin".equals(publishPageId)) {
                PermissionUtil.addOneGuideToDisablePerm("botp_wrlistcheckin", publishAppId, bizroledispermCollecction, perm);
            }
            if (!"botp_crlist".equals(pageId) || !"botp_crlistcheckin".equals(publishPageId)) continue;
            PermissionUtil.addOneGuideToDisablePerm("botp_crlistcheckin", publishAppId, bizroledispermCollecction, perm);
        }
    }

    public static void initOrUpdateRiccPerm(String oldBasicSetChange, String basicSetChange, DynamicObjectCollection exceptionUser, List<Object> kickOutUserList) {
        if (basicSetChange.equals(oldBasicSetChange)) {
            PermissionUtil.permNoChangeProcess(basicSetChange, exceptionUser, kickOutUserList);
        } else {
            PermissionUtil.permChangeProcess(basicSetChange, exceptionUser);
            logger.info(String.format("\u53c2\u6570\u914d\u7f6e\u73af\u5883\u5207\u6362,\u539f\u6765\u7684\u73af\u5883\u7c7b\u578b\u3010%1$s\u3011\uff0c\u5207\u6362\u540e\u73af\u5883\u7c7b\u578b\uff1a\u3010%2$s\u3011", !StringUtils.isEmpty(oldBasicSetChange) ? EnvRoleEnum.fromVal(oldBasicSetChange).getName() : ResManager.loadKDString((String)"\u672a\u914d\u7f6e", (String)"PermissionUtil_25", (String)"sys-ricc-common", (Object[])new Object[0]), EnvRoleEnum.fromVal(basicSetChange).getName()));
        }
    }

    public static List<Object> getbizRoleUserIdList(long bizModifyId) {
        List<Object> roleUserIdList = Collections.emptyList();
        QFilter[] qFilter = new QFilter[]{new QFilter(BIZ_ROLE, "=", (Object)bizModifyId)};
        DynamicObject[] roleUsers = BusinessDataServiceHelper.load((String)PERM_USER_BIZ_ROLE, (String)"user", (QFilter[])qFilter);
        if (roleUsers.length > 0) {
            roleUserIdList = new ArrayList<Object>(roleUsers.length);
            for (DynamicObject roleUser : roleUsers) {
                roleUserIdList.add(roleUser.getLong("user_id"));
            }
        }
        return roleUserIdList;
    }

    public static void delBizRoleUsers(List<Object> delUserIdList, long bizRoleId) {
        if (CollectionUtils.isEmpty(delUserIdList)) {
            logger.info(String.format("\u9700\u8981\u5c06\u4e1a\u52a1\u89d2\u8272\uff0c\u89d2\u8272id\u4e3a\u3010%s\u3011\u5206\u914d\u7528\u6237\u5220\u9664\u7684\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\u3002", bizRoleId));
            return;
        }
        int m = delUserIdList.size() / 200 + 1;
        List listAvg = ListUtil.averageAssign(delUserIdList, (int)m);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listAvg.size(); ++i) {
            List idsList = ((List)listAvg.get(i)).stream().map(String::valueOf).collect(Collectors.toList());
            String idsStr = String.join((CharSequence)",", idsList);
            sb.append("delete from t_perm_userbizrole");
            sb.append(" where ").append("fuserid").append(" in(").append(idsStr).append(')');
            sb.append(" and ").append("fbizroleid=").append(bizRoleId).append(';');
        }
        boolean isSuccess = SqlImportUtil.executeSql(DBRoute.base, sb.toString());
        if (!isSuccess) {
            throw new KDBizException(ResManager.loadKDString((String)"sql\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770bmonitor\u65e5\u5fd7", (String)"PermissionUtil_38", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
    }

    public static void addBizRoleUsers(List<Object> addUserIdList, long bizRoleId) {
        if (CollectionUtils.isEmpty(addUserIdList)) {
            logger.info(String.format("\u9700\u8981\u6dfb\u52a0\u5230\u4e1a\u52a1\u89d2\u8272\u3010%s\u3011\u7684\u5206\u914d\u7528\u6237\u6570\u636e\u4e3a\u7a7a", bizRoleId));
            return;
        }
        List<Object> oldUserIdList = PermissionUtil.getbizRoleUserIdList(bizRoleId);
        int size = addUserIdList.size();
        Iterator<Object> userIdsIterator = addUserIdList.iterator();
        long[] newFids = DB.genLongIds((String)PERM_USER_BIZROLE_TABLE, (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int j = 0;
        Object userId = null;
        while (userIdsIterator.hasNext()) {
            userId = userIdsIterator.next();
            if (oldUserIdList.contains(userId)) continue;
            paramList.add(new Object[]{newFids[j], userId, bizRoleId, null, null});
            ++j;
        }
        if (!paramList.isEmpty()) {
            String sql = "insert into t_perm_userbizrole (fid, fuserid, fbizroleid, fstarttime, fendtime) values(?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, paramList);
        }
    }

    public static void preOpenFormIsAdmin(PreOpenFormEventArgs e) {
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)UserServiceHelper.getCurrentUserId());
        if (isAdmin) {
            return;
        }
        e.setCancel(true);
        e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u8bf7\u4f7f\u7528administrator\u8d26\u53f7\u5728\u5b89\u5168\u7ba1\u7406-\u6743\u9650\u7ba1\u7406-\u7ba1\u7406\u5458\u4e2d\u6dfb\u52a0\u5f53\u524d\u7528\u6237\u4e3a\u7ba1\u7406\u5458\u540e\u65b9\u53ef\u4f7f\u7528\u3002", (String)"PermissionUtil_26", (String)"sys-ricc-common", (Object[])new Object[0]));
    }

    private static void permNoChangeProcess(String basicsetchange, DynamicObjectCollection exceptionUser, List<Object> kickoutUserList) {
        if (StringUtils.equals(BaseDataRightEnum.NO_NEWANDCHANGE_PERM.getVal(), basicsetchange)) {
            logger.info("\u57fa\u7840\u8bbe\u7f6e\u65b0\u589e\u53ca\u4fee\u6539\u672a\u6539\u53d8\uff0c\u4f8b\u5916\u7528\u6237\u6570\uff1a" + exceptionUser.size());
            UserPermGroup permUserGroup = new UserPermGroup(exceptionUser).invoke();
            List<Object> editPermUserIdList = permUserGroup.getEditPermUserIdList();
            List<Object> addAndEditPermUserIdList = permUserGroup.getAddAndEditPermUserIdList();
            PermissionUtil.initOrUpdateRiccBizDisabledPerm();
            PermissionUtil.delBizRoleUsers(addAndEditPermUserIdList, 1407814994422136832L);
            PermissionUtil.addBizRoleUsers(kickoutUserList, 1407814994422136832L);
            addAndEditPermUserIdList.addAll(editPermUserIdList);
            PermissionUtil.delBizRoleUsers(addAndEditPermUserIdList, 1407809474541912064L);
            PermissionUtil.addBizRoleUsers(kickoutUserList, 1407809474541912064L);
            kickoutUserList.addAll(editPermUserIdList);
            PermissionUtil.addBizRoleUsers(kickoutUserList, 1407814994422136832L);
        } else if (StringUtils.equals(BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal(), basicsetchange)) {
            logger.info("\u5f53\u524d\u73af\u5883\u89d2\u8272\u6709\u65b0\u589e\u4fee\u6539\u6743\u9650\uff0c\u65e0\u9700\u5904\u7406\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u7981\u7528\u89d2\u8272");
        } else {
            throw new RiccBizException(ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u57fa\u7840\u8bbe\u7f6e\u65b0\u589e\u53ca\u4fee\u6539\u6743\u9650\u914d\u7f6e\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermissionUtil_27", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
    }

    private static void permChangeProcess(String basicsetchange, DynamicObjectCollection exceptionUser) {
        if (StringUtils.equals(BaseDataRightEnum.NO_NEWANDCHANGE_PERM.getVal(), basicsetchange)) {
            QFilter userQfilter = PermissionUtil.getUserQFilter();
            List allUsers = QueryServiceHelper.queryPrimaryKeys((String)"bos_user", (QFilter[])userQfilter.toArray(), (String)"id", (int)-1);
            logger.info("\u57fa\u7840\u8bbe\u7f6e\u65b0\u589e\u53ca\u4fee\u6539\u6539\u53d8\uff0c\u603b\u7528\u6237\u6570\uff1a" + allUsers.size());
            UserPermGroup permUserGroup = new UserPermGroup(exceptionUser).invoke();
            List<Object> editPermUserIdList = permUserGroup.getEditPermUserIdList();
            List<Object> addAndEditPermUserIdList = permUserGroup.getAddAndEditPermUserIdList();
            PermissionUtil.initOrUpdateRiccBizDisabledPerm();
            allUsers.removeAll(addAndEditPermUserIdList);
            PermissionUtil.addBizRoleUsers(allUsers, 1407814994422136832L);
            allUsers.removeAll(editPermUserIdList);
            PermissionUtil.addBizRoleUsers(allUsers, 1407809474541912064L);
        } else {
            QFilter[] qFilter = new QFilter[]{new QFilter(BIZ_ROLE, "in", (Object)new Long[]{1407809474541912064L, 1407814994422136832L})};
            int resCount = DeleteServiceHelper.delete((String)PERM_USER_BIZ_ROLE, (QFilter[])qFilter);
            logger.info("\u7981\u7528\u65b0\u589e\u548c\u7981\u7528\u4fee\u6539\u7684\u4e24\u4e2a\u89d2\u8272\u7981\u7528\u7528\u6237\u5220\u9664\u6210\u529f\u4e2a\u6570\uff1a" + resCount);
        }
    }

    public static QFilter getUserQFilter() {
        QFilter staffFilter = new QFilter("id", "not in", (Object)SYSTEM_PREINS_USERIDS);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter forbiddenFilter = new QFilter("isforbidden", "=", (Object)"0");
        QFilter excludeRobotFilter = new QFilter("usertypes.fbasedataid", "=", (Object)1L);
        staffFilter = staffFilter.and(enableFilter).and(forbiddenFilter).and(excludeRobotFilter);
        return staffFilter;
    }

    public static String addUserToForbidRole(String number) {
        if (StringUtils.isEmpty(number)) {
            logger.info(String.format("ricc\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u6dfb\u52a0\u7528\u6237\u4e8b\u4ef6\u53d6\u6d88\uff0c\u5de5\u53f7\uff1a%s\u4e3a\u7a7a\u3002", number));
            return String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53d6\u6d88\uff0c\u5de5\u53f7\uff1a%s\u4e3a\u7a7a\u3002", (String)"PermissionUtil_28", (String)"sys-ricc-common", (Object[])new Object[0]), number);
        }
        boolean existConfig = QueryServiceHelper.exists((String)"ricc_initconfig", (Object)1367275628033736704L);
        if (!existConfig) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"PermissionUtil_29", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        String basicDataPerm = SysParaUtil.getChangePermType();
        if (BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal().equals(basicDataPerm)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6743\u9650\u8bbe\u7f6e\u4e3a\u5141\u8bb8\u65b0\u589e\u548c\u4fee\u6539\uff0c\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u7528\u6237\u52a0\u5165\u7981\u7528\u89d2\u8272\uff0c\u5de5\u53f7\uff1a%s\u7684\u6570\u636e\u65e0\u9700\u5904\u7406\u3002", (String)"PermissionUtil_30", (String)"sys-ricc-common", (Object[])new Object[0]), number);
        }
        QFilter userQfilter = new QFilter("number", "=", (Object)number);
        QFilter staffFilter = new QFilter("usertypes.fbasedataid", "=", (Object)1L);
        List users = QueryServiceHelper.queryPrimaryKeys((String)"bos_user", (QFilter[])new QFilter[]{userQfilter, staffFilter}, (String)"id", (int)1);
        if (users.isEmpty()) {
            logger.info(String.format("\u4e8b\u4ef6\u53d6\u6d88\uff0c\u5de5\u53f7\uff1a%s\u7684\u6570\u636e\u4e0d\u662f\u804c\u5458\u3002", number));
            return String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53d6\u6d88\uff0c\u5de5\u53f7\uff1a%s\u4e0d\u662f\u804c\u5458\u3002", (String)"PermissionUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]), number);
        }
        PermissionUtil.addOneUserToRiccRole(users);
        return String.format(ResManager.loadKDString((String)"\u5de5\u53f7\uff1a%s\u52a0\u5165\u7981\u7528\u89d2\u8272\u6210\u529f\uff01", (String)"PermissionUtil_31", (String)"sys-ricc-common", (Object[])new Object[0]), number);
    }

    private static void addOneUserToRiccRole(List<Object> users) {
        String exceptionPerm = PermissionUtil.riccExceptionUserPerm(users);
        if (BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal().equals(exceptionPerm)) {
            logger.info(String.format("\u8be5\u7528\u6237\u5df2\u52a0\u5165\u4f8b\u5916\u7528\u6237\uff0c\u4f8b\u5916\u6743\u9650\u4e3a\u5141\u8bb8\u65b0\u589e\u548c\u4fee\u6539\uff0c\u65e0\u9700\u52a0\u5165\u7981\u7528\u89d2\u8272\uff0c\u7528\u6237id\uff1a%s", users.get(0)));
            return;
        }
        QFilter qFilter = new QFilter(BIZ_ROLE, "in", (Object)new Long[]{1407809474541912064L, 1407814994422136832L}).and("user", "in", users);
        DynamicObject[] roleUsers = BusinessDataServiceHelper.load((String)PERM_USER_BIZ_ROLE, (String)"bizrole,user", (QFilter[])qFilter.toArray());
        logger.info(String.format("\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u7528\u6237\u5df2\u52a0\u5165\u7981\u7528\u89d2\u8272\u6570\uff1a%s", roleUsers.length));
        HashMap<Long, DynamicObject> roleUserMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject roleUser : roleUsers) {
            long bizroleId = roleUser.getLong("bizrole.id");
            roleUserMap.put(bizroleId, roleUser);
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(2);
        if (!roleUserMap.containsKey(1407809474541912064L) && !BaseDataRightEnum.HAVE_CHANGE_NONEW_PERM.getVal().equals(exceptionPerm)) {
            paramList.add(new Object[]{DB.genLongId((String)PERM_USER_BIZROLE_TABLE), users.get(0), 1407809474541912064L, null, null});
        }
        if (!roleUserMap.containsKey(1407814994422136832L)) {
            paramList.add(new Object[]{DB.genLongId((String)PERM_USER_BIZROLE_TABLE), users.get(0), 1407814994422136832L, null, null});
        }
        logger.info(String.format("\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u7528\u6237\u52a0\u5165\u7981\u7528\u89d2\u8272\u6570:%s", paramList.size()));
        if (!paramList.isEmpty()) {
            String sql = "insert into t_perm_userbizrole (fid, fuserid, fbizroleid, fstarttime, fendtime) values(?, ?, ?, ?, ?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, paramList);
        }
    }

    public static String riccExceptionUserPerm(List<Object> users) {
        String existSql = "SELECT fuserid,fexceptionperm FROM t_ricc_controlledusers WHERE fuserid=?";
        Object[] existParams = users.toArray();
        Map mapExist = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)existSql, (Object[])existParams, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = null;
                if (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("fuserid", rs.getString(1));
                    map.put("fexceptionperm", rs.getString(2));
                }
                return map;
            }
        });
        if (mapExist == null) {
            return BaseDataRightEnum.NO_DATA.getVal();
        }
        return (String)mapExist.get("fexceptionperm");
    }

    public static boolean checkPagePermission(String pageNumber, String permissionItemId) {
        int flag = PermissionServiceHelper.checkPermission((long)UserServiceHelper.getCurrentUserId(), (String)"bos_org", (long)0L, (String)null, (String)pageNumber, (String)permissionItemId);
        return flag == 1;
    }

    public static boolean hasExportPerm(String entityNumber) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!"exportlist".equals(opType)) continue;
            String permission = (String)op.get(PERMISSION);
            if (permission != null) {
                if (StringUtils.isEmpty(permission)) {
                    return true;
                }
                return PermissionUtil.checkPagePermission(entityNumber, permission);
            }
            return true;
        }
        return false;
    }

    public static boolean hasImportPerm(String entityNumber) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!"importdata".equals(opType)) continue;
            String permission = (String)op.get(PERMISSION);
            if (permission != null) {
                if (StringUtils.isEmpty(permission)) {
                    return true;
                }
                return PermissionUtil.checkPagePermission(entityNumber, permission);
            }
            return true;
        }
        return false;
    }

    public static DynamicObjectCollection querySpecialDataPermData(String operationKey, boolean queryEnabled, String ... entityNumber) {
        QFilter qFilter = new QFilter("entitytype", "in", (Object)entityNumber);
        qFilter.or("entitytype", "=", (Object)"");
        qFilter.and(new QFilter("operation_key", "=", (Object)operationKey));
        DynamicObjectCollection permRuleCollection = QueryServiceHelper.query((String)"perm_operationrule", (String)"id", (QFilter[])qFilter.toArray());
        int len = permRuleCollection.size();
        String[] permRuleId = new String[len];
        for (int i = 0; i < len; ++i) {
            permRuleId[i] = ((DynamicObject)permRuleCollection.get(i)).get("id").toString();
        }
        QFilter qFilterObj = new QFilter("operationrule_id", "in", (Object)permRuleId);
        qFilterObj.and("entitytype", "in", (Object)entityNumber);
        if (queryEnabled) {
            qFilterObj.and(new QFilter("objenabled", "=", (Object)queryEnabled));
        }
        return QueryServiceHelper.query((String)"perm_operationruleobj", (String)"id,entitytype,objenabled", (QFilter[])qFilterObj.toArray());
    }

    public static void updateSpecialPermEnabled(Map<String, Object> pkAndEnabledValue) {
        Object[] pkValue = pkAndEnabledValue.keySet().toArray();
        Map specialPermRule = BusinessDataServiceHelper.loadFromCache((Object[])pkValue, (String)"perm_operationruleobj");
        for (Map.Entry<String, Object> entry : pkAndEnabledValue.entrySet()) {
            String permPkValue = entry.getKey();
            ((DynamicObject)specialPermRule.get(permPkValue)).set("objenabled", pkAndEnabledValue.get(permPkValue));
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)specialPermRule.get(pkValue[0])).getDataEntityType(), (Object[])specialPermRule.values().toArray());
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
    }

    private static class RiccBizPerm {
        private long id;
        private String name;
        private String number;
        private String perm;
        private String description;

        private RiccBizPerm() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getPerm() {
            return this.perm;
        }

        public void setPerm(String perm) {
            this.perm = perm;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class UserPermGroup {
        private DynamicObjectCollection exceptionUser;
        private List<Object> editPermUserIdList;
        private List<Object> addAndEditPermUserIdList;

        public UserPermGroup(DynamicObjectCollection exceptionUser) {
            this.exceptionUser = exceptionUser;
        }

        public List<Object> getEditPermUserIdList() {
            return this.editPermUserIdList;
        }

        public List<Object> getAddAndEditPermUserIdList() {
            return this.addAndEditPermUserIdList;
        }

        public UserPermGroup invoke() {
            this.editPermUserIdList = new ArrayList<Object>();
            this.addAndEditPermUserIdList = new ArrayList<Object>();
            for (DynamicObject oneUser : this.exceptionUser) {
                String exceptionperm = oneUser.getString("exceptionperm");
                Long userId = oneUser.getLong("user_id");
                if (BaseDataRightEnum.HAVE_NEWANDCHANGE_PERM.getVal().equals(exceptionperm)) {
                    this.addAndEditPermUserIdList.add(userId);
                    continue;
                }
                this.editPermUserIdList.add(userId);
            }
            return this;
        }
    }
}

