/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check.configcheckitems;

import java.io.StringReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.sys.ricc.business.configitem.check.AbstractConfigCheckItem;
import kd.sys.ricc.common.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImportPluginCheck
extends AbstractConfigCheckItem {
    @Override
    public void doAction(Map<String, Object> paramsMap) {
        boolean isBinding;
        DynamicObject configItem = (DynamicObject)paramsMap.get("configItem");
        String importType = configItem.getString("importtype");
        if (!"excel".equals(importType)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4f20\u8f93\u65b9\u5f0f\u4e0d\u4e3aExcel\u5bfc\u5165\u5bfc\u51fa\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"ImportPluginCheck_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        String sql = "select fdata from t_meta_entitydesign where fnumber = ?";
        String pageNumber = ((DynamicObject)configItem.get("page")).getString("basedatafield.number");
        List result = (List)DB.query((DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])new Object[]{pageNumber}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet resultSet) throws Exception {
                ArrayList<String> list = new ArrayList<String>(16);
                while (resultSet.next()) {
                    String value = resultSet.getString("fdata");
                    list.add(value);
                }
                return list;
            }
        });
        if (StringUtils.isNotBlank((Object)result) && (isBinding = ImportPluginCheck.isBindingImportPlugin((String)result.get(0)))) {
            this.setCheckResult("failed");
            String log = ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u5bfc\u51fa\u63d2\u4ef6\uff0c\u6570\u636e\u6b63\u786e\u6027\u53ef\u80fd\u4f1a\u5f71\u54cd\uff0c\u5efa\u8bae\u5148\u8bc4\u4f30\u8be5\u8be5\u63d2\u4ef6\u7684\u5f71\u54cd", (String)"ImportPluginCheck_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        this.setCheckResult("success");
    }

    public static boolean isBindingImportPlugin(String xml) {
        boolean isBingding = false;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new StringReader(xml)));
            NodeList nodeList = doc.getElementsByTagName("ImportParameter");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Node node = nodeList.item(index);
                String content = ((Element)node).getTextContent();
                if (!StringUtils.isNotBlank((CharSequence)content) || "[]".equals(content) || "[ ]".equals(content)) continue;
                isBingding = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isBingding;
    }
}

