/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.impt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.ZipParameters;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.AttachTransHelper;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.impt.ExcelExportHelper;
import kd.sys.ricc.business.impt.ExcelImportHelper;
import kd.sys.ricc.business.impt.ExcelImportResult;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schedule.TaskHandler;
import kd.sys.ricc.business.schedule.TaskIf;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class ExcelDataPacketImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(ExcelDataPacketImpl.class);
    private static final String XLSX = ".xlsx";
    private static final String ZIP = ".zip";
    private static final String SIGN = ".";
    private static final String DATA_IMPORT_TYPE = "dataimporttype";
    private static final String KEY_FIELDS = "keyfields";
    private static final String IS_OVERRIDE_ENTRY = "isoverrideentry";
    public int maxFileRowSize = SystemPropertyUtils.getInteger((String)RequestContext.get().getTenantId(), (String)"split.file.rowsize", (Integer)1000000);

    @Override
    public SdpOutputParams exportPacket(SdpInputParams inParams) {
        String outpath;
        boolean importTemplateExists;
        SdpOutputParams result = new SdpOutputParams();
        ListSelectedRowCollection listSelectedRows = inParams.getSelectRows();
        AddPacketProgress addPacketProgress = inParams.getAddPacketProgress();
        Map<String, Object> customParams = inParams.getParam();
        String entityName = (String)customParams.get("entityname");
        String entityNumber = (String)customParams.get("entitynumber");
        String pageId = (String)customParams.get("pageId");
        String importTemplateId = (String)customParams.get("importtemplateid");
        long longImportTemplateId = 0L;
        if (!StringUtils.isEmpty((String)importTemplateId) && !(importTemplateExists = QueryServiceHelper.exists((String)"bos_importtemplate", (Object)(longImportTemplateId = Long.parseLong(importTemplateId))))) {
            return result.setSuccess(false).append(ResManager.loadKDString((String)"\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f\u5df2\u88ab\u5220\u9664\u6216\u5c1a\u672a\u914d\u7f6e\uff0c\u8bf7\u8fdb\u5165\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u91cd\u65b0\u914d\u7f6e\u6a21\u677f", (String)"ExcelDataPacketImpl_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        Map<String, Object> exportParams = ExcelExportHelper.prepareExportParams(entityName, entityNumber, pageId, longImportTemplateId);
        IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        String sortField = (String)customParams.getOrDefault("sortfield", "");
        String sortWay = (String)customParams.getOrDefault("sortway", "");
        exportParams.put("sortfield", sortField);
        exportParams.put("sortway", sortWay);
        exportParams.put("isExportAll", listSelectedRows.isEmpty());
        DynamicObject guideInfo = (DynamicObject)customParams.get("guideId");
        String entityId = guideInfo.getString("entityid");
        String keyFieldItem = guideInfo.getString(KEY_FIELDS);
        String keyFields = ConfigItemHelper.disPoseKeyField(entityId, keyFieldItem, entityName);
        HashSet<String> keyFieldSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        String filters = DataPacketHelper.getFilters(customParams);
        exportParams.put("filters", filters);
        List<Map<String, Object>> previewData = DataPacketHelper.getCustomParam(entityNumber, listSelectedRows.getPrimaryKeyValues(), filters, keyFieldSet);
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("previewData", previewData);
        param.put("keyFields", keyFieldSet);
        Object[] ids = listSelectedRows.getPrimaryKeyValues();
        if (ids.length == 0) {
            ids = previewData.stream().map(data -> data.get("id")).toArray();
        }
        List<Object> pkIdList = Arrays.stream(ids).collect(Collectors.toList());
        boolean isTransferAttach = guideInfo.getBoolean("istransferattach");
        result.setParam(param);
        DynamicObject exportLogObj = null;
        exportLogObj = this.excuteTaskByJob("kd.bos.ext.imsc.ricc.task.RiccExportDataTask", addPacketProgress, exportParams, pageId, parentView);
        ScheduleUtil.buildAddPacketProgressDesc(addPacketProgress, logger, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5df2\u5b8c\u6210\uff0cExcel\u6570\u636e\u5904\u7406\u4e2d...", (String)"ExcelDataPacketImpl_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        if (exportLogObj != null) {
            String downloadurl = exportLogObj.getString("downloadurl");
            int total = exportLogObj.getInt("total");
            String logs = exportLogObj.getString("logs");
            logger.info(String.format("\u6807\u51c6\u5bfc\u5165\u5bfc\u51fa\u83b7\u5f97\u5230\u7684\u4e0b\u8f7d\u94fe\u63a5\uff1a%s, \u603b\u6570\uff1a%s, \u65e5\u5fd7\uff1a%s", downloadurl, total, logs));
            if (StringUtils.isEmpty((String)downloadurl)) {
                if (total == 0) {
                    return result.setSuccess(false).append(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ExcelDataPacketImpl_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
                return result.setSuccess(false).append(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38: ", (String)"ExcelDataPacketImpl_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(logs).append("sys-ricc-platform");
            }
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            downloadurl = CommonUtil.checkUrl((String)downloadurl);
            String fileName = this.getFileNameFormUrl(downloadurl, total);
            outpath = inParams.getLocalPath() + File.separator + fileName;
            try (FileOutputStream out = new FileOutputStream(outpath);){
                fileService.download(downloadurl, (OutputStream)out, "ricc-agent");
            }
            catch (Exception e) {
                logger.error("excel\u4e0b\u8f7d\u5230\u672c\u5730\u51fa\u9519\u3002", (Throwable)e);
                return result.setSuccess(false).append(ResManager.loadKDString((String)"excel\u4e0b\u8f7d\u5230\u672c\u5730\u51fa\u9519\u3002", (String)"ExcelDataPacketImpl_4", (String)"sys-ricc-platform", (Object[])new Object[0]), e);
            }
            if (isTransferAttach) {
                ArrayList<String> attachKeys = new ArrayList<String>(1);
                String attachFieldStr = guideInfo.getString("attachmentfield");
                if (!StringUtils.isEmpty((String)attachFieldStr)) {
                    attachKeys = new ArrayList<String>(Arrays.asList(attachFieldStr.trim().replaceFirst(",", "").split(",")));
                }
                if (!attachKeys.isEmpty()) {
                    List<String> attachFilePaths = this.getAttachFilePaths(entityNumber, pkIdList, attachKeys, inParams.getLocalPath(), result);
                    try {
                        if (outpath.contains(ZIP)) {
                            ZipFile zipFile = new ZipFile(outpath);
                            for (String attachFilePath : attachFilePaths) {
                                File newFile = new File(attachFilePath);
                                ZipParameters zipParameters = new ZipParameters();
                                FileUtils.addFileToZipFile((File)newFile, (ZipFile)zipFile, (String)fileName, (boolean)true, (ZipParameters)zipParameters);
                            }
                        } else {
                            outpath = FileUtils.dirToZip((String)inParams.getLocalPath(), (String)fileName);
                        }
                    }
                    catch (Exception e) {
                        String errMsg = String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u6574\u4f53\u6253\u5305\u538b\u7f29\u4e3azip\u5931\u8d25\uff1a%s", (String)"ExcelDataPacketImpl_14", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage());
                        result.append(errMsg, e);
                    }
                }
            }
        } else {
            return result.setSuccess(false).append(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u53d1\u751f\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u5bfc\u51fa\u7684\u7ed3\u679c", (String)"ExcelDataPacketImpl_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        result.setExportFilePath(outpath);
        ScheduleUtil.buildAddPacketProgressDesc(addPacketProgress, logger, ResManager.loadKDString((String)"Excel\u6570\u636e\u5904\u7406\u5b8c\u6210\uff0c\u5199\u5165\u52fe\u9009\u6570\u636e\u4e2d...", (String)"ExcelDataPacketImpl_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
        result.setSelectedInfo(this.getSelectedInfo(previewData, entityName).toString());
        return result.setSuccess(true);
    }

    private List<String> getAttachFilePaths(String entityNumber, List<Object> pkIdList, List<String> attachKeys, String localPath, SdpOutputParams result) {
        List<String> attApKeys = AttachTransHelper.getAttApKeys(attachKeys);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List spitBatchList = BatchSplitUtil.splitBatch(pkIdList, (int)1000);
        ArrayList<String> attachFilePaths = new ArrayList<String>(spitBatchList.size());
        String localAttachPath = localPath + File.separator + "attach";
        FileUtils.checkAndCreateDir((String)localAttachPath);
        for (List splitList : spitBatchList) {
            DynamicObject[] splitDym = this.getSplitDym(splitList, entityType);
            Map<String, Object> attachContentMap = AttachTransHelper.getAllAttContentMap(splitDym, attachKeys, attApKeys, entityNumber, localAttachPath);
            if (attachContentMap.isEmpty()) continue;
            long currentTimeMillis = System.currentTimeMillis();
            String attachFileName = currentTimeMillis + "_attach.json";
            String attachFilePath = localPath + File.separator + attachFileName;
            attachFilePaths.add(attachFilePath);
            try {
                FileUtils.writeMap2File((String)attachFilePath, attachContentMap);
            }
            catch (Exception e) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u636e\u52a8\u6001\u5e8f\u5217\u5316\u65b9\u5f0f\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6\u540d%s", (String)"ExcelDataPacketImpl_13", (String)"sys-ricc-platform", (Object[])new Object[0]), attachFileName);
                result.append(errMsg, e);
            }
        }
        attachFilePaths.add(localAttachPath);
        return attachFilePaths;
    }

    private DynamicObject[] getSplitDym(List<Object> splitList, MainEntityType entityType) {
        return BusinessDataServiceHelper.load((Object[])splitList.toArray(), (DynamicObjectType)entityType);
    }

    private String getFileNameFormUrl(String downloadurl, int total) {
        String fileName = FileUtils.getFileNameFromPath((String)downloadurl);
        if (!fileName.contains(SIGN)) {
            fileName = total >= this.maxFileRowSize ? fileName + ZIP : fileName + XLSX;
        }
        return fileName;
    }

    private StringBuilder getSelectedInfo(List<Map<String, Object>> preViewData, String entityName) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean emptyName = false;
        for (int i = 0; i < preViewData.size(); ++i) {
            Map<String, Object> oneData = preViewData.get(i);
            if (StringUtils.isEmpty((String)((String)oneData.get("number"))) && StringUtils.isEmpty((String)((String)oneData.get("name")))) {
                stringBuilder.append(String.format("%s\t\t%s\t\t%n", i + 1, oneData.get("id")));
                emptyName = true;
                continue;
            }
            stringBuilder.append(String.format("%s\t\t%s\t\t%s%n", i + 1, oneData.get("number"), oneData.get("number")));
        }
        stringBuilder.insert(0, emptyName ? String.format("%1$s\t\t%2$sid%n", CommonConstant.getSerialNumTitle(), entityName) : String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        return stringBuilder;
    }

    private DynamicObject excuteTaskByJob(String taskName, final AddPacketProgress addPacketProgress, Map<String, Object> params, String pageId, IFormView parentView) {
        logger.info("\u8c03\u5ea6\u65b9\u5f0f\u8c03\u7528\u5e73\u53f0\u5bfc\u5165\u5bfc\u51fa\u5f00\u59cb\uff1a");
        JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305-\u5bfc\u51fa\u64cd\u4f5c", (String)"ExcelDataPacketImpl_9", (String)"sys-ricc-platform", (Object[])new Object[0]), taskName, "kd.bos.form.plugin.expt.ExportTaskClick", parentView, params);
        jobFormInfo.setParentPageId(pageId);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        logger.info("\u8c03\u5ea6\u65b9\u5f0f\u8c03\u7528\u5e73\u53f0\u5bfc\u5165\u5bfc\u51fa\uff0c\u8c03\u5ea6id\uff1a" + taskId);
        new TaskHandler(taskId, new TaskIf(){

            @Override
            public void ifUpdate(TaskInfo taskInfo) {
                ScheduleUtil.addPacketFeedbackProgress(addPacketProgress, taskInfo.getProgress() >= 10 ? taskInfo.getProgress() - 1 : taskInfo.getProgress(), taskInfo.getDesc(), ScheduleUtil.getTaskCustData(taskInfo));
            }
        }).wait2End();
        Map<String, Object> data = ScheduleUtil.getTaskCustData(taskId);
        Object logId = data.get("logid");
        logger.info("\u8c03\u5ea6\u65b9\u5f0f\u8c03\u7528\u5e73\u53f0\u5bfc\u5165\u5bfc\u51fa\uff0c\u8c03\u5ea6\u65e5\u5fd7id\uff1a" + logId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_exportlog", (QFilter[])new QFilter[]{new QFilter("id", "=", logId)});
    }

    @Override
    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams result = new SdpOutputParams();
        Map<String, Object> paramMap = sdpInputParams.getParam();
        String fileUrl = (String)paramMap.get("fileUrl");
        String fileName = (String)paramMap.get("fileName");
        String appId = (String)paramMap.get("appId");
        String formId = (String)paramMap.get("billFormId");
        String pageType = (String)paramMap.get("pageType");
        String packetType = (String)paramMap.get("packetType");
        DynamicObject guideInfo = (DynamicObject)paramMap.get("guideInfo");
        String pageEnterParam = guideInfo.getString("pageenterparam");
        String entityName = guideInfo.getString("name");
        String conditionMustStr = guideInfo.getString("conditionmustfield");
        ArrayList<String> conditionMustFields = new ArrayList(1);
        if (StringUtils.isNotEmpty((String)conditionMustStr)) {
            conditionMustFields = Arrays.asList(conditionMustStr.trim().replaceFirst(",", "").split(","));
        }
        String coverInfoStr = guideInfo.getString("coverinfo");
        ArrayList<String> coverUserFields = new ArrayList(1);
        String coverConfig = SysParaUtil.getBillCreateInfoCoverConfig();
        if (StringUtils.isNotEmpty((String)coverInfoStr) && "all".equals(coverConfig)) {
            coverUserFields = new ArrayList<String>(Arrays.asList(coverInfoStr.trim().replaceFirst(",", "").split(",")));
        }
        HashMap<String, String> excelParams = new HashMap<String, String>(3);
        if (DataPacketTypeEnum.CONFIG.getVal().equals(packetType)) {
            String dataImportType = guideInfo.getString(DATA_IMPORT_TYPE);
            String keyFields = guideInfo.getString(KEY_FIELDS);
            boolean isOverrideEntry = guideInfo.getBoolean(IS_OVERRIDE_ENTRY);
            excelParams.put(DATA_IMPORT_TYPE, dataImportType);
            excelParams.put(KEY_FIELDS, keyFields);
            excelParams.put(IS_OVERRIDE_ENTRY, String.valueOf(isOverrideEntry));
        } else {
            excelParams.put(KEY_FIELDS, ",id,");
        }
        Map<String, Object> importOpInfo = ExcelImportHelper.getImportOpInfo(formId);
        if (importOpInfo == null || importOpInfo.isEmpty()) {
            result.setSuccess(false);
            String errorTips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u914d\u7f6e\u9879\u201c%1$s\u201d\u6ca1\u6709\u5bfc\u5165\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u8c03\u6574\u3002\u4e5f\u53ef\u5c06\u914d\u7f6e\u9879\u4f20\u8f93\u65b9\u5f0f\u4fee\u6539\u4e3aJSON\u5bfc\u5165\u5bfc\u51fa\u540e\u518d\u91cd\u65b0\u6dfb\u52a0\u4f20\u8f93\u5305\u4f20\u8f93\u540c\u6b65", (String)"ExcelDataPacketImpl_12", (String)"sys-ricc-platform", (Object[])new Object[0]);
            result.append(String.format(errorTips, entityName));
            return result;
        }
        String permission = (String)importOpInfo.get("permission");
        if (StringUtils.isNotEmpty((String)permission) && !PermissionUtil.checkPagePermission((String)formId, (String)permission)) {
            return result.setSuccess(false).append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u9875\u9762\u7684\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u767b\u5f55\u7528\u6237\u6216\u5206\u914d\u3010\u5bfc\u5165\u6570\u636e\u3011\u7684\u6743\u9650\u4e4b\u540e\u518d\u8bd5\u8bd5", (String)"ExcelDataPacketImpl_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        List<Object> fileInfos = new ArrayList();
        if (fileName.endsWith(ZIP)) {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            try (InputStream inputStream = fileService.getInputStream(fileUrl);){
                fileInfos = ExcelImportHelper.parseXlsxZipFile(new BufferedInputStream(inputStream), formId, conditionMustFields, coverUserFields, result);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                result.append(String.format(CommonConstant.getImportFileErrorTip(), fileName), e);
            }
        } else if (fileName.endsWith(XLSX)) {
            fileInfos = ExcelImportHelper.parseXlsxFile(fileUrl, formId, fileName, conditionMustFields, coverUserFields);
        } else {
            String msgTpl = ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u8bc6\u522b\u4e3aexcel\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u8fdb\u884c\u4f20\u8f93\u540c\u6b65\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", (String)"ExcelDataPacketImpl_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
            result.setSuccess(false).append(String.format(msgTpl, fileUrl));
        }
        ExcelImportResult excelImportResult = ExcelImportHelper.batchExecuteExcelImport(fileInfos, formId, pageEnterParam, pageType, excelParams);
        if (excelImportResult.isSuccess()) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            if (fileInfos.size() == 1) {
                String report = excelImportResult.getReport();
                String[] splits = report.split("\u3011\uff1a");
                result.append(splits[1]);
            } else {
                result.append(excelImportResult.getReport());
            }
        }
        if (fileName.endsWith(ZIP)) {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            try (InputStream inputStream = fileService.getInputStream(fileUrl);){
                ZipInputStream zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                while (nextEntry != null) {
                    String entryFileName = nextEntry.getName();
                    if (entryFileName.endsWith("_attach.json")) {
                        AttachTransHelper.importAttContent(zipInputStream, entryFileName, result);
                    }
                    nextEntry = zipInputStream.getNextEntry();
                }
            }
            catch (Exception e) {
                result.append(String.format(CommonConstant.getImportFileErrorTip(), fileName), e);
            }
        }
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        int totalCount = excelImportResult.getTotal();
        int failedCount = excelImportResult.getFailed();
        param.put("successCount", totalCount - failedCount);
        param.put("failedCount", failedCount);
        result.setParam(param);
        return result;
    }

    @Override
    public Map<String, Object> provideData(Map<String, Object> params) {
        return ConfigItemHelper.generalProvideDataImpl(params);
    }
}

