/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.download.PacketDownLoadUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.exception.RiccBizException;

public class DataPacketDownLoader {
    private static final Log logger = LogFactory.getLog(DataPacketDownLoader.class);
    private static final String PACKET_ENTRY_STATUS = "entrystatus";

    private DataPacketDownLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static void download(DynamicObject packet, IFormView view) {
        long opTime = System.currentTimeMillis();
        ArrayList<Object> addDownloadCountList = new ArrayList<Object>(1);
        boolean isSuccess = true;
        long packetId = (Long)packet.getPkValue();
        String msg = DataPacketDownLoader.validateEnableAndSubpacket(packet);
        if (StringUtils.isEmpty((String)msg)) {
            try {
                String url = DataPacketDownLoader.getDownloadUrl(packet);
                if (view instanceof ListView) {
                    FileUtils.addDownloadPermission((String)((ListView)view).getBillFormId(), (String)url, (String)view.getFormShowParameter().getServiceAppId());
                } else {
                    FileUtils.addDownloadPermission((String)((BillView)view).getFormId(), (String)url, (String)view.getFormShowParameter().getServiceAppId());
                }
                view.download(url);
                addDownloadCountList.add(packet.get("id"));
            }
            catch (Exception e) {
                logger.error("\u4f20\u8f93\u5305\u4e0b\u8f7d\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
                isSuccess = false;
                msg = CommonUtil.getExceptionDetailInfo((Throwable)e);
                throw new RiccBizException(msg, (Throwable)e);
            }
            finally {
                DataPacketDownLoader.recordLog(packetId, msg, opTime, isSuccess);
            }
        } else {
            isSuccess = false;
            view.showErrorNotification(msg);
            DataPacketDownLoader.recordLog(packetId, msg, opTime, isSuccess);
        }
        CommonUtil.afterDownload(addDownloadCountList);
    }

    private static String getTarAccountIdStr() {
        DynamicObject[] tarAccounts = BusinessDataServiceHelper.load((String)"ricc_destaccount", (String)"number", (QFilter[])new QFilter("enable", "=", (Object)"1").toArray());
        String targetIds = "";
        if (!Objects.isNull(tarAccounts) && tarAccounts.length > 0) {
            targetIds = Arrays.stream(tarAccounts).map(tarAccount -> tarAccount.getString("number")).collect(Collectors.joining(","));
        }
        return targetIds;
    }

    private static String validateEnableAndSubpacket(DynamicObject dataPacket) {
        String enable = dataPacket.getString("enable");
        DynamicObjectCollection dCollection = dataPacket.getDynamicObjectCollection("subdatapacket");
        String packetName = dataPacket.getString("name");
        String msg = null;
        if (!"1".equalsIgnoreCase(enable)) {
            msg = String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305<%1$s | %2$s>\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u4e0b\u8f7d\uff01", (String)"DataPacketDownLoader_0", (String)"sys-ricc-platform", (Object[])new Object[0]), dataPacket.get("number"), packetName);
        } else if (Objects.isNull(dCollection) || dCollection.isEmpty()) {
            msg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u4f20\u8f93\u5305: %s \u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305\uff01", (String)"DataPacketDownLoader_1", (String)"sys-ricc-platform", (Object[])new Object[0]), packetName);
        } else {
            int subPacketCount = dCollection.size();
            int discardCount = 0;
            for (int i = 0; i < subPacketCount; ++i) {
                DynamicObject row = (DynamicObject)dCollection.get(i);
                DynamicObjectCollection fileDy = (DynamicObjectCollection)row.get("subdatapacketfile");
                if (Objects.isNull(fileDy) || fileDy.isEmpty()) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u4f20\u8f93\u5305: <%1$s> \u5b50\u4f20\u8f93\u5305\u7b2c%2$s\u884c\uff0c\u6587\u4ef6\u627e\u4e0d\u5230\uff01", (String)"DataPacketDownLoader_2", (String)"sys-ricc-platform", (Object[])new Object[0]), packetName, i + 1);
                    return msg;
                }
                DynamicObject dataPackage = (DynamicObject)fileDy.get(0);
                DynamicObject fileBaseDataId = dataPackage.getDynamicObject("fbasedataid");
                if (Objects.isNull(fileBaseDataId)) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u4f20\u8f93\u5305: <%1$s> \u5b50\u4f20\u8f93\u5305\u7b2c%2$s\u884c\uff0c\u6587\u4ef6\u627e\u4e0d\u5230\uff01", (String)"DataPacketDownLoader_2", (String)"sys-ricc-platform", (Object[])new Object[0]), packetName, i + 1);
                    return msg;
                }
                int status = row.getInt(PACKET_ENTRY_STATUS);
                if (status != 1) continue;
                ++discardCount;
            }
            if (discardCount == subPacketCount) {
                msg = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u4f20\u8f93\u5305: %s \u7684\u5b50\u4f20\u8f93\u5305\u5df2\u5168\u90e8\u4f5c\u5e9f\u3002", (String)"DataPacketDownLoader_3", (String)"sys-ricc-platform", (Object[])new Object[0]), packetName);
            }
        }
        return msg;
    }

    private static String getDownloadUrl(DynamicObject packet) throws RiccBizException {
        String zipName = packet.getString("number") + ".zip";
        String zipPath = FileUtils.generateLocalPath();
        File zipPathFile = FileUtils.checkAndCreateDir((String)zipPath);
        String packetZipPath = DataPacketDownLoader.packetToZip(packet, zipPath, zipName);
        String url = null;
        try (InputStream input = Files.newInputStream(Paths.get(packetZipPath, new String[0]), new OpenOption[0]);){
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, input, 5000);
        }
        catch (IOException e) {
            logger.error("DataPacketDownLoader.getDownloadUrl\u4e0b\u8f7d\u4f20\u8f93\u5305\u5931\u8d25", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u6574\u4f53\u6253\u5305\u52a0\u5bc6\u538b\u7f29\u5931\u8d25\uff1a%s", (String)"DataPacketDownLoader_5", (String)"sys-ricc-platform", (Object[])new Object[0]), e), (Throwable)e);
        }
        finally {
            FileUtils.deleteLocalFile((File)zipPathFile);
        }
        return url;
    }

    public static String packetToZip(DynamicObject packet, String zipPath, String zipName) {
        String targetIdsStr = DataPacketDownLoader.getTarAccountIdStr();
        packet.set("destdatacenter", (Object)targetIdsStr);
        DynamicObjectCollection subDataPackets = packet.getDynamicObjectCollection("subdatapacket");
        String filePath = FileUtils.generateLocalPath();
        File fileTemp = FileUtils.checkAndCreateDir((String)filePath);
        HashMap<String, String> md5Map = new HashMap<String, String>(subDataPackets.size());
        String packetZipPath = null;
        try {
            PacketDownLoadUtil.writeSubPacketToFile(filePath, subDataPackets, md5Map);
            ArrayList<DynamicObject> itemList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> treeList = new ArrayList<DynamicObject>(10);
            PacketDownLoadUtil.findConfigAndTree(packet, itemList, treeList);
            PacketDownLoadUtil.sortTree(treeList);
            PacketDownLoadUtil.writeItemsAndTreeToFile(filePath, itemList, treeList);
            PacketDownLoadUtil.writeToJson(packet, filePath, md5Map, !itemList.isEmpty(), !treeList.isEmpty());
            FileUtils.checkAndCreateDir((String)zipPath);
            String packetSecret = SysParaUtil.getPacketSecret();
            packetZipPath = zipPath + File.separator + zipName;
            FileUtils.createFile((String)packetZipPath);
            FileUtils.dirToZipAndEncrypt((String)filePath, (String)packetZipPath, (String)packetSecret);
        }
        catch (Exception e) {
            logger.error("DataPacketDownLoader.packetToZip \u4f20\u8f93\u5305\u8f6c\u4e3azip\u5931\u8d25", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u6574\u4f53\u6253\u5305\u538b\u7f29\u4e3azip\u5931\u8d25\uff1a%s", (String)"DataPacketDownLoader_4", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        finally {
            FileUtils.deleteLocalFile((File)fileTemp);
        }
        return packetZipPath;
    }

    private static void recordLog(long packetId, String msg, long opTime, boolean isSuccess) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ricc_log");
        log.set("id", (Object)DB.genLongId((String)"ricc_log"));
        String logNumber = CodeRuleServiceHelper.getNumber((String)"ricc_log", (DynamicObject)log, null);
        log.set("billno", (Object)logNumber);
        log.set("packet", (Object)packetId);
        log.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
        log.set("optime", (Object)opTime);
        long opEndTime = System.currentTimeMillis();
        log.set("opendtime", (Object)opEndTime);
        String timeCost = TimeCostUtil.getUsedTime((long)opTime, (long)opEndTime);
        log.set("usetime", (Object)timeCost);
        log.set("optype", (Object)"7");
        if (isSuccess) {
            msg = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"DataPacketDownLoader_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
            log.set("state", (Object)"1");
            log.set("successcount", (Object)1);
            log.set("failedcount", (Object)0);
        } else {
            log.set("state", (Object)"2");
            log.set("successcount", (Object)0);
            log.set("failedcount", (Object)1);
        }
        log.set("message", (Object)(msg.length() > 255 ? msg.substring(0, 200) + "..." : msg));
        log.set("message_tag", (Object)msg);
        log.set("traceid", (Object)RequestContext.get().getTraceId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

