/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.metadata.MetaDataExportHandler;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.common.enums.PackMode;
import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.log.ConfigLog;
import kd.sys.ricc.common.log.LogRecorder;
import kd.sys.ricc.common.log.impl.ConfigLogImpl;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class AddDataPacketTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(AddDataPacketTask.class);
    private static final String RICC_METADATA_EXPORT = "ricc_metadata_export";
    private AddPacketProgress addPacketProgress;
    private final ConfigLog configLog = new ConfigLogImpl();

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        Map<String, Object> custParam = this.getCustParam(map);
        String filterStr = (String)map.get("filters");
        custParam.put("filters", filterStr);
        String formId = (String)map.get("formId");
        Object selectGuideId = map.get("guideId");
        String pageId = (String)map.get("parentPageId");
        String packMode = (String)map.get("packmode");
        String packetType = (String)map.get("packettype");
        ListSelectedRow selectedPacket = this.getSelectedPacket(map);
        if (selectedPacket == null) {
            String msg = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25, \u8bf7\u5148\u521b\u5efa\u6216\u9009\u62e9\u4f20\u8f93\u5305\u518d\u6267\u884c\u4efb\u52a1", (String)"AddDataPacketTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            logger.error("AddDataPacketTask.getSelectedPacket.error:\u914d\u7f6e\u9879id:" + selectGuideId + msg);
            this.getAddPacketProgress().fail(msg);
            return;
        }
        if (PackMode.ADD_DIRECTLY.getValue().equals(packMode)) {
            this.configLog.preWriteLog("3", this.taskId, ((Long)selectedPacket.getPrimaryKeyValue()).longValue(), 0L, "", null);
        }
        if (RICC_METADATA_EXPORT.equals(formId)) {
            this.metadataPacket(pageId, selectedPacket);
            return;
        }
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        String selectedDataStr = (String)map.get("selectedData");
        if (!StringUtils.isEmpty((String)selectedDataStr)) {
            listSelectedRows = ListSelectedRowCollection.deSerialize((String)((String)map.get("selectedData")));
        }
        this.getAddPacketProgress().feedbackProgress(listSelectedRows.size(), 0);
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        sdpOutputParams.setSuccess(false);
        StringBuilder errMessage = new StringBuilder();
        if (StringUtils.equals((String)"ai_vchtemplate", (String)formId)) {
            QFilter[] qFilterArray;
            if (StringUtils.isBlank((CharSequence)filterStr)) {
                qFilterArray = new QFilter[]{};
            } else {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = QFilter.fromSerializedString((String)filterStr);
            }
            QFilter[] filter = qFilterArray;
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)formId, (String)"id,number,name,createorg,createorg.number", (QFilter[])filter);
            if (queryData.isEmpty()) {
                sdpOutputParams = this.getSubDataPacks(custParam, selectGuideId, pageId, packetType, selectedPacket, listSelectedRows, sdpOutputParams, errMessage);
            } else {
                ArrayList<DynamicObject> subDataPackets = new ArrayList<DynamicObject>(10);
                sdpOutputParams = this.processGroupedData(custParam, selectGuideId, pageId, packetType, selectedPacket, queryData, subDataPackets);
                sdpOutputParams.setEndTime();
                long createOrgCount = queryData.stream().map(l -> l.getLong("createorg")).distinct().count();
                if (createOrgCount == (long)subDataPackets.size()) {
                    this.saveSubDataPackets(selectedPacket, sdpOutputParams, null, subDataPackets);
                }
            }
        } else {
            sdpOutputParams = this.getSubDataPacks(custParam, selectGuideId, pageId, packetType, selectedPacket, listSelectedRows, sdpOutputParams, errMessage);
        }
        if (PackMode.ADD_DIRECTLY.getValue().equals(packMode)) {
            int selectRows;
            int total = this.addPacketProgress.getProgressTotalCount();
            total = total > (selectRows = listSelectedRows.size()) ? total : selectRows;
            this.addLog(total, (AbstractLogRecord)sdpOutputParams.getLogRecordBuilder());
        }
        this.getAddPacketProgress().complete();
    }

    private SdpOutputParams getSubDataPacks(Map<String, Object> custParam, Object selectGuideId, String pageId, String packetType, ListSelectedRow selectedPacket, ListSelectedRowCollection listSelectedRows, SdpOutputParams sdpOutputParams, StringBuilder errMessage) {
        try {
            sdpOutputParams = SubDataPacketDispatch.exportPacket(packetType, selectGuideId, selectedPacket, listSelectedRows, pageId, custParam, this.getAddPacketProgress());
        }
        catch (Exception e) {
            this.handleException(e, sdpOutputParams);
        }
        sdpOutputParams.setEndTime();
        if (!sdpOutputParams.isSuccess()) {
            this.handleFailure(sdpOutputParams, errMessage);
        } else {
            DynamicObject subDataPacket = (DynamicObject)sdpOutputParams.getParam().get("subDataPacket");
            List<DynamicObject> relyPacketList = sdpOutputParams.getParam().getOrDefault("relyBdPacketList", Collections.emptyList());
            List multiPacketList = sdpOutputParams.getParam().getOrDefault("multiDataPacketList", Collections.emptyList());
            if (!relyPacketList.isEmpty()) {
                relyPacketList.addAll(multiPacketList);
                relyPacketList.add(subDataPacket);
            } else {
                relyPacketList = new ArrayList<DynamicObject>(Collections.singletonList(subDataPacket));
            }
            this.saveSubDataPackets(selectedPacket, sdpOutputParams, subDataPacket, relyPacketList);
        }
        return sdpOutputParams;
    }

    private void saveSubDataPackets(ListSelectedRow selectedPacket, SdpOutputParams sdpOutputParams, DynamicObject subDataPacket, List<DynamicObject> relyPacketList) {
        try {
            if (relyPacketList.isEmpty()) {
                SubDataPacketDispatch.saveSubDataPacket(selectedPacket.getPrimaryKeyValue(), subDataPacket);
            } else {
                SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacket.getPrimaryKeyValue(), relyPacketList);
            }
        }
        catch (RiccBizException e) {
            logger.error("\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u540e\u4fdd\u5b58\u65f6\u5931\u8d25", (Throwable)e);
            this.handleException((Exception)((Object)e), sdpOutputParams);
        }
    }

    private void handleFailure(SdpOutputParams sdpOutputParams, StringBuilder errMessage) {
        sdpOutputParams.getError().insert(0, errMessage);
        logger.error(sdpOutputParams.getDevErrorStr());
        this.getAddPacketProgress().fail(SerializationUtils.toJsonString((Object)sdpOutputParams.getLogRecordBuilder()));
    }

    private void handleException(Exception e, SdpOutputParams sdpOutputParams) {
        logger.error((Throwable)e);
        sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", (String)"AddDataPacketTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage()), e);
        this.getAddPacketProgress().fail(SerializationUtils.toJsonString((Object)sdpOutputParams.getLogRecordBuilder()));
    }

    private SdpOutputParams processGroupedData(Map<String, Object> custParam, Object selectGuideId, String pageId, String packetType, ListSelectedRow selectedPacket, DynamicObjectCollection queryData, List<DynamicObject> subDataPackets) {
        Map<Long, List<DynamicObject>> groupedData = queryData.stream().collect(Collectors.groupingBy(l -> l.getLong("createorg")));
        Map<Long, String> orgIdToNumberMap = queryData.stream().collect(Collectors.toMap(l -> l.getLong("createorg"), l -> l.getString("createorg.number"), (value1, value2) -> value2));
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        sdpOutputParams.setSuccess(false);
        for (Map.Entry<Long, List<DynamicObject>> oneSubEntry : groupedData.entrySet()) {
            Long createOrg = oneSubEntry.getKey();
            custParam.put("org", createOrg);
            custParam.put("org_number", orgIdToNumberMap.get(createOrg));
            List<DynamicObject> value = oneSubEntry.getValue();
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (DynamicObject oneData : value) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue(oneData.get("id"));
                listSelectedRow.setNumber(oneData.getString("number"));
                listSelectedRow.setName(oneData.getString("name"));
                listSelectedRows.add((Object)listSelectedRow);
            }
            try {
                sdpOutputParams = SubDataPacketDispatch.exportPacket(packetType, selectGuideId, selectedPacket, listSelectedRows, pageId, custParam, this.getAddPacketProgress());
            }
            catch (Exception e) {
                this.handleException(e, sdpOutputParams);
                break;
            }
            if (!sdpOutputParams.isSuccess()) {
                logger.error(sdpOutputParams.getDevErrorStr());
                this.getAddPacketProgress().fail(SerializationUtils.toJsonString((Object)sdpOutputParams.getLogRecordBuilder()));
                continue;
            }
            DynamicObject subDataPacket = (DynamicObject)sdpOutputParams.getParam().get("subDataPacket");
            subDataPackets.add(subDataPacket);
        }
        return sdpOutputParams;
    }

    private ListSelectedRow getSelectedPacket(Map<String, Object> map) {
        ListSelectedRow selectedPacket = null;
        Object packetObj = map.get("selectedPacket");
        if (packetObj instanceof ListSelectedRow) {
            selectedPacket = (ListSelectedRow)packetObj;
        } else if (packetObj instanceof JSONObject) {
            JSONObject obj = (JSONObject)packetObj;
            selectedPacket = new ListSelectedRow();
            selectedPacket.setName(obj.getString("na"));
            selectedPacket.setPrimaryKeyValue((Object)obj.getLongValue("pkv"));
            selectedPacket.setNumber(obj.getString("nu"));
        } else {
            return null;
        }
        return selectedPacket;
    }

    private Map<String, Object> getCustParam(Map<String, Object> map) {
        Object custParamObject = map.get("custParam");
        HashMap<String, Object> custParam = custParamObject == null ? new HashMap<String, Object>(2) : (HashMap<String, Object>)custParamObject;
        return custParam;
    }

    private void addLog(int total, AbstractLogRecord logRecord) {
        int successCount = 0;
        if (logRecord.getMessageStr() == null || logRecord.getMessageStr().length() <= 0) {
            successCount = total;
        }
        this.configLog.afterWriteLog(total, successCount, logRecord);
    }

    public AddPacketProgress getAddPacketProgress() {
        if (this.addPacketProgress == null) {
            this.addPacketProgress = new AddPacketProgress(this.taskId);
        }
        return this.addPacketProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metadataPacket(String pageId, ListSelectedRow selectedPacket) {
        IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        String selectAppIds = parentView.getPageCache().get("selectappids");
        List selectAppList = (List)SerializationUtils.fromJsonString((String)selectAppIds, List.class);
        MetaDataExportHandler metaDataExportHandler = new MetaDataExportHandler(parentView, this.getAddPacketProgress());
        LogRecorder message = new LogRecorder();
        String result = "";
        try {
            result = metaDataExportHandler.exportMetadataByCloud(selectedPacket, selectAppList);
        }
        catch (Exception e) {
            String err = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5e94\u7528\u51fa\u73b0\u9519\u8bef\uff0c\u4efb\u52a1\u5df2\u5931\u8d25\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u8bd5\u3002\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"AddDataPacketTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage());
            message.append(err, (Throwable)e);
            this.getAddPacketProgress().fail(SerializationUtils.toJsonString((Object)message));
        }
        finally {
            if (!result.contains("success")) {
                QFilter filter = new QFilter("id", "=", selectedPacket.getPrimaryKeyValue());
                DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])filter.toArray());
            }
        }
        message.setEndTime(System.currentTimeMillis());
        this.addLog(selectAppList.size(), (AbstractLogRecord)message);
        this.getAddPacketProgress().complete();
    }
}

