/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.schedule;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sys.ricc.business.schedule.AbstractProgressTaskClick;
import kd.sys.ricc.business.schedule.ScheduleUtil;

public class BatchPacketTaskClick
extends AbstractProgressTaskClick
implements ICloseCallBack {
    private static final String FAIL_MSG = "failmsg";
    private static final String PACKET_NUMBER = "packetNumber";
    private static final String TOTAL = "total";
    private static final String SUCCESS_COUNT = "successCount";
    private static final String PART_FAILED = "part_failed";
    private static final String ALL_FAILED = "all_failed";
    private static final String SAVE = "save";
    private static final String DISCARD = "discard";
    private static final String MSG_CONFIRM_ACTION = "showConfirmMsg";
    private static final int NOTIFI_TIME = 5000;

    @Override
    public void showProgress() {
        if (!this.isExistProgressForm()) {
            IFormView view = this.getShowFormView();
            if (view != null) {
                FormShowParameter showParameter = this.getFormShowParameter("ricc_onekeypack");
                view.showForm(showParameter);
                this.setProgressPageId(showParameter.getPageId());
            } else {
                this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u6279\u91cf\u6253\u5305\u4efb\u52a1\u7684\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u6dfb\u52a0\u4f20\u8f93\u5305\u8fdb\u5ea6\u754c\u9762", (String)"BatchPacketTaskClick_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void complete(TaskInfo taskInfo) {
        IFormView view = this.getShowFormView();
        Map<String, Object> taskData = ScheduleUtil.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (StringUtils.isNotBlank((CharSequence)taskInfo.getFailureReason())) {
                view.showMessage(taskInfo.getFailureReason());
            }
            view.close();
        } else {
            String failMessage = (String)taskData.get(FAIL_MSG);
            if (failMessage != null && StringUtils.isNotBlank((CharSequence)failMessage)) {
                int successCount = (Integer)taskData.get(SUCCESS_COUNT);
                int total = (Integer)taskData.get(TOTAL);
                String packetNumber = String.valueOf(taskData.get(PACKET_NUMBER));
                Object logId = taskData.get("logId");
                if (successCount <= 0) {
                    String msg = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u4efb\u52a1\u6267\u884c\u5168\u90e8\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a", (String)"BatchPacketTaskClick_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.showExportDetailForm(view, logId, ALL_FAILED, msg, packetNumber);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305%1$s\u90e8\u5206\u914d\u7f6e\u9879\u6253\u5305\u5931\u8d25\uff08\u6210\u529f%2$d\u9879\uff0c\u5931\u8d25%3$d\u9879\uff09\uff0c\u662f\u5426\u4fdd\u7559\u5f53\u524d\u4f20\u8f93\u5305\uff1f\u70b9\u51fb\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u539f\u56e0", (String)"BatchPacketTaskClick_2", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber, successCount, total - successCount);
                    this.showExportDetailForm(view, logId, PART_FAILED, msg, packetNumber);
                }
                return;
            }
        }
        int total = (Integer)taskData.get(TOTAL);
        String packetNumber = String.valueOf(taskData.get(PACKET_NUMBER));
        view.showSuccessNotification(String.format(ResManager.loadKDString((String)"%d\u9879\u914d\u7f6e\u6253\u5305\u5168\u90e8\u6210\u529f\uff01\u4f20\u8f93\u5305\u7f16\u7801\uff1a%s", (String)"BatchPacketTaskClick_3", (String)"sys-ricc-platform", (Object[])new Object[0]), total, packetNumber), Integer.valueOf(5000));
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
    }

    private String getPacketNumber(String callBackId) {
        if (StringUtils.isEmpty((CharSequence)callBackId)) {
            return null;
        }
        String packetNumber = null;
        String[] splits = callBackId.split("@");
        if (splits.length >= 3) {
            packetNumber = splits[1];
        }
        return packetNumber;
    }

    private String getRootPageId(String callBackId) {
        if (StringUtils.isEmpty((CharSequence)callBackId)) {
            return null;
        }
        String rootPageId = null;
        String[] splits = callBackId.split("@");
        if (splits.length >= 3) {
            rootPageId = splits[2];
        }
        return rootPageId;
    }

    private void showExportDetailForm(IFormView view, Object logId, String failKey, String msg, String packetNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ricc_onekeypackconfirm");
        showParameter.setCustomParam("failKey", (Object)failKey);
        showParameter.setCustomParam("msg", (Object)msg);
        showParameter.setCustomParam("logId", logId);
        showParameter.setCustomParam(PACKET_NUMBER, (Object)packetNumber);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), MSG_CONFIRM_ACTION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
    }

    public void closedCallBack(ClosedCallBackEvent callBack) {
        String callBackId = callBack.getActionId();
        Object returnData = callBack.getReturnData();
        if (returnData == null) {
            return;
        }
        String result = (String)returnData;
        String packetNumber = this.getPacketNumber(result);
        String rootPageId = this.getRootPageId(result);
        if (MSG_CONFIRM_ACTION.equals(callBackId)) {
            if (StringUtils.isEmpty((CharSequence)packetNumber)) {
                return;
            }
            IFormView view = SessionManager.getCurrent().getView(rootPageId);
            if (result.contains(DISCARD)) {
                DeleteServiceHelper.delete((String)"ricc_datapacket", (QFilter[])new QFilter("number", "=", (Object)packetNumber).toArray());
                if (view != null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u4efb\u52a1\u7ed3\u679c\u5df2\u4e22\u5f03", (String)"BatchPacketTaskClick_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                }
            } else if (result.contains(SAVE) && view != null) {
                view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u4efb\u52a1\u5df2\u5b8c\u6210,\u7f16\u7801\uff1a%s", (String)"BatchPacketTaskClick_5", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber));
            }
        }
    }
}

