/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datasummary;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.exception.RiccBizException;

public class DataSummaryTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(DataSummaryTask.class);
    private static final String SELECT_CONFIG_ITEM_FIELDS = "id,number,name,rightpage,configtype";
    private ORM orm = ORM.create();

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        try {
            if (TaskSerailHelper.taskExist("ricc_data_summary_task")) {
                logger.info("\u540e\u53f0\u66f4\u65b0\u914d\u7f6e\u6570\u636e\u7edf\u8ba1\u4efb\u52a1\u5df2\u7ecf\u5728\u6267\u884c\u4e86\uff0c\u6682\u4e0d\u6267\u884c\u3002");
                return;
            }
            TaskSerailHelper.putTaskKey("ricc_data_summary_task");
            DeleteServiceHelper.delete((String)"ricc_datasummary", null);
            this.calculateAndSaveConfigCount();
        }
        catch (Exception e) {
            throw new RiccBizException("ricc_data_summary calculate error\u3002", (Throwable)e);
        }
        finally {
            TaskSerailHelper.taskKeyDelete("ricc_data_summary_task");
        }
    }

    private void calculateAndSaveConfigCount() {
        DynamicObject[] dataSummary = this.buildOneDataSummary();
        SaveServiceHelper.save((DynamicObject[])dataSummary);
    }

    private DynamicObject[] buildOneDataSummary() {
        DynamicObject[] needCountItems = this.getConfigCollection();
        ArrayList<DynamicObject> dataSummaryList = new ArrayList<DynamicObject>(needCountItems.length);
        for (DynamicObject oneCountItem : needCountItems) {
            String entityId;
            int count;
            ILocaleString name = oneCountItem.getLocaleString("name");
            String number = oneCountItem.getString("number");
            if (oneCountItem.getDynamicObject("rightpage") == null || (count = this.getConfigCount(number, entityId = oneCountItem.getDynamicObject("rightpage").getString("number"))) == -1) continue;
            String dataType = oneCountItem.getString("configtype");
            DynamicObject dataSummary = this.buildOneDataSummary(dataType, number, name, count);
            dataSummaryList.add(dataSummary);
        }
        return dataSummaryList.toArray(new DynamicObject[dataSummaryList.size()]);
    }

    private int getConfigCount(String number, String entityId) {
        int count = -1;
        try {
            count = this.orm.count("ricc_count_" + number, entityId, null);
        }
        catch (Exception e) {
            logger.error(String.format("\u67e5\u8be2\u7f16\u7801[%s]\uff0c\u5b9e\u4f53[%s]\u914d\u7f6e\u6570\u636e\u603b\u6570\u5931\u8d25\u3002", number, entityId), (Throwable)e);
        }
        return count;
    }

    private DynamicObject[] getConfigCollection() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] needCountItems = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)SELECT_CONFIG_ITEM_FIELDS, (QFilter[])qFilter.toArray());
        return needCountItems;
    }

    private DynamicObject buildOneDataSummary(String dataType, String number, ILocaleString name, int count) {
        DynamicObject dataSummary = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datasummary");
        dataSummary.set("datatype", (Object)dataType);
        dataSummary.set("number", (Object)number);
        dataSummary.set("name", (Object)name);
        dataSummary.set("count", (Object)count);
        dataSummary.set("updatetime", (Object)System.currentTimeMillis());
        return dataSummary;
    }
}

