/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.fasttransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddDataPacketTask;
import kd.sys.ricc.business.datapacket.schedule.AddTaskClick;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.schedule.ProgressBack;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.schedule.TaskHandler;
import kd.sys.ricc.business.schedule.TaskIf;
import kd.sys.ricc.business.transfer.PacketFastTransferTask;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PackMode;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.enums.TransferStatusEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class AddTransferTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(AddTransferTask.class);
    private static final String COMPLETE = "complete";
    private static final String TOTAL = "total";
    private ListSelectedRow selectPacket;
    private ListSelectedRowCollection dataRows;
    private ProgressBack progressBack;
    private Map<Long, Long> packetLogIdMap = new HashMap<Long, Long>(16);
    private DynamicObject[] packetLogs;
    private Map<Long, Boolean> transferFailResultMap = new HashMap<Long, Boolean>(16);
    private boolean isFail = false;
    private String total = "0";
    private String complete = "0";
    private List<String> transferTypeList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> contextMap) {
        this.initTask(contextMap);
        try {
            this.doTask(contextMap);
        }
        catch (Exception e) {
            this.isFail = true;
            this.progressBack.fail(CommonUtil.getExceptionDetailInfo((Throwable)e));
        }
        finally {
            this.progressBack.complete();
            this.recordPacketLog();
        }
    }

    private void initTask(Map<String, Object> contextMap) {
        this.transferTypeList = (List)contextMap.get("transfertype");
        String selectedDataStr = (String)contextMap.get("selectedData");
        this.dataRows = ListSelectedRowCollection.deSerialize((String)selectedDataStr);
        this.progressBack = new ProgressBack(this.taskId);
        Object targetData = contextMap.get("targetdata");
        if (targetData == null) {
            return;
        }
        Map targetDataMap = (Map)targetData;
        if (targetDataMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> packetLogList = new ArrayList<DynamicObject>(targetDataMap.size());
        for (Map.Entry targetDataEntry : targetDataMap.entrySet()) {
            Long targetDataCenterId = Long.valueOf((String)targetDataEntry.getKey());
            DynamicObject packetLog = BusinessDataServiceHelper.newDynamicObject((String)"ricc_log");
            long packetLogId = DB.genLongId((String)"ricc_log");
            packetLog.set("id", (Object)packetLogId);
            packetLog.set("name", contextMap.get("packetname"));
            packetLog.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
            packetLog.set("taskid", (Object)this.taskId);
            packetLog.set("optime", (Object)System.currentTimeMillis());
            packetLog.set("optype", (Object)"4");
            packetLog.set("state", (Object)"4");
            packetLog.set("traceid", (Object)RequestContext.get().getTraceId());
            String logNumber = CodeRuleServiceHelper.getNumber((String)"ricc_log", (DynamicObject)packetLog, null);
            packetLog.set("billno", (Object)logNumber);
            packetLogList.add(packetLog);
            this.packetLogIdMap.put(targetDataCenterId, packetLogId);
        }
        SaveServiceHelper.save((DynamicObject[])packetLogList.toArray(new DynamicObject[0]));
    }

    private void doTask(Map<String, Object> contextMap) {
        ArrayList<Long> packetLogIds = new ArrayList<Long>(this.packetLogIdMap.values());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"ricc_log");
        this.packetLogs = BusinessDataServiceHelper.load((Object[])packetLogIds.toArray(), (DynamicObjectType)dataEntityType);
        this.progressBack.custData.put("packetLogId", packetLogIds);
        StringBuilder taskDesc = new StringBuilder();
        this.createPacket(contextMap);
        if (this.isFail) {
            return;
        }
        this.total = String.valueOf(this.dataRows.size());
        this.progressBack.custData.put(TOTAL, this.total);
        this.progressBack.custData.put(COMPLETE, this.complete);
        taskDesc.append(ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6570\u636e\u6253\u5305...", (String)"AddTransferTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.progressBack.feedbackProgress(0, taskDesc.toString());
        this.doPacket(this.selectPacket, contextMap);
        if (this.isFail) {
            return;
        }
        taskDesc.append('\n').append(ResManager.loadKDString((String)"\u6253\u5305\u5b8c\u6210\uff0c\u6b63\u5728\u63d0\u4ea4\u5ba1\u6838\u4f20\u8f93\u5305...", (String)"AddTransferTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
        this.progressBack.feedbackProgress(50, taskDesc.toString());
        long packetId = (Long)this.selectPacket.getPrimaryKeyValue();
        this.submitAndAuditPacket(packetId);
        if (this.isFail) {
            return;
        }
        taskDesc.append('\n').append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4f20\u8f93\u5305\u4f20\u8f93...", (String)"AddTransferTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
        if (this.transferTypeList.contains("transferandsyn")) {
            taskDesc.append('\n').append(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u6570\u636e\u540c\u6b65...", (String)"AddTransferTask_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        this.progressBack.custData.put("transferstatus", TransferStatusEnum.Excuting.getVal());
        this.progressBack.feedbackProgress(60, taskDesc.toString());
        this.excuteTransferTask(contextMap, packetId);
        this.progressBack.feedbackProgress(99, taskDesc.toString());
    }

    private void createPacket(Map<String, Object> contextMap) {
        Object packetVersionId = contextMap.get("packetversion");
        String packetName = (String)contextMap.get("packetname");
        String description = (String)contextMap.get("description");
        long packetId = DB.genLongId((String)"ricc_datapacket");
        DynamicObject newPacket = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datapacket");
        newPacket.set("id", (Object)packetId);
        newPacket.set("packetversion", packetVersionId);
        newPacket.set("status", (Object)"A");
        newPacket.set("creator", (Object)RequestContext.get().getCurrUserId());
        newPacket.set("createtime", (Object)System.currentTimeMillis());
        newPacket.set("dltrcount", (Object)0);
        newPacket.set("enable", (Object)"1");
        newPacket.set("packettype", (Object)DataPacketTypeEnum.CONFIG.getVal());
        newPacket.set("name", (Object)packetName);
        String packetNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datapacket", (DynamicObject)newPacket, null);
        newPacket.set("number", (Object)packetNumber);
        newPacket.set("remarks", (Object)description);
        newPacket.set("datasource", (Object)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal());
        newPacket.set("lockedstatus", (Object)PacketLockEnum.NOT_LOCKED.getVal());
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPacket});
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u521b\u5efa\u5931\u8d25\uff1a", (String)"AddTransferTask_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.progressBack.fail(errMsg + CommonUtil.getExceptionDetailInfo((Throwable)e));
            this.isFail = true;
        }
        this.selectPacket = new ListSelectedRow();
        this.selectPacket.setName(packetName);
        this.selectPacket.setPrimaryKeyValue((Object)packetId);
        this.selectPacket.setNumber(packetNumber);
    }

    public void doPacket(ListSelectedRow selectedPacket, Map<String, Object> contextMap) {
        Object selectGuideId = contextMap.get("guideId");
        String parentPageId = (String)contextMap.get("parentPageId");
        String packetType = (String)contextMap.get("packettype");
        Map custParam = (Map)contextMap.get("custParam");
        if (this.dataRows.size() <= 1000) {
            SdpOutputParams sdpOutputParams = SubDataPacketDispatch.exportPacket(packetType, selectGuideId, selectedPacket, this.dataRows, parentPageId, custParam, null);
            String msgTpl = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff1a%s", (String)"AddTransferTask_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
            if (!sdpOutputParams.isSuccess()) {
                this.progressBack.fail(String.format(msgTpl, sdpOutputParams.getErrorStr()));
                this.isFail = true;
                return;
            }
            try {
                DynamicObject subDataPacket = (DynamicObject)sdpOutputParams.getParam().get("subDataPacket");
                List<DynamicObject> relyPacketList = sdpOutputParams.getParam().getOrDefault("relyBdPacketList", Collections.emptyList());
                List multiPacketList = sdpOutputParams.getParam().getOrDefault("multiDataPacketList", Collections.emptyList());
                relyPacketList.addAll(multiPacketList);
                if (relyPacketList.isEmpty()) {
                    SubDataPacketDispatch.saveSubDataPacket(selectedPacket.getPrimaryKeyValue(), subDataPacket);
                } else {
                    relyPacketList.add(subDataPacket);
                    SubDataPacketDispatch.saveBatchSubDataPacket(selectedPacket.getPrimaryKeyValue(), relyPacketList);
                }
            }
            catch (RiccBizException e) {
                logger.error("\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u540e\u4fdd\u5b58\u65f6\u5931\u8d25", (Throwable)e);
                this.progressBack.fail(String.format(msgTpl, e.getMessage()));
                this.isFail = true;
                return;
            }
            this.progressBack.custData.put(COMPLETE, this.total);
            this.complete = this.total;
        } else {
            contextMap.put("selectedPacket", selectedPacket);
            contextMap.put("packmode", PackMode.ADD_DIRECTLY.getValue());
            String jobName = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"AddTransferTask_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
            JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(jobName, AddDataPacketTask.class.getName(), AddTaskClick.class.getName(), null, contextMap);
            jobFormInfo.getJobInfo().setAppId("ricc");
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            try {
                new TaskHandler(taskId, new TaskIf(){

                    @Override
                    public void ifUpdate(TaskInfo taskInfo) {
                        Map<String, Object> addTaskData = ScheduleUtil.getTaskCustData(taskInfo);
                        AddTransferTask.this.total = (String)addTaskData.get(AddTransferTask.TOTAL);
                        AddTransferTask.this.complete = (String)addTaskData.get(AddTransferTask.COMPLETE);
                        ((AddTransferTask)AddTransferTask.this).progressBack.custData.put(AddTransferTask.TOTAL, AddTransferTask.this.total);
                        ((AddTransferTask)AddTransferTask.this).progressBack.custData.put(AddTransferTask.COMPLETE, AddTransferTask.this.complete);
                        AddTransferTask.this.progressBack.feedbackProgress(taskInfo.getProgress() / 2, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u6570\u636e\u6253\u5305", (String)"AddTransferTask_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                }).wait2End();
            }
            catch (RiccBizException e) {
                logger.error("\u6dfb\u52a0\u4f20\u8f93\u4efb\u52a1\uff0c\u540e\u53f0\u6267\u884c\u4f20\u8f93\u5305\u4f20\u8f93\u65f6\u5931\u8d25", (Throwable)e);
                String message = ResManager.loadKDString((String)"\u6dfb\u52a0\u4f20\u8f93\u5305\u4efb\u52a1\u6267\u884c\u5931\u8d25", (String)"AddTransferTask_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.progressBack.fail(message + e.getMessage());
                this.isFail = true;
            }
        }
    }

    private void submitAndAuditPacket(long packetId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("isStrict", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ricc_datapacket", (Object[])new Object[]{packetId}, (OperateOption)option);
        if (result.isSuccess()) {
            result = OperationServiceHelper.executeOperate((String)"audit", (String)"ricc_datapacket", (Object[])new Object[]{packetId}, (OperateOption)option);
        }
        if (!result.isSuccess()) {
            String message = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u63d0\u4ea4\u5ba1\u6838\u5931\u8d25\uff1a", (String)"AddTransferTask_8", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.progressBack.fail(message + result.getMessage() + result.getAllErrorOrValidateInfo());
            this.isFail = true;
        }
    }

    private void excuteTransferTask(Map<String, Object> contextMap, long packetId) {
        HashMap<String, Object> transferParam = new HashMap<String, Object>(2);
        transferParam.put("transfertype", contextMap.get("transfertype"));
        transferParam.put("targetdata", contextMap.get("targetdata"));
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        rows.add((Object)new ListSelectedRow((Object)packetId));
        transferParam.put("selectRows", rows.serialize());
        transferParam.put("packetLogIdMap", this.packetLogIdMap);
        try {
            PacketFastTransferTask task = new PacketFastTransferTask();
            task.setTaskId(String.valueOf(DB.genGlobalLongId()));
            task.realExecute(RequestContext.get(), transferParam);
        }
        catch (RiccBizException e) {
            logger.error("\u6dfb\u52a0\u4f20\u8f93\u4efb\u52a1\uff0c\u540e\u53f0\u6267\u884c\u4f20\u8f93\u5305\u4f20\u8f93\u4efb\u52a1\u65f6\u5931\u8d25", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4f20\u8f93\u4efb\u52a1\u6267\u884c\u5931\u8d25", (String)"AddTransferTask_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.progressBack.fail(message + e.getMessage());
            this.isFail = true;
            return;
        }
        ArrayList<Long> packetLogIds = new ArrayList<Long>(this.packetLogIdMap.values());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"ricc_log");
        for (DynamicObject packetLog : this.packetLogs = BusinessDataServiceHelper.load((Object[])packetLogIds.toArray(), (DynamicObjectType)dataEntityType)) {
            long packetLogId = packetLog.getLong("id");
            String status = packetLog.getString("state");
            if (StringUtils.equals((String)status, (String)"3") || StringUtils.equals((String)status, (String)"2")) {
                String errMsg = packetLog.getString("message_tag");
                this.progressBack.fail(errMsg);
                this.transferFailResultMap.put(packetLogId, true);
                continue;
            }
            if (!StringUtils.equals((String)status, (String)"1")) continue;
            this.transferFailResultMap.put(packetLogId, false);
        }
    }

    private void recordPacketLog() {
        int index = 0;
        for (DynamicObject packetLog : this.packetLogs) {
            long packetLogId = packetLog.getLong("id");
            Boolean isTransferFail = this.transferFailResultMap.get(packetLogId);
            if (this.selectPacket != null) {
                packetLog.set("name", (Object)this.selectPacket.getName());
                packetLog.set("packet", this.selectPacket.getPrimaryKeyValue());
            }
            if (this.isFail || isTransferFail.booleanValue()) {
                String msg = (String)this.progressBack.custData.get("failmessage");
                String msgHead = msg != null && msg.length() > 255 ? msg.substring(0, 200) : msg;
                packetLog.set("message", (Object)msgHead);
                packetLog.set("message_tag", (Object)msg);
                packetLog.set("state", (Object)"2");
            } else {
                packetLog.set("state", (Object)"1");
            }
            int totalCount = Integer.parseInt(this.total);
            String logState = packetLog.getString("state");
            if (StringUtils.equals((String)logState, (String)"1")) {
                packetLog.set("successcount", (Object)totalCount);
                packetLog.set("failedcount", (Object)0);
            } else {
                DynamicObjectCollection synLogEntry;
                packetLog.set("successcount", (Object)0);
                packetLog.set("failedcount", (Object)totalCount);
                if (StringUtils.equals((String)this.transferTypeList.get(index), (String)"transferandsyn") && (synLogEntry = packetLog.getDynamicObjectCollection("synlogentry")).size() > 0) {
                    int entrySuccessCount = ((DynamicObject)synLogEntry.get(0)).getInt("entrysuccesscount");
                    int entryFailedCount = ((DynamicObject)synLogEntry.get(0)).getInt("entryfailedcount");
                    if (entrySuccessCount != 0 || entryFailedCount != 0) {
                        packetLog.set("successcount", (Object)entrySuccessCount);
                        packetLog.set("failedcount", (Object)entryFailedCount);
                    }
                }
            }
            ++index;
        }
        SaveServiceHelper.save((DynamicObject[])this.packetLogs);
    }
}

