/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schemeconfig;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.business.schemeconfig.Action;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.exception.RiccBizException;

public abstract class AbstractIscInitAction
implements Action {
    private static final Log logger = LogFactory.getLog(AbstractIscInitAction.class);
    protected static final DBRoute SYS_DB_ROUTE = DBRoute.of((String)"sys");
    private Long id;
    private String name;
    private int status = 1;
    private StringBuilder msg = new StringBuilder();
    private Date startTime;
    private Date endTime;
    private int progress = 0;

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public StringBuilder getMsg() {
        return this.msg;
    }

    @Override
    public void setMsg(StringBuilder msg) {
        this.msg = msg;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean isOver() {
        return false;
    }

    protected abstract void doAction();

    protected void afterDoAction() {
        this.setEndTime(new Date());
        this.updateActionData();
    }

    protected void beforeDoAction() {
        this.setStartTime(new Date());
        this.setStatus(2);
        this.updateActionData();
    }

    protected void updateActionData() {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_RICC_SCHEMECONENTRY SET FTASKSTATUS = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(":FTASKSTATUS", 4, (Object)this.getStatus()));
        sqlBuffer.append(",FIMPLEDETAILS_TAG = ?");
        paraList.add(new SqlParameter(":FIMPLEDETAILS_TAG", 12, (Object)this.getMsg().toString()));
        sqlBuffer.append(",FPROGRESS = ? ");
        paraList.add(new SqlParameter(":FPROGRESS", 4, (Object)this.getProgress()));
        sqlBuffer.append(",FSTARTTIME = ? ");
        paraList.add(new SqlParameter(":FSTARTTIME", 91, (Object)this.getStartTime()));
        sqlBuffer.append(",FENDTIME = ? ");
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)this.getEndTime()));
        sqlBuffer.append(",FUSEDTIMES = ? ");
        String subTimes = TimeCostUtil.getUsedTime((long)this.getStartTime().getTime(), (long)System.currentTimeMillis());
        paraList.add(new SqlParameter(":FUSEDTIMES", 12, (Object)subTimes));
        sqlBuffer.append("WHERE FENTRYID = ? ");
        paraList.add(new SqlParameter(":FENTRYID", -5, (Object)this.getId()));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)SYS_DB_ROUTE, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw new RiccBizException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void execute() {
        this.beforeDoAction();
        try {
            if (this.isOver()) {
                this.setStatus(3);
            } else {
                this.doAction();
            }
        }
        catch (Exception e) {
            this.setStatus(4);
            this.getMsg().append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u3010%1$s\u3011\u6267\u884c\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0%2$s", (String)"AbstractIscInitAction_0", (String)"sys-ricc-platform", (Object[])new Object[0]), this.getName(), CommonUtil.getExceptionDetailInfo((Throwable)e)));
        }
        this.afterDoAction();
    }
}

