/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchdatacompare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.enums.DataSelectWayEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.OpenFilterFormUtil;
import kd.sys.ricc.common.util.PageChangeUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class DataComparePlanPlugin
extends AbstractBasePlugIn {
    private static final String CONFIG_ITEM = "page";
    private static final String KEY_FIELDS = "keyfields";
    private static final String FILTER_CONDITION = "filtercondition";
    private static final String FILTER_CONDITION_STORE = "filterconditionstore";
    private static final String FILTER_CONDITION_STORE_TAG = "filterconditionstore_tag";
    private static final String MANUAL_SEL = "manualsel";
    private static final String MANUAL_SELECT_CLOSE_ACTION = "manualselectcloseaction";
    private static final String MANUAL_SELECT_DATA_TAG = "manualselectdata_tag";
    private static final String MANUAL_SEL_CONDITION = "manualselcondition";
    private static final String DATA_SELECT_WAY = "dataselectway";
    private static final String DATA_SELECT_WAY_ACTION = "dataselectwayaction";
    private static final String DATA_SELECT_MARK = "dataselectmark";
    private static final String DATA_PREVIEW = "datapreview";
    private static final String COMPARE = "compare";
    private static final String COMPARE_REPORT = "comparereport";
    private static final String BATCH_COUNT = "batchcount";
    private static final String SYS = "sys";
    private static final String PAGE_NUMBER = "page.number";
    private static final String BOTP_CRLIST = "botp_crlist";
    private static final String BOS_MANAGE_PRINT_TPL = "bos_manageprinttpl";
    private static final String DATA_COMPARE_PLAN = "datacompareplan";
    private static final String IS_IGNORE_CREATE_INFO = "isignorecreateinfo";
    private static final String IS_IGNORE_KEY = "isignorekey";
    private static final String IS_IGNORE_BD_ID = "isignorebdid";
    private static final String IS_IGNORE_MULTILINGUAL = "isignoremultilingual";
    private static final String DATA_COMPARE_TASK = "kd.sys.ricc.formplugin.batchdatacompare.task.BatchDataCompareTask";
    private static final String COMPARE_STATUS = "comparestatus";
    private static final String RIGHT_PAGE = "rightpage";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FILTER_CONDITION});
        this.addClickListeners(new String[]{MANUAL_SEL});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String entityNumber = this.getEntityNumber();
        PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBeforeCenterAndUser();
    }

    private void setBeforeCenterAndUser() {
        Object td = this.getView().getModel().getValue("targetdatacenter");
        if (td == null) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            long dataCenter = this.getBeforeDataCenter(currentUserId);
            this.getView().getModel().setValue("targetdatacenter", (Object)dataCenter);
            String phone = (String)this.getView().getModel().getValue("targetdatacenteruser");
            if (StringUtils.isEmpty((String)phone)) {
                this.getView().getModel().setValue("targetdatacenteruser", (Object)this.getLatestUserPhone(dataCenter, currentUserId));
            }
        }
    }

    private long getBeforeDataCenter(long currentUserId) {
        List userIds;
        DynamicObjectCollection controlledUsers;
        QFilter creatorFilter = new QFilter("creator.id", "=", (Object)currentUserId);
        DynamicObject[] rptDyo = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)"targetdatacenter", (QFilter[])creatorFilter.toArray(), (String)"starttime desc", (int)1);
        long beforeDataCenter = rptDyo != null && rptDyo.length > 0 ? ((DynamicObject)rptDyo[0].get("targetdatacenter")).getLong("id") : CommonQuery.getDefaultDataCenter();
        DynamicObject dataCenter = BusinessDataServiceHelper.loadSingle((Object)beforeDataCenter, (String)"ricc_destaccount");
        boolean controlled = dataCenter.getBoolean("controlled");
        if (controlled && Objects.nonNull(controlledUsers = dataCenter.getDynamicObjectCollection("authorizeduser")) && !(userIds = controlledUsers.stream().map(l -> l.getLong("fbasedataid_id")).collect(Collectors.toList())).contains(currentUserId)) {
            beforeDataCenter = 0L;
        }
        return beforeDataCenter;
    }

    private String getLatestUserPhone(long centerId, long currentUserId) {
        String phone = "";
        QFilter[] idFilter = new QFilter[]{new QFilter("creator.id", "=", (Object)currentUserId), new QFilter("targetdatacenter", "=", (Object)centerId)};
        DynamicObject[] currentUser = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)"targetdatacenteruser", (QFilter[])idFilter, (String)"createtime desc", (int)1);
        phone = !Objects.isNull(currentUser) && currentUser.length > 0 ? currentUser[0].getString("targetdatacenteruser") : CommonQuery.getCurrentUserPhone();
        return phone;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String entityNumber = this.getEntityNumber();
        PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        AbstractOperate operate = (AbstractOperate)event.getSource();
        String opKey = operate.getOperateKey();
        String planNumber = (String)this.getModel().getValue("number");
        if (StringUtils.equals((String)opKey, (String)DATA_PREVIEW)) {
            this.previewData(event);
        } else if (StringUtils.equals((String)opKey, (String)"save")) {
            this.beforeSaveCheck(event);
        } else if (StringUtils.equals((String)opKey, (String)COMPARE)) {
            this.beforeCompareCheck(event);
        } else if (StringUtils.equals((String)opKey, (String)COMPARE_REPORT)) {
            this.openDataCompareRpt(planNumber);
        }
    }

    private void beforeSaveCheck(BeforeDoOperationEventArgs event) {
        QFilter[] dataFilter;
        DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
        String entityNumber = configItem.getString(PAGE_NUMBER);
        List pksList = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])(dataFilter = this.getDataFilter(entityNumber)), null, (int)-1);
        if (pksList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8fdb\u884c\u5bf9\u6bd4\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u6216\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"DataComparePlanPlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        boolean overDataLimit = this.isOverDataLimit(entityNumber);
        if (overDataLimit) {
            event.setCancel(true);
        }
    }

    private void previewData(BeforeDoOperationEventArgs event) {
        DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
        if (configItem == null) {
            this.getView().showTipNotification(this.getConfigItemMessage());
            return;
        }
        String entityNumber = configItem.getString(PAGE_NUMBER);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        String f7ListFormId = listFormConfig.getF7ListFormId();
        if (StringUtils.equals((String)entityNumber, (String)BOTP_CRLIST) || StringUtils.equals((String)entityNumber, (String)BOS_MANAGE_PRINT_TPL) || StringUtils.equals((String)entityNumber, (String)"gl_initbalance")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8", (String)"DataComparePlanPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        QFilter[] filters = this.getDataFilter(entityNumber);
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, null, Arrays.asList(filters), (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.DataPreviewListPlugin");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        String pageParam = (String)configItem.get("pageenterparam");
        ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private QFilter[] getDataFilter(String entityNumber) {
        QFilter filter = null;
        String dataSelectWay = (String)this.getModel().getValue(DATA_SELECT_WAY);
        if (DataSelectWayEnum.FILTER_SELECT_WAY.getVal().equals(dataSelectWay)) {
            String filterStr = (String)this.getModel().getValue(FILTER_CONDITION_STORE_TAG);
            if (!StringUtils.isEmpty((String)filterStr)) {
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), crCondition.getFilterCondition());
                fb.buildFilter();
                filter = fb.getQFilter();
            }
        } else {
            String selectData = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG);
            if (StringUtils.isEmpty((String)selectData)) {
                filter = new QFilter("id", "in", (Object)new Object[0]);
            } else {
                List<Object> ids = this.getManualSelectDataIds();
                filter = new QFilter("id", "in", ids);
            }
        }
        return filter == null ? new QFilter[]{} : filter.toArray();
    }

    private List<Object> getManualSelectDataIds() {
        ArrayList<Object> selectDataIdsList = new ArrayList<Object>();
        String selectDataStr = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG);
        if (StringUtils.isEmpty((String)selectDataStr)) {
            return selectDataIdsList;
        }
        String entityNumber = ((DynamicObject)this.getModel().getValue(CONFIG_ITEM)).getString(PAGE_NUMBER);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ISimpleProperty idProperty = dataEntityType.getPrimaryKey();
        JSONObject selectData = JSON.parseObject((String)selectDataStr);
        if (idProperty instanceof LongProp) {
            return selectData.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        if (idProperty instanceof VarcharProp) {
            return new ArrayList<Object>(selectData.keySet());
        }
        String msgTpl = ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u7684\u4e3b\u952e\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u82cd\u7a79\u7684\u89c4\u8303\uff0c\u8bf7\u4fee\u6539\u4e3b\u952e\u7684\u6570\u636e\u7c7b\u578b\u4e3along\u6216\u8005varchar", (String)"DataComparePlanPlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]);
        throw new RiccBizException(String.format(msgTpl, entityNumber));
    }

    private void beforeCompareCheck(BeforeDoOperationEventArgs event) {
        String compareStatus;
        DynamicObject desAccountObj;
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5bf9\u6bd4\u5931\u8d25\uff0c\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u5bf9\u6bd4\u65b9\u6848", (String)"DataComparePlanPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        boolean dataChanged = this.getView().getModel().getDataChanged();
        if (dataChanged) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u53d1\u751f\u503c\u6539\u53d8\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u6267\u884c\u5bf9\u6bd4", (String)"DataComparePlanPlugin_17", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        String enable = (String)this.getModel().getValue("enable");
        if (enable.equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5bf9\u6bd4\u5931\u8d25\uff0c\u7981\u7528\u7684\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u4e0d\u5141\u8bb8\u6267\u884c\u5bf9\u6bd4\uff0c\u82e5\u8981\u5bf9\u6bd4\u8bf7\u5148\u542f\u7528\u8be5\u5bf9\u6bd4\u65b9\u6848", (String)"DataComparePlanPlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
        String entityNumber = configItem.getString(PAGE_NUMBER);
        String dataSelectWay = (String)this.getModel().getValue(DATA_SELECT_WAY);
        List<Object> manualSelectDataIds = this.getManualSelectDataIds();
        if (StringUtils.equals((String)dataSelectWay, (String)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal())) {
            for (Object manualSelectDataId : manualSelectDataIds) {
                boolean exists = QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "=", manualSelectDataId)});
                if (exists) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5185\u7801\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u5e76\u4fdd\u5b58\uff0c\u518d\u6267\u884c\u5bf9\u6bd4", (String)"DataComparePlanPlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]), manualSelectDataId));
                event.setCancel(true);
                return;
            }
        }
        if ((desAccountObj = (DynamicObject)this.getModel().getValue("targetdatacenter")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u3002", (String)"DataComparePlanPlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        long dataComparePlanId = (Long)this.getModel().getValue("id");
        QFilter numberFilter = new QFilter("datacompareplan.id", "=", (Object)dataComparePlanId);
        DynamicObject[] rptDyo = BusinessDataServiceHelper.load((String)"ricc_datacompare_rpt", (String)COMPARE_STATUS, (QFilter[])numberFilter.toArray(), (String)"createtime desc", (int)1);
        if (rptDyo != null && rptDyo.length > 0 && (compareStatus = rptDyo[0].getString(COMPARE_STATUS)).equals(CompareStatusEnum.BEGINNING.getVal())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u6b63\u5728\u6267\u884c\u6570\u636e\u5bf9\u6bd4\uff0c\u8bf7\u7b49\u5f85\uff0c\u6216\u65b0\u589e\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u518d\u6267\u884c\u5bf9\u6bd4", (String)"DataComparePlanPlugin_16", (String)"sys-ricc-platform", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        boolean overDataLimit = this.isOverDataLimit(entityNumber);
        if (overDataLimit) {
            event.setCancel(true);
        }
    }

    private boolean isOverDataLimit(String entityNumber) {
        QFilter[] dataFilter = this.getDataFilter(entityNumber);
        List pksList = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])dataFilter, null, (int)-1);
        DynamicObject initConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)1367275628033736704L, (String)"ricc_initconfig");
        int dataMaxSize = initConfig.getInt("batchpackmanualcount");
        if (pksList.size() > dataMaxSize) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u8fdb\u884c\u5bf9\u6bd4\u7684\u6570\u636e\u6570\u91cf\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236%d\u6761\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\u6027\uff0c\u8bf7\u7f29\u5c0f\u5bf9\u6bd4\u8303\u56f4\u6216\u5206\u6279\u8fdb\u884c\u5bf9\u6bd4", (String)"DataComparePlanPlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]), dataMaxSize));
            return true;
        }
        return false;
    }

    private void openDataCompareRpt(String planNumber) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            long planId = (Long)this.getModel().getDataEntity().getPkValue();
            qFilterList.add(new QFilter("datacompareplan.id", "=", (Object)planId));
        }
        ListShowParameter showParam = ShowParameterUtil.listShowParameter((String)"ricc_datacompare_rpt", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, null, qFilterList, null, null);
        String pageId = this.getView().getFormShowParameter().getRootPageId();
        showParam.setPageId(planNumber + pageId);
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        showParam.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (StringUtils.equals((String)fieldKey, (String)CONFIG_ITEM)) {
            boolean isCheckPass;
            DynamicObject configItem = (DynamicObject)changeData.getNewValue();
            this.getView().getModel().setValue(KEY_FIELDS, null);
            this.getView().getModel().setValue(FILTER_CONDITION, null);
            this.getView().getModel().setValue(FILTER_CONDITION_STORE, null);
            this.getView().getModel().setValue(FILTER_CONDITION_STORE_TAG, null);
            this.getView().getModel().setValue(MANUAL_SEL_CONDITION, (Object)this.getManualSelConditionMes());
            this.getView().getModel().setValue(MANUAL_SELECT_DATA_TAG, null);
            this.getView().getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
            if (configItem != null && (isCheckPass = this.checkConfigItemModelType(configItem))) {
                String configItemName;
                String entityNumber = this.getEntityNumber();
                PageChangeUtil.getKeyFields((IFormView)this.getView(), (String)entityNumber);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (entityType != null) {
                    this.getModel().setValue(KEY_FIELDS, (Object)entityType.getPrimaryKey().getName());
                }
                if (StringUtils.isNotBlank((CharSequence)(configItemName = configItem.getLocaleString("name").getLocaleValue()))) {
                    OrmLocaleValue planName = (OrmLocaleValue)this.getModel().getValue("name");
                    String planNameLocaleValue = planName.getLocaleValue();
                    String planNameEnd = ResManager.loadKDString((String)"_\u6570\u636e\u5bf9\u6bd4\u65b9\u6848", (String)"DataComparePlanPlugin_21", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    if (StringUtils.isBlank((CharSequence)planNameLocaleValue)) {
                        this.getModel().setValue("name", (Object)(configItem.getString("name") + planNameEnd));
                    } else if (planNameLocaleValue.endsWith(planNameEnd)) {
                        this.getModel().setValue("name", (Object)(configItem.getString("name") + planNameEnd));
                    }
                }
            }
        } else if (StringUtils.equals((String)fieldKey, (String)DATA_SELECT_WAY)) {
            String dataSelectWay = (String)changeData.getNewValue();
            String markDataSelection = this.getPageCache().get(DATA_SELECT_MARK);
            if (!StringUtils.equals((String)markDataSelection, (String)SYS)) {
                this.dataSelectWayChange(dataSelectWay);
            }
            this.getPageCache().remove(DATA_SELECT_MARK);
        } else if (StringUtils.equals((String)fieldKey, (String)FILTER_CONDITION) && StringUtils.isBlank((Object)changeData.getNewValue())) {
            this.getModel().setValue(FILTER_CONDITION, null);
            this.getModel().setValue(FILTER_CONDITION_STORE, null);
            this.getModel().setValue(FILTER_CONDITION_STORE_TAG, null);
        }
    }

    private String getEntityNumber() {
        DynamicObject rightPage = (DynamicObject)((DynamicObject)this.getView().getModel().getValue(CONFIG_ITEM)).get(RIGHT_PAGE);
        Object rightPageId = rightPage.get("id");
        QFilter rightPageFilter = new QFilter("id", "=", rightPageId);
        DynamicObject bosEntityMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"basedatafield", (QFilter[])rightPageFilter.toArray());
        return ((DynamicObject)bosEntityMeta.get("basedatafield")).getString("number");
    }

    private boolean checkConfigItemModelType(DynamicObject configItem) {
        String pageNumber = configItem.getString(PAGE_NUMBER);
        String pageName = configItem.getString("page.name");
        String importType = configItem.getString("importtype");
        QFilter numberFilter = new QFilter("number", "=", (Object)pageNumber);
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])numberFilter.toArray());
        String modelType = formMeta.getString("modeltype");
        if (!StringUtils.equals((String)modelType, (String)"BillFormModel") && !StringUtils.equals((String)modelType, (String)"BaseFormModel")) {
            ComboProp comboProp = (ComboProp)formMeta.getDataEntityType().getProperties().get((Object)"modeltype");
            String modelTypeName = comboProp.getItemByName(modelType);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u201c%1$s\u201d\u7684\u914d\u7f6e\u8868\u5355\u9875\u9762\u7c7b\u578b\u4e3a%2$s\uff0c\u6682\u4e0d\u652f\u6301\u6570\u636e\u5bf9\u6bd4", (String)"DataComparePlanPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]), pageName, modelTypeName));
            this.getModel().setValue(CONFIG_ITEM, null);
            return false;
        }
        if (!StringUtils.equals((String)importType, (String)"excel") && !StringUtils.equals((String)importType, (String)"json")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u201c%s\u201d\u7684\u4f20\u8f93\u65b9\u5f0f\u4e0d\u4e3aExcel\u4f20\u8f93\u6216Json\u4f20\u8f93\uff0c\u6682\u4e0d\u652f\u6301\u6570\u636e\u5bf9\u6bd4", (String)"DataComparePlanPlugin_18", (String)"sys-ricc-platform", (Object[])new Object[0]), pageName));
            this.getModel().setValue(CONFIG_ITEM, null);
            return false;
        }
        return true;
    }

    private void dataSelectWayChange(String dataSelectWay) {
        String filter = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"DataComparePlanPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String manual = ResManager.loadKDString((String)"\u624b\u5de5\u9009\u62e9", (String)"DataComparePlanPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        if (StringUtils.equals((String)dataSelectWay, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal())) {
            String manualSelectData = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG);
            if (manualSelectData.isEmpty()) {
                return;
            }
            this.getPageCache().put(DATA_SELECT_WAY, DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"DataComparePlanPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), filter, manual), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_SELECT_WAY_ACTION, (IFormPlugin)this));
            this.getPageCache().put(DATA_SELECT_MARK, SYS);
            this.getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal());
        } else {
            String filterSelectData = (String)this.getModel().getValue(FILTER_CONDITION_STORE);
            if (filterSelectData.isEmpty()) {
                this.getModel().setValue(FILTER_CONDITION_STORE_TAG, null);
                this.getModel().setValue(MANUAL_SEL_CONDITION, (Object)this.getManualSelConditionMes());
                return;
            }
            this.getPageCache().put(DATA_SELECT_WAY, DataSelectWayEnum.MANUAL_SELECT_WAY.getVal());
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"DataComparePlanPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), manual, filter), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_SELECT_WAY_ACTION, (IFormPlugin)this));
            this.getPageCache().put(DATA_SELECT_MARK, SYS);
            this.getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (StringUtils.equals((String)callBackId, (String)DATA_SELECT_WAY_ACTION) && result == MessageBoxResult.Yes) {
            String dataSelectWay = this.getPageCache().get(DATA_SELECT_WAY);
            if (StringUtils.equals((String)dataSelectWay, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal())) {
                this.getPageCache().put(DATA_SELECT_MARK, SYS);
                this.getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal());
                this.selMethodChangeClearData(MANUAL_SEL_CONDITION, MANUAL_SELECT_DATA_TAG);
            } else if (StringUtils.equals((String)dataSelectWay, (String)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal())) {
                this.getPageCache().put(DATA_SELECT_MARK, SYS);
                this.getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal());
                this.selMethodChangeClearData(FILTER_CONDITION, FILTER_CONDITION_STORE);
                this.getModel().setValue(FILTER_CONDITION_STORE_TAG, null);
                this.getModel().setValue(DATA_SELECT_WAY, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal());
                this.getModel().setValue(MANUAL_SEL_CONDITION, (Object)this.getManualSelConditionMes());
            }
        }
    }

    private void selMethodChangeClearData(String selectDataCondition, String beforeChangeStore) {
        this.getModel().setValue(selectDataCondition, null);
        this.getModel().setValue(beforeChangeStore, null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((String)controlKey, (String)FILTER_CONDITION)) {
            this.showDataFilterCondition();
        } else if (StringUtils.equals((String)controlKey, (String)MANUAL_SEL)) {
            this.showConfigItemListF7();
        }
    }

    private void showDataFilterCondition() {
        DynamicObject configItem = (DynamicObject)this.getView().getModel().getValue(CONFIG_ITEM);
        if (configItem == null) {
            this.getView().showTipNotification(this.getConfigItemMessage());
        } else {
            DynamicObject page = BusinessDataServiceHelper.loadSingleFromCache((Object)configItem.getPkValue(), (String)"ricc_configitems");
            String formId = page.getString("page.basedatafield.number");
            String conditionJson = (String)this.getModel().getValue(FILTER_CONDITION_STORE_TAG);
            String number = page.getString(PAGE_NUMBER);
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
            String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
            OpenFilterFormUtil.showConditionForm((IFormView)this.getView(), (String)conditionJson, (String)formId, (String)flsNodes, (String)this.getPluginName(), (String)"filtereditaction");
        }
    }

    private void showConfigItemListF7() {
        DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
        if (configItem == null) {
            this.getView().showTipNotification(this.getConfigItemMessage());
            return;
        }
        String entityNumber = configItem.getString(PAGE_NUMBER);
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        String f7ListFormId = listFormConfig.getF7ListFormId();
        if ("cts_layoutscheme_listf7".equals(f7ListFormId)) {
            f7ListFormId = "bos_listf7";
        }
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, null, null, (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.ManualSelectDataLimitPlugin");
        String pageParam = configItem.getString("pageenterparam");
        ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        List<Object> selectPks = this.getManualSelectDataIds();
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        listShowParameter.setListSelectedRowCollection(selectedRows);
        selectPks.forEach(pk -> selectedRows.add((Object)new ListSelectedRow(pk)));
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MANUAL_SELECT_CLOSE_ACTION));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((String)actionId, (String)"filtereditaction")) {
            String data = (String)event.getReturnData();
            if (!StringUtils.isEmpty((String)data)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)data, CRCondition.class);
                String exprTran = condition.getExprDesc();
                this.getModel().setValue(FILTER_CONDITION_STORE, (Object)exprTran);
                this.getModel().setValue(FILTER_CONDITION_STORE_TAG, (Object)data);
                this.getModel().setValue(FILTER_CONDITION, (Object)exprTran);
            }
            DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
            String entityNumber = configItem.getString(PAGE_NUMBER);
            this.isOverDataLimit(entityNumber);
        } else if (StringUtils.equals((String)actionId, (String)MANUAL_SELECT_CLOSE_ACTION)) {
            this.setManualSelectData(event);
        }
    }

    private void setManualSelectData(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            String numberField = null;
            int size = selectedRows.size();
            if (size > 0) {
                ListSelectedRow row2 = selectedRows.get(0);
                if (StringUtils.isNotEmpty((String)row2.getBillNo())) {
                    numberField = "billno";
                }
                if (StringUtils.isNotEmpty((String)row2.getNumber())) {
                    numberField = "number";
                }
            }
            HashMap dataIdNumberMaps = new HashMap(size);
            if ("number".equals(numberField)) {
                selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getNumber()));
            } else if ("billno".equals(numberField)) {
                selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getBillNo()));
            } else {
                selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), " "));
            }
            String dataStr = JSON.toJSONString(dataIdNumberMaps);
            this.getModel().setValue(MANUAL_SEL_CONDITION, (Object)String.format(ResManager.loadKDString((String)"\u5df2\u9009%d\u6761", (String)"DataComparePlanPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), size));
            this.getModel().setValue(MANUAL_SELECT_DATA_TAG, (Object)dataStr);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)COMPARE)) {
            DynamicObject configItem = (DynamicObject)this.getModel().getValue(CONFIG_ITEM);
            String entityNumber = configItem.getString(PAGE_NUMBER);
            int batchCount = (Integer)this.getModel().getValue(BATCH_COUNT);
            String dataFilterString = null;
            QFilter[] dataFilter = this.getDataFilter(entityNumber);
            if (dataFilter.length > 0) {
                dataFilterString = dataFilter[0].toSerializedString();
            }
            DynamicObject desAccountObj = (DynamicObject)this.getModel().getValue("targetdatacenter");
            long destAccountPk = (Long)desAccountObj.getPkValue();
            String targetCenterUser = (String)this.getModel().getValue("targetdatacenteruser");
            StringBuilder rptKeyFields = this.getKeyFieldsDisplayName(entityNumber);
            Object isIgnoreCreateInfo = this.getModel().getValue(IS_IGNORE_CREATE_INFO);
            Object isIgnoreKey = this.getModel().getValue(IS_IGNORE_KEY);
            Object isIgnoreBdId = this.getModel().getValue(IS_IGNORE_BD_ID);
            Object isIgnoreMultilingual = this.getModel().getValue(IS_IGNORE_MULTILINGUAL);
            String dataComparePlanNumber = (String)this.getModel().getValue("number");
            QFilter idFilter = new QFilter("number", "=", (Object)dataComparePlanNumber);
            DynamicObject dataComparePlan = BusinessDataServiceHelper.loadSingleFromCache((String)"ricc_datacompare_plan", (QFilter[])idFilter.toArray());
            DynamicObject dataCompareRpt = BusinessDataServiceHelper.newDynamicObject((String)"ricc_datacompare_rpt");
            dataCompareRpt.set("configitem_id", configItem.getPkValue());
            dataCompareRpt.set("targetdatacenter_id", (Object)destAccountPk);
            dataCompareRpt.set("targetdatacenteruser", (Object)targetCenterUser);
            dataCompareRpt.set(COMPARE_STATUS, (Object)CompareStatusEnum.BEGINNING.getVal());
            dataCompareRpt.set(DATA_COMPARE_PLAN, dataComparePlan.getPkValue());
            dataCompareRpt.set(IS_IGNORE_CREATE_INFO, isIgnoreCreateInfo);
            dataCompareRpt.set(IS_IGNORE_KEY, isIgnoreKey);
            dataCompareRpt.set(IS_IGNORE_BD_ID, isIgnoreBdId);
            dataCompareRpt.set(IS_IGNORE_MULTILINGUAL, isIgnoreMultilingual);
            dataCompareRpt.set(KEY_FIELDS, (Object)rptKeyFields);
            dataCompareRpt.set(BATCH_COUNT, (Object)batchCount);
            long dataCompareRptId = DB.genLongId((String)"t_ricc_datacompare_rpt");
            dataCompareRpt.set("id", (Object)dataCompareRptId);
            String readNumber = CodeRuleServiceHelper.getNumber((String)"ricc_datacompare_rpt", (DynamicObject)dataCompareRpt, null);
            dataCompareRpt.set("billno", (Object)readNumber);
            long creatorId = UserServiceHelper.getCurrentUserId();
            dataCompareRpt.set("creator_id", (Object)creatorId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCompareRpt});
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("dataFilter", dataFilterString);
            param.put("planId", this.getModel().getDataEntity().getPkValue());
            param.put("dataCompareRptId", dataCompareRptId);
            String jobName = ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u4efb\u52a1", (String)"DataComparePlanPlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
            JobFormInfo jobFormInfo = ScheduleUtil.buildJobFormInfo(jobName, DATA_COMPARE_TASK, "", this.getView(), param);
            jobFormInfo.getJobInfo().setAppId("ricc");
            ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            BaseShowParameter billShowDataDetail = new BaseShowParameter();
            billShowDataDetail.setPkId((Object)dataCompareRptId);
            billShowDataDetail.setFormId("ricc_datacompare_rpt");
            billShowDataDetail.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowDataDetail);
            String pageId = billShowDataDetail.getPageId();
            IFormView view = this.getView().getView(pageId);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u6570\u636e\u5bf9\u6bd4,\u8bf7\u624b\u5de5\u70b9\u51fb\u5237\u65b0\u6309\u94ae\u67e5\u770b\u5bf9\u6bd4\u8fdb\u5ea6", (String)"DataComparePlanPlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]), Integer.valueOf(5000));
            this.getView().sendFormAction(view);
        }
    }

    private StringBuilder getKeyFieldsDisplayName(String entityNumber) {
        String keyFields = (String)this.getModel().getValue(KEY_FIELDS);
        HashSet<String> keyFieldsSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        StringBuilder rptKeyFields = new StringBuilder();
        for (IDataEntityProperty property : entityType.getProperties()) {
            for (String keyField : keyFieldsSet) {
                if (!StringUtils.equals((String)keyField, (String)property.getName())) continue;
                if (StringUtils.equals((String)keyField, (String)"id")) {
                    rptKeyFields.append(ResManager.loadKDString((String)"\u5185\u7801\uff1b", (String)"DataComparePlanPlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    continue;
                }
                rptKeyFields.append(property.getDisplayName()).append('\uff1b');
            }
        }
        rptKeyFields.deleteCharAt(rptKeyFields.length() - 1);
        int keyFieldsMaxSize = 200;
        if (rptKeyFields.length() > keyFieldsMaxSize) {
            rptKeyFields = new StringBuilder(rptKeyFields.substring(0, keyFieldsMaxSize));
        }
        return rptKeyFields;
    }

    private String getConfigItemMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u9879", (String)"DataComparePlanPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }

    private String getManualSelConditionMes() {
        return ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"DataComparePlanPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
    }
}

