/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchdatacompare.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.common.enums.CompareDataResultEnum;
import kd.sys.ricc.common.enums.CompareStatusEnum;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.CompareDataUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.common.util.TransferUtil;
import kd.sys.ricc.common.util.setter.D;
import kd.sys.ricc.exception.RiccBizException;

public class BatchDataCompareTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(BatchDataCompareTask.class);
    private static final String IS_IGNORE_CREATE_INFO = "isignorecreateinfo";
    private static final String IS_IGNORE_KEY = "isignorekey";
    private static final String IS_IGNORE_BD_ID = "isignorebdid";
    private static final String IS_IGNORE_MULTILINGUAL = "isignoremultilingual";
    private static final String BASE_DATA_ID_PROP_SUFFIX = "_id";
    private static final DBRoute DB_SYS = DBRoute.of((String)"sys");
    private static final int VAL_MAX_SIZE = 200;
    private String entityNumber;
    private MainEntityType entityType;
    private int batchCount;
    private QFilter[] dataFilter;
    private Set<String> keyFieldsSet;
    private Map<String, Object> loginParams;
    private boolean isIgnoreCreateInfo;
    private boolean isIgnoreKey;
    private boolean isIgnoreBdId;
    private boolean isIgnoreMultilingual;
    private long dataCompareRptId;
    private int ignoreCount = 0;
    private int differentCount = 0;
    private int targetDataCount = 0;
    private int completeCompareCount = 0;
    private Set<String> bdProps;
    private Set<IDataEntityProperty> uniqueKeyProps;
    private CompareResult dataCompareResult = null;
    private static final HashMap<String, Integer> PRIORITIES = new HashMap(16);

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> paramsMap) {
        this.initTaskParam(paramsMap);
        long startTime = System.currentTimeMillis();
        List pksList = QueryServiceHelper.queryPrimaryKeys((String)this.entityNumber, (QFilter[])this.dataFilter, null, (int)-1);
        this.initUpdateProgress(pksList.size(), startTime, this.taskId, RequestContext.get().getTraceId());
        List splitsPks = BatchSplitUtil.splitBatch((List)pksList, (int)this.batchCount);
        try {
            DataEntityPropertyCollection properties = this.entityType.getProperties();
            Map compareRequiresPropMap = CompareDataUtil.getCompareRequiresPropMap((DataEntityPropertyCollection)properties);
            for (List pks : splitsPks) {
                Map currentDyo = BusinessDataServiceHelper.loadFromCache((String)this.entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                List<Map<String, Object>> curData = currentDyo.values().stream().map(dyo -> DynamicObjectUtil.object2Map((DynamicObject)dyo, (Map)compareRequiresPropMap)).collect(Collectors.toList());
                Map<String, List<Map<String, Object>>> currentCompareDataMap = this.getKeyFieldsValueToMap(curData);
                QFilter tarDataFilter = this.getKeyFieldFilter(currentDyo.values());
                Map<String, List<Map<String, Object>>> tarCompareDataMap = this.getTarCompareData(tarDataFilter, currentCompareDataMap.keySet());
                this.executeCompare(currentCompareDataMap, tarCompareDataMap, pksList.size());
            }
            this.batchUpdateProgress();
        }
        catch (RiccBizException e) {
            String errorMessage = BatchDataCompareTask.subErrorMessage((Exception)((Object)e));
            logger.error("\u6570\u636e\u5bf9\u6bd4\u65e5\u5fd7", (Throwable)e);
            long errorEndTime = System.currentTimeMillis();
            String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)errorEndTime);
            this.errorUpdateProgress(errorMessage, errorMessage, errorEndTime, consumeTime);
            return;
        }
        catch (Exception e) {
            String errorMessage = BatchDataCompareTask.subErrorMessage(e);
            String tagErrorMessage = e.getMessage() + CommonUtil.getExceptionDetailInfo((Throwable)e);
            logger.error("\u6570\u636e\u5bf9\u6bd4\u65e5\u5fd7", (Throwable)e);
            long errorEndTime = System.currentTimeMillis();
            String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)errorEndTime);
            this.errorUpdateProgress(errorMessage, tagErrorMessage, errorEndTime, consumeTime);
            return;
        }
        long endTime = System.currentTimeMillis();
        String consumeTime = TimeCostUtil.getUsedTime((long)startTime, (long)endTime);
        this.completeUpdateProgress(endTime, consumeTime);
    }

    private static String subErrorMessage(Exception e) {
        String errorMessage = e.getMessage();
        if (StringUtils.isEmpty((String)errorMessage)) {
            return "";
        }
        int maxSize = 160;
        if (errorMessage.length() > maxSize) {
            errorMessage = errorMessage.substring(0, maxSize);
        }
        return errorMessage;
    }

    private void initTaskParam(Map<String, Object> paramsMap) {
        long planId = (Long)paramsMap.get("planId");
        DynamicObject comparePlan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"ricc_datacompare_plan");
        DynamicObject configItem = comparePlan.getDynamicObject("page");
        this.entityNumber = configItem.getString("page.number");
        this.batchCount = comparePlan.getInt("batchcount");
        String dataFilterString = (String)paramsMap.get("dataFilter");
        this.dataFilter = !StringUtils.isEmpty((String)dataFilterString) ? new QFilter[]{QFilter.fromSerializedString((String)dataFilterString)} : new QFilter[0];
        String keyFields = comparePlan.getString("keyfields");
        this.keyFieldsSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        this.dataCompareRptId = (Long)paramsMap.get("dataCompareRptId");
        this.entityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        long destAccountPk = (Long)((DynamicObject)comparePlan.get("targetdatacenter")).getPkValue();
        String targetCenterUser = comparePlan.getString("targetdatacenteruser");
        this.loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        this.isIgnoreBdId = comparePlan.getBoolean(IS_IGNORE_BD_ID);
        this.isIgnoreCreateInfo = comparePlan.getBoolean(IS_IGNORE_CREATE_INFO);
        this.isIgnoreKey = comparePlan.getBoolean(IS_IGNORE_KEY);
        this.isIgnoreMultilingual = comparePlan.getBoolean(IS_IGNORE_MULTILINGUAL);
        this.bdProps = new HashSet<String>(4);
        this.getBaseDataPropName(this.bdProps, this.entityType.getProperties());
        this.uniqueKeyProps = this.getUniqueKeyProps();
    }

    private void getBaseDataPropName(Set<String> bdProps, DataEntityPropertyCollection properties) {
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof BasedataProp) {
                bdProps.add(((BasedataProp)prop).getBaseEntityId());
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
            this.getBaseDataPropName(bdProps, entryProperties);
        }
    }

    private void initUpdateProgress(int allDataCount, long startTime, String taskId, String traceId) {
        String progressDesc = String.format("%d/%d", 0, allDataCount);
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FCURRENTCOUNT = ?, FCOMPAREPROGRESS = ?, FSTARTTIME = ?, FTASKID = ?, FTRACEID = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(6);
        paraList.add(new SqlParameter(":FCURRENTCOUNT", 12, (Object)allDataCount));
        paraList.add(new SqlParameter(":FPROGRESS", 12, (Object)progressDesc));
        paraList.add(new SqlParameter(":FSTARTTIME", 91, (Object)new Date(startTime)));
        paraList.add(new SqlParameter(":FTASKID", 12, (Object)taskId));
        paraList.add(new SqlParameter(":FTRACEID", 12, (Object)traceId));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[6]));
    }

    private void batchUpdateProgress() {
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FTARGETCOUNT = ?, FDIFFERENTCOUNT = ?, FIGNORECOUNT = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(4);
        paraList.add(new SqlParameter(":FTARGETCOUNT", -5, (Object)this.targetDataCount));
        paraList.add(new SqlParameter(":FDIFFERENTCOUNT", -5, (Object)this.differentCount));
        paraList.add(new SqlParameter(":FIGNORECOUNT", -5, (Object)this.ignoreCount));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[4]));
    }

    private void errorUpdateProgress(String displayErrorMessage, String tagErrorMessage, long errorEndTime, String consumeTime) {
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FERRORMESSAGE = ?, FERRORMESSAGE_TAG = ?, FENDTIME = ?, FCOMPARETIME = ?, FCOMPARESTATUS = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(6);
        paraList.add(new SqlParameter(":FERRORMESSAGE", -9, (Object)displayErrorMessage));
        paraList.add(new SqlParameter(":FERRORMESSAGE_TAG", -9, (Object)tagErrorMessage));
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(errorEndTime)));
        paraList.add(new SqlParameter(":FCOMPARETIME", -9, (Object)consumeTime));
        paraList.add(new SqlParameter(":FCOMPARESTATUS", 12, (Object)CompareStatusEnum.UNUSUAL_STOP.getVal()));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[6]));
    }

    private void completeUpdateProgress(long endTime, String consumeTime) {
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FCOMPARESTATUS = ?, FENDTIME = ?, FCOMPARETIME = ?, FCOMPARERESULT = ? WHERE FID = ?";
        String compareResult = this.differentCount > 0 ? CompareDataResultEnum.DIFFERENCE.getVal() : CompareDataResultEnum.NO_DIFFERENCE.getVal();
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(5);
        paraList.add(new SqlParameter(":FCOMPARESTATUS", -9, (Object)CompareStatusEnum.FINISHED.getVal()));
        paraList.add(new SqlParameter(":FENDTIME", 91, (Object)new Date(endTime)));
        paraList.add(new SqlParameter(":FCOMPARETIME", -9, (Object)consumeTime));
        paraList.add(new SqlParameter(":FCOMPARERESULT", 12, (Object)compareResult));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[5]));
    }

    private void updateProgress(int allDataCount) {
        String progressDesc = String.format("%d/%d", this.completeCompareCount, allDataCount);
        String updateSql = "UPDATE T_RICC_DATACOMPARE_RPT SET FCOMPAREPROGRESS = ? WHERE FID = ?";
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>(2);
        paraList.add(new SqlParameter(":FCOMPAREPROGRESS", 12, (Object)progressDesc));
        paraList.add(new SqlParameter(":FID", -5, (Object)this.dataCompareRptId));
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])paraList.toArray(new SqlParameter[2]));
    }

    private void saveDataCompareResult(CompareResult compareResult) {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                compareResult.save();
            }
            catch (Exception e) {
                logger.error("sql\u6267\u884c\u5931\u8d25", (Throwable)e);
                h1.markRollback();
            }
        }
    }

    private Map<String, List<Map<String, Object>>> getKeyFieldsValueToMap(List<Map<String, Object>> compareData) {
        HashMap<String, List<Map<String, Object>>> fieldKeyValueMap = new HashMap<String, List<Map<String, Object>>>(4);
        for (Map<String, Object> compareDataObject : compareData) {
            StringBuilder tarKey = new StringBuilder();
            for (String key : this.keyFieldsSet) {
                IDataEntityProperty property = (IDataEntityProperty)this.entityType.getProperties().get((Object)key);
                if (property instanceof BasedataProp) {
                    tarKey.append(((Map)compareDataObject.get(key)).get("number")).append("$$$");
                    continue;
                }
                if (property instanceof MuliLangTextProp) {
                    tarKey.append(((Map)compareDataObject.get(key)).get("zh_CN")).append("$$$");
                    continue;
                }
                tarKey.append(compareDataObject.get(key)).append("$$$");
            }
            tarKey.delete(tarKey.length() - 3, tarKey.length());
            List dyoList = (List)fieldKeyValueMap.get(tarKey.toString());
            if (dyoList != null) {
                dyoList.add(compareDataObject);
                continue;
            }
            ArrayList<Map<String, Object>> compareDataList = new ArrayList<Map<String, Object>>(2);
            compareDataList.add(compareDataObject);
            fieldKeyValueMap.put(tarKey.toString(), compareDataList);
        }
        return fieldKeyValueMap;
    }

    private QFilter getKeyFieldFilter(Collection<DynamicObject> currentData) {
        QFilter filter = null;
        for (IDataEntityProperty prop : this.uniqueKeyProps) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            String name = prop.getName();
            for (DynamicObject dy : currentData) {
                Object keyFieldsValue = this.getKeyFieldsValue(prop, dy);
                valueSet.add(keyFieldsValue);
            }
            if (prop instanceof BasedataProp) {
                name = prop.getName() + ".number";
            }
            if (filter == null) {
                filter = new QFilter(name, "in", valueSet);
                continue;
            }
            filter.and(new QFilter(name, "in", valueSet));
        }
        return filter;
    }

    private Set<IDataEntityProperty> getUniqueKeyProps() {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)this.entityNumber).getProperties();
        HashSet<IDataEntityProperty> queryKeyProps = new HashSet<IDataEntityProperty>(4);
        for (IDataEntityProperty property : properties) {
            for (String keyField : this.keyFieldsSet) {
                if (!property.getName().equals(keyField)) continue;
                queryKeyProps.add(property);
            }
        }
        return queryKeyProps;
    }

    private Object getKeyFieldsValue(IDataEntityProperty prop, DynamicObject srcData) {
        String name = prop.getName();
        Object keyFieldsValue = prop instanceof MuliLangTextProp ? ((Map)srcData.get(name)).get("zh_CN") : (prop instanceof BasedataProp ? ((DynamicObject)srcData.get(name)).get("number") : srcData.get(name));
        return keyFieldsValue;
    }

    private Map<String, List<Map<String, Object>>> getTarCompareData(QFilter tarDataFilter, Set<String> compareDataKeys) {
        HashMap<String, Object> formParams = new HashMap<String, Object>(2);
        if (tarDataFilter != null) {
            String qFilterString = tarDataFilter.toSerializedString();
            formParams.put("qFilter", qFilterString);
        }
        formParams.put("entitynumber", this.entityNumber);
        formParams.put("compareDataKeys", compareDataKeys);
        formParams.put("keyFieldsSet", this.keyFieldsSet);
        String response = ApiUtil.getDestAccountData(formParams, this.loginParams, (String)"batchdatacompare");
        CustomApiResult apiResult = (CustomApiResult)JSON.parseObject((String)response, CustomApiResult.class);
        HashMap<String, Object> customData = new HashMap<String, Object>(4);
        if (!apiResult.isStatus()) {
            customData.put("fail", Boolean.TRUE);
            customData.put("failmessage", apiResult.getMessage());
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, customData);
            String errorCode = apiResult.getErrorCode();
            if (StringUtils.equals((String)errorCode, (String)"FormNotFound") || StringUtils.equals((String)errorCode, (String)"NoQueryPerm")) {
                throw new RiccBizException(apiResult.getMessage());
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u76ee\u6807\u73af\u5883\u6570\u636e\u5931\u8d25\uff0c%s", (String)"BatchDataCompareTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]), apiResult.getMessage()));
        }
        String responseData = (String)apiResult.getData();
        Map targetData = (Map)JSON.parse((String)responseData);
        if (targetData != null) {
            this.targetDataCount += targetData.size();
        }
        return targetData;
    }

    private void executeCompare(Map<String, List<Map<String, Object>>> currentCompareDataMap, Map<String, List<Map<String, Object>>> tarCompareDataMap, int allDataCount) {
        long[] compareDataEntryIds = DB.genLongIds((String)"t_ricc_datacompare_entry", (int)allDataCount);
        LinkedList entryIdList = new LinkedList();
        Arrays.stream(compareDataEntryIds).forEach(entryIdList::add);
        for (Map.Entry<String, List<Map<String, Object>>> entry : currentCompareDataMap.entrySet()) {
            String key = entry.getKey();
            List<Map<String, Object>> value = entry.getValue();
            List<Map<String, Object>> currentCompareData = currentCompareDataMap.get(key);
            List<Object> tarCompareData = new ArrayList(4);
            if (tarCompareDataMap != null) {
                tarCompareData = tarCompareDataMap.get(key);
            }
            HashMap<String, String> keyFieldsMap = this.getEntryFields(this.entityNumber);
            for (Map<String, Object> curDataMap : currentCompareData) {
                String suggestMethod;
                long compareDataEntryId = (Long)entryIdList.remove(0);
                Object curDataId = curDataMap.get(keyFieldsMap.get("id"));
                String curDataNumber = (String)curDataMap.get(keyFieldsMap.get("number"));
                curDataNumber = StringUtils.isEmpty((String)curDataNumber) ? " " : curDataNumber;
                String curDataName = this.getDataName(keyFieldsMap, curDataMap, curDataNumber);
                if (tarCompareData == null || tarCompareData.isEmpty()) {
                    suggestMethod = ResManager.loadKDString((String)"\u6839\u636e\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6570\u636e\uff0c\u5728\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u51c6\u786e\u6027\uff0c\u6216\u5230\u76ee\u6807\u73af\u5883\u67e5\u770b\u5177\u4f53\u60c5\u51b5", (String)"BatchDataCompareTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.dataCompareResult = new CompareResult(this.dataCompareRptId, compareDataEntryId, this.completeCompareCount + 1, curDataId, curDataNumber, curDataName, "", "", "", CompareDataResultEnum.DIFFERENCE.getVal(), suggestMethod);
                } else if (tarCompareData.size() > 1) {
                    suggestMethod = ResManager.loadKDString((String)"\u6839\u636e\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u7684\u6570\u636e\uff0c\u5728\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u5339\u914d\u5230\u591a\u6761\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u552f\u4e00\u6027\uff0c\u6216\u5230\u76ee\u6807\u73af\u5883\u67e5\u770b\u5177\u4f53\u6570\u636e\u60c5\u51b5", (String)"BatchDataCompareTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.dataCompareResult = new CompareResult(this.dataCompareRptId, compareDataEntryId, this.completeCompareCount + 1, curDataId, curDataNumber, curDataName, "", "", "", CompareDataResultEnum.DIFFERENCE.getVal(), suggestMethod);
                } else {
                    Map tarDataMap = (Map)tarCompareData.get(0);
                    String tarDataId = curDataMap.get(keyFieldsMap.get("id")).toString();
                    String tarDataNumber = (String)tarDataMap.get(keyFieldsMap.get("number"));
                    tarDataNumber = StringUtils.isEmpty((String)tarDataNumber) ? " " : curDataNumber;
                    String tarDataName = this.getDataName(keyFieldsMap, tarDataMap, tarDataNumber);
                    this.dataCompareResult = new CompareResult(this.dataCompareRptId, compareDataEntryId, this.completeCompareCount + 1, curDataId, curDataNumber, curDataName, tarDataId, tarDataNumber, tarDataName, "", "");
                    this.mapValCompare("", "", (IDataEntityType)this.entityType, curDataMap, tarDataMap);
                }
                this.saveDataCompareResult(this.dataCompareResult);
                ++this.completeCompareCount;
                if (CompareDataResultEnum.DIFFERENCE == this.dataCompareResult.hasDifference()) {
                    ++this.differentCount;
                    continue;
                }
                if (CompareDataResultEnum.IGNORE != this.dataCompareResult.hasDifference()) continue;
                ++this.ignoreCount;
            }
            this.updateProgress(allDataCount);
        }
    }

    private String getDataName(HashMap<String, String> keyFieldsMap, Map<String, Object> curDataMap, String curDataNumber) {
        Object nameMap;
        String curDataName = curDataNumber;
        if (this.entityType instanceof BasedataEntityType && (nameMap = curDataMap.get(keyFieldsMap.get("name"))) instanceof Map) {
            Object name = ((Map)nameMap).get("zh_CN");
            curDataName = name == null ? " " : name.toString();
        }
        return curDataName;
    }

    private HashMap<String, String> getEntryFields(String entityNumber) {
        this.entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String id = this.entityType.getPrimaryKey().getName();
        String number = null;
        String name = null;
        if (this.entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)this.entityType;
            number = basedataEntityType.getNumberProperty();
            name = basedataEntityType.getNameProperty();
        } else if (this.entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)this.entityType;
            name = number = billEntityType.getBillNo();
        }
        HashMap<String, String> keyFieldsMap = new HashMap<String, String>(4);
        keyFieldsMap.put("id", id);
        keyFieldsMap.put("number", number);
        keyFieldsMap.put("name", name);
        return keyFieldsMap;
    }

    private void mapValCompare(String preEntityName, String preEntityKey, IDataEntityType entityType, Map<String, Object> currentCompareMap, Map<String, Object> tarCompareMap) {
        String[] fields;
        for (String fieldKey : fields = this.collectKeys(currentCompareMap, tarCompareMap)) {
            Object curFieldVal = currentCompareMap.get(fieldKey);
            Object tarFieldVal = tarCompareMap.get(fieldKey);
            String curEntityName = this.getEntityDisplayName(entityType, fieldKey);
            String curEntityKey = fieldKey;
            if (!StringUtils.isEmpty((String)preEntityName)) {
                curEntityName = preEntityName + "." + curEntityName;
                curEntityKey = preEntityKey + "." + curEntityKey;
            }
            this.fieldCompare(curEntityName, curEntityKey, fieldKey, entityType, curFieldVal, tarFieldVal);
        }
    }

    private String[] collectKeys(Map<String, Object> currentCompareMap, Map<String, Object> tarCompareMap) {
        HashSet keys = new HashSet(currentCompareMap.size() + tarCompareMap.size());
        keys.addAll(currentCompareMap.keySet());
        keys.addAll(tarCompareMap.keySet());
        HashSet finalKeys = keys;
        String s = "$";
        keys = (HashSet)keys.stream().filter(key -> {
            if (key.startsWith(s)) {
                return false;
            }
            if (key.endsWith(BASE_DATA_ID_PROP_SUFFIX)) {
                String bdKey = key.substring(0, key.lastIndexOf(BASE_DATA_ID_PROP_SUFFIX));
                return !finalKeys.contains(bdKey);
            }
            return true;
        }).collect(Collectors.toSet());
        String[] array = keys.toArray(new String[0]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int p1 = this.getPriorities(s1);
                int p2 = this.getPriorities(s2);
                return Integer.compare(p1, p2);
            }

            private int getPriorities(String s1) {
                Integer p1 = (Integer)PRIORITIES.get(s1);
                return p1 == null ? PRIORITIES.size() : p1.intValue();
            }
        });
        return array;
    }

    private String getEntityDisplayName(IDataEntityType entity, String key) {
        if (entity == null) {
            return key;
        }
        IDataEntityProperty property = (IDataEntityProperty)entity.getProperties().get((Object)key);
        if (property == null) {
            return key;
        }
        String s = D.s((Object)property.getDisplayName());
        if (s != null) {
            return s;
        }
        return key;
    }

    private void fieldCompare(String curEntityName, String curEntityKey, String fieldKey, IDataEntityType entityType, Object curFieldVal, Object tarFieldVal) {
        boolean isIgnore = this.compareStrategy(curEntityName, curEntityKey, entityType, fieldKey);
        if (StringUtils.isBlank((Object)curFieldVal)) {
            this.handleCurrentIsNull(curEntityName, curEntityKey, entityType, tarFieldVal, isIgnore);
        } else if (StringUtils.isBlank((Object)tarFieldVal)) {
            this.handleTargetIsNull(curEntityName, curEntityKey, entityType, curFieldVal, isIgnore);
        } else if (curFieldVal instanceof Map && tarFieldVal instanceof Map) {
            this.mapValCompare(curEntityName, curEntityKey, this.getSubEntityType(entityType, fieldKey), (Map)curFieldVal, (Map)tarFieldVal);
        } else if (curFieldVal instanceof List && tarFieldVal instanceof List) {
            this.handleEntryEntity(curEntityName, curEntityKey, this.getSubEntityType(entityType, fieldKey), (List)curFieldVal, (List)tarFieldVal);
        } else {
            boolean isEquals;
            if (curFieldVal instanceof Date) {
                curFieldVal = JSON.toJSONStringWithDateFormat((Object)curFieldVal, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[0]).replace("\"", "");
                isEquals = curFieldVal.equals(tarFieldVal.toString());
            } else {
                isEquals = curFieldVal instanceof BigDecimal || curFieldVal instanceof Long ? StringUtils.equals((String)curFieldVal.toString(), (String)tarFieldVal.toString()) : curFieldVal.equals(tarFieldVal);
            }
            String differentType = CompareDataResultEnum.valueOf((boolean)isEquals).getVal();
            if (isIgnore && !isEquals) {
                differentType = CompareDataResultEnum.IGNORE.getVal();
            }
            FieldCompareResult fieldCompareResult = new FieldCompareResult(this.dataCompareResult.getEntryId(), curEntityName, curEntityKey, curFieldVal, tarFieldVal, differentType);
            this.dataCompareResult.add(fieldCompareResult);
        }
    }

    private boolean compareStrategy(String curEntityName, String curEntityKey, IDataEntityType entityType, String fieldKey) {
        boolean isBaseDataProp;
        boolean isIgnore;
        if (this.isIgnoreCreateInfo) {
            DataEntityPropertyCollection properties = this.entityType.getProperties();
            boolean isModifierOrCreator = BatchDataCompareTask.isModifierOrCreator(curEntityKey, properties);
            if (isModifierOrCreator) {
                return true;
            }
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldKey);
            if (property instanceof ModifyDateProp || property instanceof CreateDateProp) {
                return true;
            }
        }
        if (this.isIgnoreMultilingual && curEntityKey.contains(".") && (isIgnore = Arrays.toString(Lang.values()).replace("zh_CN", "").contains(fieldKey))) {
            return true;
        }
        boolean bl = isBaseDataProp = entityType != null && StringUtils.isNotBlank((CharSequence)curEntityName) && this.bdProps.contains(entityType.getName());
        if (isBaseDataProp) {
            if (this.isIgnoreBdId) {
                isIgnore = StringUtils.equals((String)fieldKey, (String)"id");
                return isIgnore;
            }
        } else if (this.isIgnoreKey) {
            isIgnore = StringUtils.equals((String)fieldKey, (String)"id") || StringUtils.equals((String)fieldKey, (String)"masterid") || curEntityKey.endsWith(".id");
            return isIgnore;
        }
        return false;
    }

    private static boolean isModifierOrCreator(String curEntityKey, DataEntityPropertyCollection properties) {
        boolean isModifierOrCreator = false;
        if (curEntityKey.contains(".") && !curEntityKey.endsWith(".name")) {
            String[] entityKeys;
            for (String entityKey : entityKeys = curEntityKey.split("\\.")) {
                IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)entityKey);
                if (!(prop instanceof ModifierProp) && !(prop instanceof CreaterProp)) continue;
                isModifierOrCreator = true;
            }
        }
        return isModifierOrCreator;
    }

    private void handleCurrentIsNull(String fieldDisplayName, String fieldDisplayKey, IDataEntityType entityType, Object tarFieldVal, boolean isIgnore) {
        if (StringUtils.isBlank((Object)tarFieldVal)) {
            tarFieldVal = "";
            FieldCompareResult fieldCompareResult = new FieldCompareResult(this.dataCompareResult.getEntryId(), fieldDisplayName, fieldDisplayKey, "", tarFieldVal, CompareDataResultEnum.NO_DIFFERENCE.getVal());
            this.dataCompareResult.add(fieldCompareResult);
        } else if (tarFieldVal instanceof Map) {
            this.mapValCompare(fieldDisplayName, fieldDisplayKey, this.getSubEntityType(entityType, fieldDisplayKey), Collections.emptyMap(), (Map)tarFieldVal);
        } else if (tarFieldVal instanceof List) {
            this.handleEntryEntity(fieldDisplayName, fieldDisplayKey, this.getSubEntityType(entityType, fieldDisplayKey), Collections.emptyList(), (List)tarFieldVal);
        } else {
            String differentType = CompareDataResultEnum.DIFFERENCE.getVal();
            if (isIgnore) {
                differentType = CompareDataResultEnum.IGNORE.getVal();
            }
            FieldCompareResult fieldCompareResult = new FieldCompareResult(this.dataCompareResult.getEntryId(), fieldDisplayName, fieldDisplayKey, "", tarFieldVal, differentType);
            this.dataCompareResult.add(fieldCompareResult);
        }
    }

    private void handleTargetIsNull(String curEntityName, String curEntityKey, IDataEntityType entityType, Object curFieldVal, boolean isIgnore) {
        HashMap<String, Object> currentFieldMap = new HashMap<String, Object>(4);
        if (curFieldVal instanceof Map) {
            this.mapValCompare(curEntityName, curEntityKey, this.getSubEntityType(entityType, curEntityKey), currentFieldMap, Collections.emptyMap());
        } else if (curFieldVal instanceof List) {
            this.handleEntryEntity(curEntityName, curEntityKey, this.getSubEntityType(entityType, curEntityKey), (List)curFieldVal, Collections.emptyList());
        } else {
            String differentType = CompareDataResultEnum.DIFFERENCE.getVal();
            if (isIgnore) {
                differentType = CompareDataResultEnum.IGNORE.getVal();
            }
            FieldCompareResult fieldCompareResult = new FieldCompareResult(this.dataCompareResult.getEntryId(), curEntityName, curEntityKey, curFieldVal, "", differentType);
            this.dataCompareResult.add(fieldCompareResult);
        }
    }

    private void handleEntryEntity(String curEntityName, String curEntityKey, IDataEntityType entityType, List<Map<String, Object>> current, List<Map<String, Object>> target) {
        int srcSize = current.size();
        int targetSize = target.size();
        int index = 0;
        int maxSize = Math.max(srcSize, targetSize);
        if (srcSize > targetSize) {
            for (Map<String, Object> targetMap : target) {
                Map<String, Object> srcMap = current.get(++index - 1);
                this.mapValCompare(this.generatePrefix(curEntityName, index), curEntityKey, entityType, srcMap, targetMap);
            }
            for (int i = index; i < maxSize; ++i) {
                this.mapValCompare(this.generatePrefix(curEntityName, ++index), curEntityKey, entityType, current.get(index - 1), Collections.emptyMap());
            }
        } else {
            for (Map<String, Object> srcMap : current) {
                Map<String, Object> targetMap = target.get(++index - 1);
                this.mapValCompare(this.generatePrefix(curEntityName, index), curEntityKey, entityType, srcMap, targetMap);
            }
            for (int i = index; i < maxSize; ++i) {
                this.mapValCompare(this.generatePrefix(curEntityName, ++index), curEntityKey, entityType, Collections.emptyMap(), target.get(index - 1));
            }
        }
    }

    private String generatePrefix(String curEntityName, int index) {
        StringBuilder s = new StringBuilder();
        if (curEntityName.length() == 0) {
            s.append('[').append(index).append(']');
        } else {
            s.append(curEntityName, 0, curEntityName.length() - 1);
            s.append('[').append(index).append(']');
        }
        return s.toString();
    }

    private IDataEntityType getSubEntityType(IDataEntityType entityType, String fieldKey) {
        if (entityType == null) {
            return null;
        }
        Object property = entityType.getProperties().get((Object)fieldKey);
        if (property == null) {
            return null;
        }
        if (property instanceof BasedataProp) {
            String entityId = ((BasedataProp)property).getBaseEntityId();
            return EntityMetadataCache.getDataEntityType((String)entityId);
        }
        if (property instanceof EntryProp) {
            return ((EntryProp)property).getItemType();
        }
        return null;
    }

    static {
        PRIORITIES.put("id", 0);
        PRIORITIES.put("entryid", PRIORITIES.size());
        PRIORITIES.put("detailid", PRIORITIES.size());
        PRIORITIES.put("number", PRIORITIES.size());
        PRIORITIES.put("name", PRIORITIES.size());
        PRIORITIES.put("title", PRIORITIES.size());
        PRIORITIES.put("full_name", PRIORITIES.size());
        PRIORITIES.put("type", PRIORITIES.size());
        PRIORITIES.put("version", PRIORITIES.size());
        PRIORITIES.put("modifytime", PRIORITIES.size());
        PRIORITIES.put("entryentity", PRIORITIES.size());
        PRIORITIES.put("coordinate", 2147483547);
    }

    static class FieldCompareResult {
        public static final String TABLE_NAME = "t_ricc_datacompare_sentry";
        public static final String SUB_ENTRY_SQL = "INSERT INTO T_RICC_DATACOMPARE_SENTRY (FENTRYID, FDETAILID, FSEQ, FFIELDNAME, FFIELDKEY, FCURRENTVALUE,  FTARGETVALUE, FDIFFERENTTYPE ) values (?, ?, ?, ?, ?, ?, ?, ?);";
        private final long fEntryId;
        private final long fDetailId;
        private int fSeq;
        private final String fFieldName;
        private final String fFieldKey;
        private final Object fCurrentValue;
        private final Object fTargetValue;
        private final String fDifferentType;

        public FieldCompareResult(long fEntryId, long fDetailId, String fFieldName, String fFieldKey, Object fCurrentValue, Object fTargetValue, String fDifferentType) {
            this.fEntryId = fEntryId;
            this.fDetailId = fDetailId;
            this.fFieldName = fFieldName;
            this.fFieldKey = fFieldKey;
            this.fCurrentValue = this.preDealVal(fCurrentValue);
            this.fTargetValue = this.preDealVal(fTargetValue);
            this.fDifferentType = fDifferentType;
        }

        private Object preDealVal(Object o) {
            String valStr = FieldCompareResult.convertObjToString(o);
            if (valStr.length() > 200) {
                return valStr.substring(0, 200);
            }
            return valStr;
        }

        public static String convertObjToString(Object o) {
            return o == null ? "" : o.toString();
        }

        public FieldCompareResult(long fEntryId, String fFieldName, String fFieldKey, Object fCurrentValue, Object fTargetValue, String fDifferentType) {
            this(fEntryId, 0L, fFieldName, fFieldKey, fCurrentValue, fTargetValue, fDifferentType);
        }

        public long getDetailId() {
            return this.fDetailId;
        }

        public int getSeq() {
            return this.fSeq;
        }

        public void setSeq(int fSeq) {
            this.fSeq = fSeq;
        }

        public String getFieldName() {
            return this.fFieldName;
        }

        public String getFieldKey() {
            return this.fFieldKey;
        }

        public String getDifferentType() {
            return this.fDifferentType;
        }

        public long getEntryId() {
            return this.fEntryId;
        }

        public Object getCurrentValue() {
            return this.fCurrentValue;
        }

        public Object getTargetValue() {
            return this.fTargetValue;
        }
    }

    static class CompareResult {
        public static final String ENTRY_SQL = "INSERT INTO T_RICC_DATACOMPARE_ENTRY (FID, FENTRYID, FSEQ, FCURDATAID, FCURDATANUMBER, FCURDATANAME, FTARDATAID, FTARDATANUMBER, FTARDATANAME, FENTRYRESULT, FSUGGESTMETHOD) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        private long fid;
        private final long fEntryId;
        private final int fSeq;
        private final Object fCurDataId;
        private final String fCurDataNumber;
        private final String fCurDataName;
        private final Object fTarDataId;
        private final String fTarDataNumber;
        private final String fTarDataName;
        private final String fEntryResult;
        private String fSuggestMethod = "";
        public final List<FieldCompareResult> fieldResults = new ArrayList<FieldCompareResult>();

        public CompareResult(long fid, long fEntryId, int fSeq, Object fCurDataId, String fCurDataNumber, String fCurDataName, Object fTarDataId, String fTarDataNumber, String fTarDataName, String fEntryResult, String fSuggestMethod) {
            this.fid = fid;
            this.fEntryId = fEntryId;
            this.fSeq = fSeq;
            this.fCurDataId = fCurDataId;
            this.fCurDataNumber = fCurDataNumber;
            this.fCurDataName = fCurDataName;
            this.fTarDataId = fTarDataId;
            this.fTarDataNumber = fTarDataNumber;
            this.fTarDataName = fTarDataName;
            this.fEntryResult = fEntryResult;
            this.fSuggestMethod = fSuggestMethod;
        }

        public long getFid() {
            return this.fid;
        }

        public void setFid(long fid) {
            this.fid = fid;
        }

        public long getEntryId() {
            return this.fEntryId;
        }

        public int getSeq() {
            return this.fSeq;
        }

        public Object getCurDataId() {
            return this.fCurDataId;
        }

        public String getCurDataNumber() {
            return this.fCurDataNumber;
        }

        public String getCurDataName() {
            return this.fCurDataName == null ? "" : this.fCurDataName;
        }

        public Object getTarDataId() {
            return this.fTarDataId;
        }

        public String getTarDataNumber() {
            return this.fTarDataNumber;
        }

        public String getTarDataName() {
            return this.fTarDataName == null ? "" : this.fTarDataName;
        }

        public String getEntryResult() {
            return this.fEntryResult;
        }

        public String getSuggestMethod() {
            return this.fSuggestMethod;
        }

        public List<FieldCompareResult> getFieldResults() {
            return this.fieldResults;
        }

        public CompareDataResultEnum hasDifference() {
            boolean hasIgnore = false;
            List<FieldCompareResult> fieldResultsList = this.getFieldResults();
            if (!fieldResultsList.isEmpty()) {
                for (FieldCompareResult f : fieldResultsList) {
                    String differentType = f.getDifferentType();
                    if (differentType.equals(CompareDataResultEnum.DIFFERENCE.getVal())) {
                        return CompareDataResultEnum.DIFFERENCE;
                    }
                    if (!differentType.equals(CompareDataResultEnum.IGNORE.getVal())) continue;
                    hasIgnore = true;
                }
                if (hasIgnore) {
                    return CompareDataResultEnum.IGNORE;
                }
                return CompareDataResultEnum.NO_DIFFERENCE;
            }
            return CompareDataResultEnum.DIFFERENCE;
        }

        public void add(FieldCompareResult fieldCompareResult) {
            fieldCompareResult.setSeq(this.getFieldResults().size() + 1);
            this.fieldResults.add(fieldCompareResult);
        }

        public void save() {
            Object[] params = new Object[]{this.getFid(), this.getEntryId(), this.getSeq(), this.getCurDataId(), this.getCurDataNumber(), this.getCurDataName(), this.getTarDataId(), this.getTarDataNumber(), this.getTarDataName(), this.hasDifference().getVal(), this.getSuggestMethod()};
            DB.execute((DBRoute)DB_SYS, (String)ENTRY_SQL, (Object[])params);
            if (!this.fieldResults.isEmpty()) {
                int filedSize = this.fieldResults.size();
                long[] subEntryIds = DB.genLongIds((String)"t_ricc_datacompare_sentry", (int)filedSize);
                ArrayList<Object[]> fieldResultParams = new ArrayList<Object[]>(filedSize);
                for (int i = 0; i < this.fieldResults.size(); ++i) {
                    FieldCompareResult fieldResult = this.fieldResults.get(i);
                    fieldResultParams.add(new Object[]{fieldResult.getEntryId(), subEntryIds[i], fieldResult.getSeq(), fieldResult.getFieldName(), fieldResult.getFieldKey(), fieldResult.getCurrentValue(), fieldResult.getTargetValue(), fieldResult.getDifferentType()});
                }
                DB.executeBatch((DBRoute)DB_SYS, (String)"INSERT INTO T_RICC_DATACOMPARE_SENTRY (FENTRYID, FDETAILID, FSEQ, FFIELDNAME, FFIELDKEY, FCURRENTVALUE,  FTARGETVALUE, FDIFFERENTTYPE ) values (?, ?, ?, ?, ?, ?, ?, ?);", fieldResultParams);
            }
        }
    }
}

