/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.batchpackscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataSelectWayEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.OpenFilterFormUtil;
import kd.sys.ricc.common.util.PageChangeUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class BatchPackSchemePlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String ITEM = "item";
    private static final String RELY_CONFIG_ITEM = "relyconfigitem";
    private static final String FILTER_TERM = "filterterm";
    private static final String FILTER_TERM_L = "filterterm_l";
    private static final String FILTER_TERM_STORE = "exportfilters";
    private static final String FILTER_TERM_STORE_TAG = "exportfilters_tag";
    private static final String PACK_SCHEME_ENTRY = "packschemeentry";
    private static final String DATA_SELECTION = "dataselection";
    private static final String MANUAL_SEL = "manualsel";
    private static final String MANUAL_SELECT_DATA_TAG = "manualselectdata_tag";
    private static final String MANUAL_SELECT_CLOSE_ACTION = "manualSelectAction";
    private static final String CHOOSE_ITEM = "chooseItem";
    private static final String DATA_SELECT_ACTION = "dataSelection";
    private static final String INTELLIGENTADDRELYDATA = "intelligentaddrelydata";
    private static final String CAN_BATCH_PACK_ITEM = "canBatchPackItem";
    private static final String CAN_BATCH_PACK_RELY = "canBatchPackRely";
    private static final String COLOR_BLACK = "#212121";
    private static final String COLOR_CANARY = "#FF991C";
    private static final String ISPRESET = "ispreset";
    private static final String RELYITEMENTRY = "relyitementry";
    private static final String RELYITEM = "relyitem";
    private static final String MARK_DATASELCTION = "mark";
    private static final String ITEM_CHANGED = "itemChanged";
    private static final String PAGE_NUMBER = "page.number";
    private static final String QUERYFIELDS = "id,number,name,canexportall,importtype,page.number,page.bizappid,pagetype,custompage,pageenterparam,group.name,ispreset,relyconfigitem,exportfiltersdesc_l,exportfilters,exportfilters_tag,relyitementry.relyitem";
    private static final String BATCH_ADD_FILTER_CLOSE_ACTION = "batchaddfilterclose";
    private static final String SCHEME_ROW_DELETE = "schemeRowDelete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{RELY_CONFIG_ITEM, FILTER_TERM});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean whetherBatchPack = CommonUtil.whetherBatchPack();
        if (!whetherBatchPack) {
            e.setCancel(true);
            e.setCancelMessage(CommonConstant.getBatchPackPerm());
        }
    }

    public void afterCreateNewData(EventObject e) {
        String selectData;
        List items;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String itemsInfo = (String)formShowParameter.getCustomParam("itemsInfo");
        if (StringUtils.isNotEmpty((String)itemsInfo) && (items = (List)JSON.parse((String)itemsInfo)) != null) {
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)QUERYFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)items)});
            for (int i = 0; i < configs.length; ++i) {
                DynamicObject itemRow = configs[i];
                this.createRowAndSetVal(itemRow, i, false);
            }
            this.refreshItemRely();
        }
        if (StringUtils.isNotEmpty((String)(selectData = (String)formShowParameter.getCustomParam("selectData")))) {
            this.addRelyDataFromTransfer(formShowParameter, selectData);
        }
    }

    private void addRelyDataFromTransfer(FormShowParameter formShowParameter, String selectData) {
        String itemNumber = (String)formShowParameter.getCustomParam("itemNumber");
        ListSelectedRowCollection dataRows = ListSelectedRowCollection.deSerialize((String)selectData);
        DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"ricc_configitems", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)itemNumber)});
        this.getModel().createNewEntryRow(PACK_SCHEME_ENTRY, 0, null);
        this.getPageCache().put(ITEM_CHANGED, "sys");
        this.getModel().setValue(ITEM, (Object)item, 0);
        this.getPageCache().remove(ITEM_CHANGED);
        String relyItemName = this.getRelyItemNameStr(item);
        this.getModel().setValue(RELY_CONFIG_ITEM, (Object)relyItemName, 0);
        this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal());
        this.setManualSelectData(0, dataRows, item.getString(PAGE_NUMBER));
        DynamicObject schemeRow = this.getModel().getEntryRowEntity(PACK_SCHEME_ENTRY, 0);
        DynamicObject configItem = (DynamicObject)schemeRow.get(ITEM);
        DynamicObjectCollection relyItemEntry = configItem.getDynamicObjectCollection(RELYITEMENTRY);
        ArrayList<Object> allRelyIds = new ArrayList<Object>(10);
        for (DynamicObject row : relyItemEntry) {
            DynamicObject rely = (DynamicObject)row.get(RELYITEM);
            if (rely == null) continue;
            allRelyIds.add(rely.getPkValue());
        }
        Map allRelyItems = BusinessDataServiceHelper.loadFromCache((String)"ricc_configitems", (QFilter[])new QFilter[]{new QFilter("id", "in", allRelyIds)});
        this.createSubLevelRowAndSetVal(allRelyItems, 0, schemeRow);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(PACK_SCHEME_ENTRY);
        entryGrid.expandOne(0);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{RELY_CONFIG_ITEM});
        this.refreshItemRely();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection packEntry = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        for (int i = 0; i < packEntry.size(); ++i) {
            DynamicObject item = (DynamicObject)packEntry.get(i);
            DynamicObject rowItem = (DynamicObject)item.get(ITEM);
            String relyItem = this.getRelyItemNameStr(rowItem);
            this.getModel().setValue(RELY_CONFIG_ITEM, (Object)relyItem, i);
            String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue(FILTER_TERM_L, i)).getLocaleValue();
            this.getModel().setValue(FILTER_TERM, (Object)exportFiltersDescMultilingual, i);
        }
        this.refreshItemRely();
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
            DynamicObject itemConfig = (DynamicObject)entryRow.get(ITEM);
            String relyItemNameStr = this.getRelyItemNameStr(itemConfig);
            this.getModel().setValue(RELY_CONFIG_ITEM, (Object)relyItemNameStr, i);
            String exportFiltersDescMultilingual = ((OrmLocaleValue)this.getModel().getValue(FILTER_TERM_L, i)).getLocaleValue();
            this.getModel().setValue(FILTER_TERM, (Object)exportFiltersDescMultilingual, i);
        }
        this.refreshItemRely();
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(PACK_SCHEME_ENTRY, "setColEditorProp", new Object[]{RELY_CONFIG_ITEM, "sx", Boolean.FALSE});
        DynamicObjectCollection packEntry = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        for (int i = 0; i < packEntry.size(); ++i) {
            String dataSelection = (String)this.getModel().getValue(DATA_SELECTION, i);
            if (!StringUtils.equals((String)dataSelection, (String)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal())) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{FILTER_TERM});
        }
        boolean canOneKeyPacket = SysParaUtil.canBatchPack();
        this.getView().setEnable(Boolean.valueOf(canOneKeyPacket), new String[]{"startpack"});
        ArrayList<String> cleanTipsKeyList = new ArrayList<String>();
        if (canOneKeyPacket) {
            cleanTipsKeyList.add("startpack");
        }
        if (!cleanTipsKeyList.isEmpty()) {
            FormViewUtil.cleanButtonTips(cleanTipsKeyList, (IFormView)this.getView());
        }
        if ((status = this.getView().getFormShowParameter().getStatus()).equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_copy"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((String)itemKey, (String)"additem")) {
            this.openChooseItemF7Form();
        }
    }

    private void openChooseItemF7Form() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_templatetreelistf7");
        listShowParameter.setBillFormId("ricc_configitems");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(false);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580");
        inlineStyleCss.setWidth("960");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowApproved(true);
        listShowParameter.setShowUsed(true);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(new QFilter("canexportall", "=", (Object)Boolean.TRUE));
        listShowParameter.setListFilterParameter(filterParameter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CHOOSE_ITEM);
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String markDataSelection;
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((String)fieldKey, (String)ITEM)) {
            DynamicObject newItem = (DynamicObject)changeData.getNewValue();
            if (newItem == null) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{RELY_CONFIG_ITEM});
                this.getModel().setValue(RELY_CONFIG_ITEM, null, rowIndex);
                this.getModel().setValue(FILTER_TERM, null, rowIndex);
                this.getModel().setValue(FILTER_TERM_L, null, rowIndex);
                this.getModel().setValue(FILTER_TERM_STORE, null, rowIndex);
                this.getModel().setValue(FILTER_TERM_STORE_TAG, null, rowIndex);
            } else {
                DynamicObject itemConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)newItem.getPkValue(), (String)"ricc_configitems");
                String relyItem = this.getRelyItemNameStr(itemConfig);
                this.getModel().setValue(RELY_CONFIG_ITEM, (Object)relyItem, rowIndex);
                this.getModel().setValue(FILTER_TERM, itemConfig.get("exportfiltersdesc_l"), rowIndex);
                this.getModel().setValue(FILTER_TERM_L, itemConfig.get("exportfiltersdesc_l"), rowIndex);
                this.getModel().setValue(FILTER_TERM_STORE, itemConfig.get(FILTER_TERM_STORE), rowIndex);
                this.getModel().setValue(FILTER_TERM_STORE_TAG, itemConfig.get(FILTER_TERM_STORE_TAG), rowIndex);
            }
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{FILTER_TERM});
            this.getPageCache().put(MARK_DATASELCTION, "sys");
            this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal(), rowIndex);
            this.getPageCache().remove(MARK_DATASELCTION);
            this.getModel().setValue(MANUAL_SEL, null, rowIndex);
            this.getModel().setValue(MANUAL_SELECT_DATA_TAG, null, rowIndex);
            String itemChanged = this.getPageCache().get(ITEM_CHANGED);
            if (!StringUtils.equals((String)itemChanged, (String)"sys")) {
                this.refreshItemRely();
            }
            this.getPageCache().remove(ITEM_CHANGED);
        } else if (StringUtils.equals((String)fieldKey, (String)FILTER_TERM)) {
            if (StringUtils.isBlank((Object)changeData.getNewValue())) {
                this.getModel().setValue(FILTER_TERM, null);
                this.getModel().setValue(FILTER_TERM_L, null);
                this.getModel().setValue(FILTER_TERM_STORE, null);
                this.getModel().setValue(FILTER_TERM_STORE_TAG, null);
            }
        } else if (StringUtils.equals((String)fieldKey, (String)DATA_SELECTION) && !StringUtils.equals((String)(markDataSelection = this.getPageCache().get(MARK_DATASELCTION)), (String)"sys")) {
            String selection = (String)changeData.getNewValue();
            this.dataSelectionChanged(selection, rowIndex);
        }
    }

    private void dataSelectionChanged(String selection, int rowIndex) {
        this.getPageCache().put("dataselectrow", String.valueOf(rowIndex));
        String filter = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"BatchPackSchemePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
        String manual = ResManager.loadKDString((String)"\u624b\u5de5\u9009\u62e9", (String)"BatchPackSchemePlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        if (StringUtils.equals((String)selection, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal())) {
            String manualSelectValue = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG, rowIndex);
            if (manualSelectValue.isEmpty()) {
                this.selectMethodChangedClearData(rowIndex, FILTER_TERM, MANUAL_SEL, MANUAL_SELECT_DATA_TAG);
                return;
            }
            this.getPageCache().put("dataselecttype", "filter");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"BatchPackSchemePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), filter, manual), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_SELECT_ACTION, (IFormPlugin)this));
            this.getPageCache().put(MARK_DATASELCTION, "sys");
            this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal(), rowIndex);
            this.getPageCache().remove(MARK_DATASELCTION);
        } else {
            String filterSelectValue = (String)this.getModel().getValue(FILTER_TERM, rowIndex);
            if (filterSelectValue.isEmpty()) {
                this.selectMethodChangedClearData(rowIndex, MANUAL_SEL, FILTER_TERM, FILTER_TERM_STORE);
                this.getModel().setValue(FILTER_TERM_STORE_TAG, null, rowIndex);
                this.getModel().setValue(MANUAL_SEL, (Object)ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"BatchPackSchemePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("dataselecttype", "manual");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u3010%1$s\u3011,\u5c06\u6e05\u7a7a\u3010%2$s\u3011\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"BatchPackSchemePlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), manual, filter), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATA_SELECT_ACTION, (IFormPlugin)this));
            this.getPageCache().put(MARK_DATASELCTION, "sys");
            this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal(), rowIndex);
            this.getPageCache().remove(MARK_DATASELCTION);
        }
    }

    private List<CellStyle> setForeColor(String color, int index) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(RELY_CONFIG_ITEM);
        cellStyle.setRow(index);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
        return cellStyles;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equals((String)"startpack", (String)opKey)) {
            DynamicObjectCollection packSchemeEntry = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
            if (packSchemeEntry.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u914d\u7f6e\u4fe1\u606f\u5206\u5f55\u9009\u62e9\u9700\u8981\u6253\u5305\u7684\u914d\u7f6e\u9879", (String)"BatchPackSchemePlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.entryDataIsEmpty(packSchemeEntry)) {
                args.setCancel(true);
                return;
            }
            if (!this.validateDataLimitAndShowTip(packSchemeEntry)) {
                args.setCancel(true);
                return;
            }
            String enable = (String)this.getModel().getValue("enable");
            if (StringUtils.equals((String)enable, (String)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u7684\u65b9\u6848\u4e0d\u5141\u8bb8\u6267\u884c\u6253\u5305\uff0c\u8bf7\u5148\u542f\u7528", (String)"BatchPackSchemePlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.isHasPermAndShowTip() || this.isExecutingAndShowTip() || !this.manualDataCheck()) {
                args.setCancel(true);
                return;
            }
            if (!this.isOpenImportTemplateCheck()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6253\u5f00\u5168\u91cf\u5bfc\u5165\u6a21\u677f\u5305\u542b\u5185\u7801\u5f00\u5173\uff0c\u8bf7\u5148\u5230\u516c\u5171\u8bbe\u7f6e->\u53c2\u6570\u914d\u7f6e->\u7cfb\u7edf\u53c2\u6570->\u516c\u5171\u53c2\u6570 \u6253\u5f00\u5168\u91cf\u5bfc\u5165\u6a21\u677f\u5305\u542b\u5185\u7801\u5f00\u5173", (String)"BatchPackSchemePlugin_19", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            LinkedHashMap<String, String> transTipMap = this.getTransTipMap(packSchemeEntry);
            this.openFastAddPacket(transTipMap);
        } else if (StringUtils.equals((String)"viewlog", (String)opKey)) {
            String schemeNumber = (String)this.getModel().getValue("number");
            boolean schemeIsSave = this.schemeIsSave(schemeNumber);
            this.openPacketLogForm(schemeNumber, schemeIsSave);
        } else if (StringUtils.equals((String)"viewpacket", (String)opKey)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("ricc_datapacket");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)"datapreview", (String)opKey)) {
            boolean forbiddenPreview;
            int rowKey = this.getEntryOperationRowKey();
            FormConfig listFormConfig = this.getFormConfigByEntryItem(rowKey);
            if (listFormConfig == null) {
                args.setCancel(true);
                return;
            }
            String entityNumber = listFormConfig.getEntityTypeId();
            boolean bl = forbiddenPreview = StringUtils.equals((String)entityNumber, (String)"botp_crlist") || StringUtils.equals((String)entityNumber, (String)"bos_manageprinttpl") || StringUtils.equals((String)entityNumber, (String)"botp_wrlistcheckin") || StringUtils.equals((String)entityNumber, (String)"perm_role") || StringUtils.equals((String)entityNumber, (String)"gl_initbalance");
            if (forbiddenPreview) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8", (String)"BatchPackSchemePlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String number = null;
            String name = null;
            if (entityType instanceof BasedataEntityType) {
                BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
                number = basedataEntityType.getNumberProperty();
                name = basedataEntityType.getNameProperty();
            } else if (entityType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)entityType;
                number = billEntityType.getBillNo();
                name = billEntityType.getBillNo();
            }
            if (StringUtils.isBlank(number) && StringUtils.isBlank(name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u7684\u914d\u7f6e\u8868\u5355\u5b9e\u4f53\u6ca1\u6709\u7f16\u7801\u548c\u540d\u79f0\uff0c\u6682\u4e0d\u652f\u6301\u6570\u636e\u9884\u89c8", (String)"BatchPackSchemePlugin_33", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.dataPreview(args);
        } else if (StringUtils.equals((String)"save", (String)opKey)) {
            if (!this.manualDataCheck()) {
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)"copy", (String)opKey)) {
            boolean isChanged = this.getModel().getDataChanged();
            if (isChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848", (String)"BatchPackSchemePlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)INTELLIGENTADDRELYDATA, (String)opKey)) {
            if (!this.whetherSmartAddData()) {
                args.setCancel(true);
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u667a\u80fd\u6dfb\u52a0\u4f9d\u8d56\u5c06\u6839\u636e\u4f9d\u8d56\u5173\u7cfb\u81ea\u52a8\u521b\u5efa\u914d\u7f6e\u5b50\u5206\u5f55\u548c\u9009\u62e9\u4f9d\u8d56\u6570\u636e\uff08\u65e0\u5b9e\u4f53\u7279\u6b8a\u914d\u7f6e\u6682\u4e0d\u652f\u6301\u81ea\u52a8\u52fe\u9009\u6570\u636e\uff09\u3002\u4f1a\u6e05\u7a7a\u76ee\u524d\u5df2\u9009\u4f9d\u8d56\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6dfb\u52a0", (String)"BatchPackSchemePlugin_24", (String)"sys-ricc-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(INTELLIGENTADDRELYDATA, (IFormPlugin)this));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (StringUtils.equals((String)"moveentryup", (String)opKey) || StringUtils.equals((String)"moveentrydown", (String)opKey)) {
            this.refreshItemRely();
        } else if (StringUtils.equals((String)"batchaddfilter", (String)opKey)) {
            ArrayList<Object> itemIdList = new ArrayList<Object>(10);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
            for (DynamicObject rowData : entryEntity) {
                DynamicObject configItem = rowData.getDynamicObject(ITEM);
                if (configItem == null) continue;
                itemIdList.add(configItem.get("id"));
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ricc_batchaddfilter");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("itemIdList", (Object)JSON.toJSONString(itemIdList));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCH_ADD_FILTER_CLOSE_ACTION));
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean validateDataLimitAndShowTip(DynamicObjectCollection packSchemeEntry) {
        int packDataLimit = SysParaUtil.getPackDataLimit();
        ArrayList<Integer> seqs = new ArrayList<Integer>();
        for (DynamicObject entry : packSchemeEntry) {
            int seq;
            QFilter qFilter;
            String dataSelectWay = entry.getString(DATA_SELECTION);
            if (!DataSelectWayEnum.FILTER_SELECT_WAY.getVal().equals(dataSelectWay)) continue;
            DynamicObject item = entry.getDynamicObject(ITEM);
            DynamicObject dbItem = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"page,page.number,page.basedatafield.number", (QFilter[])new QFilter("id", "=", item.getPkValue()).toArray());
            String entityNumber = dbItem.getString("page.basedatafield.number");
            List pks = QueryServiceHelper.queryPrimaryKeys((String)(entityNumber = this.getVchTemplateEntity(entityNumber)), (QFilter[])((qFilter = this.getEntryRowFilters((seq = entry.getInt("seq")) - 1, entityNumber)) == null ? null : qFilter.toArray()), null, (int)-1);
            if (pks.size() <= packDataLimit) continue;
            seqs.add(seq);
        }
        if (!seqs.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6dfb\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\u6027\uff0c\u5355\u6b21\u6dfb\u52a0\u4f20\u8f93\u6570\u636e\u6570\u91cf\u4e0d\u5f97\u8d85\u8fc7%d\u6761\uff0c\u8bf7\u8c03\u6574\u7b2c%s\u884c\u9009\u62e9\u6570\u636e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4e2d\u8c03\u6574\u9650\u5236", (String)"BatchPackSchemePlugin_31", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msg, packDataLimit, seqs), Integer.valueOf(7000));
            return false;
        }
        return true;
    }

    private boolean entryDataIsEmpty(DynamicObjectCollection packSchemeEntry) {
        boolean result = false;
        StringBuilder entryDataIsEmptyRow = new StringBuilder();
        for (int i = 0; i < packSchemeEntry.size(); ++i) {
            int row = i;
            DynamicObject itemRow = (DynamicObject)packSchemeEntry.get(i);
            DynamicObject item = (DynamicObject)itemRow.get(ITEM);
            if (item != null) continue;
            entryDataIsEmptyRow.append(++row).append(',');
        }
        if (entryDataIsEmptyRow.length() > 0) {
            entryDataIsEmptyRow.deleteCharAt(entryDataIsEmptyRow.lastIndexOf(","));
            String tip = ResManager.loadKDString((String)"\u65b9\u6848\u5206\u5f55\u7b2c[%s]\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"BatchPackSchemePlugin_29", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(tip, entryDataIsEmptyRow));
            result = true;
        }
        return result;
    }

    private boolean whetherSmartAddData() {
        boolean result = true;
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        StringBuilder msg = new StringBuilder();
        if (selectRows.length <= 0) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u914d\u7f6e\u4fe1\u606f\u5206\u5f55\u9009\u62e9\u914d\u7f6e\u9879", (String)"BatchPackSchemePlugin_25", (String)"sys-ricc-platform", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection entityData = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
            StringBuilder notManualSelection = new StringBuilder();
            StringBuilder notData = new StringBuilder();
            StringBuilder notRelyRow = new StringBuilder();
            for (int row : selectRows) {
                DynamicObject packRow = (DynamicObject)entityData.get(row);
                String dataSelection = (String)packRow.get(DATA_SELECTION);
                if (StringUtils.equals((String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal(), (String)dataSelection)) {
                    notManualSelection.append(++row).append(',');
                    continue;
                }
                String manualSelectTag = packRow.getString(MANUAL_SELECT_DATA_TAG);
                if (StringUtils.isBlank((CharSequence)manualSelectTag)) {
                    notData.append(++row).append(',');
                    continue;
                }
                DynamicObject itemConfig = (DynamicObject)packRow.get(ITEM);
                ArrayList<Object> relyPkList = this.getAllRelyPkList(itemConfig);
                if (!relyPkList.isEmpty()) continue;
                notRelyRow.append(++row).append(',');
            }
            if (notManualSelection.length() > 0) {
                notManualSelection.deleteCharAt(notManualSelection.lastIndexOf(","));
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u7684\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a\u8fc7\u6ee4\u6761\u4ef6\u9009\u62e9\uff0c\u8bf7\u5207\u6362\u4e3a\u624b\u5de5\u9009\u62e9\u5e76\u9009\u62e9\u6570\u636e\u3002", (String)"BatchPackSchemePlugin_26", (String)"sys-ricc-platform", (Object[])new Object[0]), notManualSelection));
            }
            if (notData.length() > 0) {
                notData.deleteCharAt(notData.lastIndexOf(","));
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u672a\u9009\u62e9\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"BatchPackSchemePlugin_27", (String)"sys-ricc-platform", (Object[])new Object[0]), notData));
            }
            if (notRelyRow.length() > 0) {
                notRelyRow.deleteCharAt(notRelyRow.lastIndexOf(","));
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u65e0\u4f9d\u8d56\u914d\u7f6e\u9879\uff0c\u65e0\u9700\u667a\u80fd\u6dfb\u52a0\u4f9d\u8d56\u6570\u636e\u3002", (String)"BatchPackSchemePlugin_28", (String)"sys-ricc-platform", (Object[])new Object[0]), notRelyRow));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            result = false;
            this.getView().showMessage(msg.toString());
        }
        return result;
    }

    private boolean isOpenImportTemplateCheck() {
        boolean openImportTemplateId = this.isOpenImportTemplateId();
        if (openImportTemplateId) {
            return true;
        }
        DynamicObjectCollection packEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
        for (DynamicObject item : packEntity) {
            DynamicObject itemConfig = (DynamicObject)item.get(ITEM);
            String type = itemConfig.getString("importtype");
            if (!"excel".equals(type)) continue;
            return false;
        }
        return true;
    }

    private boolean isOpenImportTemplateId() {
        Object importtrmplatehasid = SystemParamServiceHelper.loadPublicParameterFromCache((String)"importtrmplatehasid");
        if (importtrmplatehasid != null) {
            return (Boolean)importtrmplatehasid;
        }
        return false;
    }

    private boolean schemeIsSave(String schemeNumber) {
        return QueryServiceHelper.exists((String)"ricc_packscheme", (QFilter[])new QFilter("number", "=", (Object)schemeNumber).toArray());
    }

    private List<Object> getManualSelectedPks(int rowIndex) {
        String dataStr = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG, rowIndex);
        if (StringUtils.isEmpty((String)dataStr)) {
            return new ArrayList<Object>();
        }
        JSONObject selectDatas = JSON.parseObject((String)dataStr);
        if (selectDatas.isEmpty()) {
            return new ArrayList<Object>();
        }
        DynamicObjectCollection packEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        DynamicObject row = (DynamicObject)packEntity.get(rowIndex);
        DynamicObject item = row.getDynamicObject(ITEM);
        DynamicObject itemOne = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"id,page.basedatafield.number", (QFilter[])new QFilter("id", "=", item.getPkValue()).toArray());
        String entityNumber = itemOne.getString("page.basedatafield.number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)(entityNumber = this.getVchTemplateEntity(entityNumber)));
        ISimpleProperty idProperty = dataEntityType.getPrimaryKey();
        if (idProperty instanceof LongProp) {
            return selectDatas.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        if (idProperty instanceof VarcharProp) {
            return new ArrayList<Object>(selectDatas.keySet());
        }
        String msgTpl = ResManager.loadKDString((String)"\u914d\u7f6e\u9879%s\u7684\u4e3b\u952e\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u82cd\u7a79\u7684\u89c4\u8303\uff0c\u8bf7\u4fee\u6539\u4e3b\u952e\u7684\u6570\u636e\u7c7b\u578b\u4e3along\u6216\u8005varchar", (String)"BatchPackSchemePlugin_32", (String)"sys-ricc-platform", (Object[])new Object[0]);
        throw new RiccBizException(String.format(msgTpl, entityNumber));
    }

    private void dataPreview(BeforeDoOperationEventArgs args) {
        int rowKey = this.getEntryOperationRowKey();
        FormConfig listFormConfig = this.getFormConfigByEntryItem(rowKey);
        if (listFormConfig == null) {
            args.setCancel(true);
            return;
        }
        String entityNumber = listFormConfig.getEntityTypeId();
        QFilter filters = this.getEntryRowFilters(rowKey, entityNumber);
        QFilter[] filtersArr = filters == null ? new QFilter[]{} : filters.toArray();
        String f7ListFormId = listFormConfig.getF7ListFormId();
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        if (filters != null) {
            customParams.put("filter", filters.toSerializedString());
        }
        ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, customParams, Arrays.asList(filtersArr), (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.DataPreviewListPlugin");
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowApproved(false);
        listShowParameter.setF7Style(0);
        DynamicObject itemConfig = (DynamicObject)this.getModel().getValue(ITEM, rowKey);
        String pageParam = (String)itemConfig.get("pageenterparam");
        ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private QFilter getEntryRowFilters(int rowIndex, String entityNumber) {
        QFilter filter;
        String dataSelectMethod = (String)this.getModel().getValue(DATA_SELECTION, rowIndex);
        if (DataSelectWayEnum.FILTER_SELECT_WAY.getVal().equals(dataSelectMethod)) {
            String filterStr = (String)this.getModel().getValue(FILTER_TERM_STORE_TAG, rowIndex);
            if (StringUtils.isEmpty((String)filterStr)) {
                filter = null;
            } else {
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), crCondition.getFilterCondition());
                fb.buildFilter();
                filter = fb.getQFilter();
            }
        } else {
            String selectData = (String)this.getModel().getValue(MANUAL_SELECT_DATA_TAG, rowIndex);
            if (StringUtils.isEmpty((String)selectData)) {
                filter = new QFilter("id", "in", (Object)new Object[0]);
            } else {
                List<Object> ids = this.getManualSelectedPks(rowIndex);
                filter = new QFilter("id", "in", ids);
            }
        }
        return filter;
    }

    private int getEntryOperationRowKey() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
        return entryGrid.getEntryState().getFocusRow();
    }

    private FormConfig getFormConfigByEntryItem(int rowKey) {
        Object selectRowItem = this.getModel().getValue(ITEM, rowKey);
        if (selectRowItem == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u9879", (String)"BatchPackSchemePlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return null;
        }
        DynamicObject rowItem = (DynamicObject)selectRowItem;
        Object itemId = rowItem.getPkValue();
        DynamicObject dbItem = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"page,page.number,page.basedatafield.number", (QFilter[])new QFilter("id", "=", itemId).toArray());
        String entityNumber = dbItem.getString("page.basedatafield.number");
        String showMessage = ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9879\u6682\u4e0d\u652f\u6301\u624b\u5de5\u9009\u62e9\u548c\u6570\u636e\u9884\u89c8\uff0c\u8bf7\u901a\u8fc7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u6253\u5305\u6216\u5355\u72ec\u4f20\u8f93", (String)"BatchPackSchemePlugin_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
        boolean isManualSelect = StringUtils.equals((String)entityNumber, (String)"gl_initbalance");
        if (StringUtils.isEmpty((String)entityNumber) || isManualSelect) {
            this.getView().showTipNotification(showMessage);
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)(entityNumber = this.getVchTemplateEntity(entityNumber)));
        boolean isBillEntityType = entityType instanceof BillEntityType;
        if (!isBillEntityType) {
            this.getView().showTipNotification(showMessage);
            return null;
        }
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)entityNumber);
        if (listFormConfig == null) {
            this.getView().showTipNotification(showMessage);
            return null;
        }
        if (StringUtils.equals((String)"al_rule_setting", (String)entityNumber)) {
            listFormConfig.setF7ListFormId("bos_treelistf7");
        }
        listFormConfig.setEntityTypeId(entityNumber);
        return listFormConfig;
    }

    private boolean manualDataCheck() {
        DynamicObjectCollection packEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        for (int i = 0; i < packEntity.size(); ++i) {
            DynamicObject item = (DynamicObject)packEntity.get(i);
            String dataSelectWay = item.getString(DATA_SELECTION);
            if (!StringUtils.equals((String)dataSelectWay, (String)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal())) continue;
            String manualSelectData = (String)item.get(MANUAL_SELECT_DATA_TAG);
            if (StringUtils.isEmpty((String)manualSelectData)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u9009\u62e9\u65b9\u5f0f\u4e3a'\u624b\u5de5\u9009\u62e9'\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"BatchPackSchemePlugin_10", (String)"sys-ricc-platform", (Object[])new Object[0]), i + 1));
                return false;
            }
            JSONObject selectDatas = JSON.parseObject((String)manualSelectData);
            List<Object> selectDataPks = this.getManualSelectedPks(i);
            QFilter filter = new QFilter("id", "in", selectDataPks);
            DynamicObject itemConfig = (DynamicObject)item.get(ITEM);
            itemConfig = QueryServiceHelper.queryOne((String)"ricc_configitems", (String)"page,page.number,page.basedatafield.number", (QFilter[])new QFilter("id", "=", itemConfig.getPkValue()).toArray());
            String entityName = itemConfig.getString("page.basedatafield.number");
            entityName = this.getVchTemplateEntity(entityName);
            List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filter.toArray(), null, (int)1000);
            List notExist = selectDataPks.stream().filter(o -> !queryPrimaryKeys.contains(o)).collect(Collectors.toList());
            if (notExist.isEmpty()) continue;
            StringBuilder notExistNumber = new StringBuilder();
            for (Object id : notExist) {
                notExistNumber.append(selectDatas.getString(String.valueOf(id))).append(',');
                notExistNumber.deleteCharAt(notExistNumber.lastIndexOf(","));
                selectDatas.remove((Object)id.toString());
            }
            if (selectDatas.size() > 0) {
                String msg = ResManager.loadKDString((String)"\u5df2\u9009%d\u6761", (String)"BatchPackSchemePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getModel().setValue(MANUAL_SEL, (Object)String.format(msg, queryPrimaryKeys.size()), i);
                String dataStr = JSON.toJSONString((Object)selectDatas);
                this.getModel().setValue(MANUAL_SELECT_DATA_TAG, (Object)dataStr, i);
            } else {
                this.getModel().setValue(MANUAL_SEL, (Object)ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"BatchPackSchemePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), i);
                this.getModel().setValue(MANUAL_SELECT_DATA_TAG, null, i);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u914d\u7f6e\u9879\u5df2\u9009\u7f16\u7801\u4e3a[%2$s]\u7684\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u540e\u518d\u6279\u91cf\u6253\u5305/\u4fdd\u5b58\u65b9\u6848\uff1b", (String)"BatchPackSchemePlugin_12", (String)"sys-ricc-platform", (Object[])new Object[0]), i, notExistNumber));
            return false;
        }
        return true;
    }

    private boolean isExecutingAndShowTip() {
        if (TaskSerailHelper.taskExist("onekey_packet_task")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u6709\u4efb\u52a1\u5728\u6267\u884c\u6279\u91cf\u6253\u5305\u4e86\uff0c\u8bf7\u7b49\u5f85\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u4e4b\u540e\u518d\u53d1\u8d77", (String)"BatchPackSchemePlugin_13", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isHasPermAndShowTip() {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        boolean hasPerm = permissionService.hasSpecificPerm(RequestContext.get().getCurrUserId(), "ricc", "ricc_configitems", "2EQ14YWDAHC7");
        if (!hasPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6279\u91cf\u6253\u5305\u7684\u529f\u80fd\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BatchPackSchemePlugin_14", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private LinkedHashMap<String, String> getTransTipMap(DynamicObjectCollection packSchemeEntry) {
        LinkedHashMap<String, String> transTipMap = new LinkedHashMap<String, String>(16);
        for (DynamicObject dynamicObject : packSchemeEntry) {
            DynamicObject item = dynamicObject.getDynamicObject(ITEM);
            String itemName = item.getString("name");
            String transTips = item.getString("transtips");
            if (!StringUtils.isNotEmpty((String)transTips)) continue;
            transTipMap.put(itemName, transTips);
        }
        return transTipMap;
    }

    private void openFastAddPacket(Map<String, String> transTipMap) {
        OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("name");
        String schemeName = localeValue.getLocaleValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        if (StringUtils.isBlank((CharSequence)schemeName)) {
            schemeName = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305", (String)"BatchPackSchemePlugin_30", (String)"sys-ricc-platform", (Object[])new Object[0]);
        }
        StyleCss style = new StyleCss();
        if (transTipMap != null && !transTipMap.isEmpty()) {
            style.setHeight("510px");
            formShowParameter.getOpenStyle().setInlineStyleCss(style);
        } else {
            style.setHeight("268px");
        }
        formShowParameter.getOpenStyle().setInlineStyleCss(style);
        formShowParameter.setCustomParam("transtips", (Object)SerializationUtils.toJsonString(transTipMap));
        formShowParameter.setCustomParam("schemeName", (Object)schemeName);
        formShowParameter.setFormId("ricc_fastaddpacket");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addPacketClose"));
        this.getView().showForm(formShowParameter);
    }

    private void openPacketLogForm(String schemeNumber, boolean schemeIsSave) {
        ListShowParameter showParam = ShowParameterUtil.listShowParameter((String)"ricc_log", (String)"bos_list", (ShowType)ShowType.MainNewTabPage, null, null, null, null);
        showParam.setCustomParam("isleachschemebumber", (Object)schemeIsSave);
        showParam.setCustomParam("packschemenumber", (Object)schemeNumber);
        String pageId = this.getView().getFormShowParameter().getRootPageId();
        showParam.setPageId(schemeNumber + pageId);
        String parentPageId = ShowParameterUtil.getParentPageId((IFormView)this.getView());
        showParam.setParentPageId(parentPageId);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void setManualSelectData(int rowIndex, ListSelectedRowCollection selectedRows, String entityNumber) {
        String numberField = null;
        int size = selectedRows.size();
        if (size > 0) {
            ListSelectedRow row2 = selectedRows.get(0);
            if (StringUtils.isNotEmpty((String)row2.getBillNo())) {
                numberField = "billno";
            }
            if (StringUtils.isNotEmpty((String)row2.getNumber())) {
                numberField = "number";
            }
        }
        HashMap dataIdNumberMaps = new HashMap(size);
        if ("number".equals(numberField)) {
            if (StringUtils.equals((String)entityNumber, (String)"ai_vchtemplate_configs")) {
                selectedRows.forEach(row -> dataIdNumberMaps.put(Long.parseLong(String.valueOf(row.getPrimaryKeyValue())), row.getNumber()));
            } else {
                selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getNumber()));
            }
        } else if ("billno".equals(numberField)) {
            selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), row.getBillNo()));
        } else {
            selectedRows.forEach(row -> dataIdNumberMaps.put(row.getPrimaryKeyValue(), " "));
        }
        String dataStr = JSON.toJSONString(dataIdNumberMaps);
        this.getModel().setValue(MANUAL_SEL, (Object)String.format(ResManager.loadKDString((String)"\u5df2\u9009%d\u6761", (String)"BatchPackSchemePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), size), rowIndex);
        this.getModel().setValue(MANUAL_SELECT_DATA_TAG, (Object)dataStr, rowIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((String)FILTER_TERM, (String)controlKey)) {
            int row = this.getModel().getEntryCurrentRowIndex(PACK_SCHEME_ENTRY);
            DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM, row);
            if (item == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u914d\u7f6e\u9879", (String)"BatchPackSchemePlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            DynamicObject configItem = BusinessDataServiceHelper.loadSingleFromCache((Object)item.getPkValue(), (String)"ricc_configitems");
            String formId = configItem.getString("page.basedatafield.number");
            formId = this.getVchTemplateEntity(formId);
            String conditionJson = (String)this.getModel().getValue(FILTER_TERM_STORE_TAG, row);
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)dataEntityType, null);
            String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
            OpenFilterFormUtil.showConditionForm((IFormView)this.getView(), (String)conditionJson, (String)formId, (String)flsNodes, (String)this.getPluginName(), (String)"filtereditaction");
        } else if (StringUtils.equals((String)RELY_CONFIG_ITEM, (String)controlKey)) {
            boolean isPreset = (Boolean)this.getModel().getValue(ISPRESET);
            if (isPreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BatchPackSchemePlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection packEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
            int indexRow = this.getModel().getEntryCurrentRowIndex(PACK_SCHEME_ENTRY);
            DynamicObject packItem = (DynamicObject)packEntity.get(indexRow);
            DynamicObject itemConfig = (DynamicObject)packItem.get(ITEM);
            DynamicObjectCollection relyConfigItem = itemConfig.getDynamicObjectCollection(RELYITEMENTRY);
            ArrayList<Object> canBatchPackList = new ArrayList<Object>();
            StringBuilder canBatchPackItemStr = new StringBuilder();
            StringBuilder cannotBatchPackItemStr = new StringBuilder();
            StringBuilder cannotAddPacketStr = new StringBuilder();
            this.resolveRelyItem(relyConfigItem, canBatchPackList, canBatchPackItemStr, cannotBatchPackItemStr, cannotAddPacketStr, indexRow);
            this.showRelyMessage(canBatchPackList, canBatchPackItemStr, cannotBatchPackItemStr, cannotAddPacketStr);
        }
    }

    private void resolveRelyItem(DynamicObjectCollection relyConfigItem, ArrayList<Object> canBatchPackList, StringBuilder canBatchPackItemName, StringBuilder cannotBatchPackItemName, StringBuilder cannotAddPacketStr, int indexRow) {
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject itemRow : relyConfigItem) {
            DynamicObject item = (DynamicObject)itemRow.get(RELYITEM);
            ids.add(item.get("id"));
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] configItems = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id,name,supportaddtopacket,canexportall", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        int[] entryNextRows = BatchPackSchemePlugin.getEntryNextRows(entryEntity, indexRow);
        ArrayList<Object> existRelyPkList = new ArrayList<Object>(10);
        for (int entryNextRow : entryNextRows) {
            DynamicObject entryRow = (DynamicObject)entryEntity.get(entryNextRow);
            DynamicObject existRely = entryRow.getDynamicObject(ITEM);
            if (existRely == null) continue;
            existRelyPkList.add(existRely.getPkValue());
        }
        for (DynamicObject item : configItems) {
            boolean canExportAll = item.getBoolean("canexportall");
            boolean canAddPacket = item.getBoolean("supportaddtopacket");
            Object itemPk = item.getPkValue();
            if (!canExportAll) {
                if (canAddPacket) {
                    cannotBatchPackItemName.append(item.getString("name")).append('\uff0c');
                    continue;
                }
                cannotAddPacketStr.append(item.getString("name")).append('\uff0c');
                continue;
            }
            if (existRelyPkList.contains(itemPk)) continue;
            canBatchPackItemName.append(item.get("name")).append('\uff0c');
            canBatchPackList.add(item.getPkValue());
        }
    }

    private void showRelyMessage(ArrayList<Object> canBatchPackList, StringBuilder canBatchPackItemStr, StringBuilder cannotBatchPackItemStr, StringBuilder cannotAddPacketStr) {
        String canBatchItems = JSON.toJSONString(canBatchPackList);
        StringBuilder msg = new StringBuilder();
        if (cannotAddPacketStr.length() > 0) {
            cannotAddPacketStr.deleteCharAt(cannotAddPacketStr.lastIndexOf("\uff0c"));
            msg.append(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u4f20\u8f93\uff0c\u8bf7\u6ce8\u610f\u5355\u72ec\u914d\u7f6e\uff1b", (String)"BatchPackSchemePlugin_20", (String)"sys-ricc-platform", (Object[])new Object[0]), cannotAddPacketStr));
        }
        if (cannotBatchPackItemStr.length() > 0) {
            cannotBatchPackItemStr.deleteCharAt(cannotBatchPackItemStr.lastIndexOf("\uff0c"));
            msg.append(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u3010%s\u3011\u4e0d\u652f\u6301\u6279\u91cf\u6253\u5305\uff0c\u8bf7\u6ce8\u610f\u5355\u72ec\u4f20\u8f93\uff1b", (String)"BatchPackSchemePlugin_21", (String)"sys-ricc-platform", (Object[])new Object[0]), cannotBatchPackItemStr));
        }
        if (canBatchPackList.isEmpty()) {
            this.getView().showTipNotification(msg.toString());
        } else {
            this.getPageCache().put(CAN_BATCH_PACK_ITEM, canBatchItems);
            canBatchPackItemStr.deleteCharAt(canBatchPackItemStr.lastIndexOf("\uff0c"));
            msg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u6dfb\u52a0\u3010%s\u3011\u914d\u7f6e\u9879\u81f3\u5f53\u524d\u65b9\u6848\uff1b", (String)"BatchPackSchemePlugin_22", (String)"sys-ricc-platform", (Object[])new Object[0]), canBatchPackItemStr));
            this.getView().showConfirm(msg.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CAN_BATCH_PACK_RELY, (IFormPlugin)this));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (CHOOSE_ITEM.equals(actionId) && event.getReturnData() != null) {
            ListSelectedRowCollection items = (ListSelectedRowCollection)event.getReturnData();
            Object[] itemsPks = items.getPrimaryKeyValues();
            DynamicObjectCollection packItemEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)QUERYFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemsPks)});
            for (int i = 0; i < configs.length; ++i) {
                DynamicObject item = configs[i];
                int entitySize = packItemEntity.size();
                this.createRowAndSetVal(item, entitySize + i, false);
            }
            this.refreshItemRely();
        } else if ("filtereditaction".equals(actionId) && event.getReturnData() != null) {
            String conditionJson = (String)event.getReturnData();
            OpenFilterFormUtil.receiveCondition((IDataModel)this.getModel(), (String)conditionJson, (String)PACK_SCHEME_ENTRY, (String)FILTER_TERM_STORE_TAG, (String)FILTER_TERM, (String)FILTER_TERM_L);
        } else if ("addPacketClose".equals(actionId) && event.getReturnData() != null) {
            Object packetId = event.getReturnData();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ricc_onekeypack");
            DynamicObjectCollection packEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
            HashSet<Object> itemsPkSet = new HashSet<Object>();
            for (DynamicObject itemRow : packEntity) {
                DynamicObject item = (DynamicObject)itemRow.get(ITEM);
                if (item == null) continue;
                itemsPkSet.add(item.getPkValue());
            }
            DynamicObject[] queryData = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id,page,page.number,page.basedatafield.number", (QFilter[])new QFilter("id", "in", itemsPkSet).toArray());
            HashMap itemMapping = new HashMap(8);
            Arrays.stream(queryData).forEach(l -> itemMapping.put(l.getPkValue(), l));
            JSONArray jsonArrayItem = new JSONArray();
            for (int i = 0; i < packEntity.size(); ++i) {
                DynamicObject itemRow = (DynamicObject)packEntity.get(i);
                JSONObject config = new JSONObject();
                DynamicObject item = (DynamicObject)itemRow.get(ITEM);
                if (item == null) continue;
                config.put("seq", itemRow.get("seq"));
                config.put("name", (Object)item.getLocaleString("name").getLocaleValue());
                String formId = (String)item.get(PAGE_NUMBER);
                config.put("formid", (Object)this.getVchTemplateEntity(formId));
                config.put("importtype", item.get("importtype"));
                config.put("pageenterparam", item.get("pageenterparam"));
                config.put("id", item.get("id"));
                config.put("pagetype", item.get("pagetype"));
                config.put("custompage", item.get("custompage"));
                DynamicObject dbItem = (DynamicObject)itemMapping.get(item.getPkValue());
                String entityNumber = dbItem.getString("page.basedatafield.number");
                QFilter qFilter = this.getEntryRowFilters(i, this.getVchTemplateEntity(entityNumber));
                String filterStr = qFilter == null ? null : qFilter.toSerializedString();
                config.put("filters", (Object)filterStr);
                jsonArrayItem.add((Object)config);
            }
            Object packSchemeId = this.getModel().getDataEntity().getPkValue();
            formShowParameter.setCustomParam("packSchemeId", packSchemeId);
            formShowParameter.setCustomParam(PACK_SCHEME_ENTRY, (Object)jsonArrayItem);
            formShowParameter.setCustomParam("packetId", packetId);
            formShowParameter.setCustomParam("parentPageId", (Object)this.getView().getPageId());
            formShowParameter.setCustomParam("formId", (Object)"ricc_onekeypack");
            HashSet<String> taskKeySet = new HashSet<String>();
            taskKeySet.add("onekey_packet_task");
            formShowParameter.setCustomParam("ricconcekey", taskKeySet);
            this.getView().showForm(formShowParameter);
        } else if (MANUAL_SELECT_CLOSE_ACTION.equals(actionId)) {
            int rowIndex = this.getEntryOperationRowKey();
            Object returnData = event.getReturnData();
            if (returnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                this.setManualSelectData(rowIndex, selectedRows, "");
            }
        } else if (BATCH_ADD_FILTER_CLOSE_ACTION.equals(actionId) && event.getReturnData() != null) {
            Map returnDataMap = (Map)event.getReturnData();
            this.batchAddFilter(returnDataMap);
        }
    }

    private void batchAddFilter(Map<String, Object> returnDataMap) {
        String defaultEntityNumber = (String)returnDataMap.get("entityNumber");
        defaultEntityNumber = this.getVchTemplateEntity(defaultEntityNumber);
        MainEntityType defaultEntityType = CommonUtil.getEntityTypeByFormId((String)defaultEntityNumber);
        Map defaultEntityMapping = defaultEntityType.getAllFields();
        FilterCondition filterCondition = (FilterCondition)returnDataMap.get("filterCondition");
        List newFilterRowList = filterCondition.getFilterRow();
        List<String> filterFields = newFilterRowList.stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toList());
        ArrayList<String> filterFields2 = new ArrayList<String>(filterFields);
        for (int i = 0; i < filterFields.size(); ++i) {
            String currentItem = (String)filterFields.get(i);
            int dotIndex = currentItem.indexOf(46);
            if (dotIndex == -1) continue;
            String prefix = currentItem.substring(0, dotIndex);
            filterFields.set(i, prefix + "_id");
            filterFields2.set(i, prefix);
        }
        FilterBuilder filterBuilder = new FilterBuilder(defaultEntityType, filterCondition, true);
        filterBuilder.setUserService((IUserService)this.getView().getService(kd.bos.permission.api.IUserService.class));
        filterBuilder.buildFilter(false);
        String exprTran = filterBuilder.getFilterObject().getFilter();
        filterCondition.setFilter(exprTran);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        for (DynamicObject entryRow : entryEntity) {
            String filterStore;
            String saveExprTran;
            String dataSelection = (String)entryRow.get(DATA_SELECTION);
            if (!StringUtils.equals((String)dataSelection, (String)DataSelectWayEnum.FILTER_SELECT_WAY.getVal())) continue;
            DynamicObject configItem = (DynamicObject)entryRow.get(ITEM);
            String entityNumber = configItem.getString(PAGE_NUMBER);
            entityNumber = this.getVchTemplateEntity(entityNumber);
            MainEntityType rowEntityType = CommonUtil.getEntityTypeByFormId((String)entityNumber);
            DataEntityPropertyCollection properties = rowEntityType.getProperties();
            List itemFields = properties.stream().map(IMetadata::getName).collect(Collectors.toList());
            Map rowEntityMapping = rowEntityType.getAllFields();
            boolean typeSame = this.isTypeSame(defaultEntityMapping, rowEntityMapping, filterFields, filterFields2);
            boolean isContainsAll = itemFields.containsAll(filterFields) || itemFields.containsAll(filterFields2);
            if (!isContainsAll || !typeSame) continue;
            String exportFilters = (String)entryRow.get(FILTER_TERM_STORE_TAG);
            if (StringUtils.isBlank((CharSequence)exportFilters)) {
                CRCondition condition = new CRCondition();
                condition.setFilterCondition(filterCondition);
                saveExprTran = exprTran;
                filterStore = SerializationUtils.toJsonString((Object)condition);
            } else {
                Map oldFilterStoreMap = (Map)SerializationUtils.fromJsonString((String)exportFilters, Map.class);
                String oldFilterRowString = (String)oldFilterStoreMap.get("filterString");
                LinkedHashMap filterRowMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)oldFilterRowString, Map.class);
                List filterRowList = filterRowMap.getOrDefault("filterRow", new ArrayList());
                filterRowList.addAll(this.createSimpleFilterRow(newFilterRowList));
                filterRowMap.put("filterRow", filterRowList);
                String newFilterRowString = SerializationUtils.toJsonString((Object)filterRowMap);
                oldFilterStoreMap.put("filterString", newFilterRowString);
                LinkedHashMap<String, List> filterConditionMap = oldFilterStoreMap.getOrDefault("filterCondition", new LinkedHashMap());
                List conditionList = filterConditionMap.getOrDefault("filterRow", new ArrayList());
                conditionList.addAll(this.createSimpleFilterRow(newFilterRowList));
                filterConditionMap.put("filterRow", conditionList);
                oldFilterStoreMap.put("filterCondition", filterConditionMap);
                filterStore = SerializationUtils.toJsonString((Object)oldFilterStoreMap);
                String oldExprTran = (String)entryRow.get(FILTER_TERM);
                saveExprTran = oldExprTran + " and " + exprTran;
            }
            entryRow.set(FILTER_TERM, (Object)StringUtils.limitStringLength((int)2000, (String)saveExprTran));
            entryRow.set(FILTER_TERM_L, (Object)StringUtils.limitStringLength((int)2000, (String)saveExprTran));
            entryRow.set(FILTER_TERM_STORE_TAG, (Object)filterStore);
        }
        this.getView().updateView(PACK_SCHEME_ENTRY);
        this.refreshItemRely();
    }

    private boolean isTypeSame(Map<String, IDataEntityProperty> defaultMapping, Map<String, IDataEntityProperty> rowMapping, List<String> fields, List<String> fields2) {
        if (this.isTypeSame(fields, defaultMapping, rowMapping)) {
            return false;
        }
        return !this.isTypeSame(fields2, defaultMapping, rowMapping);
    }

    private boolean isTypeSame(List<String> fields2, Map<String, IDataEntityProperty> defaultMapping, Map<String, IDataEntityProperty> rowMapping) {
        for (String field : fields2) {
            IDataEntityProperty defaultProp = defaultMapping.get(field);
            IDataEntityProperty rowProp = rowMapping.get(field);
            if (defaultProp == null || rowProp == null || defaultProp.getClass() == rowProp.getClass() && !StringUtils.isBlank((CharSequence)rowProp.getAlias())) continue;
            return true;
        }
        return false;
    }

    private List<LinkedHashMap<String, Object>> createSimpleFilterRow(List<SimpleFilterRow> newFilterRowList) {
        ArrayList<LinkedHashMap<String, Object>> result = new ArrayList<LinkedHashMap<String, Object>>(newFilterRowList.size());
        for (SimpleFilterRow simpleFilterRow : newFilterRowList) {
            LinkedHashMap<String, Object> oneFilterRow = new LinkedHashMap<String, Object>(8);
            oneFilterRow.put("id", simpleFilterRow.getId());
            oneFilterRow.put("leftBracket", simpleFilterRow.getLeftBracket());
            oneFilterRow.put("compareType", simpleFilterRow.getCompareType());
            oneFilterRow.put("fieldName", simpleFilterRow.getFieldName());
            oneFilterRow.put("rightBracket", simpleFilterRow.getRightBracket());
            oneFilterRow.put("logic", simpleFilterRow.getLogic());
            oneFilterRow.put("value", simpleFilterRow.getValue());
            oneFilterRow.put("baseDataIds", simpleFilterRow.getBaseDataIds());
            result.add(oneFilterRow);
        }
        return result;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int rowIndex = e.getInsertRow();
        DynamicObject itemRow = (DynamicObject)this.getModel().getValue(ITEM, rowIndex);
        String createRow = this.getPageCache().get("sysCreateRow");
        if (!StringUtils.equals((String)createRow, (String)"syscreate") && itemRow == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{RELY_CONFIG_ITEM});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String schemeRowDelete = this.getView().getPageCache().get(SCHEME_ROW_DELETE);
        if (!StringUtils.equals((String)schemeRowDelete, (String)"sys")) {
            this.refreshItemRely();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CAN_BATCH_PACK_RELY.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String canExportConfigs = this.getPageCache().get(CAN_BATCH_PACK_ITEM);
            List itemsPks = (List)JSON.parse((String)canExportConfigs);
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)QUERYFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)itemsPks)});
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
            int focusRow = this.getModel().getEntryCurrentRowIndex(PACK_SCHEME_ENTRY);
            for (DynamicObject item : configs) {
                this.createRowAndSetVal(item, focusRow, true);
            }
            List<CellStyle> cellStyles = this.setForeColor(COLOR_BLACK, focusRow);
            entryGrid.setCellStyle(cellStyles);
            this.getView().setEnable(Boolean.FALSE, focusRow, new String[]{RELY_CONFIG_ITEM});
            entryGrid.expand(focusRow);
            this.refreshItemRely();
        } else if (DATA_SELECT_ACTION.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String dataSelectRow = this.getPageCache().get("dataselectrow");
            String dataSelectType = this.getPageCache().get("dataselecttype");
            if (StringUtils.equals((String)dataSelectType, (String)"filter")) {
                this.getPageCache().put(MARK_DATASELCTION, "sys");
                this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.FILTER_SELECT_WAY.getVal(), Integer.parseInt(dataSelectRow));
                this.getPageCache().remove(MARK_DATASELCTION);
                this.selectMethodChangedClearData(Integer.parseInt(dataSelectRow), FILTER_TERM, MANUAL_SEL, MANUAL_SELECT_DATA_TAG);
                this.getPageCache().remove(MARK_DATASELCTION);
            } else {
                this.selectMethodChangedClearData(Integer.parseInt(dataSelectRow), MANUAL_SEL, FILTER_TERM, FILTER_TERM_STORE);
                this.getModel().setValue(FILTER_TERM_STORE_TAG, null, Integer.parseInt(dataSelectRow));
                this.getPageCache().put(MARK_DATASELCTION, "sys");
                this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal(), Integer.parseInt(dataSelectRow));
                this.getPageCache().remove(MARK_DATASELCTION);
                this.getModel().setValue(MANUAL_SEL, (Object)ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"BatchPackSchemePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        } else if (INTELLIGENTADDRELYDATA.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.intelligentAddRelyData();
            this.refreshItemRely();
        }
    }

    private void intelligentAddRelyData() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entityData = this.getModel().getEntryEntity(PACK_SCHEME_ENTRY);
        ArrayList<Object> allRelyIds = new ArrayList<Object>(10);
        for (int rowIndex : selectRows) {
            DynamicObject packRow = (DynamicObject)entityData.get(rowIndex);
            DynamicObject itemConfig = (DynamicObject)packRow.get(ITEM);
            allRelyIds.addAll(this.getAllRelyPkList(itemConfig));
        }
        if (allRelyIds.isEmpty()) {
            return;
        }
        Map allRelyItems = BusinessDataServiceHelper.loadFromCache((String)"ricc_configitems", (QFilter[])new QFilter[]{new QFilter("id", "in", allRelyIds)});
        int levelAddRows = 0;
        ArrayList<Integer> newSelectRowsList = new ArrayList<Integer>(10);
        for (int rowIndex : selectRows) {
            entityData = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
            newSelectRowsList.add(rowIndex += levelAddRows);
            int[] entryNextRows = BatchPackSchemePlugin.getEntryNextRows(entityData, rowIndex);
            this.getView().getPageCache().put(SCHEME_ROW_DELETE, "sys");
            this.getModel().deleteEntryRows(PACK_SCHEME_ENTRY, entryNextRows);
            this.getPageCache().remove(SCHEME_ROW_DELETE);
            DynamicObject schemeRow = (DynamicObject)entityData.get(rowIndex);
            int newCreateRows = this.createSubLevelRowAndSetVal(allRelyItems, rowIndex, schemeRow);
            levelAddRows += newCreateRows - entryNextRows.length;
        }
        entryGrid.expandOne(newSelectRowsList.stream().mapToInt(Integer::intValue).toArray());
    }

    private int createSubLevelRowAndSetVal(Map<Object, DynamicObject> allRelyItems, int rowIndex, DynamicObject schemeRow) {
        DynamicObject configItem = (DynamicObject)schemeRow.get(ITEM);
        String entityNumber = configItem.getString(PAGE_NUMBER);
        entityNumber = this.getVchTemplateEntity(entityNumber);
        String configItemPageType = PageChangeUtil.getConfigItemPageType((String)entityNumber);
        MainEntityType entityType = null;
        if ("PCLayout".equals(configItemPageType)) {
            String entityTypeId;
            entityNumber = entityTypeId = FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId();
            entityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        } else {
            entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        DataEntityPropertyCollection properties = entityType.getProperties();
        HashMap<String, IDataEntityProperty> entityBasePropMap = this.getBaseDataPropMap(properties, "");
        DynamicObjectCollection relyItemEntry = configItem.getDynamicObjectCollection(RELYITEMENTRY);
        StringBuilder relyRelationField = new StringBuilder();
        for (DynamicObject relyRow : relyItemEntry) {
            relyRelationField.append(relyRow.getString("relyrelationfield"));
        }
        String[] split = relyRelationField.toString().split(",");
        String queryF = this.getQueryFields(entityBasePropMap, split);
        String manualSelectData = schemeRow.getString(MANUAL_SELECT_DATA_TAG);
        Map data = (Map)JSON.parseObject((String)manualSelectData, Map.class);
        ArrayList ids = new ArrayList(data.keySet());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] loadRowData = BusinessDataServiceHelper.load((String)entityNumber, (String)queryF, (QFilter[])qFilter.toArray());
        int newRelyRow = 0;
        for (DynamicObject relyRow : relyItemEntry) {
            Object relyItemId;
            DynamicObject relyItem;
            boolean canPackAll;
            DynamicObject relyItemRow = (DynamicObject)relyRow.get(RELYITEM);
            if (relyItemRow == null || !(canPackAll = (relyItem = allRelyItems.get(relyItemId = relyItemRow.getPkValue())).getBoolean("canexportall"))) continue;
            int newCreateRow = this.createRowAndSetVal(relyItem, rowIndex, true);
            String relyField = relyRow.getString("relyrelationfield");
            String relyPageNumber = relyItem.getString(PAGE_NUMBER);
            HashMap<Object, String> dataIdNumberMap = this.getDataIdNumberMap(properties, entityBasePropMap, loadRowData, relyField, relyPageNumber);
            this.setManualInfo(newCreateRow, dataIdNumberMap);
            ++newRelyRow;
        }
        return newRelyRow;
    }

    private HashMap<Object, String> getDataIdNumberMap(DataEntityPropertyCollection properties, Map<String, IDataEntityProperty> entityBasePropMap, DynamicObject[] loadRowData, String relyField, String relyPageNumber) {
        HashMap<Object, String> dataIdNumberMaps = new HashMap<Object, String>(16);
        if (relyField.length() > 0) {
            String[] rowFieldsArr = relyField.split(",");
            String fullNameField = this.getFilterFields(entityBasePropMap, rowFieldsArr);
            if (StringUtils.isBlank((CharSequence)fullNameField)) {
                return dataIdNumberMaps;
            }
            String[] queryRowFieldArr = fullNameField.split(",");
            for (DynamicObject oneData : loadRowData) {
                for (String field : queryRowFieldArr) {
                    IDataEntityProperty property = entityBasePropMap.get(field);
                    String[] dotFieldArr = field.split("\\.");
                    boolean containsKey = properties.containsKey((Object)dotFieldArr[dotFieldArr.length - 1]);
                    if (containsKey) {
                        this.getDataValueToMap(oneData, field, dataIdNumberMaps, property, relyPageNumber);
                        continue;
                    }
                    List collectionProperties = properties.getCollectionProperties(false);
                    this.getMatchValueFromDynamicCollection(oneData, field, dotFieldArr[dotFieldArr.length - 1], dataIdNumberMaps, collectionProperties, property, relyPageNumber);
                }
            }
        }
        return dataIdNumberMaps;
    }

    private void getMatchValueFromDynamicCollection(DynamicObject dataObj, String field, String matchKey, Map<Object, String> dataIdNumberMaps, List<ICollectionProperty> collectionProperties, IDataEntityProperty property, String relyPageNumber) {
        ArrayList<String> splitFields = new ArrayList<String>(Arrays.asList(field.split("\\.")));
        splitFields.remove(matchKey);
        for (ICollectionProperty collectionProperty : collectionProperties) {
            String collectionKey = collectionProperty.getName();
            boolean match = false;
            if (collectionProperty instanceof EntryProp) {
                for (String splitField : splitFields) {
                    if (!collectionKey.equals(splitField)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            DynamicObjectCollection dynamicObjectCollection = dataObj.getDynamicObjectCollection(collectionKey);
            DynamicObjectType entryItemPropertyType = ((EntryProp)collectionProperty).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryDynamicProperties = entryItemPropertyType.getProperties();
            if (entryDynamicProperties.containsKey((Object)matchKey)) {
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    this.getDataValueToMap(dynamicObject, matchKey, dataIdNumberMaps, property, relyPageNumber);
                }
                return;
            }
            List entryCollectionProperties = entryDynamicProperties.getCollectionProperties(false);
            if (entryCollectionProperties.isEmpty()) continue;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                this.getMatchValueFromDynamicCollection(dynamicObject, field, matchKey, dataIdNumberMaps, entryCollectionProperties, property, relyPageNumber);
            }
        }
    }

    private void getDataValueToMap(DynamicObject oneData, String matchKey, Map<Object, String> dataIdNumberMaps, IDataEntityProperty property, String relyPageNumber) {
        Object keyValueObj = oneData.get(matchKey);
        if (Objects.isNull(keyValueObj)) {
            return;
        }
        if (keyValueObj instanceof DynamicObjectCollection) {
            String numberProp = ((MulBasedataProp)property).getNumberProp();
            for (DynamicObject oneMulRelyData : (DynamicObjectCollection)keyValueObj) {
                DynamicObject oneMulRelyDataValue = oneMulRelyData.getDynamicObject("fbasedataid");
                if (!StringUtils.equals((String)oneMulRelyDataValue.getDataEntityType().getName(), (String)relyPageNumber)) continue;
                dataIdNumberMaps.put(oneMulRelyDataValue.getPkValue(), oneMulRelyDataValue.getString(numberProp));
            }
        } else if (keyValueObj instanceof DynamicObject) {
            DynamicObject relyData = (DynamicObject)keyValueObj;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)relyPageNumber);
            String numberProperty = ((BasedataEntityType)dataEntityType).getNumberProperty();
            if (StringUtils.equals((String)relyData.getDataEntityType().getName(), (String)relyPageNumber)) {
                dataIdNumberMaps.put(relyData.getPkValue(), relyData.getString(numberProperty));
            }
        }
    }

    private void setManualInfo(int newRelyRow, Map<Object, String> dataIdNumberMaps) {
        String msg;
        if (dataIdNumberMaps.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u5f85\u9009\u62e9", (String)"BatchPackSchemePlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        } else {
            String dataStr = JSON.toJSONString(dataIdNumberMaps);
            msg = String.format(ResManager.loadKDString((String)"\u5df2\u9009%d\u6761", (String)"BatchPackSchemePlugin_11", (String)"sys-ricc-platform", (Object[])new Object[0]), dataIdNumberMaps.size());
            this.getModel().setValue(MANUAL_SELECT_DATA_TAG, (Object)dataStr, newRelyRow);
        }
        this.getModel().setValue(MANUAL_SEL, (Object)msg, newRelyRow);
        this.getPageCache().put(MARK_DATASELCTION, "sys");
        this.getModel().setValue(DATA_SELECTION, (Object)DataSelectWayEnum.MANUAL_SELECT_WAY.getVal(), newRelyRow);
        this.getPageCache().remove(MARK_DATASELCTION);
        this.selectMethodChangedClearData(newRelyRow, MANUAL_SEL, FILTER_TERM, FILTER_TERM_STORE);
    }

    private String getFilterFields(Map<String, IDataEntityProperty> entityAllPropMap, String[] split) {
        StringBuilder selectFields = new StringBuilder();
        for (String field : split) {
            if (!StringUtils.isNotBlank((CharSequence)field)) continue;
            for (Map.Entry<String, IDataEntityProperty> entry : entityAllPropMap.entrySet()) {
                IDataEntityProperty prop = entry.getValue();
                if (!StringUtils.equals((String)field, (String)prop.getName())) continue;
                String key = entry.getKey();
                selectFields.append(key).append(',');
            }
        }
        return selectFields.length() > 0 ? selectFields.deleteCharAt(selectFields.lastIndexOf(",")).toString() : "";
    }

    private String getQueryFields(Map<String, IDataEntityProperty> entityAllPropMap, String[] split) {
        StringBuilder selectFields = new StringBuilder();
        for (String field : split) {
            if (!StringUtils.isNotBlank((CharSequence)field)) continue;
            for (Map.Entry<String, IDataEntityProperty> entry : entityAllPropMap.entrySet()) {
                IDataEntityProperty prop = entry.getValue();
                if (!StringUtils.equals((String)field, (String)prop.getName())) continue;
                String key = entry.getKey();
                String[] keyArr = key.split("\\.");
                if (keyArr.length == 3) {
                    selectFields.append(keyArr[0]).append('.').append(keyArr[1]).append(',');
                    selectFields.append(keyArr[1]).append('.').append(keyArr[2]).append(',');
                }
                selectFields.append(key).append(',');
            }
        }
        return selectFields.length() > 0 ? selectFields.deleteCharAt(selectFields.lastIndexOf(",")).toString() : "";
    }

    private HashMap<String, IDataEntityProperty> getBaseDataPropMap(DataEntityPropertyCollection properties, String parentEntityName) {
        HashMap<String, IDataEntityProperty> result = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)prop;
                String entryEntityName = "";
                entryEntityName = StringUtils.isBlank((CharSequence)parentEntityName) ? entryProp.getName() : parentEntityName + "." + entryProp.getName();
                DataEntityPropertyCollection entryProperties = entryProp.getDynamicCollectionItemPropertyType().getProperties();
                HashMap<String, IDataEntityProperty> entryPropMap = this.getBaseDataPropMap(entryProperties, entryEntityName);
                result.putAll(entryPropMap);
                continue;
            }
            boolean isBaseProp = prop instanceof BasedataProp || prop instanceof MulBasedataProp;
            if (!isBaseProp) continue;
            result.put(StringUtils.isBlank((CharSequence)parentEntityName) ? prop.getName() : parentEntityName + "." + prop.getName(), prop);
        }
        return result;
    }

    private int createRowAndSetVal(DynamicObject item, int index, boolean isLower) {
        this.getPageCache().put("sysCreateRow", "syscreate");
        int newRow = isLower ? this.getModel().insertEntryRow(PACK_SCHEME_ENTRY, index) : this.getModel().createNewEntryRow(PACK_SCHEME_ENTRY, index, null);
        this.getPageCache().remove("sysCreateRow");
        this.getPageCache().put(ITEM_CHANGED, "sys");
        this.getModel().setValue(ITEM, (Object)item, newRow);
        this.getPageCache().remove(ITEM_CHANGED);
        String relyItemName = this.getRelyItemNameStr(item);
        this.getModel().setValue(RELY_CONFIG_ITEM, (Object)relyItemName, newRow);
        this.getModel().setValue(FILTER_TERM, item.get("exportfiltersdesc_l"), newRow);
        this.getModel().setValue(FILTER_TERM_L, item.get("exportfiltersdesc_l"), newRow);
        this.getModel().setValue(FILTER_TERM_STORE, item.get(FILTER_TERM_STORE), newRow);
        this.getModel().setValue(FILTER_TERM_STORE_TAG, item.get(FILTER_TERM_STORE_TAG), newRow);
        return newRow;
    }

    private static int[] getEntryNextRows(DynamicObjectCollection entryRows, int row) {
        ArrayList<Integer> nextRows = new ArrayList<Integer>();
        Object id = ((DynamicObject)entryRows.get(row)).get("id");
        for (int i = row + 1; i < entryRows.size(); ++i) {
            if (!id.equals(((DynamicObject)entryRows.get(i)).get("pid"))) continue;
            nextRows.add(i);
            nextRows.addAll(Arrays.stream(BatchPackSchemePlugin.getEntryNextRows(entryRows, i)).boxed().collect(Collectors.toList()));
        }
        return nextRows.stream().mapToInt(Integer::intValue).toArray();
    }

    private void refreshItemRely() {
        DynamicObjectCollection packEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PACK_SCHEME_ENTRY);
        for (int i = 0; i < packEntity.size(); ++i) {
            DynamicObject packItem = (DynamicObject)packEntity.get(i);
            DynamicObject itemConfig = (DynamicObject)packItem.get(ITEM);
            ArrayList<Object> relyPk = this.getCanBatchPackRelyPkList(itemConfig);
            if (relyPk.isEmpty()) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{RELY_CONFIG_ITEM});
                continue;
            }
            entryGrid.setCellStyle(this.setIconVisibleAndCol(i, relyPk));
        }
    }

    private String getVchTemplateEntity(String entityNumber) {
        if (StringUtils.equals((String)"ai_vchtemplate_configs", (String)entityNumber)) {
            entityNumber = "ai_vchtemplate";
        }
        return entityNumber;
    }

    private List<CellStyle> setIconVisibleAndCol(int indexRow, ArrayList<Object> relyPk) {
        List<CellStyle> cellStyles;
        ArrayList<Object> entryItemPk = this.getEntryItemPkList();
        if (entryItemPk.containsAll(relyPk)) {
            this.getView().setEnable(Boolean.FALSE, indexRow, new String[]{RELY_CONFIG_ITEM});
            cellStyles = this.setForeColor(COLOR_BLACK, indexRow);
        } else {
            this.getView().setEnable(Boolean.TRUE, indexRow, new String[]{RELY_CONFIG_ITEM});
            cellStyles = this.setForeColor(COLOR_CANARY, indexRow);
        }
        return cellStyles;
    }

    private void selectMethodChangedClearData(int rowIndex, String changedType, String changedBeforeType, String changedBeforeTypeStore) {
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{changedType});
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{changedBeforeType});
        this.getModel().setValue(changedBeforeType, null, rowIndex);
        this.getModel().setValue(changedBeforeTypeStore, null, rowIndex);
    }

    private ArrayList<Object> getCanBatchPackRelyPkList(DynamicObject itemConfig) {
        ArrayList<Object> relyPkList = new ArrayList<Object>();
        if (itemConfig != null) {
            DynamicObjectCollection relyConfigItem = itemConfig.getDynamicObjectCollection(RELYITEMENTRY);
            for (int i = 0; i < relyConfigItem.size(); ++i) {
                DynamicObject relyRow = (DynamicObject)relyConfigItem.get(i);
                DynamicObject relyItem = (DynamicObject)relyRow.get(RELYITEM);
                if (relyItem == null) {
                    this.getView().showTipNotification(CommonConstant.getRelyItemIsNullTip((String)itemConfig.getString("name"), (int)(i + 1)));
                    continue;
                }
                relyPkList.add(relyItem.getPkValue());
            }
        }
        QFilter qFilterId = new QFilter("id", "in", relyPkList);
        QFilter qFilterCanExportAll = new QFilter("canexportall", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection canExportRelys = QueryServiceHelper.query((String)"ricc_configitems", (String)"id,canexportall", (QFilter[])new QFilter[]{qFilterId.and(qFilterCanExportAll)});
        relyPkList.clear();
        for (DynamicObject canExportRely : canExportRelys) {
            relyPkList.add(canExportRely.get("id"));
        }
        return relyPkList;
    }

    private ArrayList<Object> getAllRelyPkList(DynamicObject itemConfig) {
        ArrayList<Object> relyPkList = new ArrayList<Object>();
        if (itemConfig != null) {
            DynamicObjectCollection relyConfigItem = itemConfig.getDynamicObjectCollection(RELYITEMENTRY);
            for (DynamicObject relyRow : relyConfigItem) {
                DynamicObject relyItem = (DynamicObject)relyRow.get(RELYITEM);
                if (relyItem == null) continue;
                relyPkList.add(relyItem.getPkValue());
            }
        }
        return relyPkList;
    }

    private ArrayList<Object> getEntryItemPkList() {
        DynamicObjectCollection packEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PACK_SCHEME_ENTRY);
        ArrayList<Object> entryItemPk = new ArrayList<Object>();
        for (DynamicObject packItem : packEntity) {
            DynamicObject item = (DynamicObject)packItem.get(ITEM);
            if (item == null) continue;
            entryItemPk.add(item.getPkValue());
        }
        return entryItemPk;
    }

    private String getRelyItemNameStr(DynamicObject item) {
        DynamicObjectCollection relyConfigItem = item.getDynamicObjectCollection(RELYITEMENTRY);
        StringBuilder relyItemName = new StringBuilder();
        for (DynamicObject rely : relyConfigItem) {
            DynamicObject relyItem = (DynamicObject)rely.get(RELYITEM);
            if (relyItem == null) continue;
            relyItemName.append(relyItem.getLocaleString("name").getLocaleValue()).append(',');
        }
        if (relyItemName.length() > 0) {
            relyItemName.deleteCharAt(relyItemName.lastIndexOf(","));
        }
        return relyItemName.toString();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldKey = evt.getFieldName();
        if (MANUAL_SEL.equals(fieldKey)) {
            int rowKey = this.getEntryOperationRowKey();
            boolean isPreset = (Boolean)this.getModel().getValue(ISPRESET);
            if (isPreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BatchPackSchemePlugin_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            FormConfig listFormConfig = this.getFormConfigByEntryItem(rowKey);
            if (listFormConfig == null) {
                return;
            }
            String entityNumber = listFormConfig.getEntityTypeId();
            String f7ListFormId = listFormConfig.getF7ListFormId();
            if ("cts_layoutscheme_listf7".equals(f7ListFormId)) {
                f7ListFormId = "bos_listf7";
            }
            ListShowParameter listShowParameter = ShowParameterUtil.listShowParameter((String)entityNumber, (String)f7ListFormId, (ShowType)ShowType.Modal, null, null, (String)"", (String)"kd.bos.ext.imsc.ricc.form.f7ext.ManualSelectDataLimitPlugin");
            DynamicObject itemConfig = (DynamicObject)this.getModel().getValue(ITEM, rowKey);
            String pageParam = (String)itemConfig.get("pageenterparam");
            ShowParameterUtil.setPageEnterParam((ListShowParameter)listShowParameter, (String)pageParam);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setShowApproved(false);
            listShowParameter.setF7Style(0);
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            listShowParameter.getOpenStyle().setInlineStyleCss(style);
            listShowParameter.setShowTitle(false);
            listShowParameter.setLookUp(true);
            List<Object> selectPks = null;
            selectPks = this.getManualSelectedPks(rowKey);
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            selectPks.forEach(pk -> selectedRows.add((Object)new ListSelectedRow(pk)));
            listShowParameter.setListSelectedRowCollection(selectedRows);
            listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MANUAL_SELECT_CLOSE_ACTION));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }
}

