/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bccenter.guide;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.isc.IscSyncHelper;
import kd.sys.ricc.common.util.StringUtils;

public class BaseConfigIscSyncPlugin
extends AbstractFormPlugin {
    private static final String ISC_TYPE = "isctype";
    private static final String SCHEME_STATUS = "schemestatus";
    private static final String ISC_DATA_COPY_TRIGGER = "isc_data_copy_trigger";
    private static final String ISC_SERVICE_FLOW = "isc_service_flow";
    private static final String SUCCESS = "success";
    private static final String SCHEME = "scheme";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ISCTYPE = "isctype";
    private static final String DIRECTION = "direction";
    private static final String EXECUTE_FLOW_EVENT = "execute_flow_event";
    private static final String GET_FLOW_PARAMS = "get_flow_params";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String direction = (String)customParams.get(DIRECTION);
        Label label = (Label)this.getView().getControl(DIRECTION);
        label.setText(direction);
        Object itemId = customParams.get("id");
        DynamicObject configItem = BusinessDataServiceHelper.loadSingleFromCache(itemId, (String)"ricc_configitems");
        DynamicObjectCollection itemSchemes = (DynamicObjectCollection)configItem.get("ricc_schemeentry");
        int size = itemSchemes.size();
        for (int i = 0; i < size; ++i) {
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
            DynamicObject itemScheme = (DynamicObject)itemSchemes.get(i);
            DynamicObject scheme = (DynamicObject)itemScheme.get(SCHEME);
            DynamicObject schemeEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)scheme.getDynamicObjectType().getName());
            this.getModel().setValue("isctype", itemScheme.get("isctype"), i);
            this.getModel().setValue("id", scheme.getPkValue(), i);
            this.getModel().setValue(SCHEME, (Object)scheme, i);
            this.getModel().setValue(SCHEME_STATUS, schemeEntity.get("enable"), i);
            this.getModel().setValue("explain", itemScheme.get("entryexplain"), i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String opKey = op.getOperateKey();
        if (StringUtils.equals((String)"ok", (String)opKey)) {
            String iscType;
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u65b9\u6848\uff01", (String)"BaseConfigIscSyncPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (int selectRow : selectRows) {
                DynamicObject itemScheme = (DynamicObject)entity.get(selectRow);
                String status = (String)itemScheme.get(SCHEME_STATUS);
                if (!StringUtils.equals((String)status, (String)"0")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u540e\u518d\u8bd5\uff01", (String)"BaseConfigIscSyncPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            int selectedNum = selectRows[0];
            String schemeId = (String)this.getView().getModel().getValue("id", selectedNum);
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)(iscType = (String)this.getView().getModel().getValue("isctype", selectedNum)));
            if (Objects.isNull(scheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u65b9\u6848\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01", (String)"BaseConfigIscSyncPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            if (ISC_DATA_COPY_TRIGGER.equalsIgnoreCase(iscType)) {
                IscSyncHelper.startDataCopyTrigger(this.getView(), scheme);
            } else if (ISC_SERVICE_FLOW.equalsIgnoreCase(iscType)) {
                IscSyncHelper.startFlow(this.getView(), this.getPluginName(), scheme);
            }
            Object id = this.getView().getFormShowParameter().getCustomParams().get("id");
            IscSyncHelper.recordLog(scheme, iscType, "ricc_configitems", id);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (GET_FLOW_PARAMS.equals(action)) {
            IscSyncHelper.parseAndStartFlow(data, this.getView());
        } else if (EXECUTE_FLOW_EVENT.equals(action) && SUCCESS.equals(data)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u6d41\u7a0b\u6267\u884c!", (String)"BaseConfigIscSyncPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            IscSyncHelper.openFlowInstList(null, this.getView());
        }
    }
}

