/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.setting.account;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.exception.RiccBizException;

public abstract class DataCenterFormPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(DataCenterFormPlugin.class);
    public static final String FL_DATA_CENTER = "fl_data_center";

    public abstract String getAccountIdField();

    public abstract String getAccountNameField();

    public abstract String getEnvUrlField();

    public abstract String getDataCenterField();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.getAccountIdField(), "datacenter"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String envUrl = (String)this.getView().getModel().getValue(this.getEnvUrlField());
        this.fillComboListByDc(envUrl);
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (this.getAccountIdField().equals(controlKey)) {
            String url = (String)this.getView().getModel().getValue(this.getEnvUrlField());
            if (StringUtils.isBlank((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u73af\u5883\u7684\u8fde\u63a5\u5730\u5740\u3002", (String)"DataCenterFormPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return;
            }
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u8fde\u63a5\u76ee\u6807\u73af\u5883\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u3002\u3002\u3002", (String)"DataCenterFormPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0])));
            try {
                Map<String, Object> customParams = this.getShowDcListCustParams(url, (String)this.getModel().getValue(this.getAccountIdField()));
                FormShowParameter parameter = ShowParameterUtil.formShowParameter((String)"ricc_dynamic_param", (ShowType)ShowType.Modal, customParams, (String)ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u5217\u8868", (String)"DataCenterFormPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]), null);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accountIdCloseCallBack"));
                this.getView().showForm(parameter);
            }
            catch (RiccBizException e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff1a %s", (String)"DataCenterFormPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)));
                logger.error(CommonUtil.getExceptionDetailInfo((Throwable)e));
            }
            this.getView().hideLoading();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("accountIdCloseCallBack".equals(actionId) && (returnData = evt.getReturnData()) != null) {
            DynamicObject dyo = (DynamicObject)evt.getReturnData();
            this.getModel().setValue(this.getAccountIdField(), dyo.get("accountId"));
            this.getModel().setValue(this.getAccountNameField(), dyo.get("accountName"));
        }
    }

    private Map<String, Object> getShowDcListCustParams(String url, String accountVal) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        ArrayList fieldList = new ArrayList();
        HashMap<String, String> accountKvParam = new HashMap<String, String>(2);
        accountKvParam.put("id", "accountId");
        accountKvParam.put("name", ResManager.loadKDString((String)"\u8d26\u5957ID", (String)"DataCenterFormPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
        fieldList.add(accountKvParam);
        HashMap<String, String> accountNameKvParam = new HashMap<String, String>();
        accountNameKvParam.put("id", "accountName");
        accountNameKvParam.put("name", ResManager.loadKDString((String)"\u8d26\u5957\u540d\u79f0", (String)"DataCenterFormPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
        fieldList.add(accountNameKvParam);
        customParams.put("fields", fieldList);
        List accountList = ApiUtil.getDestDataCenterList((String)url);
        ArrayList fieldValList = new ArrayList(accountList.size());
        for (JSONObject oneCenter : accountList) {
            HashMap<String, String> map = new HashMap<String, String>(accountList.size());
            map.put("accountId", oneCenter.getString("accountId"));
            map.put("accountName", oneCenter.getString("accountName"));
            fieldValList.add(map);
        }
        customParams.put("fieldVals", fieldValList);
        String tips = String.format(ResManager.loadKDString((String)"\u73af\u5883\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f %s", (String)"DataCenterFormPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), url);
        customParams.put("tips", tips);
        customParams.put("selectedval", accountVal);
        customParams.put("selectedfield", "accountId");
        return customParams;
    }

    private void fillComboListByDc(String url) {
        List accountList;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(this.getDataCenterField());
        try {
            accountList = ApiUtil.getDestDataCenterList((String)url);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getLocalizedMessage());
            comboEdit.setComboItems(Collections.EMPTY_LIST);
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(accountList.size());
        for (JSONObject oneCenter : accountList) {
            ComboItem comboItem = new ComboItem();
            String oneAccountId = oneCenter.getString("accountId");
            String oneAccountName = oneCenter.getString("accountName");
            comboItem.setId(oneAccountId);
            comboItem.setValue(oneAccountId);
            comboItem.setCaption(new LocaleString(oneAccountName + "(" + oneAccountId + ")"));
            items.add(comboItem);
            this.getPageCache().put(oneAccountId, oneAccountName);
        }
        String accountId = (String)this.getModel().getValue(this.getAccountIdField());
        this.getPageCache().put(FL_DATA_CENTER, "1");
        this.getView().getModel().setValue(this.getDataCenterField(), (Object)accountId);
        comboEdit.setComboItems(items);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean newControlled;
        String fieldKey = e.getProperty().getName();
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        String newValue = newValueObj.toString();
        if (this.getEnvUrlField().equals(fieldKey)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d\u6570\u636e\u4e2d\u5fc3\uff0c\u8bf7\u7a0d\u540e\u3002\u3002\u3002", (String)"DataCenterFormPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0])));
            this.fillComboListByDc(newValue);
            this.getView().hideLoading();
        }
        if (this.getDataCenterField().equals(fieldKey)) {
            this.getView().getModel().setValue(this.getAccountIdField(), (Object)newValue);
            String flDataCenter = this.getPageCache().get(FL_DATA_CENTER);
            if (!"1".equals(flDataCenter)) {
                this.getView().getModel().setValue(this.getAccountNameField(), (Object)this.getPageCache().get(newValue));
            } else {
                this.getPageCache().put(FL_DATA_CENTER, "0");
            }
        }
        if ("controlled".equals(fieldKey) && !(newControlled = ((Boolean)newValueObj).booleanValue())) {
            this.getModel().setValue("authorizeduser", null);
        }
    }
}

