/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.task;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.common.enums.TransferStatusEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.TransferUtil;

public class TransferTaskEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TRANSFERSTATUS = "transferstatus";
    private static final String DATAPACKET = "datapacket";
    private static final String TASK_ENTRY = "datapackettrans";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mEdit = (BasedataEdit)this.getView().getControl(DATAPACKET);
        mEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferUtil.setDefaultCenterAndUser((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("targetdatacenter".equals(key)) {
            this.getModel().deleteEntryData(TASK_ENTRY);
            this.getModel().createNewEntryRow(TASK_ENTRY);
            this.getView().updateView();
            DynamicObject newCenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
            long newCenterId = newCenter.getLong("id");
            this.getModel().setValue("targetdatacenteruser", (Object)CommonQuery.getTransferLatestUserPhone((long)newCenterId));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject targetdatacenter = (DynamicObject)this.getModel().getValue("targetdatacenter");
        if (targetdatacenter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6570\u636e\u4e2d\u5fc3", (String)"TransferTaskEditPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("targetdatacenter", "=", targetdatacenter.getPkValue());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"ricc_transfertask", (String)"id, datapackettrans.transferstatus, datapackettrans.datapacket", (QFilter[])filter.toArray());
        HashSet<Long> pkgids = new HashSet<Long>();
        for (DynamicObject task : tasks) {
            DynamicObjectCollection entrys = task.getDynamicObjectCollection(TASK_ENTRY);
            if (entrys == null || entrys.isEmpty()) continue;
            entrys.forEach(entry -> {
                if (TransferStatusEnum.SUCCESS.getVal().equals(entry.get(TRANSFERSTATUS))) {
                    pkgids.add((Long)entry.getDynamicObject(DATAPACKET).getPkValue());
                }
            });
        }
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        List selectFields = showParameter.getListFilterParameter().getSelectFields();
        selectFields.add("number");
        selectFields.add("name");
        selectFields.add("allowchange");
        selectFields.add("createtime");
        DynamicObject currTask = this.getModel().getDataEntity(true);
        DynamicObjectCollection col = currTask.getDynamicObjectCollection(TASK_ENTRY);
        for (DynamicObject row : col) {
            DynamicObject pkg = row.getDynamicObject(DATAPACKET);
            if (pkg == null) continue;
            pkgids.add(pkg.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "not in", pkgids);
        showParameter.setShowApproved(false);
        qFilter.and(new QFilter("subpacketcount", ">", (Object)0));
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.getListFilterParameter().setOrderBy("createtime desc");
    }
}

