/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.task;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.schedule.TaskSerailHelper;
import kd.sys.ricc.common.enums.ConfigControlItems;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class TransferTaskListPlugin
extends AbstractListPlugin {
    private static final String ACTION_TRANSFER = "transfer";
    private static final String OP_VIEWLOGS = "viewlogs";
    private static final String OP_TRANSFER_ONLINE = "transferonline";
    private static final String TRANSFER_STATUS = "transferstatus";
    private static final String OP_TRANSFERANDSYN = "transferandsyn";
    public static final String TIP_IS_SHOW = "tipIsShow";

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        String dataPacketNumber = (String)this.getView().getFormShowParameter().getCustomParam("dataPacketNumber");
        if (!StringUtils.isEmpty((String)dataPacketNumber)) {
            long creator = UserServiceHelper.getCurrentUserId();
            QFilter creatorFilter = new QFilter("creator.id", "=", (Object)creator);
            QFilter numberFilter = new QFilter("datapackettrans.datapacket.number", "=", (Object)dataPacketNumber);
            int filteredTransferTaskCount = ORM.create().count("transfertaskcount", "ricc_transfertask", new QFilter[]{creatorFilter, numberFilter});
            int allTransferTaskCount = (Integer)this.getView().getFormShowParameter().getCustomParam("count");
            String tipIsShow = this.getPageCache().get(TIP_IS_SHOW);
            if (filteredTransferTaskCount < allTransferTaskCount && StringUtils.isEmpty((String)tipIsShow)) {
                this.getPageCache().put(TIP_IS_SHOW, "1");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6309\u7167\u5f53\u524d\u7528\u6237\u6743\u9650\u8fc7\u6ee4\u51fa\u6240\u6709\u4f20\u8f93\u4efb\u52a1\u3002", (String)"TransferTaskListPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dataPacketNumber = (String)formShowParameter.getCustomParam("dataPacketNumber");
        if (!StringUtils.isEmpty((String)dataPacketNumber)) {
            FilterColumn filter = args.getFilterColumn("datapacket.number");
            filter.setDefaultValue(dataPacketNumber);
            FilterColumn dataFilter = args.getFilterColumn("createtime");
            dataFilter.setDefaultValue(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && StringUtils.equals((String)(opKey = (operate = (AbstractOperate)args.getSource()).getOperateKey()), (String)OP_TRANSFERANDSYN)) {
            ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
            for (DynamicObject task : this.getSelectedTransferTasks(listSelectedRows)) {
                DynamicObject tarAccount = task.getDynamicObject("targetdatacenter");
                String destEnvType = tarAccount.getString("evntype");
                EnvRoleEnum tarEnvRole = EnvRoleEnum.fromVal((String)destEnvType);
                if (tarEnvRole == null) {
                    String msgtpl = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u4f20\u8f93\u4efb\u52a1\u3010%s\u3011\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7684\u73af\u5883\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"TransferTaskListPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    String taskNo = task.getString("billno");
                    this.getView().showMessage(String.format(msgtpl, taskNo));
                    args.setCancel(true);
                    return;
                }
                String evnTypeName = tarEnvRole.getName();
                boolean canRemoteSyn = SysParaUtil.hasPermInEnvType((String)destEnvType, (String)ConfigControlItems.CAN_REMOTE_SYNC.getValue());
                if (canRemoteSyn) continue;
                String msgTpl = ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u3010%1$s\u3011\u73af\u5883\u7c7b\u578b\u4e3a\u3010%2$s\u3011\uff0c\u4e0d\u80fd\u76f4\u63a5\u4f20\u8f93\u5e76\u540c\u6b65\uff0c\u8bf7\u4f7f\u7528\u5728\u7ebf\u4f20\u8f93\u540e\u5728\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4e2d\u540c\u6b65\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferTaskListPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(msgTpl, tarAccount.getString("name"), evnTypeName));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isTransferOp;
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        boolean bl = isTransferOp = StringUtils.equals((String)opKey, (String)OP_TRANSFER_ONLINE) || StringUtils.equals((String)opKey, (String)OP_TRANSFERANDSYN);
        if (isTransferOp && args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
            DynamicObject[] selectedTransferTasks = this.getSelectedTransferTasks(listSelectedRows);
            HashSet<String> taskKeySet = new HashSet<String>(listSelectedRows.size());
            for (DynamicObject selectedTransferTask : selectedTransferTasks) {
                String taskNo = selectedTransferTask.getString("billno");
                String taskKey = ACTION_TRANSFER + taskNo;
                if (TaskSerailHelper.taskExist(taskKey)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u4efb\u52a1<%s>\u5df2\u7ecf\u5728\u6267\u884c\u4f20\u8f93\u4e86\uff0c\u8bf7\u68c0\u67e5\u540e\u53f0\u4efb\u52a1\u67e5\u770b\u8be6\u60c5\u6216\u7b49\u5f85\u4efb\u52a1\u7ed3\u675f", (String)"TransferTaskListPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]), taskNo));
                    return;
                }
                String targetUser = selectedTransferTask.getString("targetdatacenteruser");
                if (StringUtils.isEmpty((String)targetUser)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u4efb\u52a1<%s>\u4f20\u8f93\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u6ca1\u6709\u586b\u5199\u3002", (String)"TransferTaskListPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]), taskNo));
                    return;
                }
                DynamicObject targetCenter = selectedTransferTask.getDynamicObject("targetdatacenter");
                String targetCenterEnable = targetCenter.getString("enable");
                String targetCenterName = targetCenter.getString("name");
                if ("0".equals(targetCenterEnable)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u4efb\u52a1<%1$s>\u4f20\u8f93\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3<%2$s>\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f20\u8f93\u3002", (String)"TransferTaskListPlugin_5", (String)"sys-ricc-platform", (Object[])new Object[0]), taskNo, targetCenterName));
                    return;
                }
                DynamicObjectCollection taskPkgs = selectedTransferTask.getDynamicObjectCollection("datapackettrans");
                for (DynamicObject entry : taskPkgs) {
                    DynamicObject pkg = entry.getDynamicObject("datapacket");
                    String pkgName = pkg.getString("name");
                    String pkgEnable = pkg.getString("enable");
                    if (!"0".equals(pkgEnable)) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u4efb\u52a1<%1$s>\u4f20\u8f93\u7684\u4f20\u8f93\u5305<%2$s>\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f20\u8f93\u3002", (String)"TransferTaskListPlugin_6", (String)"sys-ricc-platform", (Object[])new Object[0]), taskNo, pkgName));
                    return;
                }
                taskKeySet.add(taskKey);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ricc_transferprogress");
            formShowParameter.setCustomParam("selectRows", (Object)listSelectedRows.serialize());
            String transferType = StringUtils.equals((String)opKey, (String)OP_TRANSFER_ONLINE) ? ACTION_TRANSFER : OP_TRANSFERANDSYN;
            formShowParameter.setCustomParam("transfertype", (Object)transferType);
            formShowParameter.setCustomParam("ricconcekey", taskKeySet);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_TRANSFER));
            this.getView().showForm(formShowParameter);
        }
        if (StringUtils.equals((String)opKey, (String)OP_VIEWLOGS)) {
            this.viewLogs();
        }
    }

    private DynamicObject[] getSelectedTransferTasks(ListSelectedRowCollection listSelectedRows) {
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        MainEntityType transferTaskType = EntityMetadataCache.getDataEntityType((String)"ricc_transfertask");
        return BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)transferTaskType);
    }

    private void viewLogs() {
        DynamicObject[] selectedTransferTasks;
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u52fe\u9009\u591a\u6761\u4f20\u8f93\u4efb\u52a1\u8fdb\u884c\u65e5\u5fd7\u67e5\u770b\uff01", (String)"TransferTaskListPlugin_7", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject selectedTransferTask : selectedTransferTasks = this.getSelectedTransferTasks(listSelectedRows)) {
            String taskNo = selectedTransferTask.getString("billno");
            if (this.isTransferred(selectedTransferTask)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u4efb\u52a1 %s \u8fd8\u672a\u6267\u884c\u5728\u7ebf\u4f20\u8f93\uff0c\u6ca1\u6709\u4f20\u8f93\u65e5\u5fd7", (String)"TransferTaskListPlugin_8", (String)"sys-ricc-platform", (Object[])new Object[0]), taskNo));
            return;
        }
        String billNo = listSelectedRows.get(0).getBillNo();
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        ShowParameterUtil.showLogs((IFormView)this.getView(), (QFilter)filter, (ShowType)ShowType.Modal);
    }

    private boolean isTransferred(DynamicObject task) {
        String billStatus = task.getString("billstatus");
        if (StringUtils.equals((String)billStatus, (String)"C")) {
            return true;
        }
        DynamicObjectCollection entrys = task.getDynamicObjectCollection("datapackettrans");
        if (entrys != null && !entrys.isEmpty()) {
            DynamicObject entry = (DynamicObject)entrys.get(0);
            String entryStatus = entry.getString(TRANSFER_STATUS);
            return !StringUtils.isEmpty((String)entryStatus);
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((String)actionId, (String)ACTION_TRANSFER)) {
            AbstractListView view = (AbstractListView)this.getView();
            view.setNeedRefreshTree(false);
            view.refresh();
        }
    }
}

