/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.transmanage.task;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.business.transfer.PacketFastTransferTask;
import kd.sys.ricc.business.transfer.TransferTaskClick;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.formplugin.AbstractProgressFormPlugin;

public class TransferTaskProgressPlugin
extends AbstractProgressFormPlugin
implements ProgresssListener {
    private static final String TRANSFER_TYPE = "transferType";
    public static final String CUSTPARAM_SELECTROWS = "selectRows";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETESDP = "completesdp";
    private static final String KEY_FAILPACKET = "failPacketCount";
    private static final String KEY_CURRENTROW = "currentrow";
    private static final String LABEL_SUCCESS = "success";
    private static final String LABEL_FAILED = "failed";
    private static final String LABEL_SUCCESSALL = "successall";
    private static final String LABEL_SUCCESSSUBALL = "successsuball";
    private static final String PANEL_SUCCESSS = "successpanel";
    private static final String PANEL_SYNC = "syncpanel";
    private static final String PANEL_FALI = "failedpanel";

    @Override
    public JobFormInfo buildJobFormInfo() {
        if (!this.checkCustParams()) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(this.getView().getFormShowParameter().getCustomParams());
        return ScheduleUtil.buildJobFormInfo(ResManager.loadKDString((String)"\u4f20\u8f93\u4f20\u8f93\u5305", (String)"TransferTaskProgressPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), PacketFastTransferTask.class.getName(), TransferTaskClick.class.getName(), this.getView(), params);
    }

    @Override
    public void showDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        Object totalVal = data.get(KEY_TOTAL);
        int totalCount = totalVal != null ? Integer.parseInt(totalVal.toString()) : 0;
        Object completesdpVal = data.get(KEY_COMPLETESDP);
        int completeSdpCount = completesdpVal != null ? Integer.parseInt(completesdpVal.toString()) : 0;
        Object titleVal = data.get(KEY_TITLE);
        String title = titleVal != null ? (String)titleVal : "";
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(String.valueOf(totalCount));
        Label completesdpLabel = (Label)this.getControl(KEY_COMPLETESDP);
        completesdpLabel.setText(String.valueOf(completeSdpCount));
        Label currentrowLabel = (Label)this.getControl(KEY_CURRENTROW);
        int completeSdpCounts = completeSdpCount + 1;
        if (completeSdpCounts > totalCount) {
            completeSdpCounts = totalCount;
        }
        currentrowLabel.setText(String.valueOf(completeSdpCounts));
        Label titleLabel = (Label)this.getControl(KEY_TITLE);
        titleLabel.setText(title);
    }

    @Override
    public void showComplete(TaskInfo taskInfo, ProgressEvent e) {
        HashMap<String, Integer> notHidden;
        int failPacketCount;
        Map<String, Object> taskData = ScheduleUtil.getTaskCustData(taskInfo);
        Object totalVal = taskData.get(KEY_TOTAL);
        int totalCount = totalVal != null ? Integer.parseInt(totalVal.toString()) : 0;
        String failPacketCountVal = (String)taskData.get(KEY_FAILPACKET);
        int n = failPacketCount = failPacketCountVal != null ? Integer.parseInt(failPacketCountVal) : 0;
        if (failPacketCount > 0) {
            Label success = (Label)this.getControl(LABEL_SUCCESS);
            success.setText("" + (totalCount - failPacketCount));
            Label fail = (Label)this.getControl(LABEL_FAILED);
            fail.setText("" + failPacketCount);
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_FALI});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_SYNC, PANEL_SUCCESSS});
            notHidden = new HashMap(1);
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(PANEL_FALI, notHidden);
        } else {
            Label success = (Label)this.getControl(LABEL_SUCCESSALL);
            success.setText("" + totalCount);
            Label successsuball = (Label)this.getControl(LABEL_SUCCESSSUBALL);
            successsuball.setText("" + totalCount);
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_SUCCESSS});
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_SYNC, PANEL_FALI});
            notHidden = new HashMap<String, Integer>(1);
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(PANEL_SUCCESSS, notHidden);
        }
        Object dataFailVal = taskData.get("fail");
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (CommonUtil.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"TransferTaskProgressPlugin_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
            return;
        }
        if (dataFailVal != null) {
            boolean fail = (Boolean)dataFailVal;
            String failmessage = (String)taskData.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.getView().showErrorNotification(failmessage);
                this.stopBar();
                return;
            }
        }
        String newName = ResManager.loadKDString((String)"\u5173\u95ed", (String)"TransferTaskProgressPlugin_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.modifyControlName("btncancel", newName);
        e.setProgress(100);
        this.stopBar();
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnresult"});
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btnresult".equals(controlKey)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)this.getTaskId())};
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"ricc_log", (String)"id,packet,optype", (QFilter[])qFilters);
            if (logs.size() == 1) {
                DynamicObject log = (DynamicObject)logs.get(0);
                ShowParameterUtil.showLog((Object)log.get("id"), (IFormView)this.getView(), (ShowType)ShowType.Modal, (String)log.getString("optype"));
                return;
            }
            QFilter qFilter = new QFilter("taskid", "=", (Object)this.getTaskId());
            ShowParameterUtil.showLogs((IFormView)this.getView(), (QFilter)qFilter, (ShowType)ShowType.Modal);
        }
    }

    public boolean checkCustParams() {
        ListSelectedRowCollection selectRows = this.getSelectRows();
        if (selectRows.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u6570\u636e\u3002", (String)"TransferTaskProgressPlugin_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public ListSelectedRowCollection getSelectRows() {
        return ListSelectedRowCollection.deSerialize((String)this.getSelectRowsStr());
    }

    public String getSelectRowsStr() {
        String selectedRowStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_SELECTROWS);
        if (StringUtils.isEmpty((CharSequence)selectedRowStr)) {
            return "[]";
        }
        return selectedRowStr;
    }
}

