/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.dataref.BaseDataCheckRefrenceBusiness;
import kd.sys.ricc.business.dataref.IDataRefQueryBusiness;
import kd.sys.ricc.common.enums.DataRefSpecailTypeEnum;
import kd.sys.ricc.common.util.StringUtils;
import org.apache.commons.beanutils.ConvertUtils;

public class DataReferenceRptQuery
extends AbstractReportListDataPlugin {
    private static final String ENTITY_DEPENDENCY = "2";
    private static String[] FIELDS = new String[]{"id", "referencednumber", "referencedname", "datatype", "referenceid", "referencenumber", "referencename"};
    private static String[] DEPENDENCY_FIELDS = new String[]{"basetype", "dependency"};
    private static DataType[] DEPENDENCY_TYPES = new DataType[]{DataType.StringType, DataType.StringType};
    private static DataType[] DATA_TYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        String queryType = this.getQueryParam().getFilter().getString("querytype");
        Collection<Object> rows = new ArrayList();
        RowMeta rowMeta = new RowMeta(new Field[0]);
        if (StringUtils.equals((String)ENTITY_DEPENDENCY, (String)queryType)) {
            rows = this.buildDependencyCollection(reportQueryParam);
            rowMeta = RowMetaFactory.createRowMeta((String[])DEPENDENCY_FIELDS, (DataType[])DEPENDENCY_TYPES);
        } else {
            rows = this.buildCollection(reportQueryParam);
            rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATA_TYPES);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, rows);
        DataSet dataSetCount = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        return dataSetCount;
    }

    private Collection<Object[]> buildCollection(ReportQueryParam reportQueryParam) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        if (filterInfo != null) {
            String referencedDataId = (String)filterInfo.getValue("referenceddataid");
            DynamicObject baseDataType = (DynamicObject)filterInfo.getValue("basedatatype");
            boolean isLongPk = DataReferenceRptQuery.isLongPk(baseDataType.getString("number"));
            Object[] ids = isLongPk ? (Long[])ConvertUtils.convert((String[])referencedDataId.split(";"), Long.class) : referencedDataId.split(";");
            Map objectMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)baseDataType.getString("number"));
            BaseDataCheckRefrence checkRefrence = new BaseDataCheckRefrence();
            BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataType.getString("number"));
            Map refrenceResultMap = checkRefrence.checkRef(dataEntityType, ids);
            for (Map.Entry entry : refrenceResultMap.entrySet()) {
                IDataEntityProperty property;
                String nameKey;
                String numberKey;
                BaseDataRefenceKey refenceKey = ((BaseDataCheckRefrenceResult)entry.getValue()).getRefenceKey();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)refenceKey.getRefEntityKey());
                String key = this.generateKey(refenceKey.getRefEntityKey(), refenceKey.getRefCol());
                String selectKey = null;
                String idKey = entityType.getPrimaryKey().getName();
                if (entityType instanceof BillEntityType) {
                    numberKey = ((BillEntityType)entityType).getBillNo();
                    nameKey = ((BillEntityType)entityType).getBillNo();
                    selectKey = entityType.getPrimaryKey().getName() + "," + numberKey;
                    property = entityType.findProperty(numberKey);
                    if (StringUtils.isBlank((CharSequence)numberKey) || property == null || StringUtils.isBlank((CharSequence)property.getAlias())) {
                        numberKey = entityType.getPrimaryKey().getName();
                        nameKey = entityType.getPrimaryKey().getName();
                        selectKey = entityType.getPrimaryKey().getName();
                    }
                } else if (entityType instanceof BasedataEntityType) {
                    numberKey = ((BasedataEntityType)entityType).getNumberProperty();
                    nameKey = ((BasedataEntityType)entityType).getNameProperty();
                    property = entityType.findProperty(numberKey);
                    if (StringUtils.isBlank((CharSequence)numberKey) || property == null || StringUtils.isBlank((CharSequence)property.getAlias())) {
                        numberKey = entityType.getPrimaryKey().getName();
                    }
                    IDataEntityProperty nameProperty = entityType.findProperty(nameKey);
                    if (StringUtils.isBlank((CharSequence)nameKey) || nameProperty == null || StringUtils.isBlank((CharSequence)nameProperty.getAlias())) {
                        nameKey = entityType.getPrimaryKey().getName();
                    }
                    selectKey = !StringUtils.equals((String)numberKey, (String)nameKey) ? entityType.getPrimaryKey().getName() + "," + numberKey + "," + nameKey : entityType.getPrimaryKey().getName();
                } else {
                    nameKey = null;
                    numberKey = null;
                }
                if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank(selectKey) || !StringUtils.isNotBlank((CharSequence)nameKey) || !StringUtils.isNotBlank((CharSequence)numberKey)) continue;
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)refenceKey.getRefEntityKey(), (String)selectKey, (QFilter[])new QFilter[]{new QFilter(key, "=", entry.getKey())});
                String finalNumberKey = numberKey;
                String finalNameKey = nameKey;
                Arrays.stream(objs).forEach(o -> rows.add(new Object[]{entry.getKey(), ((DynamicObject)objectMap.get(entry.getKey())).getString(dataEntityType.getNumberProperty()), ((DynamicObject)objectMap.get(entry.getKey())).getString(dataEntityType.getNameProperty()), refenceKey.getRefEntityKey(), o.getString(idKey), o.getString(finalNumberKey), o.getString(finalNameKey)}));
            }
            DataReferenceRptQuery.buildSpecialCollection(baseDataType.getString("number"), referencedDataId.split(";"), objectMap, rows, filterInfo.getString("specialtype"));
        }
        return rows;
    }

    private Collection<Object[]> buildDependencyCollection(ReportQueryParam reportQueryParam) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        if (filterInfo != null) {
            DynamicObject baseDataType = (DynamicObject)filterInfo.getValue("basedatatype");
            BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataType.getString("number"));
            List<Object> baseDataRefenceKeys = BaseDataCheckRefrenceBusiness.getAllRefKeys(dataEntityType);
            baseDataRefenceKeys = baseDataRefenceKeys.stream().collect(Collectors.toMap(BaseDataRefenceKey::getRefEntityKey, r -> r, (r1, r2) -> r1)).values().stream().collect(Collectors.toList());
            for (BaseDataRefenceKey baseDataRefenceKey : baseDataRefenceKeys) {
                rows.add(new Object[]{baseDataRefenceKey.getBaseEntityKey(), baseDataRefenceKey.getRefEntityKey()});
            }
        }
        return rows;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        String queryType = this.getQueryParam().getFilter().getString("querytype");
        for (AbstractReportColumn reportColumn : columns) {
            ReportColumnGroup columnGroup = (ReportColumnGroup)reportColumn;
            List children = columnGroup.getChildren();
            for (AbstractReportColumn column : children) {
                if (StringUtils.equals((String)ENTITY_DEPENDENCY, (String)queryType)) {
                    if (!Arrays.asList(FIELDS).contains(((ReportColumn)column).getFieldKey())) continue;
                    ((ReportColumn)column).setHide(true);
                    continue;
                }
                if (!Arrays.asList(DEPENDENCY_FIELDS).contains(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(true);
            }
        }
        return columns;
    }

    private static boolean isLongPk(String entityName) {
        ISimpleProperty prop = MetadataServiceHelper.getDataEntityType((String)entityName).getPrimaryKey();
        return prop instanceof LongProp;
    }

    private String generateKey(String mainEntity, String refAlias) {
        IDataEntityType itemType;
        DataEntityPropertyCollection entryProperties;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        Optional<IDataEntityProperty> first = mainEntityType.getProperties().stream().filter(o -> StringUtils.equals((String)o.getAlias(), (String)refAlias)).findFirst();
        if (first.isPresent()) {
            return first.get().getName();
        }
        boolean isExsist = false;
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (!(property instanceof EntryProp) || !(first = (entryProperties = (itemType = ((EntryProp)property).getItemType()).getProperties()).stream().filter(s -> StringUtils.equals((String)s.getAlias(), (String)refAlias)).findFirst()).isPresent()) continue;
            isExsist = true;
            break;
        }
        if (isExsist) {
            return first.get().getParent().getName() + "." + first.get().getName();
        }
        block1: for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (!(property instanceof EntryProp)) continue;
            itemType = ((EntryProp)property).getItemType();
            entryProperties = itemType.getProperties();
            for (IDataEntityProperty entryProperty : entryProperties) {
                IDataEntityType type;
                DataEntityPropertyCollection subEntryProperties;
                if (!(entryProperty instanceof SubEntryProp) || !(first = (subEntryProperties = (type = ((SubEntryProp)entryProperty).getItemType()).getProperties()).stream().filter(s -> StringUtils.equals((String)s.getAlias(), (String)refAlias)).findFirst()).isPresent()) continue;
                isExsist = true;
                continue block1;
            }
        }
        if (isExsist) {
            return first.get().getParent().getParent().getName() + first.get().getParent().getName() + "." + first.get().getName();
        }
        return null;
    }

    private static void buildSpecialCollection(String baseDataType, String[] baseDataIds, Map<Object, DynamicObject> objectMap, Collection<Object[]> rows, String specialType) {
        if (StringUtils.isNotBlank((CharSequence)specialType)) {
            String[] specialTypes;
            for (String type : specialTypes = specialType.split(",")) {
                Collection<Object[]> objects;
                IDataRefQueryBusiness service;
                if (StringUtils.isBlank((CharSequence)type) || (service = DataRefSpecailTypeEnum.getServiceByType(type)) == null || !CollectionUtils.isNotEmpty(objects = service.obtainDataRef(baseDataType, baseDataIds, objectMap))) continue;
                rows.addAll(objects);
            }
        }
    }
}

