/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonSupportSubEntityImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class BillTypeImpl
extends JsonSupportSubEntityImpl {
    private static final Log logger = LogFactory.getLog(BillTypeImpl.class);

    protected void beforeImportPacket(SdpInputParams sdpInputParams, SdpOutputParams sdpOutputParams) {
        super.beforeImportPacket(sdpInputParams, sdpOutputParams);
        Map param = sdpInputParams.getParam();
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        String formId = guideInfo.getString("page.number");
        String entityName = guideInfo.getString("name");
        String appId = guideInfo.getString("page.bizappid");
        boolean hasPermission = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, formId, entityName, sdpOutputParams, "47156aff000000ac", "4715a0df000000ac");
        sdpOutputParams.setSuccess(hasPermission);
    }

    protected List<JsonSupportSubEntityImpl.EntityMappingInfo> getSubEntityList() {
        ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo> entityMappingInfoList = new ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo>();
        JsonSupportSubEntityImpl.EntityMappingInfo billTypeParameter = new JsonSupportSubEntityImpl.EntityMappingInfo("billTypeParameter", null, null);
        entityMappingInfoList.add(billTypeParameter);
        return entityMappingInfoList;
    }

    protected Map<String, Map<String, Object>> getBatchSubContentMap(DynamicObject[] batchData, Map<String, Object> batchContentMap, JsonSupportSubEntityImpl.EntityMappingInfo entityMappingInfo) {
        String formId = null;
        String billTypeNumber = null;
        long billTypeId = 0L;
        HashMap<String, Map<String, Object>> mainIdAndSubContentMap = new HashMap<String, Map<String, Object>>(16);
        String errMessage = "";
        try {
            for (DynamicObject billType : batchData) {
                DynamicObject billTypeParam;
                formId = billType.getString("billformid.id");
                billTypeNumber = billType.getString("number");
                billTypeId = billType.getLong("id");
                if (formId == null) {
                    errMessage = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u53c2\u6570\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5355\u636e\u7c7b\u578b\u5bf9\u5e94\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u3002\u5355\u636e\u7c7b\u578bid\uff1a%1$s\uff0c\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a%2$s", (String)"BillTypeImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]), billTypeId, billTypeNumber);
                    break;
                }
                BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
                String billTypePara = dt.getBillTypePara();
                if (!StringUtils.isNotBlank((CharSequence)billTypePara) || (billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)billTypePara, (long)billTypeId)) == null) continue;
                String jsonData = this.serializeToJsonData(billTypeParam);
                HashMap jsonMap = new HashMap(1);
                HashMap<String, String> dataMap = new HashMap<String, String>(1);
                dataMap.put(formId, jsonData);
                jsonMap.put(String.valueOf(billTypeId), dataMap);
                mainIdAndSubContentMap.put(String.valueOf(billTypeId), jsonMap);
            }
        }
        catch (Exception e) {
            errMessage = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u53c2\u6570\u5931\u8d25\uff1a\u8868\u5355\u6807\u8bc6\uff1a%1$s\uff0c\u5355\u636e\u7c7b\u578bid\uff1a%2$s\uff0c\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a%3$s\uff0c\u62a5\u9519\u539f\u56e0:%4$s", (String)"BillTypeImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), formId, billTypeId, billTypeNumber, e.getMessage());
            logger.error(errMessage, (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)errMessage)) {
            throw new RiccBizException(errMessage);
        }
        return mainIdAndSubContentMap;
    }

    protected int batchImportSave(String entityNumber, List<Object> mainIdList, Map<String, Object> subDataEntityMap, SdpOutputParams outputParams, String keyFields, JsonDataPacketImpl.BatchSaveType saveType) {
        int successCount = 0;
        Set<Map.Entry<String, Object>> subDataEntries = subDataEntityMap.entrySet();
        for (Map.Entry<String, Object> dataEntry : subDataEntries) {
            long billTypeId = Long.parseLong(dataEntry.getKey());
            Map jsonDataMap = (Map)dataEntry.getValue();
            Set jsonDataEntries = jsonDataMap.entrySet();
            for (Map.Entry jsonDataEntry : jsonDataEntries) {
                String formId = (String)jsonDataEntry.getKey();
                String jsonData = (String)jsonDataEntry.getValue();
                ParameterWriter.saveBillTypeParameter((String)formId, (long)billTypeId, (String)jsonData);
                ++successCount;
            }
        }
        return successCount;
    }

    private String serializeToJsonData(DynamicObject param) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(param.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jSer = new DcJsonSerializer((DcBinder)binder);
        return jSer.serializeToString((Object)param, null);
    }

    public Map<String, Object> provideData(Map<String, Object> params) {
        return null;
    }
}

