/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.adaptor.CodeRuleSigner;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonSupportSubEntityImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;

public class CodeRuleImpl
extends JsonSupportSubEntityImpl {
    private static final String CODE_RULE_TYPE_SEQ = "16";
    private static final String CHECKRIGHT_APPID = "18XR3MJ0W0ET";

    protected List<JsonSupportSubEntityImpl.EntityMappingInfo> getSubEntityList() {
        ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo> entityMappingInfoList = new ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo>();
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo("bos_coderuleappcondpro", "property_id", "id"));
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo("bos_crappcondprovalue", "propertyvalue_id", "id"));
        return entityMappingInfoList;
    }

    protected void beforeImportPacket(SdpInputParams sdpInputParams, SdpOutputParams sdpOutputParams) {
        super.beforeImportPacket(sdpInputParams, sdpOutputParams);
        Map param = sdpInputParams.getParam();
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        String formId = guideInfo.getString("page.number");
        String entityName = guideInfo.getString("name");
        boolean hasPermission = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), CHECKRIGHT_APPID, formId, entityName, sdpOutputParams, "47156aff000000ac", "4715a0df000000ac");
        sdpOutputParams.setSuccess(hasPermission);
    }

    protected void afterBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
        DynamicObject[] codeRules;
        for (DynamicObject codeRule : codeRules = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_coderule"))) {
            DynamicObjectCollection ruleEntry = codeRule.getDynamicObjectCollection("ruleentry");
            String id = codeRule.getString("id");
            int databaseStep = 0;
            for (DynamicObject ruleEntryObj : ruleEntry) {
                String attributeType = ruleEntryObj.getString("attributetype");
                if (!attributeType.equals(CODE_RULE_TYPE_SEQ)) continue;
                databaseStep = ruleEntryObj.getInt("step");
            }
            JSONObject codeRuleObj = dataMap.getJSONObject(id);
            JSONObject codeRuleData = codeRuleObj.getJSONObject("data");
            JSONArray ruleEntryArr = codeRuleData.getJSONArray("ruleentry");
            int newStep = 0;
            for (int i = 0; i < ruleEntryArr.size(); ++i) {
                JSONObject ruleEntryObj = ruleEntryArr.getJSONObject(i);
                String attributeType = ruleEntryObj.getString("attributetype");
                if (!attributeType.equals(CODE_RULE_TYPE_SEQ)) continue;
                newStep = ruleEntryObj.getIntValue("step");
            }
            if (databaseStep <= 0 || databaseStep != newStep) continue;
            this.updateStepForSortItems(id, databaseStep);
        }
    }

    protected JsonDataPacketImpl.BatchSaveType getBatchSaveType() {
        return JsonDataPacketImpl.BatchSaveType.SAVE;
    }

    private void updateStepForSortItems(String codeRuleId, Integer newStep) {
        DynamicObject[] codeRuleMaxSerial;
        QFilter qf = new QFilter("coderuleid", "=", (Object)codeRuleId);
        for (DynamicObject maxSerial : codeRuleMaxSerial = BusinessDataServiceHelper.load((String)"bos_coderule_maxserial", (String)"sortitemvalue", (QFilter[])new QFilter[]{qf})) {
            String sortItemValue = maxSerial.getString("sortitemvalue");
            CodeRuleSigner codeRuleSigner = CodeRuleSignerFactory.newInstance();
            codeRuleSigner.updateStep(codeRuleId, sortItemValue, newStep.intValue());
        }
    }

    public Map<String, Object> provideData(Map<String, Object> params) {
        return null;
    }
}

