/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.business.TaxcOrgBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxcCombineBusiness {
    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayer(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayer();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayer(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayerByTaxationsysId(taxationsysId);
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(Long userId, List<Long> orgIds) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(orgIds);
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcOrgIdsWithPerm(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcOrgIdsWithPerm(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds(taxationsysId);
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcOrgIdsByIsTaxpayerWithPerm(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcOrgIdByIsTaxpayer();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayerAndFs(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayerAndFs();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayer(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayer();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayer(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayerByTaxationsysId(taxationsysId);
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByOrgIdsAndIsTaxpayer(Long userId, String appId, String entityNum, String permItemId, List<Long> orgIds) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(orgIds);
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysIdWithIsTaxpayer(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysIdWithIsTaxpayer(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysIdWithIsTaxpayer(Long userId, Long taxationsysId, boolean isIncludeTaxationsys) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId, isIncludeTaxationsys);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysIdWithIsTaxpayer(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId, boolean isIncludeTaxationsys) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId, isIncludeTaxationsys);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysId(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysId(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByTaxationsysId(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysId(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> loadTaxcMainOrgIdByIsTaxpayerAndFs(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdByIsTaxpayerAndFs();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdsWithPerm(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdsByIsTaxpayerWithPerm(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxOrgIds = TaxcCombineBusiness.loadTaxcOrgIdByIsTaxpayer();
            userHasPermOrgs.retainAll(taxOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryOrgIdByViewWithPerm(Long userId, String viewNumber) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId, viewNumber);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List viewOrgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)viewNumber, (boolean)false);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
                return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryOrgIdByViewWithPerm(Long userId, String viewNumber, boolean isIncludeDisable) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId, viewNumber);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List viewOrgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)viewNumber, (boolean)isIncludeDisable);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
                return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryOrgIdByViewWithPerm(Long userId, String appId, String entityNum, String permItemId, String viewNumber) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        TaxResult result = new TaxResult();
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List viewOrgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)viewNumber, (boolean)false);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
                return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), result.getData()));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByIsTaxpayerForHwsWithPerm(Long userId, Long taxationsysId, Long categoryId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> viewOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByIsTaxpayerForHws(taxationsysId, categoryId);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
                return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByIsTaxpayerForHwsWithPerm(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId, Long categoryId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> viewOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByIsTaxpayerForHws(taxationsysId, categoryId);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
                return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainCategoryByIsTaxpayerForHwsWithPerm(Long userId, Long taxationsysId, Long categoryId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> viewOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByIsTaxpayerForHws(taxationsysId, categoryId);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                return TaxcCombineBusiness.loadTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(userHasPermOrgs, taxationsysId, categoryId);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainCategoryByIsTaxpayerForHwsWithPerm(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId, Long categoryId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> viewOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByIsTaxpayerForHws(taxationsysId, categoryId);
            userHasPermOrgs.retainAll(viewOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                return TaxcCombineBusiness.loadTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(userHasPermOrgs, taxationsysId, categoryId);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByTaxationsysIdWithIsTaxpayer(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                return TaxcCombineBusiness.loadTaxcOrgByTaxationsysId(userHasPermOrgs, taxationsysId);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByTaxationsysIdWithIsTaxpayer(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainIdByTaxationsysIdWithTaxpayer(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
                return TaxcCombineBusiness.loadTaxcOrgByTaxationsysId(userHasPermOrgs, taxationsysId);
            }
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryOrgIdsWithPerm(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds();
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByTaxpayerWithPerm(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByTaxpayer();
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByTaxpayerWithPerm(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByTaxpayer(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByTaxpayerWithPerm(Long userId, String appId, String entityNum, String permItemId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadTaxcMainOrgIdsByTaxpayer();
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryOrgIdsWithPerm(Long userId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds();
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryOrgIdsWithPerm(Long userId, Long taxationsysId) {
        List<Long> userHasPermOrgs = TaxcCombineBusiness.getUserHasPermOrgs(userId);
        if (CollectionUtils.isNotEmpty(userHasPermOrgs)) {
            List<Long> taxMainOrgIds = TaxcCombineBusiness.loadAllTaxcOrgIds(taxationsysId);
            userHasPermOrgs.retainAll(taxMainOrgIds);
            Map<String, Object> resultMap = ServiceResultUtils.returnResultHandler(userHasPermOrgs);
            return ServiceInvokeUtils.createTaxResult(Long.class, resultMap);
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(Boolean.FALSE, TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getCode(), TaxcErrorCode.TAXC_PERMISSION_CODE_IS_EMPTY.getMessage(), null));
    }

    private static List<Long> getUserHasPermOrgs(Long userId) {
        TaxResult<List<Long>> result = PermDataServiceHelper.getUserHasPermOrgs(userId, "40");
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> getUserHasPermOrgs(Long userId, String viewNumber) {
        TaxResult<List<Long>> result = PermDataServiceHelper.getUserHasPermOrgs(userId, viewNumber);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> getAllPermOrgs(Long userId, String appId, String entityNum, String permItemId) {
        TaxResult<List<Long>> result = PermDataServiceHelper.getAllPermOrgs(userId, appId, entityNum, permItemId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainOrgIdByIsTaxpayer() {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer();
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainOrgIdByIsTaxpayerByTaxationsysId(Long taxationsysId) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer(taxationsysId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(orgIds);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadAllTaxcOrgIds() {
        TaxResult<List<Long>> result = TaxcOrgDataServiceHelper.queryAllTaxcOrgId();
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadAllTaxcOrgIds(Long taxationsysId) {
        TaxResult<List<Long>> result = TaxcOrgDataServiceHelper.queryAllTaxcOrgId(taxationsysId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcOrgIdByIsTaxpayer() {
        TaxResult<List<Long>> result = TaxcOrgDataServiceHelper.queryTaxcOrgIdByIsTaxpayer();
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainOrgIdByIsTaxpayerAndFs() {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByFinancialStatementAndIsTaxpayer();
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainIdByTaxationsysIdWithTaxpayer(Long taxationsysId) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer(taxationsysId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainIdByTaxationsysIdWithTaxpayer(Long taxationsysId, boolean isIncludeTaxationsys) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer(taxationsysId, isIncludeTaxationsys);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainIdByTaxationsysId(Long taxationsysId) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIds(taxationsysId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static TaxResult<List<DynamicObject>> loadTaxcOrgByTaxationsysId(List<Long> orgIds, Long taxationsysId) {
        TaxResult<List<DynamicObject>> listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, taxationsysId);
        if (listTaxResult != null) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), taxationsysId, Boolean.TRUE));
            return listTaxResult;
        }
        return TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, taxationsysId);
    }

    private static TaxResult<List<Long>> loadTaxcOrgIdByTaxationsysId(List<Long> orgIds, Long taxationsysId) {
        return TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgIdsAndTaxationsysId(orgIds, taxationsysId);
    }

    private static List<Long> loadTaxcMainOrgIdsByIsTaxpayerForHws(Long taxationsysId, Long categoryId) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByIsTaxpayerForHws(taxationsysId, categoryId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static TaxResult<List<DynamicObject>> loadTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(List<Long> orgIds, Long taxationsysId, Long categoryId) {
        return TaxcMainDataServiceHelper.queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(orgIds, taxationsysId, categoryId);
    }

    private static List<Long> loadTaxcMainOrgIdsByTaxpayer() {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByTaxpayer();
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }

    private static List<Long> loadTaxcMainOrgIdsByTaxpayer(Long taxationsysId) {
        TaxResult<List<Long>> result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByTaxpayer(taxationsysId);
        if (result != null) {
            return result.getData();
        }
        return new ArrayList<Long>();
    }
}

