/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import org.apache.commons.collections.CollectionUtils;

public class TaxcOrgBusiness {
    public static List<DynamicObject> queryTaxcOrgByTaxationsysId(List<DynamicObject> objs, Long taxationsysId, boolean isIncludeTaxationsys) {
        for (DynamicObject obj : objs) {
            TaxcOrgBusiness.filterDataBytaxationsysId(obj, taxationsysId, isIncludeTaxationsys);
        }
        return objs;
    }

    public static void filterDataBytaxationsysId(DynamicObject doc, Long taxationsysId, boolean isIncludeTaxationsys) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("entryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryObjs = isIncludeTaxationsys ? entryentity.stream().filter(o -> o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("entryentity", (Object)entryObjs);
        }
    }

    public static List<DynamicObject> loadTaxcOrgByTaxationsysId(List<DynamicObject> objs, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            if (!TaxcOrgBusiness.isMatchBytaxationsysId(obj, taxationsysId, isIncludeTaxationsys)) continue;
            objList.add(obj);
        }
        return objList;
    }

    public static boolean isMatchBytaxationsysId(DynamicObject doc, Long taxationsysId, boolean isIncludeTaxationsys) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("entryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = isIncludeTaxationsys ? entryentity.stream().filter(o -> o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).findFirst();
            return entryObj.isPresent();
        }
        return false;
    }
}

