/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.service.IBillLogService;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillLogService;
import kd.taxc.bdtaxr.common.enums.changemodel.EnableStatusEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang3.StringUtils;

public class ChangeModelBusiness {
    private static final Log logger = LogFactory.getLog(ChangeModelBusiness.class);

    public static DynamicObject getChangeModel4SrcBill(String srcBillEntiyId) {
        QFilter qf1 = new QFilter("srcbill", "=", (Object)srcBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return ChangeModelBusiness.getChangeModel(new QFilter[]{qf1, qf2});
    }

    public static DynamicObject getChangeModel(QFilter[] qFilter) {
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bdtaxr_changemodel", (QFilter[])qFilter);
        if (!ChangeModelUtil.isNull(map)) {
            ArrayList list = new ArrayList(map.values());
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    public static DynamicObject getChangeModel4XBill(String xBillEntiyId) {
        QFilter qf1 = new QFilter("xbill", "=", (Object)xBillEntiyId);
        QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bdtaxr_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
        if (!ChangeModelUtil.isNull(map)) {
            ArrayList list = new ArrayList(map.values());
            DynamicObject changeModel = (DynamicObject)list.get(0);
            return changeModel;
        }
        return null;
    }

    public static IBillLogService getBillLogService(DynamicObject changeModel) {
        Map<String, Map<String, String>> XBillEntryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        String logService = null;
        if (XBillEntryAndOp != null && XBillEntryAndOp.get("_config") != null) {
            logService = XBillEntryAndOp.get("_config").get("logservice");
        }
        IBillLogService billLogService = null;
        billLogService = StringUtils.isNotEmpty(logService) ? (IBillLogService)TypesContainer.createInstance(logService) : new BillLogService();
        return billLogService;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOp(DynamicObject changeModel) {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(10);
        if (changeModel == null) {
            return result;
        }
        String[] plugins = ChangeModelBusiness.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            result = ChangeModelBusiness.getXBillEntryAndOpFromCustpama(changeModel);
            if (result == null || result.size() == 0) {
                result = ChangeModelBusiness.getDefaultXBillEntryAndOp();
            }
            return result;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod("getXBillEntryAndOp", new Class[0]);
                Object r = m.invoke(c.newInstance(), new Object[0]);
                if (!(r instanceof Map)) continue;
                result.putAll((Map)r);
            }
            catch (Exception e) {
                String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u63d2\u4ef6\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelBusiness_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
        }
        return result;
    }

    public static Map<String, Map<String, String>> getExtendParam4SrcBill(String billFormId) {
        Map<String, Map<String, String>> result = null;
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4SrcBill(billFormId);
        result = changeModel != null ? ChangeModelBusiness.getXBillEntryAndOp(changeModel) : ChangeModelBusiness.getDefaultXBillEntryAndOp();
        return result;
    }

    public static Map<String, Map<String, String>> getDefaultXBillEntryAndOp() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(2);
        HashMap<String, String> value = new HashMap<String, String>(10);
        value.put("entity", "entryentity");
        value.put("entry_toolbar", "tool_entry");
        value.put("btn_add", "addentry");
        value.put("btn_delete", "delentry");
        value.put("btn_modify", "modifyrow");
        value.put("changetype", "entrychangetype");
        value.put("srcid", "entrysrcid");
        result.put((String)value.get("entity"), (Map<String, String>)value);
        HashMap<String, String> billValue = new HashMap<String, String>(10);
        billValue.put("number", "number");
        billValue.put("status", "status");
        result.put("_bill", billValue);
        return result;
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOpFromCustpama(DynamicObject changeModel) {
        String customparameter = changeModel.getString("customparameter_tag");
        if (customparameter == null || customparameter.isEmpty()) {
            return null;
        }
        String xbilldtstr = "";
        if (changeModel.getDynamicObject("xbill") != null && changeModel.getDynamicObject("xbill").getPkValue() != null) {
            xbilldtstr = (String)changeModel.getDynamicObject("xbill").getPkValue();
        }
        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
        List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities((IDataEntityType)xBillDt);
        List customparameters = new ArrayList(16);
        try {
            customparameters = (List)SerializationUtils.fromJsonString((String)customparameter, customparameters.getClass());
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(10);
            for (Map map : customparameters) {
                for (EntityType xBillentryEntity : xBillentryEntitys) {
                    if (!xBillentryEntity.getName().equalsIgnoreCase((String)map.get("name"))) continue;
                    try {
                        Map propertymapping = (Map)SerializationUtils.fromJsonString((String)((String)map.get("val")), Map.class);
                        result.put((String)map.get("name"), propertymapping);
                    }
                    catch (Exception ee) {
                        String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelBusiness_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                        throw new KDBizException(errMsg);
                    }
                }
                if (!"_bill".equalsIgnoreCase((String)map.get("name"))) continue;
                try {
                    Map propertymapping = (Map)SerializationUtils.fromJsonString((String)((String)map.get("val")), Map.class);
                    result.put((String)map.get("name"), propertymapping);
                }
                catch (Exception ee) {
                    String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelBusiness_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                    throw new KDBizException(errMsg);
                }
            }
            return result;
        }
        catch (Exception ee) {
            String errMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u6a21\u578b\u201c\u81ea\u5b9a\u4e49\u53c2\u6570\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ChangeModelBusiness_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    public static String[] getUnEnableProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    private static DynamicObjectCollection getMappingColFromXBillDT(IDataEntityType xBillDt) {
        if (xBillDt == null) {
            return null;
        }
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBillDt.getName());
        if (changeModel == null) {
            return null;
        }
        DynamicObjectCollection mappingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
        return mappingEntitys;
    }

    public static String[] getUnEnableProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelBusiness.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanLogProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canlog");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelBusiness.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xbillDt) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xbillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canLog = mappingEntity.getBoolean("canwriteback");
            String[] targetItems = targetFieldname.split("\\.");
            if (headTitle == null || !headTitle.containsValue((Object)targetItems[0]) || !canLog.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getCanWritebackProperty(IDataEntityType xBillDt, String entryEntity) {
        DynamicObjectCollection mappingEntitys = ChangeModelBusiness.getMappingColFromXBillDT(xBillDt);
        if (mappingEntitys == null || mappingEntitys.size() < 1) {
            return null;
        }
        ArrayList<String> arPropName = new ArrayList<String>(30);
        LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"ChangeModelBusiness_2", (String)"taxc-bdtaxr-base");
        for (DynamicObject mappingEntity : mappingEntitys) {
            String targetField = mappingEntity.getString("targetfield");
            String targetFieldname = mappingEntity.getString("targetfieldname");
            Boolean canEnable = mappingEntity.getBoolean("canenable");
            String[] targetItems = targetFieldname.split("\\.");
            List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities(xBillDt);
            EntityType xBillEntryType = ChangeModelBusiness.getChildEntitiesByAlias(xBillentryEntitys, targetItems[0]);
            if (xBillEntryType == null || targetItems.length != 2 || headTitle != null && headTitle.containsValue((Object)targetItems[0]) || !entryEntity.equalsIgnoreCase(xBillEntryType.getName()) || !canEnable.booleanValue()) continue;
            arPropName.add(targetField);
        }
        return arPropName.toArray(new String[0]);
    }

    public static String[] getProperty4Entry(IDataEntityType dt, String entryName) {
        DynamicPropertyCollection dynPropColl = (DynamicPropertyCollection)dt.getProperties();
        Iterator it = dynPropColl.iterator();
        ArrayList<String> arPropName = new ArrayList<String>(50);
        while (it.hasNext()) {
            DataEntityPropertyCollection entry;
            IDataEntityProperty dataEntityProp = (IDataEntityProperty)it.next();
            if (dataEntityProp instanceof EntryProp && dataEntityProp.getName().equals(entryName)) {
                entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropEntry : entry) {
                    if (dataEntityPropEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropEntry.getName());
                }
                continue;
            }
            if (!(dataEntityProp instanceof EntryProp)) continue;
            entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty dataEntityPropEntry : entry) {
                if (!(dataEntityPropEntry instanceof EntryProp) || !dataEntityPropEntry.getName().equals(entryName)) continue;
                DataEntityPropertyCollection subEntry = ((EntryProp)dataEntityPropEntry).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropSubEntry : subEntry) {
                    if (dataEntityPropSubEntry instanceof EntryProp) continue;
                    arPropName.add(dataEntityPropSubEntry.getName());
                }
            }
        }
        return arPropName.toArray(new String[0]);
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>(10);
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(ChangeModelBusiness.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    public static FilterBuilder convertStringToQFilter(String runcondition, String srcType) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)runcondition)) {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)runcondition, FilterCondition.class);
            condition.createMetaData();
            FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)srcType), condition);
            fb.buildFilter();
            return fb;
        }
        return null;
    }

    public static void excutePluginMethod(DynamicObject changeModel, String methodName, DynamicObject arg) {
        String[] plugins = ChangeModelBusiness.getChangeService(changeModel);
        if (plugins == null || plugins.length == 0) {
            return;
        }
        for (String plugin : plugins) {
            try {
                Class<?> c = Class.forName(plugin);
                Method m = c.getMethod(methodName, DynamicObject.class);
                m.invoke(c.newInstance(), arg);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String[] getChangeService(DynamicObject changeModel) {
        if (ChangeModelUtil.isNull(changeModel)) {
            return null;
        }
        DynamicObjectCollection plugins = changeModel.getDynamicObjectCollection("pluginentity");
        if (ChangeModelUtil.isNull(plugins)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(10);
        for (DynamicObject plugin : plugins) {
            Boolean pluginenable = plugin.getBoolean("pluginenable");
            String classname = plugin.getString("classname");
            if (!pluginenable.booleanValue() || ChangeModelUtil.isNull(classname)) continue;
            res.add(classname);
        }
        if (res.size() != 0) {
            return res.toArray(new String[res.size()]);
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId, String opkey) {
        DynamicObject changmodel = ChangeModelBusiness.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObject changemodelDO = changmodel;
            String validoptype = changemodelDO.getString("validoptype");
            if (StringUtils.isNotEmpty((CharSequence)validoptype) && validoptype.contains(opkey)) {
                DynamicObjectCollection validcol = changemodelDO.getDynamicObjectCollection("validentity");
                ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>(10);
                for (DynamicObject valid : validcol) {
                    ConditionValidation validation = ChangeModelBusiness.convertStringToValidate(valid.getString("validconditionjson_tag"));
                    if (validation == null || !validation.getEnabled()) continue;
                    vallist.add(validation);
                }
                return vallist;
            }
            return null;
        }
        return null;
    }

    public static List<ConditionValidation> getValidConditionList(String xBillEntiyId) {
        DynamicObject changmodel = ChangeModelBusiness.getChangeModel4XBill(xBillEntiyId);
        if (changmodel != null) {
            DynamicObjectCollection validcol = changmodel.getDynamicObjectCollection("validentity");
            ArrayList<ConditionValidation> vallist = new ArrayList<ConditionValidation>(10);
            for (DynamicObject valid : validcol) {
                ConditionValidation validation = ChangeModelBusiness.convertStringToValidate(valid.getString("validconditionjson_tag"));
                if (validation == null || !validation.getEnabled()) continue;
                vallist.add(validation);
            }
            return vallist;
        }
        return null;
    }

    public static ConditionValidation convertStringToValidate(String validconditionjson) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)validconditionjson)) {
            ArrayList<IDataEntityType> dTypes = new ArrayList<IDataEntityType>(10);
            dTypes.add(DataEntityType.getDataEntityType(ConditionValidation.class));
            ListDcxmlBinder binder = new ListDcxmlBinder(false, dTypes);
            Map parameter = (Map)SerializationUtils.fromJsonString((String)validconditionjson, Map.class);
            DcJsonSerializer ds = new DcJsonSerializer((DcBinder)binder);
            ds.setIsLocaleValueFull(true);
            ConditionValidation validation = (ConditionValidation)ds.deserializeFromMap(parameter, null);
            if (validation.getDescription() == null && StringUtils.isNotBlank((CharSequence)((String)parameter.get("Description"))) && parameter.get("Description") instanceof String) {
                validation.setDescription(new LocaleString((String)parameter.get("Description")));
            }
            if (validation.getMessage() == null && StringUtils.isNotBlank((CharSequence)((String)parameter.get("Message"))) && parameter.get("Message") instanceof String) {
                validation.setMessage(new LocaleString((String)parameter.get("Message")));
            }
            return validation;
        }
        return null;
    }

    public static EntityType getChildEntitiesByAlias(List<EntityType> childEntities, String alias) {
        for (EntityType childEntity : childEntities) {
            LocaleString childEntityDisName = childEntity.getDisplayName();
            if (alias == null || childEntityDisName == null || !childEntityDisName.containsValue((Object)alias)) continue;
            return childEntity;
        }
        return null;
    }
}

