/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillTransferService;
import kd.taxc.bdtaxr.common.enums.changemodel.BillStatusEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import kd.taxc.bdtaxr.common.enums.changemodel.BizValidStatusEnum;

public class XBillBusiness {
    public static DynamicObject[] generateXBill(DynamicObject[] srcBills) {
        BillTransferService transferService = new BillTransferService();
        DynamicObject[] xBills = transferService.generateXBill(srcBills);
        SaveServiceHelper.save((DynamicObject[])xBills);
        return xBills;
    }

    public static DynamicObject generateXBill(Long srcBillId, String srcBillEntiy) {
        BillTransferService transferService = new BillTransferService();
        return transferService.generateXBill(srcBillId, srcBillEntiy);
    }

    public static DynamicObject getOnWayXBill(Long srcBillId, String srcBillEntity) {
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4SrcBill(srcBillEntity);
        if (changeModel != null && changeModel.getDynamicObject("xbill") != null) {
            Map<String, Map<String, String>> entryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
            String billstatus = entryAndOp.get("_bill").get("status");
            String xBillEntityID = changeModel.getDynamicObject("xbill").getString("id");
            QFilter q1 = new QFilter("sourcebillid", "=", (Object)srcBillId);
            QFilter q2 = new QFilter(billstatus, "!=", (Object)BillStatusEnum.AUDIT.getValue());
            QFilter q3 = new QFilter("changestatus", "!=", (Object)BizChangeStatusEnum.INITED.getValue());
            return BusinessDataServiceHelper.loadSingle((String)xBillEntityID, (String)("id," + billstatus), (QFilter[])new QFilter[]{q1, q2, q3});
        }
        return null;
    }

    public static DynamicObject getXbillById(Long xbillid, String xBillEntity) {
        return CommonDataBusiness.loadSingle(xbillid, xBillEntity);
    }

    public static void volidXbill(DynamicObject[] bills) {
        DynamicObject changer = BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        for (DynamicObject bill : bills) {
            bill.set("validstatus", (Object)BizValidStatusEnum.VALID.getValue());
            bill.set("validdate", (Object)new Date(System.currentTimeMillis()));
            bill.set("valider", (Object)changer);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    public static DynamicObject[] getZeroXBillBySrcBillIds(List<Long> srcBillIds, String xBillEntity) {
        QFilter zeroXBillQFilter1 = new QFilter("sourcebillid", "in", srcBillIds);
        QFilter zeroXBillQFilter2 = new QFilter("changestatus", "=", (Object)"D");
        DynamicObject[] zeroXBillDOCol = BusinessDataServiceHelper.load((String)xBillEntity, (String)"id,sourcebillid", (QFilter[])new QFilter[]{zeroXBillQFilter1, zeroXBillQFilter2});
        return zeroXBillDOCol;
    }
}

