/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.changemodel.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang3.StringUtils;

public class ChangeModelHelper {
    private static final Log logger = LogFactory.getLog(ChangeModelHelper.class);

    public static EntityType getChildEntitiesByAlias(List<EntityType> childEntities, String alias) {
        for (EntityType childEntity : childEntities) {
            LocaleString childEntityDisName = childEntity.getDisplayName();
            if (alias == null || childEntityDisName == null || !childEntityDisName.containsValue((Object)alias)) continue;
            return childEntity;
        }
        return null;
    }

    public static String getEntryPropertyAlias(IDataEntityType dt, String entryName, String propertyName) {
        DynamicPropertyCollection dynPropColl = (DynamicPropertyCollection)dt.getProperties();
        for (IDataEntityProperty dataEntityProp : dynPropColl) {
            DataEntityPropertyCollection entry;
            if (dataEntityProp instanceof EntryProp && dataEntityProp.getName().equals(entryName)) {
                entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropEntry : entry) {
                    if (!dataEntityPropEntry.getName().equals(propertyName)) continue;
                    return dataEntityPropEntry.getDisplayName().toString();
                }
                continue;
            }
            if (!(dataEntityProp instanceof EntryProp)) continue;
            entry = ((EntryProp)dataEntityProp).getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty dataEntityPropEntry : entry) {
                if (!(dataEntityPropEntry instanceof EntryProp) || !dataEntityPropEntry.getName().equals(entryName)) continue;
                DataEntityPropertyCollection subEntry = ((EntryProp)dataEntityPropEntry).getDynamicCollectionItemPropertyType().getProperties();
                for (IDataEntityProperty dataEntityPropSubEntry : subEntry) {
                    if (!dataEntityPropSubEntry.getName().equals(propertyName)) continue;
                    return dataEntityPropSubEntry.getDisplayName().toString();
                }
            }
        }
        return null;
    }

    public static boolean compareField(Object srcField, Object newField) {
        if (srcField == null && newField == null) {
            return true;
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return true;
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal && srcField.equals(newField)) {
            return true;
        }
        if (srcField instanceof DynamicObject && newField instanceof DynamicObject && ((DynamicObject)srcField).getPkValue().equals(((DynamicObject)newField).getPkValue())) {
            return true;
        }
        if (newField != null && newField.equals(srcField)) {
            return true;
        }
        if (srcField != null && srcField.equals(newField)) {
            return true;
        }
        if (srcField != null && newField != null) {
            String srcFieldStr = srcField.toString();
            String newFieldStr = newField.toString();
            if (srcFieldStr == null && newFieldStr == null) {
                return true;
            }
            return srcFieldStr != null && srcFieldStr.equals(newFieldStr);
        }
        return false;
    }

    public static String compareSizes(Object srcField, Object newField) {
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal) {
            BigDecimal oldBig = (BigDecimal)srcField;
            BigDecimal newBig = (BigDecimal)newField;
            if (ChangeModelUtil.isNull(oldBig) || ChangeModelUtil.isNull(newBig)) {
                return "";
            }
            if (oldBig.compareTo(newBig) < 0) {
                return "\u2191";
            }
            if (oldBig.compareTo(newBig) > 0) {
                return "\u2193";
            }
        } else if (srcField instanceof Integer && newField instanceof Integer) {
            Integer oldBig = (Integer)srcField;
            Integer newBig = (Integer)newField;
            if (ChangeModelUtil.isNull(oldBig) || ChangeModelUtil.isNull(newBig)) {
                return "";
            }
            if (oldBig.compareTo(newBig) < 0) {
                return "\u2191";
            }
            if (oldBig.compareTo(newBig) > 0) {
                return "\u2193";
            }
        }
        return "";
    }

    public static String getPropertyAlias(IDataEntityType dt, String propertyName) {
        DynamicPropertyCollection dynPropColl = (DynamicPropertyCollection)dt.getProperties();
        for (IDataEntityProperty dataEntityProp : dynPropColl) {
            if (dataEntityProp instanceof EntryProp || !dataEntityProp.getName().equals(propertyName)) continue;
            return dataEntityProp.getDisplayName().toString();
        }
        return null;
    }

    public static String displayFieldValue(Object newField, DynamicProperty newdp) {
        if (newField == null) {
            return "";
        }
        if (newField instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)newField;
            return b.stripTrailingZeros().toPlainString();
        }
        if (newField instanceof Date) {
            Date d = (Date)newField;
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            return ChangeModelHelper.getTransString(df.format(d));
        }
        if (newField instanceof Boolean) {
            Boolean b = (Boolean)newField;
            return b != false ? ResManager.loadKDString((String)"\u662f", (String)"ChangeModelHelper_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ChangeModelHelper_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
        }
        if (newField instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)newField;
            if (newdp instanceof BasedataProp) {
                if (newdp instanceof FlexProp) {
                    return ChangeModelHelper.getTransString(dyo.toString());
                }
                BasedataProp bdProp = (BasedataProp)newdp;
                return ChangeModelHelper.getTransString(bdProp.getDisplayValue(newField));
            }
            return ChangeModelHelper.getTransString(dyo.toString());
        }
        if (newField instanceof DynamicObjectCollection) {
            DynamicObjectCollection dyoCol = (DynamicObjectCollection)newField;
            if (dyoCol.isEmpty()) {
                return "";
            }
            if (newdp instanceof MulBasedataProp) {
                if (newdp instanceof AttachmentProp) {
                    AttachmentProp panel = (AttachmentProp)newdp;
                    return ChangeModelHelper.getTransString(panel.getDisplayValue(newField));
                }
                MulBasedataProp mulbdPro = (MulBasedataProp)newdp;
                return ChangeModelHelper.getTransString(mulbdPro.getDisplayValue(newField));
            }
        } else {
            if (newdp instanceof MulComboProp) {
                MulComboProp cbPros = (MulComboProp)newdp;
                return ChangeModelHelper.getTransString(cbPros.getItemByName((String)newField));
            }
            if (newdp instanceof ComboProp) {
                ComboProp cbPro = (ComboProp)newdp;
                List cbItems = cbPro.getComboItems();
                for (ValueMapItem cbItem : cbItems) {
                    if (cbItem == null || !newField.equals(cbItem.getValue())) continue;
                    return ChangeModelHelper.getTransString(cbItem.getName().toString());
                }
            } else {
                if (newField instanceof OrmLocaleValue) {
                    String str = ((OrmLocaleValue)newField).getLocaleValue();
                    if (str == null) {
                        return "";
                    }
                    return ChangeModelHelper.getTransString(str);
                }
                if (newdp instanceof AssistantProp) {
                    AssistantProp assistantPropdp = (AssistantProp)newdp;
                    return ChangeModelHelper.getTransString(assistantPropdp.getDisplayValue(newField));
                }
            }
        }
        return ChangeModelHelper.getTransString(newField.toString());
    }

    public static String getTransString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            if (str.contains("\\")) {
                str = str.replaceAll("\\\\", "&#123;");
            }
            if (str.contains("\"")) {
                str = str.replaceAll("\"", "&#124;");
            }
        } else {
            str = "";
        }
        return str;
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        if (entityType == null) {
            return childEntities;
        }
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
        }
        return childEntities;
    }

    public static Map<String, String[]> getAllChangeLogPropertyMap(DynamicObject xBill) {
        HashMap<String, String[]> allCanLogProperty = new HashMap<String, String[]>();
        if (xBill == null) {
            return allCanLogProperty;
        }
        List<EntityType> entities = ChangeModelHelper.getAllEntities(xBill.getDynamicObjectType().getProperties());
        if (entities.size() > 0) {
            for (EntityType entitie : entities) {
                String enName = entitie.getName();
                String[] canLogProperty = ChangeModelBusiness.getCanLogProperty(xBill.getDataEntityType(), enName);
                allCanLogProperty.put(enName, canLogProperty);
            }
        }
        return allCanLogProperty;
    }

    public static List<EntityType> getAllEntities(DataEntityPropertyCollection entityType) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        if (entityType == null) {
            return entities;
        }
        for (IDataEntityProperty property : entityType) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            entities.add(childEntity);
            entities.addAll(ChangeModelHelper.getAllEntities(childEntity.getProperties()));
        }
        return entities;
    }
}

