/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.comparisonmodel;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCompareService;
import kd.taxc.bdtaxr.common.enums.comparisonmodel.DataCompareEnum;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;

public class DataCompareBusiness {
    private static final Log logger = LogFactory.getLog(DataCompareBusiness.class);

    public static DataCompareResult doCompare(DataCompareParams params) {
        DataCompareConfig config = DataCompareEnum.getEnum(params.getSchemeId()).getConfig();
        IDataCompareService compareService = config.getCompareService();
        if (params.isSync()) {
            return compareService.compare(params);
        }
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("param", SerializationUtils.serializeToBase64((Object)params));
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u5bf9\u4efb\u52a1", (String)"DataCompareBusiness_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        job.setTaskClassname("kd.taxc.bdtaxr.business.comparisonmodel.task.DataCompareTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setId(UUID.randomUUID().toString());
        job.setParams(jobParams);
        JobClient.dispatch((JobInfo)job);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011doCompare JobClient dispatch");
        return null;
    }
}

