/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.comparisonmodel.service.impl;

import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCalculateService;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCompareSubService;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataFetchService;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataResultService;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;
import kd.taxc.bdtaxr.common.utils.LowTimer;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DataCompareSubService
implements IDataCompareSubService {
    private static final Log logger = LogFactory.getLog(DataCompareSubService.class);
    protected DataCompareResult result = null;
    protected IDataFetchService fetchService = null;
    protected IDataCalculateService calculateService = null;
    protected IDataResultService resultService = null;

    @Override
    public void process(DataCompareTaskParams taskParams, DataCompareResult result) {
        this.init(taskParams, result);
        this.beforeProcess(taskParams);
        this.doProcess(taskParams);
        this.afterProcess(taskParams);
    }

    protected void init(DataCompareTaskParams taskParams, DataCompareResult result) {
        this.result = result;
        this.fetchService = taskParams.getConfig().getFetchService();
        this.calculateService = taskParams.getConfig().getCalculateService();
        this.resultService = taskParams.getConfig().getResultService();
    }

    protected void beforeProcess(DataCompareTaskParams taskParams) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(DataCompareTaskParams taskParams) {
        Object srcData = null;
        Object destData = null;
        Object calResult = null;
        try {
            logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.doProcess:\u6267\u884c\u5f00\u59cb");
            LowTimer timer = new LowTimer();
            this.initData(taskParams);
            srcData = this.getSrcData(taskParams);
            destData = this.getDestData(taskParams);
            calResult = this.calculate(srcData, destData, taskParams);
            this.saveResult(calResult, taskParams);
            this.doSuccess(taskParams);
            logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.doProcess\uff1a\u603b\u8017\u65f6:{}" + timer.msValue());
            this.close(srcData, destData, calResult);
        }
        catch (Throwable e) {
            try {
                String msg = ExceptionUtils.getStackTrace((Throwable)e);
                logger.error("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.doProcess\uff1a\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)msg);
                this.result.getExceptionList().add(msg);
                this.doFailure(taskParams, msg);
                this.close(srcData, destData, calResult);
            }
            catch (Throwable throwable) {
                this.close(srcData, destData, calResult);
                throw throwable;
            }
        }
    }

    protected void initData(DataCompareTaskParams taskParams) {
        LowTimer timer = new LowTimer();
        this.fetchService.initData(taskParams);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.initData:\u521d\u59cb\u5316\uff0c\u8017\u65f6\uff1a{}", (Object)timer.msValue());
    }

    protected Object getSrcData(DataCompareTaskParams taskParams) {
        LowTimer timer = new LowTimer();
        Object srcData = this.fetchService.getSrcData(taskParams);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.getSrcData:\u83b7\u53d6\u6e90\u5355\u7ed3\u679c\u96c6\uff0c\u8017\u65f6\uff1a{}", (Object)timer.msValue());
        return srcData;
    }

    protected Object getDestData(DataCompareTaskParams taskParams) {
        LowTimer timer = new LowTimer();
        Object destData = this.fetchService.getDestData(taskParams);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.getDestData:\u83b7\u53d6\u76ee\u6807\u5355\u7ed3\u679c\u96c6\uff0c\u8017\u65f6\uff1a{}", (Object)timer.msValue());
        return destData;
    }

    protected Object calculate(Object srcData, Object destData, DataCompareTaskParams taskParams) {
        LowTimer timer = new LowTimer();
        Object calResult = this.calculateService.calculate(srcData, destData, taskParams);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.calculate:\u6267\u884c\u6bd4\u5bf9\uff0c\u8017\u65f6\uff1a{}", (Object)timer.msValue());
        return calResult;
    }

    protected void saveResult(Object calResult, DataCompareTaskParams taskParams) {
        LowTimer timer = new LowTimer();
        this.resultService.saveResult(calResult, taskParams);
        logger.info("\u3010\u6570\u636e\u6bd4\u5bf9\u3011DataCompareSubService.saveResult:\u4fdd\u5b58\u6570\u636e\u6bd4\u5bf9\u7ed3\u679c\uff0c\u8017\u65f6\uff1a{}", (Object)timer.msValue());
    }

    protected void doSuccess(DataCompareTaskParams taskParams) {
    }

    protected void doFailure(DataCompareTaskParams taskParams, String msg) {
    }

    protected void afterProcess(DataCompareTaskParams taskParams) {
    }

    protected void close(Object srcData, Object destData, Object calResult) {
        if (calResult instanceof DataSet) {
            ((DataSet)calResult).close();
        }
        if (calResult instanceof DataSet) {
            ((DataSet)srcData).close();
        }
        if (calResult instanceof DataSet) {
            ((DataSet)destData).close();
        }
        srcData = null;
        destData = null;
        calResult = null;
    }
}

