/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.comparisonmodel.task;

import com.google.common.collect.Lists;
import java.util.List;
import kd.taxc.bdtaxr.business.comparisonmodel.service.IDataCalculateService;
import kd.taxc.bdtaxr.common.enums.comparisonmodel.DataCompareEnum;
import kd.taxc.bdtaxr.common.executor.Task;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareConfig;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareParams;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareResult;
import kd.taxc.bdtaxr.common.pojo.comparisonmodel.DataCompareTaskParams;

public class DataCompareThreadTask
extends Task<List<DataCompareTaskParams>> {
    private DataCompareParams params = null;
    private DataCompareResult result = null;

    public DataCompareThreadTask(DataCompareParams params, DataCompareResult result) {
        this.params = params;
        this.result = result;
    }

    @Override
    public List<List<DataCompareTaskParams>> getValue() {
        DataCompareConfig config = DataCompareEnum.getEnum(this.params.getSchemeId()).getConfig();
        IDataCalculateService calculateService = config.getCalculateService();
        List<DataCompareTaskParams> paramsList = calculateService.buildTaskParamsList(this.params, this.result);
        return Lists.partition(paramsList, (int)calculateService.getBatchSize());
    }

    @Override
    public List<DataCompareTaskParams> executor(List<DataCompareTaskParams> paramsList) {
        DataCompareTaskParams taskParams = null;
        int size = paramsList.size();
        for (int i = 0; i < size; ++i) {
            taskParams = paramsList.get(i);
            taskParams.getConfig().getCompareSubService().process(taskParams, this.result);
        }
        return paramsList;
    }
}

