/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource;

import kd.taxc.bdtaxr.business.customsource.DataQueryService;
import kd.taxc.bdtaxr.business.customsource.impl.FinanceDataQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.FinanceDataSubQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.FinanceFilterQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.GlbalanceDataQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.MultiDataQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.NsrxxDataQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.StandardDataQueryServiceImpl;
import kd.taxc.bdtaxr.business.customsource.impl.TaxAcceDiffDataQueryServiceImpl;

public class DataQueryFactory {
    private DataQueryFactory() {
    }

    public static DataQueryFactory getInstance() {
        return SingleDataQuery.INSTANCE;
    }

    public DataQueryService getDataQueryService(String entityname, String subName) {
        DataQueryService dqs = DataQueryServiceEnum.getService(entityname + "#" + subName);
        if (null == dqs) {
            dqs = DataQueryServiceEnum.getService(entityname);
        }
        if (null == dqs) {
            dqs = DataQueryServiceEnum.getService("default");
        }
        return dqs;
    }

    private static class SingleDataQuery {
        private static DataQueryFactory INSTANCE = new DataQueryFactory();

        private SingleDataQuery() {
        }
    }

    static enum DataQueryServiceEnum {
        DEFAULT(new String[]{"default"}, new StandardDataQueryServiceImpl()),
        GLBALANCE(new String[]{"gl_balance", "gl_voucher"}, new GlbalanceDataQueryServiceImpl()),
        NSRXX(new String[]{"tcvat_nsrxx"}, new NsrxxDataQueryServiceImpl()),
        FINANCE(new String[]{"tdm_finance_main"}, new FinanceDataQueryServiceImpl()),
        FINANCE_SUB(new String[]{"tdm_finance_main#tdm_finance_lrb"}, new FinanceDataSubQueryServiceImpl()),
        TAXACCEDIFF(new String[]{"tccit_tax_acce_diff"}, new TaxAcceDiffDataQueryServiceImpl()),
        MULTIQUERY(new String[]{"tpo_declare_main_tsd", "tpo_declare_main_tsc"}, new MultiDataQueryServiceImpl()),
        FINANCE_FILTER(new String[]{"tdm_finance_hblrbfilter", "tdm_finance_hbzcfzbfilter", "tdm_finance_lrbfilter", "tdm_finance_syzqybdfilter", "tdm_finance_xjllbfilter", "tdm_finance_zcfzbfilter"}, new FinanceFilterQueryServiceImpl());

        private final String[] entityname;
        private final DataQueryService service;

        private DataQueryServiceEnum(String[] entityname, DataQueryService service) {
            this.entityname = entityname;
            this.service = service;
        }

        public String[] getEntityname() {
            return this.entityname;
        }

        public DataQueryService getService() {
            return this.service;
        }

        public static DataQueryService getService(String entityName) {
            for (DataQueryServiceEnum e : DataQueryServiceEnum.values()) {
                for (String key : e.getEntityname()) {
                    if (!key.equalsIgnoreCase(entityName)) continue;
                    return e.getService();
                }
            }
            return null;
        }
    }
}

