/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.DataQueryService;
import kd.taxc.bdtaxr.common.utils.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDataQueryService
implements DataQueryService {
    private static Log logger = LogFactory.getLog(AbstractDataQueryService.class);

    protected QFilter buildFilter(String conditionjson, String entryName) {
        if (null != conditionjson && !"".equals(conditionjson)) {
            Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
            dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
            dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
            DcJsonSerializer ser = new DcJsonSerializer(dts);
            FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entryName);
            FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
            filterBuilder.setUserService((IUserService)new UserService());
            filterBuilder.buildFilter(false);
            return filterBuilder.getQFilter();
        }
        return new QFilter("1", "=", (Object)1);
    }

    public String handlerSelectKey(CustomSource customSource, String selectKey) {
        if (customSource.getIfUseKeyId().booleanValue()) {
            List<Long> ids = customSource.getSelectKeyIds();
            if (CollectionUtils.isEmpty(ids)) {
                throw new KDBizException("selectkeyIds is null");
            }
            selectKey = this.generateKeyByFieldId(ids, customSource);
            if (customSource.getSelectKey() == null) {
                customSource.setSelectKey(selectKey);
            }
        }
        return selectKey;
    }

    private String generateKeyByFieldId(List<Long> fieldList, CustomSource customeSource) {
        StringBuilder selectKeys = new StringBuilder();
        for (Long fieldId : fieldList) {
            CustomSource.EntityField f = customeSource.getDatasourceFieldById(fieldId);
            String fieldKey = f.getFieldname();
            String entityKey = f.getFieldsubname();
            if (selectKeys.length() > 0) {
                selectKeys.append(",");
            }
            if (entityKey.equals(customeSource.getEntityname())) {
                selectKeys.append(fieldKey).append(" as k_").append(fieldId);
                continue;
            }
            selectKeys.append(entityKey).append(".").append(fieldKey).append(" as k_").append(fieldId);
        }
        return selectKeys.toString();
    }

    public QFilter handlerOrgQfilter(CustomSource customSource) {
        CustomSource.EntityField orgState = customSource.getOrgstate();
        String fieldName = orgState.getFieldname();
        Object value = orgState.getValue();
        if (value instanceof Long) {
            return new QFilter(fieldName, "=", value);
        }
        if (value instanceof Collection) {
            return new QFilter(fieldName, "in", value);
        }
        return new QFilter(fieldName, "=", (Object)Long.valueOf((String)value));
    }

    public QFilter handlerDateQfilter(CustomSource customSource) {
        if (null != customSource.getDatastate()) {
            QFilter skssqq = new QFilter(customSource.getDatastate().getFieldname(), ">=", (Object)((Date[])customSource.getDatastate().getValue())[0]);
            QFilter skssqz = new QFilter(customSource.getDatastate().getFieldname(), "<=", (Object)((Date[])customSource.getDatastate().getValue())[1]);
            return skssqq.and(skssqz);
        }
        String yearStart = DateUtils.format(((Date[])customSource.getYearstate().getValue())[0], "yyyy");
        String yearEnd = DateUtils.format(((Date[])customSource.getYearstate().getValue())[1], "yyyy");
        int monthStart = DateUtils.getMonthOfDate(((Date[])customSource.getYearstate().getValue())[0]);
        int monthEnd = DateUtils.getMonthOfDate(((Date[])customSource.getYearstate().getValue())[1]);
        if (StringUtils.equalsIgnoreCase((CharSequence)yearStart, (CharSequence)yearEnd)) {
            ArrayList<String> accountperiodList = new ArrayList<String>(2);
            for (int monthInt = monthStart; monthInt <= monthEnd; ++monthInt) {
                String monthOfFormat = String.format("%02d", monthInt);
                accountperiodList.add(monthOfFormat);
            }
            QFilter year = new QFilter(customSource.getYearstate().getFieldname(), "=", (Object)yearStart);
            QFilter month = new QFilter(customSource.getMonthstate().getFieldname(), "in", accountperiodList);
            return year.and(month);
        }
        ArrayList<String> accountperiodList = new ArrayList<String>(2);
        for (int monthInt = monthStart; monthInt <= 12; ++monthInt) {
            String monthOfFormat = String.format("%02d", monthInt);
            accountperiodList.add(monthOfFormat);
        }
        QFilter yearStartQ = new QFilter(customSource.getYearstate().getFieldname(), "=", (Object)yearStart);
        QFilter monthStartQ = new QFilter(customSource.getMonthstate().getFieldname(), "in", accountperiodList);
        QFilter upYearQ = yearStartQ.and(monthStartQ);
        ArrayList<String> accountperiodEndList = new ArrayList<String>(2);
        for (int monthInt = 1; monthInt <= monthEnd; ++monthInt) {
            String monthOfFormat = String.format("%02d", monthInt);
            accountperiodEndList.add(monthOfFormat);
        }
        QFilter yearEndQ = new QFilter(customSource.getYearstate().getFieldname(), "=", (Object)yearEnd);
        QFilter monthEndQ = new QFilter(customSource.getMonthstate().getFieldname(), "in", accountperiodEndList);
        QFilter downYearQ = yearEndQ.and(monthEndQ);
        return upYearQ.or(downYearQ);
    }

    public QFilter handlerOrgMappingQfilter(CustomSource customSource) {
        CustomSource.EntityField accessmapstate = customSource.getAccessmapstate();
        if (accessmapstate == null) {
            return null;
        }
        String fieldName = FilterBuilderUtils.buildQueryField(customSource, accessmapstate.getFieldsubname(), accessmapstate.getFieldname());
        Object value = accessmapstate.getValue();
        if (value instanceof Long) {
            return new QFilter(fieldName, "=", value);
        }
        if (value instanceof Collection) {
            return new QFilter(fieldName, "in", value);
        }
        if (value instanceof String && !StringUtils.isNumeric((CharSequence)value.toString())) {
            return new QFilter(fieldName, "in", value);
        }
        return new QFilter(fieldName, "=", (Object)Long.valueOf((String)value));
    }

    private QFilter buildWhereQfilter(CustomSource customSource, String whereFilter) {
        return this.buildWhereQfilter(customSource, whereFilter, null);
    }

    public QFilter buildWhereQfilter(CustomSource customSource, String whereFilter, Map<String, QFilter> customFilter) {
        QFilter finalFilter = this.buildFilter(whereFilter, customSource.getEntityname());
        if (customFilter != null && customFilter.size() > 0) {
            for (QFilter item : customFilter.values()) {
                finalFilter.and(item);
            }
        }
        return finalFilter;
    }

    public abstract DataSet queryBizData(CustomSource var1, String var2, QFilter var3, QFilter var4, QFilter var5);

    protected BigDecimal queryBizDataSum(CustomSource customSource, String selectKey, QFilter orgQFilter, QFilter dateQFilter, QFilter whereQFilter, Map<String, QFilter> customFilter) {
        return this.callOrmAggreGate(customSource.getEntityname(), selectKey, new QFilter[]{orgQFilter, dateQFilter, whereQFilter});
    }

    protected BigDecimal callOrmAggreGate(String entityName, String selectKey, QFilter[] qFilters) {
        BigDecimal amount = BigDecimal.ZERO;
        ORM orm = ORM.create();
        Object[] sumObject = orm.aggregate(this.getClass().getName(), entityName, new String[]{selectKey}, qFilters);
        if (ObjectUtils.isNotEmpty((Object)sumObject) && ObjectUtils.isNotEmpty((Object)sumObject[0])) {
            amount = (BigDecimal)sumObject[0];
        }
        return amount;
    }

    @Override
    public DataSet queryDynamicObjectBizData(CustomSource customSource, String selectKey, String whereFilter) {
        return this.queryBizDataSetMultiCondition(customSource, selectKey, whereFilter, (Boolean)false, (Map<String, QFilter>)Collections.EMPTY_MAP);
    }

    @Override
    public DataSet queryDynamicObjectBizData(CustomSource customSource, String selectKey, QFilter whereFilter) {
        return this.queryBizDataSetMultiCondition(customSource, selectKey, whereFilter, (Boolean)false, (Map<String, QFilter>)Collections.EMPTY_MAP);
    }

    @Override
    public DataSet queryBizDataSetSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter) {
        return this.queryBizDataSetMultiCondition(customSource, selectKey, whereFilter, (Boolean)true, (Map<String, QFilter>)Collections.EMPTY_MAP);
    }

    @Override
    public DataSet queryBizDataSetSumWithOrgMapping(CustomSource customSource, String selectKey, QFilter whereFilter) {
        return this.queryBizDataSetMultiCondition(customSource, selectKey, whereFilter, (Boolean)true, (Map<String, QFilter>)Collections.EMPTY_MAP);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSum(CustomSource customSource, String selectKey, String whereFilter) {
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, false, null);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter) {
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, true, null);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSum(CustomSource customSource, String selectKey, String whereFilter, QFilter customFilter) {
        HashMap<String, QFilter> customFilterMap = new HashMap<String, QFilter>(4);
        if (customFilter != null) {
            customFilterMap.put("default", customFilter);
        }
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, false, customFilterMap);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSum(CustomSource customSource, String selectKey, String whereFilter, Map<String, QFilter> customFilter) {
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, false, customFilter);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter, QFilter customFilter) {
        HashMap<String, QFilter> customFilterMap = new HashMap<String, QFilter>(4);
        if (customFilter != null) {
            customFilterMap.put("default", customFilter);
        }
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, true, customFilterMap);
    }

    @Override
    public BigDecimal queryDynamicObjectBizDataSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter, Map<String, QFilter> customFilter) {
        return this.queryBizDataSumMultiCondition(customSource, selectKey, whereFilter, true, customFilter);
    }

    private BigDecimal queryBizDataSumMultiCondition(CustomSource customSource, String selectKey, String whereFilter, Boolean ifOrgMaping, Map<String, QFilter> customFilter) {
        Object[] params = this.buildParams(customSource, selectKey, whereFilter, ifOrgMaping, customFilter);
        customSource = (CustomSource)params[0];
        selectKey = (String)params[1];
        QFilter orgQFilter = (QFilter)params[2];
        QFilter dateQFilter = (QFilter)params[3];
        QFilter whereQFilter = (QFilter)params[4];
        if (customSource != null) {
            return this.queryBizDataSum(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter, customFilter);
        }
        return BigDecimal.ZERO;
    }

    public DataSet queryBizDataSetMultiCondition(CustomSource customSource, String selectKey, String whereFilter, Boolean ifOrgMaping, Map<String, QFilter> customFilter) {
        Object[] params = this.buildParams(customSource, selectKey, whereFilter, ifOrgMaping, (Map<String, QFilter>)Collections.EMPTY_MAP);
        customSource = (CustomSource)params[0];
        selectKey = (String)params[1];
        QFilter orgQFilter = (QFilter)params[2];
        QFilter dateQFilter = (QFilter)params[3];
        QFilter whereQFilter = (QFilter)params[4];
        return this.queryBizData(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter);
    }

    public DataSet queryBizDataSetMultiCondition(CustomSource customSource, String selectKey, QFilter whereFilter, Boolean ifOrgMaping, Map<String, QFilter> customFilter) {
        Object[] params = this.buildParams(customSource, selectKey, whereFilter, ifOrgMaping, (Map<String, QFilter>)Collections.EMPTY_MAP);
        customSource = (CustomSource)params[0];
        selectKey = (String)params[1];
        QFilter orgQFilter = (QFilter)params[2];
        QFilter dateQFilter = (QFilter)params[3];
        QFilter whereQFilter = (QFilter)params[4];
        return this.queryBizData(customSource, selectKey, orgQFilter, dateQFilter, whereQFilter);
    }

    private Object[] buildParams(CustomSource customSource, String selectKey, String whereFilter, Boolean ifOrgMaping, Map<String, QFilter> customFilter) {
        QFilter whereQFilter = this.buildWhereQfilter(customSource, whereFilter, customFilter);
        return this.buildParams(customSource, selectKey, whereQFilter, ifOrgMaping, customFilter);
    }

    private Object[] buildParams(CustomSource customSource, String selectKey, QFilter whereFilter, Boolean ifOrgMaping, Map<String, QFilter> customFilter) {
        QFilter orgQFilter = this.handlerOrgQfilter(customSource);
        QFilter dateQFilter = this.handlerDateQfilter(customSource);
        if (ifOrgMaping == null) {
            ifOrgMaping = false;
        }
        QFilter whereQFilter = whereFilter;
        QFilter orgMappingQfilter = null;
        if (ifOrgMaping.booleanValue() && (orgMappingQfilter = this.handlerOrgMappingQfilter(customSource)) != null) {
            whereQFilter.and(orgMappingQfilter);
        }
        selectKey = this.handlerSelectKey(customSource, selectKey);
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(selectKey).append(" from ").append(customSource != null ? customSource.getEntityname() : "").append(" where ").append(whereQFilter).append(" orgQfileter= ").append(orgQFilter).append(" dateQfilter= ").append(dateQFilter).append(" orgMappingQfilter=").append(orgMappingQfilter != null ? orgMappingQfilter : " none");
        logger.info(sql.toString());
        Object[] params = new Object[]{customSource, selectKey, orgQFilter, dateQFilter, whereQFilter};
        return params;
    }

    @Override
    public List<Map<String, Object>> queryGroupBizData(CustomSource customSource, List<String> selectKeyList, QFilter whereFilter, List<Long> groupDimIds) {
        String selectKey = String.join((CharSequence)",", selectKeyList);
        Object[] params = this.buildParams(customSource, selectKey, whereFilter, (Boolean)false, (Map<String, QFilter>)Collections.EMPTY_MAP);
        customSource = (CustomSource)params[0];
        selectKey = (String)params[1];
        QFilter orgQFilter = (QFilter)params[2];
        QFilter dateQFilter = (QFilter)params[3];
        QFilter whereQFilter = (QFilter)params[4];
        return this.queryGroupBizData(customSource, selectKeyList, orgQFilter, dateQFilter, whereQFilter, groupDimIds);
    }

    public List<Map<String, Object>> queryGroupBizData(CustomSource customSource, List<String> selectKeyList, QFilter orgQFilter, QFilter dateQFilter, QFilter whereFilter, List<Long> groupDimIds) {
        throw new NotSupportedException();
    }
}

