/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.customsource.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.business.customsource.CustomSourceDataService;
import kd.taxc.bdtaxr.business.customsource.DataQueryFactory;
import kd.taxc.bdtaxr.business.customsource.DataQueryService;
import kd.taxc.bdtaxr.business.customsource.DbQueryService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleConfigEnum;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.EntityUtils;
import kd.taxc.bdtaxr.common.utils.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.rule.RuleAccessUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CustomSourceDataServiceImpl
implements CustomSourceDataService {
    private static Log logger = LogFactory.getLog(CustomSourceDataServiceImpl.class);

    @Override
    public int queryBizDataCount(long orgId, String startDate, String endDate, long tableId, QFilter whereFilter, String accessLogic) {
        DataSet ds = this.queryBizDataRetDoc(orgId, startDate, endDate, tableId, "1", whereFilter, accessLogic);
        int count = 0;
        while (ds.hasNext()) {
            ds.next();
            ++count;
        }
        return count;
    }

    @Override
    public DataSet queryBizDataRetDoc(long orgId, String startDate, String endDate, long tableId, String selectKey, QFilter whereFilter, String accessLogic) {
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate), tableId);
        CustomSource customSource = this.setCustomSourceValue(tableId, raltionOrgIds, startDate, endDate, accessLogic, selectKey);
        return this.queryBizDataFromDB(customSource, selectKey, whereFilter);
    }

    @Override
    public DataSet queryBizDataRetDoc(long orgId, String startDate, String endDate, long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accessLogic) {
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate), tableId);
        CustomSource customSource = this.setCustomSourceValue(tableId, raltionOrgIds, startDate, endDate, accessLogic, selectKey);
        return this.queryBizDataFromDB(customSource, selectKey, whereFilter);
    }

    @Override
    public DataSet queryBizDataRetDoc(long orgId, String startDate, String endDate, long tableId, String selectKey, String selectKeyEntity, String whereFilter) {
        return this.queryBizDataRetDoc(orgId, startDate, endDate, tableId, selectKey, selectKeyEntity, whereFilter, null);
    }

    @Override
    public DataSet queryBizDataRetDoc(long orgId, String startDate, String endDate, long tableId, List<Long> fieldIds, String whereFilter, String accessLogic) {
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate), tableId);
        String selectKey = null;
        CustomSource customSource = this.setCustomSourceValue(tableId, raltionOrgIds, startDate, endDate, accessLogic, selectKey);
        customSource.setSelectKeyIds(fieldIds);
        customSource.setIfUseKeyId(true);
        return this.queryBizDataFromDB(customSource, selectKey, whereFilter);
    }

    @Override
    public DataSet queryBizDataRetDoc(long orgId, String startDate, String endDate, long tableId, List<Long> fieldIds, String whereFilter) {
        return this.queryBizDataRetDoc(orgId, startDate, endDate, tableId, fieldIds, whereFilter, null);
    }

    @Override
    public List<Map<String, Object>> queryBizDataRetList(long orgId, String startDate, String endDate, long tableId, String selectKey, String selectKeyEntity, String whereFilter) {
        return this.handlerResult(selectKey, this.queryBizDataRetDoc(orgId, startDate, endDate, tableId, selectKey, selectKeyEntity, whereFilter));
    }

    @Override
    public BigDecimal queryBizDataRetSum(List<Long> orgId, Date startDate, Date endDate, long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accesslogic) {
        CustomSource customSource = this.setCustomSourceValue(tableId, orgId, DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity);
        String sumKey = this.sumKey(customSource, selectKey);
        if (StringUtils.isEmpty((CharSequence)sumKey)) {
            return null;
        }
        BigDecimal sumAmount = this.queryBizDataFromDBSum(customSource, sumKey, whereFilter);
        return sumAmount;
    }

    @Override
    public BigDecimal queryBizDataRetSum(Long orgId, Date startDate, Date endDate, Long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accesslogic, Long categoryId) {
        Map<Long, QFilter> longQFilterMap = this.handledataSourceMappingMap(tableId, orgId, categoryId, startDate, endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        CustomSource customSource = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.setCustomSourceValue(tableId, raltionOrgIds, SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)), DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity) : this.setCustomSourceValue(tableId, raltionOrgIds, DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity);
        String sumKey = this.sumKey(customSource, selectKey);
        if (StringUtils.isEmpty((CharSequence)sumKey)) {
            return null;
        }
        BigDecimal sumAmount = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.queryBizDataFromDBSumWithOrgMapping(customSource, sumKey, whereFilter) : this.queryBizDataFromDBSum(customSource, sumKey, whereFilter);
        return sumAmount;
    }

    @Override
    public BigDecimal queryBizDataRetSum(Long orgId, Date startDate, Date endDate, Long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accesslogic, Long categoryId, QFilter customFilter) {
        Map<Long, QFilter> longQFilterMap = this.handledataSourceMappingMap(tableId, orgId, categoryId, startDate, endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        CustomSource customSource = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.setCustomSourceValue(tableId, raltionOrgIds, SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)), DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity) : this.setCustomSourceValue(tableId, raltionOrgIds, DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity);
        String sumKey = this.sumKey(customSource, selectKey);
        if (StringUtils.isEmpty((CharSequence)sumKey)) {
            return null;
        }
        BigDecimal sumAmount = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.queryBizDataFromDBSumWithOrgMapping(customSource, sumKey, whereFilter, customFilter) : this.queryBizDataFromDBSum(customSource, sumKey, whereFilter, customFilter);
        return sumAmount;
    }

    @Override
    public BigDecimal queryBizDataRetSum(Long orgId, Date startDate, Date endDate, Long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accesslogic, Map<String, QFilter> customFilter) {
        Map<Long, QFilter> longQFilterMap = this.handledataSourceMappingMap(tableId, orgId, null, startDate, endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        CustomSource customSource = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.setCustomSourceValue(tableId, raltionOrgIds, SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)), DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity) : this.setCustomSourceValue(tableId, raltionOrgIds, DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity);
        String sumKey = this.sumKey(customSource, selectKey);
        if (StringUtils.isEmpty((CharSequence)sumKey)) {
            return null;
        }
        BigDecimal sumAmount = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId) ? this.queryBizDataFromDBSumWithOrgMapping(customSource, sumKey, whereFilter, customFilter) : this.queryBizDataFromDBSum(customSource, sumKey, whereFilter, customFilter);
        return sumAmount;
    }

    @Override
    public List<Map<String, Object>> queryGroupBizData(Long orgId, Date startDate, Date endDate, Long tableId, List<String> selectKeyList, QFilter whereFilter, String accesslogic, List<Long> groupDimIds) {
        String startStr = DateUtils.formatHMS(startDate);
        String endStr = DateUtils.formatHMS(endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        String selectKeyStr = String.join((CharSequence)",", selectKeyList);
        CustomSource customSource = this.setCustomSourceValue(tableId, raltionOrgIds, startStr, endStr, accesslogic, selectKeyStr);
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryGroupBizData(customSource, selectKeyList, whereFilter, groupDimIds);
    }

    @Override
    public List<Map<String, Object>> queryGroupBizData(Long orgId, Date startDate, Date endDate, Long tableId, String selectKey, String selectKeyEntity, String whereFilter, String accesslogic, Long categoryId) {
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1aorgId" + orgId);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1astartDate" + startDate);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1aendDate" + endDate);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1atableId" + tableId);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1aselectKey" + selectKey);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1aselectKeyEntity" + selectKeyEntity);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1awhereFilter" + whereFilter);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1aaccesslogic" + accesslogic);
        logger.info("\u5206\u7ef4\u5ea6\u53d6\u6570\u63a5\u53e3\u5165\u53c2\uff1acategoryId" + categoryId);
        Map<Long, QFilter> longQFilterMap = this.handledataSourceMappingMap(tableId, orgId, categoryId, startDate, endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        boolean hasDataSourceMapping = ObjectUtils.isNotEmpty(longQFilterMap) && longQFilterMap.containsKey(tableId);
        CustomSource customSource = hasDataSourceMapping ? this.setCustomSourceValue(tableId, raltionOrgIds, SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)), DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity) : this.setCustomSourceValue(tableId, raltionOrgIds, DateUtils.formatHMS(startDate), DateUtils.formatHMS(endDate), accesslogic, selectKey, selectKeyEntity);
        CustomSource.EntityField orgState = customSource.getOrgstate();
        String orgFileName = orgState.getFieldname();
        CustomSource.EntityField accessmapstate = customSource.getAccessmapstate();
        String mainEntity = customSource.getEntityname();
        String subEntity = customSource.getSubname();
        String accessField = null;
        String selectAccessField = null;
        if (accessmapstate != null && hasDataSourceMapping) {
            accessField = accessmapstate.getFieldname();
            selectAccessField = this.generateKey(mainEntity, subEntity, accessmapstate.getFieldsubname(), accessField);
        }
        String selectField = this.generateKey(mainEntity, subEntity, customSource.getSelectKeyEntity(), selectKey);
        StringBuilder selectString = new StringBuilder(selectField);
        String selectOrgField = this.generateKey(mainEntity, subEntity, orgState.getFieldsubname(), orgFileName);
        CustomSourceDataServiceImpl.buildKey(selectString, selectOrgField);
        if (StringUtils.isNotBlank((CharSequence)selectAccessField)) {
            CustomSourceDataServiceImpl.buildKey(selectString, selectAccessField);
        }
        String queryKey = selectString.toString();
        DataSet data = hasDataSourceMapping ? this.queryBizDataSetFromDBSumWithOrgMapping(customSource, queryKey, whereFilter) : this.queryBizDataFromDB(customSource, queryKey, whereFilter);
        List<Map<String, Object>> result = this.handlerGroupResult(customSource, selectField, data, orgId, categoryId, hasDataSourceMapping, tableId, startDate, endDate);
        logger.info("\u5206\u7ef4\u5ea6\u8ba1\u63d0\u51fa\u53c2\uff1a" + JSON.toJSONString(result));
        return result;
    }

    private String sumKey(CustomSource customSource, String selectKey) {
        String[] key = this.splitSelectKey(selectKey);
        String mainEntity = customSource.getEntityname();
        String subEntity = customSource.getSubname();
        String selectKeyEntity = customSource.getSelectKeyEntity();
        String selectField = key[0];
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        if (customSource.getEntityname().equals("tpo_declare_main_tsd") || customSource.getEntityname().equals("tpo_declare_main_tsc")) {
            return selectKey;
        }
        if (null != mainEntityType.findProperty(selectField)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)mainEntity)) {
                return "sum(" + selectField + ")";
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)subEntity)) {
                if (mainEntityType.findProperty(selectKeyEntity) instanceof EntryProp) {
                    return "sum(" + subEntity + "." + selectField + ")";
                }
                if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp) {
                    return "sum(" + mainEntityType.findProperty(selectKeyEntity).getParent().getName() + "." + selectKeyEntity + "." + selectField + ")";
                }
                return "sum(" + selectField + ")";
            }
            if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp && StringUtils.equalsIgnoreCase((CharSequence)mainEntityType.findProperty(selectKeyEntity).getParent().getName(), (CharSequence)subEntity)) {
                return "sum(" + subEntity + "." + selectKeyEntity + "." + selectField + ")";
            }
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)selectKeyEntity);
        if (null == entityType || null == entityType.findProperty(selectField)) {
            return null;
        }
        return "sum(" + selectField + ")";
    }

    private String generateKeyByFieldId(List<Long> fieldList, CustomSource customeSource) {
        StringBuilder selectKeys = new StringBuilder();
        for (Long fieldId : fieldList) {
            CustomSource.EntityField f = customeSource.getDatasourceFieldById(fieldId);
            String fieldKey = f.getFieldname();
            String entityKey = f.getFieldsubname();
            if (selectKeys.length() > 0) {
                selectKeys.append(",");
            }
            if (entityKey.equals(customeSource.getEntityname())) {
                selectKeys.append(fieldKey);
                continue;
            }
            selectKeys.append(entityKey).append(".").append(fieldKey);
        }
        return selectKeys.toString();
    }

    private String generateKey(String mainEntity, String subEntity, String selectKeyEntity, String selectKey) {
        String[] keys = this.splitSelectKey(selectKey);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        if (mainEntity.equals("tpo_declare_main_tsd") || mainEntity.equals("tpo_declare_main_tsc")) {
            return selectKey;
        }
        String selectField = keys[0];
        if (null != mainEntityType.findProperty(selectField)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)mainEntity)) {
                return selectField;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)subEntity)) {
                if (mainEntityType.findProperty(selectKeyEntity) instanceof EntryProp) {
                    return subEntity + "." + selectField;
                }
                if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp) {
                    return "sum(" + mainEntityType.findProperty(selectKeyEntity).getParent().getName() + "." + selectKeyEntity + "." + selectField + ")";
                }
                return selectField;
            }
            if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp && StringUtils.equalsIgnoreCase((CharSequence)mainEntityType.findProperty(selectKeyEntity).getParent().getName(), (CharSequence)subEntity)) {
                return subEntity + "." + selectKeyEntity + "." + selectField;
            }
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)selectKeyEntity);
        if (null == entityType || null == entityType.findProperty(selectField)) {
            return null;
        }
        return selectField;
    }

    private static void buildKey(StringBuilder stringBuilder, String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (StringUtils.isNotBlank((CharSequence)stringBuilder)) {
                stringBuilder.append(",").append(key);
            } else {
                stringBuilder.append(key);
            }
        }
    }

    private DataSet queryBizDataFromDB(CustomSource customSource, String selectKey, String whereFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizData(customSource, selectKey, whereFilter);
    }

    private DataSet queryBizDataFromDB(CustomSource customSource, String selectKey, QFilter whereFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizData(customSource, selectKey, whereFilter);
    }

    private BigDecimal queryBizDataFromDBSum(CustomSource customSource, String selectKey, String whereFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSum(customSource, selectKey, whereFilter);
    }

    private BigDecimal queryBizDataFromDBSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSumWithOrgMapping(customSource, selectKey, whereFilter);
    }

    private BigDecimal queryBizDataFromDBSum(CustomSource customSource, String selectKey, String whereFilter, QFilter customFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSum(customSource, selectKey, whereFilter, customFilter);
    }

    private BigDecimal queryBizDataFromDBSum(CustomSource customSource, String selectKey, String whereFilter, Map<String, QFilter> customFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSum(customSource, selectKey, whereFilter, customFilter);
    }

    private BigDecimal queryBizDataFromDBSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter, QFilter customFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSumWithOrgMapping(customSource, selectKey, whereFilter, customFilter);
    }

    private BigDecimal queryBizDataFromDBSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter, Map<String, QFilter> customFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryDynamicObjectBizDataSumWithOrgMapping(customSource, selectKey, whereFilter, customFilter);
    }

    private DataSet queryBizDataSetFromDBSumWithOrgMapping(CustomSource customSource, String selectKey, String whereFilter) {
        DataQueryService dataQueryService = DataQueryFactory.getInstance().getDataQueryService(customSource.getEntityname(), customSource.getSubname());
        return dataQueryService.queryBizDataSetSumWithOrgMapping(customSource, selectKey, whereFilter);
    }

    private CustomSource setCustomSourceValue(long tableId, Object orgId, String startDate, String endDate, String accesslogic, String selectKey) {
        return this.setCustomSourceValue(tableId, orgId, startDate, endDate, accesslogic, selectKey, null);
    }

    private CustomSource setCustomSourceValue(long tableId, Object orgId, String startDate, String endDate, String accessLogic, String selectKey, String selectKeyEntity) {
        CustomSource customSource = DbQueryService.getInstance().queryCustomSource(tableId);
        customSource.setSelectKey(selectKey);
        customSource.setSelectKeyEntity(selectKeyEntity);
        customSource.getOrgstate().setValue(orgId);
        Date tempStartDate = DateUtils.getDayFirst(DateUtils.stringToDate(startDate));
        Date tempEndDate = DateUtils.getDayLast(DateUtils.stringToDate(endDate));
        ImmutablePair<Date, Date> dataPair = ImmutablePair.of((Object)tempStartDate, (Object)tempEndDate);
        if (StringUtils.isNotEmpty((CharSequence)accessLogic)) {
            dataPair = this.setQueryDateByAccessLogic(tempStartDate, tempEndDate, accessLogic);
        }
        if (null != customSource.getDatastate()) {
            customSource.getDatastate().setValue(new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        } else {
            customSource.getYearstate().setValue(new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        }
        this.handleCustomDateOrYearState(customSource);
        return customSource;
    }

    private CustomSource setCustomSourceValue(long tableId, Object orgId, String orgMappingQfilter, String startDate, String endDate, String accessLogic, String selectKey, String selectKeyEntity) {
        CustomSource customSource = DbQueryService.getInstance().queryCustomSource(tableId);
        customSource.setSelectKey(selectKey);
        customSource.setSelectKeyEntity(selectKeyEntity);
        customSource.getOrgstate().setValue(orgId);
        customSource.getAccessmapstate().setValue(JSONObject.parseObject((String)orgMappingQfilter).get((Object)"value"));
        Date tempStartDate = DateUtils.getDayFirst(DateUtils.stringToDate(startDate));
        Date tempEndDate = DateUtils.getDayLast(DateUtils.stringToDate(endDate));
        ImmutablePair<Date, Date> dataPair = ImmutablePair.of((Object)tempStartDate, (Object)tempEndDate);
        if (StringUtils.isNotEmpty((CharSequence)accessLogic)) {
            dataPair = this.setQueryDateByAccessLogic(tempStartDate, tempEndDate, accessLogic);
        }
        if (null != customSource.getDatastate()) {
            customSource.getDatastate().setValue(new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        } else {
            customSource.getYearstate().setValue(new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        }
        this.handleCustomDateOrYearState(customSource);
        return customSource;
    }

    private void handleCustomDateOrYearState(CustomSource customSource) {
        String fieldEntity;
        CustomSource.EntityField yearState;
        String fieldEntity2;
        String mainEntity = customSource.getEntityname();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        CustomSource.EntityField dataState = customSource.getDatastate();
        if (null != dataState && !StringUtils.equalsIgnoreCase((CharSequence)mainEntity, (CharSequence)(fieldEntity2 = dataState.getFieldsubname())) && null != mainEntityType.findProperty(fieldEntity2)) {
            dataState.setFieldname(fieldEntity2 + "." + dataState.getFieldname());
        }
        if (null != (yearState = customSource.getYearstate()) && !StringUtils.equalsIgnoreCase((CharSequence)mainEntity, (CharSequence)(fieldEntity = yearState.getFieldsubname())) && null != mainEntityType.findProperty(fieldEntity)) {
            yearState.setFieldname(fieldEntity + "." + yearState.getFieldname());
        }
    }

    private List<Map<String, Object>> handlerResult(String selectKey, DataSet dataSet) {
        String[] key = this.splitSelectKey(selectKey);
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        if (dataSet == null) {
            return list;
        }
        for (Row subRow : dataSet.copy()) {
            HashMap<String, Object> map = new HashMap<String, Object>(key.length);
            for (String k : key) {
                map.put(k, subRow.get(k));
            }
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> handlerGroupResult(CustomSource customSource, String selectKey, DataSet dataSet, Long orgId, Long categoryId, Boolean isHasMapping, Long tableId, Date startDate, Date endDate) {
        String provisiondimension = CustomSourceDataServiceImpl.getProvisiondimension(orgId, categoryId, startDate, endDate);
        Long defalulOrgId = null;
        DynamicObject businessdimensionObj = null;
        Long businessdimensionId = null;
        DynamicObject businessdimension = CustomSourceDataServiceImpl.getBusinessdimension(orgId, categoryId, startDate, endDate);
        if (StringUtils.isNotEmpty((CharSequence)provisiondimension)) {
            defalulOrgId = this.buildDefaultOrg(orgId, tableId, provisiondimension, defalulOrgId);
            if (provisiondimension.contains("businessdimension") && businessdimension != null) {
                businessdimensionId = businessdimension.getLong("ruleentity.rule.businessdimension.fbasedataid.id");
                businessdimensionObj = this.getDefaultBusinessDimensionObj(orgId, categoryId, startDate, endDate, businessdimensionObj, businessdimensionId);
            }
        }
        CustomSource.EntityField orgState = customSource.getOrgstate();
        String orgFileName = orgState.getFieldname();
        CustomSource.EntityField accessmapstate = customSource.getAccessmapstate();
        String selectOrgField = this.generateKey(customSource.getEntityname(), customSource.getSubname(), orgState.getFieldsubname(), orgFileName);
        String selectAccessField = null;
        if (accessmapstate != null) {
            String accessField = accessmapstate.getFieldname();
            selectAccessField = this.generateKey(customSource.getEntityname(), customSource.getSubname(), accessmapstate.getFieldsubname(), accessField);
        }
        String entityName = null;
        TaxResult<List<DynamicObject>> result = null;
        Map<Object, DynamicObject> mappingObjects = null;
        if (businessdimensionId != null) {
            result = TaxcOrgMappingDataServiceHelper.getOrgMappingPlanByIds(Collections.singletonList(businessdimensionId));
            if (result != null && CollectionUtils.isNotEmpty((Collection)result.getData())) {
                entityName = result.getData().get(0).getDynamicObject("mapobject").getString("id");
            }
            if (accessmapstate != null && accessmapstate.getValue() != null) {
                mappingObjects = CustomSourceDataServiceImpl.getMappingObject((List)accessmapstate.getValue(), entityName);
            }
        }
        if (dataSet == null || dataSet.isEmpty()) {
            Map<String, Object> dataMap = this.buildDefaultMap();
            if (defalulOrgId == null) {
                dataMap.put("accountorg", null);
            } else {
                dataMap.put("accountorg", defalulOrgId);
            }
            if (businessdimensionObj != null) {
                this.buildDefaultBusinessDimension(businessdimensionObj, dataMap);
            }
            return Collections.singletonList(dataMap);
        }
        return this.buildData(selectKey, dataSet, isHasMapping, provisiondimension, defalulOrgId, businessdimensionObj, businessdimension, selectOrgField, selectAccessField, entityName, mappingObjects);
    }

    private DynamicObject getDefaultBusinessDimensionObj(Long orgId, Long categoryId, Date startDate, Date endDate, DynamicObject businessdimensionObj, Long businessdimensionId) {
        Optional<DynamicObject> first;
        DynamicObjectCollection objs = CustomSourceDataServiceImpl.getOrgMappingByOrgIdAndCategoryIdAndGroup(orgId, categoryId, businessdimensionId, startDate, endDate);
        if (objs != null && objs.size() > 0 && (first = objs.stream().filter(o -> o.getBoolean("entryentity.isdefault")).findFirst()).isPresent()) {
            businessdimensionObj = first.get();
        }
        return businessdimensionObj;
    }

    private Map<String, Object> buildDefaultMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fetchamount", BigDecimal.ZERO);
        dataMap.put("bizdimensiontype", null);
        dataMap.put("bizdimensionname", null);
        dataMap.put("bizdimensionid", null);
        dataMap.put("accountorg", null);
        return dataMap;
    }

    private Long buildDefaultOrg(Long orgId, Long tableId, String provisiondimension, Long defalulOrgId) {
        String orgFunc = CustomSourceDataServiceImpl.getOrgFunc(tableId);
        if (!OrgFuncEnum.ACCOUNT.getNumber().equals(orgFunc) || provisiondimension.contains("accountorg")) {
            defalulOrgId = CustomSourceDataServiceImpl.getDefaultAccountingOrgIdByTaxcOrgId(orgId);
        }
        return defalulOrgId;
    }

    private List<Map<String, Object>> buildData(String selectKey, DataSet dataSet, Boolean isHasMapping, String provisiondimension, Long defalulOrgId, DynamicObject businessdimensionObj, DynamicObject businessdimension, String selectOrgField, String selectAccessField, String entityName, Map<Object, DynamicObject> mappingObjects) {
        GroupbyDataSet groupbyDataSet = isHasMapping != false && StringUtils.isNotBlank((CharSequence)selectAccessField) ? dataSet.copy().groupBy(new String[]{selectOrgField, selectAccessField}) : dataSet.copy().groupBy(new String[]{selectOrgField});
        groupbyDataSet.sum(selectKey);
        DataSet newDataSet = groupbyDataSet.finish();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (Row subRow : newDataSet.copy()) {
            Map<String, Object> dataMap = this.buildDefaultMap();
            dataMap.put("fetchamount", subRow.get(selectKey));
            if (subRow.get(selectOrgField) != null) {
                dataMap.put("accountorg", subRow.get(selectOrgField));
            } else {
                dataMap.put("accountorg", defalulOrgId);
            }
            if (provisiondimension.contains("businessdimension")) {
                if (mappingObjects != null && mappingObjects.containsKey(subRow.get(selectAccessField))) {
                    dataMap.put("bizdimensiontype", entityName);
                    dataMap.put("bizdimensionname", mappingObjects.get(subRow.get(selectAccessField)).getString("name"));
                    dataMap.put("bizdimensionid", subRow.get(selectAccessField));
                } else if (businessdimensionObj != null) {
                    this.buildDefaultBusinessDimension(businessdimensionObj, dataMap);
                }
            }
            data.add(dataMap);
        }
        return data;
    }

    private void buildDefaultBusinessDimension(DynamicObject businessdimensionObj, Map<String, Object> dataMap) {
        dataMap.put("bizdimensiontype", businessdimensionObj.get("group.mapobject.id"));
        dataMap.put("bizdimensionname", businessdimensionObj.getString("entryentity.businessname"));
        String id = businessdimensionObj.getString("entryentity.businessid");
        boolean longPk = EntityUtils.isLongPk(businessdimensionObj.getString("group.mapobject.id"));
        dataMap.put("bizdimensionid", longPk ? Long.valueOf(id) : id);
    }

    private String[] splitSelectKey(String selectKey) {
        String[] key = selectKey.split(",");
        return key;
    }

    private ImmutablePair<Date, Date> setQueryDateByAccessLogic(Date startDate, Date endDate, String accessLogic) {
        if (accessLogic.equals(RuleConfigEnum.CUMULATIVE.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfYear(startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.TOBEGIN.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfMonth(startDate);
            endDate = DateUtils.getLastDateOfMonth(startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.TOEND.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfMonth(endDate);
            endDate = DateUtils.getLastDateOfMonth(endDate);
        }
        if (accessLogic.equals(RuleConfigEnum.SQQMS.getRuleConfigCode())) {
            startDate = DateUtils.addMonth(startDate, -1);
            endDate = DateUtils.getLastDateOfMonth(startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.SNLJS.getRuleConfigCode())) {
            Date tempStartDate = startDate;
            startDate = DateUtils.getFirstDateOfYear(DateUtils.addYear(startDate, -1));
            endDate = DateUtils.getLastDateOfYear(DateUtils.addYear(tempStartDate, -1));
        }
        if (accessLogic.equals(RuleConfigEnum.SNTQS.getRuleConfigCode())) {
            startDate = DateUtils.addMonth(startDate, -12);
            endDate = DateUtils.addMonth(endDate, -12);
        }
        if (accessLogic.equals(RuleConfigEnum.SNXQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay(startDate, endDate)) {
                startDate = DateUtils.addTime(startDate, -1, 0, 1);
                endDate = DateUtils.addTime(endDate, -1, 0, 1);
            } else {
                int monthOffSet = DateUtils.getMonthSpan(startDate, endDate);
                startDate = DateUtils.addMonth(startDate, -12 + monthOffSet);
                endDate = DateUtils.addMonth(endDate, -12 + monthOffSet);
            }
        }
        if (accessLogic.equals(RuleConfigEnum.SNXXQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay(startDate, endDate)) {
                startDate = DateUtils.addTime(startDate, -1, 0, 2);
                endDate = DateUtils.addTime(endDate, -1, 0, 2);
            } else {
                int monthOffSet = DateUtils.getMonthSpan(startDate, endDate);
                startDate = DateUtils.addMonth(startDate, -12 + monthOffSet * 2);
                endDate = DateUtils.addMonth(endDate, -12 + monthOffSet * 2);
            }
        }
        if (accessLogic.equals(RuleConfigEnum.SNZHQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay(startDate, endDate)) {
                Date lastYear = DateUtils.addTime(startDate, -1, 0, 0);
                Date lastYearLastDay = DateUtils.getLastDateOfYear(lastYear);
                startDate = DateUtils.getDayFirst(lastYearLastDay);
                endDate = DateUtils.getDayLast(lastYearLastDay);
            } else {
                int monthOffSet = DateUtils.getMonthSpan(startDate, endDate);
                endDate = DateUtils.addMonth(endDate, -12);
                endDate = DateUtils.getLastDateOfYear(endDate);
                endDate = DateUtils.getLastDateOfMonth(endDate);
                startDate = DateUtils.addMonth(endDate, -monthOffSet + 1);
                startDate = DateUtils.getFirstDateOfMonth(startDate);
            }
        }
        return ImmutablePair.of((Object)startDate, (Object)endDate);
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    private Map<Long, QFilter> handledataSourceMappingMap(Long tableId, Long orgId, Long categoryId, Date startDate, Date endDate) {
        Map<Long, QFilter> dataSourceResultMap = new HashMap<Long, QFilter>(8);
        TaxResult<Map<Long, Map<String, Object>>> dataSourceMappingList = TaxcOrgMappingDataServiceHelper.getDataSourceMappingList(Collections.singletonList(tableId), orgId, startDate, endDate, categoryId);
        if (ObjectUtils.isNotEmpty(dataSourceMappingList) && dataSourceMappingList.isSuccess() && ObjectUtils.isNotEmpty(dataSourceMappingList.getData())) {
            Map<Long, Map<String, Object>> dataSourceMap = dataSourceMappingList.getData();
            dataSourceResultMap = FilterBuilderUtils.buildMappingQfilter(dataSourceMap);
        }
        return dataSourceResultMap;
    }

    private List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, Long tableId) {
        DynamicObject dataSourceObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tableId, (String)"tctb_custom_datasource");
        String entryName = dataSourceObject.getString("entityname");
        Map<String, List<Long>> orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, skssqq, skssqz);
        Map<String, String> fieldMap = RuleAccessUtil.getTableFields(tableId);
        String org = fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = TaxOrgTakeRelationServiceHelper.getOrgListByRelation(orgRelationMap, orgList, entryName, entityKey, orgFieldName);
        }
        return orgList;
    }

    private static String getProvisiondimension(Long orgId, Long categoryId, Date startDate, Date endDate) {
        Optional<DynamicObject> first;
        TaxResult<DynamicObjectCollection> taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), categoryId, 1L, startDate, endDate);
        String provisiondimension = "";
        if (taxResult != null && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData())) && (first = taxResult.getData().stream().filter(o -> o.getBoolean("ruleentity.rule.isdimprovision")).findFirst()).isPresent()) {
            provisiondimension = first.get().getString("ruleentity.rule.provisiondimension");
        }
        return provisiondimension;
    }

    private static DynamicObject getBusinessdimension(Long orgId, Long categoryId, Date startDate, Date endDate) {
        Optional<DynamicObject> first;
        TaxResult<DynamicObjectCollection> taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), categoryId, 1L, startDate, endDate);
        if (taxResult != null && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData())) && (first = taxResult.getData().stream().filter(o -> o.getBoolean("ruleentity.rule.isdimprovision") && o.getString("ruleentity.rule.provisiondimension").contains("businessdimension")).findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    private static Long getDefaultAccountingOrgIdByTaxcOrgId(Long taxOrgId) {
        TaxResult<Long> result = OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId(taxOrgId);
        if (result != null && result.isSuccess() && result.getData() != null) {
            return result.getData();
        }
        return null;
    }

    private static String getOrgFunc(Long tableId) {
        Map<String, String> fieldMap = RuleAccessUtil.getTableFields(tableId);
        String entityName = fieldMap.get("entity");
        String org = fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entityName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            return MetadataUtil.getOrgFun(entityName, entityKey, orgFieldName);
        }
        return null;
    }

    private static DynamicObjectCollection getOrgMappingByOrgIdAndCategoryIdAndGroup(Long orgId, Long categoryId, Long mappingObjectId, Date startDate, Date endDate) {
        TaxResult<DynamicObjectCollection> result = TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryIdAndGroup(orgId, categoryId, mappingObjectId, startDate, endDate);
        if (result != null && result.isSuccess() && result.getData() != null) {
            return result.getData();
        }
        return null;
    }

    private static Map<Object, DynamicObject> getMappingObject(List<Object> ids, String entityName) {
        try {
            DynamicObject[] objects;
            boolean longPk = EntityUtils.isLongPk(entityName);
            if (longPk) {
                List idList = ids.stream().map(o -> Long.valueOf(String.valueOf(o))).collect(Collectors.toList());
                objects = BusinessDataServiceHelper.load((String)entityName, (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            } else {
                List idList = ids.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
                objects = BusinessDataServiceHelper.load((String)entityName, (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            }
            if (objects != null && objects.length > 0) {
                return Arrays.stream(objects).collect(Collectors.toMap(d -> d.get("id"), v -> v));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6620\u5c04\u5f02\u5e38", (Throwable)e);
            logger.error("\u67e5\u8be2\u6620\u5c04\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }
}

