/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.prescripted;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedDao;
import kd.taxc.bdtaxr.business.prescripted.service.ScriptedExecuteService;
import kd.taxc.bdtaxr.common.dto.ScriptedExecuteParamsDto;
import kd.taxc.bdtaxr.common.dto.ScriptedExecuteResultDto;
import kd.taxc.bdtaxr.common.enums.prescripted.DeployStatusEnum;
import kd.taxc.bdtaxr.common.enums.prescripted.ScriptedExecuteEnum;

public class PreScriptedBusiness {
    private static Log logger = LogFactory.getLog(PreScriptedBusiness.class);

    public static DynamicObject[] queryPreScriptedByIds(List<Long> ids) {
        return PreScriptedDao.queryPreScriptedByIds(ids);
    }

    public static DynamicObject[] queryAllUnDepolyScripted() {
        return PreScriptedDao.queryAllUnDepolyScripted();
    }

    public static void deployPreScripted(DynamicObject obj) {
        try {
            logger.info("\u90e8\u7f72\uff1a{}\uff0c\u5f00\u59cb\u6267\u884c\u3002", (Object)obj.getString("name"));
            long start = System.currentTimeMillis();
            String appId = obj.getDynamicObject("bizapp").getString("number");
            String cloudId = PreScriptedBusiness.queryBizCloudIdByBizAppId(appId);
            boolean isSuccess = true;
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            Long executeTime = 0L;
            for (DynamicObject entry : entries) {
                try {
                    if (DeployStatusEnum.DEPLOYED.getValue().equals(entry.getString("deploystatus_entry"))) continue;
                    entry.set("deploystatus_entry", (Object)DeployStatusEnum.DEPLOYING.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                    ScriptedExecuteParamsDto params = new ScriptedExecuteParamsDto();
                    params.setPrescriptedid(obj.getLong("id"));
                    params.setPrescriptedentryid(entry.getLong("id"));
                    params.setFilename(entry.getString("filename"));
                    params.setBizobjNumber(entry.getDynamicObject("bizobj").getString("number"));
                    params.setScriptedplugin(entry.getString("scriptedplugin"));
                    params.setAppId(appId);
                    params.setCloudId(cloudId);
                    ScriptedExecuteService executeService = ScriptedExecuteEnum.getHandler(entry.getString("filetype"));
                    ScriptedExecuteResultDto resultDto = executeService.scriptedExecute(params);
                    entry.set("deploystatus_entry", (Object)DeployStatusEnum.DEPLOYED.getValue());
                    entry.set("executetime_entry", (Object)resultDto.getExecuteTime());
                    executeTime = executeTime + resultDto.getExecuteTime();
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
                catch (Exception e) {
                    logger.error("{}\u90e8\u7f72\u5931\u8d25", (Object)entry.getString("filename"), (Object)e);
                    isSuccess = false;
                    entry.set("deploystatus_entry", (Object)DeployStatusEnum.DEPLOYFAIL.getValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
            }
            if (isSuccess) {
                obj.set("deploystatus", (Object)DeployStatusEnum.DEPLOYED.getValue());
                obj.set("executetime", (Object)executeTime);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            } else {
                obj.set("deploystatus", (Object)DeployStatusEnum.DEPLOYFAIL.getValue());
                obj.set("executetime", (Object)executeTime);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            logger.info("\u90e8\u7f72\uff1a{}\uff0c\u8017\u65f6 {}", (Object)obj.getString("name"), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            logger.error("\u90e8\u7f72\u5931\u8d25", (Throwable)ex);
            obj.set("deploystatus", (Object)DeployStatusEnum.DEPLOYFAIL.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    public static String queryBizCloudIdByBizAppId(String appId) {
        QFilter bizappidQfilter = new QFilter("number", "=", (Object)appId);
        DynamicObjectCollection bizappObj = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"bizcloud.number as bizcloudnumber", (QFilter[])new QFilter[]{bizappidQfilter});
        if (bizappObj == null || bizappObj.size() == 0) {
            return null;
        }
        return ((DynamicObject)bizappObj.get(0)).getString("bizcloudnumber");
    }

    public static String deployPreScriptedWithJob(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            obj.set("deploystatus", (Object)DeployStatusEnum.DEPLOYING.getValue());
            obj.set("deploycount", (Object)(obj.getInt("deploycount") + 1));
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        List ids = Arrays.stream(objs).map(v -> v.getLong("id")).collect(Collectors.toList());
        HashMap params = new HashMap(8);
        params.put("ids", ids);
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.REALTIME);
        job.setName(ResManager.loadKDString((String)"\u9884\u7f6e\u811a\u672c\u90e8\u7f72\u4efb\u52a1", (String)"PreScriptedBusiness_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        job.setTaskClassname("kd.taxc.bdtaxr.business.prescripted.task.PreScriptedTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setId(UUID.randomUUID().toString());
        job.setParams(params);
        logger.info("JobClient dispatch");
        return JobClient.dispatch((JobInfo)job);
    }

    public static void resetDeployPreScripted(DynamicObject obj) {
        obj.set("deploystatus", (Object)DeployStatusEnum.UNDEPLOY.getValue());
        obj.set("deploycount", (Object)0);
        obj.set("executetime", null);
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            entry.set("deploystatus_entry", (Object)DeployStatusEnum.UNDEPLOY.getValue());
            entry.set("executetime_entry", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }
}

