/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.prescripted;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedFileDao;

public class PreScriptedFileBusiness {
    private static Log logger = LogFactory.getLog(PreScriptedFileBusiness.class);

    public static void savePreScriptedFile(Long prescriptedid, Long prescriptedentryid, String content) {
        DynamicObject obj = PreScriptedFileDao.queryPreScriptedFile(prescriptedid, prescriptedentryid);
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_prescriptedfile");
            obj.set("prescripted", (Object)prescriptedid);
            obj.set("prescriptedentry", (Object)prescriptedentryid);
        }
        obj.set("content_tag", (Object)content);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static DynamicObject queryPreScriptedFileContent(Long prescriptedid, Long prescriptedentryid) {
        return PreScriptedFileDao.queryPreScriptedFileContent(prescriptedid, prescriptedentryid);
    }

    public static void deletePreScriptedFile(Long prescriptedid) {
        PreScriptedFileDao.deletePreScriptedFile(prescriptedid);
    }

    public static void deleteNotRelatePreScriptedFile(Long prescriptedid, List<Long> prescriptedentryids) {
        PreScriptedFileDao.deleteNotRelatePreScriptedFile(prescriptedid, prescriptedentryids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileContent(String fileUrl) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        int temp = 0;
        int len = 0;
        byte[] bt = null;
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>();
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                if (p.length < 2) continue;
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            bt = new byte[0x500000];
            while ((temp = inStream.read()) != -1) {
                bt[len] = (byte)temp;
                ++len;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return bt;
    }
}

