/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.tpo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.JSONUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.enums.tpo.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.utils.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;

public class DeclareMainTableBusiness {
    private static final Log logger = LogFactory.getLog(DeclareMainTableBusiness.class);

    public static TaxResult updateDeclareMainTable(List<DynamicObject> declares, DeclareOperationEnum operate, String source) {
        Map<Long, DynamicObject> declareMap = declares.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (k1, k2) -> k2));
        List<Long> ids = declares.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Map<Long, String> idVersionMap = DeclareMainServiceHelper.queryModelVersionByIds(ids).getData();
        if (CollectionUtils.isEmpty(idVersionMap)) {
            logger.info("idVersionMap isEmpty.");
            return ServiceInvokeUtils.createTaxResult(Map.class, ServiceResultUtils.returnResultHandler(false, "-1", "updateDeclareMainTable failure.", null));
        }
        ArrayList<DynamicObject> model2List = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> model3List = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, String> entry : idVersionMap.entrySet()) {
            if (ModelVersionEnum.MODEL3.getVersion().equalsIgnoreCase(entry.getValue())) {
                model3List.add(declareMap.get(entry.getKey()));
                continue;
            }
            model2List.add(declareMap.get(entry.getKey()));
        }
        if (model2List.size() > 0) {
            logger.info("updateDeclareMainTable.update model2 start.");
            List<DynamicObject> model2Declares = DeclareMainTableBusiness.transferData(declares);
            DeclareMainTableBusiness.batchUpdate(model2Declares);
            List<Long> model2Ids = model2Declares.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            try {
                DeclareMainServiceHelper.syncModel2DataToModel3(model2Ids, operate);
            }
            catch (Exception e) {
                logger.error(String.format("\u4e3b\u52a8\u540c\u6b65\u66f4\u65b0model3.0\u5904\u7406\u5f02\u5e38\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a%s \u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", operate != null ? operate.getOperation() : "", e.getMessage()), (Throwable)e);
            }
            try {
                DeclareMainTableBusiness.afterMainTableChanged(model2Ids, ModelVersionEnum.MODEL2, operate, source);
            }
            catch (Exception e) {
                logger.error(String.format("\u4e3b\u8868\u6539\u53d8\u540e\u5904\u7406\u5f02\u5e38\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a%s \u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", operate != null ? operate.getOperation() : "", e.getMessage()), (Throwable)e);
            }
            DeclareMainTableBusiness.triggerDeclareMainEvent(model2Ids, model2Declares, ModelVersionEnum.MODEL2, operate, source, null);
        }
        if (model3List.size() > 0) {
            logger.info("updateDeclareMainTable.update model3 start.");
            DeclareMainTableBusiness.batchUpdate(model3List);
            List<Long> model3Ids = declares.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            try {
                DeclareMainTableBusiness.afterMainTableChanged(model3Ids, ModelVersionEnum.MODEL3, operate, source);
            }
            catch (Exception e) {
                logger.error(String.format("\u4e3b\u8868\u6539\u53d8\u540e\u5904\u7406\u5f02\u5e38\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a%s \u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", operate != null ? operate.getOperation() : "", e.getMessage()), (Throwable)e);
            }
            DeclareMainTableBusiness.triggerDeclareMainEvent(model3Ids, model3List, ModelVersionEnum.MODEL3, operate, source, null);
        }
        return ServiceInvokeUtils.buildTaxResult(String.class, "success.");
    }

    private static void batchUpdate(List<DynamicObject> declares) {
        HashMap<String, List> declareMap = new HashMap<String, List>(10);
        for (DynamicObject dynamicObject : declares) {
            declareMap.computeIfAbsent(dynamicObject.getDataEntityType().getName(), v -> new ArrayList(10)).add(dynamicObject);
        }
        if (!CollectionUtils.isEmpty(declareMap)) {
            for (Map.Entry entry : declareMap.entrySet()) {
                SaveServiceHelper.update((DynamicObject[])((List)entry.getValue()).toArray(new DynamicObject[((List)entry.getValue()).size()]));
            }
        }
    }

    private static void afterMainTableChanged(List<Long> ids, ModelVersionEnum version, DeclareOperationEnum operate, String source) {
        if (CollectionUtils.isEmpty(ids) || version == null || operate == null || !"tsate".equals(source)) {
            return;
        }
        switch (operate.getOperation()) {
            case "apply": {
                DeclareMainTableBusiness.handleApply(ids, version);
                break;
            }
            case "cancelapply": {
                DeclareMainTableBusiness.handleCancelApply(ids, version);
                break;
            }
            case "pay": {
                DeclareMainTableBusiness.handlePay(ids, version);
                break;
            }
            case "cancelpay": {
                DeclareMainTableBusiness.handleCancelPay(ids, version);
            }
        }
    }

    private static void handleApply(List<Long> ids, ModelVersionEnum version) {
        if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualDeclare", (Object[])new Object[]{ids});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{ids});
        }
    }

    private static void handleCancelApply(List<Long> ids, ModelVersionEnum version) {
        if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"cancelDeclare", (Object[])new Object[]{ids});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{ids});
        }
    }

    private static void handlePay(List<Long> ids, ModelVersionEnum version) {
        if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"manualPay", (Object[])new Object[]{ids});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{ids});
        }
    }

    private static void handleCancelPay(List<Long> ids, ModelVersionEnum version) {
        if (ModelVersionEnum.MODEL3.getVersion().equals(version.getVersion())) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"cancelPay", (Object[])new Object[]{ids});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{ids});
        }
    }

    public static void triggerDeclareMainEvent(List<Long> ids, List<DynamicObject> declares, ModelVersionEnum version, DeclareOperationEnum operate, String source, Map<String, Object> extParam) {
        if (CollectionUtils.isEmpty(ids)) {
            logger.info("DeclareMainBusiness.triggerDeclareMainEvent ids is Empty.");
            return;
        }
        try {
            logger.info("DeclareMainBusiness.triggerDeclareMainEvent start.");
            String eventNumber = "bdtaxr_declaremain_change";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", ids);
            params.put("declares", declares != null ? DynamicObjectUtils.dynamicObjects2ListMap(declares) : null);
            params.put("operate", operate != null ? operate.getOperation() : null);
            params.put("source", source);
            params.put("version", version != null ? version.getVersion() : null);
            params.put("extParam", extParam);
            params.put("appId", StringUtils.isNotBlank((CharSequence)source) ? source : "bdtaxr");
            EventServiceHelper.triggerEventSubscribe((String)eventNumber, (String)JSONUtils.toString(params));
        }
        catch (Exception e) {
            logger.error("DeclareMainBusiness.triggerDeclareMainEvent error." + e.getMessage(), (Throwable)e);
        }
    }

    private static List<DynamicObject> transferData(List<DynamicObject> declares) {
        ArrayList<DynamicObject> model2List = new ArrayList<DynamicObject>(declares.size());
        for (DynamicObject declare : declares) {
            if (MultiTableEnum.TSCOO1.getDeclareMainTable().equals(declare.getDataEntityType().getName())) {
                model2List.add(DeclareMainTableBusiness.transferModel3ToModel2(declare));
                continue;
            }
            model2List.add(declare);
        }
        return model2List;
    }

    public static DynamicObject transferModel3ToModel2(DynamicObject declare) {
        DynamicObject newDeclare = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_nsrxx"));
        for (Map.Entry<String, String> entry : DeclareMainTableBusiness.getModel2ToModel3FieldMap().entrySet()) {
            if ("type".equals(entry.getKey())) {
                DynamicObject templateType = (DynamicObject)declare.get(entry.getValue());
                if (templateType != null) {
                    newDeclare.set(entry.getKey(), templateType.get("id"));
                    continue;
                }
                newDeclare.set(entry.getKey(), null);
                continue;
            }
            newDeclare.set(entry.getKey(), declare.get(entry.getValue()));
        }
        return newDeclare;
    }

    public static DynamicObject transferModel2ToModel3(DynamicObject declare) {
        DynamicObject newDeclare = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MultiTableEnum.TSCOO1.getDeclareMainTable()));
        for (Map.Entry<String, String> entry : DeclareMainTableBusiness.getModel2ToModel3FieldMap().entrySet()) {
            if ("type".equals(entry.getKey())) {
                DynamicObject templateType = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_template_type"));
                templateType.set("id", declare.get(entry.getKey()));
                newDeclare.set(entry.getValue(), (Object)templateType);
                continue;
            }
            newDeclare.set(entry.getValue(), declare.get(entry.getKey()));
        }
        newDeclare.set("sourcebillid", (Object)declare.getLong("id"));
        newDeclare.set("sourcebillno", (Object)declare.getString("billno"));
        return newDeclare;
    }

    private static Map<String, String> getModel2ToModel3FieldMap() {
        return DeclareMainServiceHelper.getModel2ToModel3FieldMap().getData();
    }
}

