/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.taxc.bdtaxr.common.constant.i18n.MultiLangEnumBridge;

public enum DataType {
    ZJQS("zjqs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u76f4\u63a5\u53d6\u6570", (String)"DataType_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_0", "taxc-bdtaxr-base")),
    JSFLQS("jsflqs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u542b\u7a0e\u4ef7\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", (String)"DataType_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_1", "taxc-bdtaxr-base")),
    CYSLDSQS("cysldsqs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u7a0e\u989d\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", (String)"DataType_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_2", "taxc-bdtaxr-base")),
    SEHSHSJ("sehshsj", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u7a0e\u989d\u6362\u7b97\u542b\u7a0e\u4ef7", (String)"DataType_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_3", "taxc-bdtaxr-base")),
    HSJHSSE("hsjhsse", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u542b\u7a0e\u4ef7\u6362\u7b97\u7a0e\u989d", (String)"DataType_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_4", "taxc-bdtaxr-base")),
    BHSJHSSE("bhsjhsse", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u4ef7\u6362\u7b97\u7a0e\u989d", (String)"DataType_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_5", "taxc-bdtaxr-base")),
    BHSJHSHSJ("bhsjhshsj", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u4ef7\u6362\u7b97\u542b\u7a0e\u4ef7", (String)"DataType_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_6", "taxc-bdtaxr-base")),
    ZJJS("zjjs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u76f4\u63a5\u8ba1\u6570", (String)"DataType_7", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_7", "taxc-bdtaxr-base")),
    GJQS("gjqs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u9ad8\u7ea7\u53d6\u6570", (String)"DataType_8", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_8", "taxc-bdtaxr-base")),
    YJJSFLQS("yjjsflqs", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u9884\u7f34\u542b\u7a0e\u4ef7\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7", (String)"DataType_9", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), "DataType_9", "taxc-bdtaxr-base"));

    private String code;
    private MultiLangEnumBridge bridge;

    private DataType(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public static List<ComboItem> buildDataType(List<DataType> dataTypes) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>();
        for (DataType dataType : DataType.values()) {
            if (dataTypes != null && !dataTypes.contains((Object)dataType)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(dataType.getCode());
            comboItem.setCaption(new LocaleString(dataType.getBridge().getDescription()));
            result.add(comboItem);
        }
        return result;
    }
}

