/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums.ttc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public enum TtcValueRulesSceneidEnum {
    DEFAULT("default"),
    VAT_SBMC("VAT-SBMC", (List)Collections.singletonList("tcvat_product_name"), (List)Arrays.asList("tpo_tcvat_assist_entry", "tcvat_ncp_declare_name")){

        @Override
        public void dealEnable(IFormView formView) {
            formView.setEnable(Boolean.FALSE, new String[]{"sourcetype", "targettype"});
            this.setSourceTargetTypeDefaultValue(formView);
        }

        @Override
        public void setSourceTargetTypeDefaultValue(IFormView formView) {
            formView.getModel().setValue("sourcetype", (Object)"basedata");
            formView.getModel().setValue("targettype", (Object)"basedata");
            DynamicObjectCollection collection = formView.getModel().getDataEntity().getDynamicObjectCollection("sceneid");
            List list = collection.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
            if (list.contains(this.getSceneNumber()) && !list.contains(VAT_YLMC.getSceneNumber())) {
                boolean basicdatatypeNoDefault = true;
                List<String> basicdataList = this.getBasicDataTypeFilterList();
                for (int i = 0; i < basicdataList.size(); ++i) {
                    DynamicObject object = formView.getModel().getDataEntity().getDynamicObject("basicdatatype");
                    if (null == object || !StringUtil.equalsIgnoreCase((CharSequence)object.getString("id"), (CharSequence)basicdataList.get(i))) continue;
                    formView.getModel().setValue("basicdatatype", (Object)basicdataList.get(i));
                    basicdatatypeNoDefault = false;
                    break;
                }
                if (basicdatatypeNoDefault) {
                    formView.getModel().setValue("basicdatatype", (Object)basicdataList.get(0));
                }
                boolean targetNoDefault = true;
                List<String> argetObjectIdTypeFilterList = this.getTargetObjectIdTypeFilterList();
                for (int i = 0; i < argetObjectIdTypeFilterList.size(); ++i) {
                    DynamicObject targetobjectidObject = formView.getModel().getDataEntity().getDynamicObject("targetobjectid");
                    if (null == targetobjectidObject || !StringUtil.equalsIgnoreCase((CharSequence)targetobjectidObject.getString("id"), (CharSequence)argetObjectIdTypeFilterList.get(i))) continue;
                    formView.getModel().setValue("targetobjectid", (Object)argetObjectIdTypeFilterList.get(i));
                    targetNoDefault = false;
                    break;
                }
                if (targetNoDefault) {
                    formView.getModel().setValue("targetobjectid", (Object)argetObjectIdTypeFilterList.get(0));
                }
            }
        }

        @Override
        public QFilter dealTargetValueFilter(IFormView formView) {
            DynamicObject row = formView.getModel().getDataEntity();
            if (StringUtil.equalsIgnoreCase((CharSequence)formView.getModel().getDataEntity().getString("targettype"), (CharSequence)"basedata") && null != row.getDynamicObject("targetobjectid")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"tcvat_ncp_declare_name", (CharSequence)row.getDynamicObject("targetobjectid").getString("id"))) {
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id", (QFilter[])new QFilter[]{new QFilter("nametype", "=", (Object)"cpmc")});
                    List list = collection.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                    return new QFilter("id", "in", list);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"tpo_tcvat_assist_entry", (CharSequence)row.getDynamicObject("targetobjectid").getString("id"))) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"tpo_tcvat_assist", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"cpmc")});
                    return new QFilter("pid", "=", dynamicObject.getPkValue());
                }
            }
            return null;
        }
    }
    ,
    VAT_YLMC("VAT-YLMC", (List)Collections.singletonList("tcvat_hyncp_name"), (List)Arrays.asList("tpo_tcvat_assist_entry", "tcvat_ncp_declare_name")){

        @Override
        public void dealEnable(IFormView formView) {
            formView.setEnable(Boolean.FALSE, new String[]{"sourcetype", "targettype"});
            this.setSourceTargetTypeDefaultValue(formView);
        }

        @Override
        public void setSourceTargetTypeDefaultValue(IFormView formView) {
            formView.getModel().setValue("sourcetype", (Object)"basedata");
            formView.getModel().setValue("targettype", (Object)"basedata");
            DynamicObjectCollection collection = formView.getModel().getDataEntity().getDynamicObjectCollection("sceneid");
            List list = collection.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
            if (list.contains(this.getSceneNumber()) && !list.contains(VAT_SBMC.getSceneNumber())) {
                boolean basicdatatypeNoDefault = true;
                List<String> basicdataList = this.getBasicDataTypeFilterList();
                for (int i = 0; i < basicdataList.size(); ++i) {
                    DynamicObject object = formView.getModel().getDataEntity().getDynamicObject("basicdatatype");
                    if (null == object || !StringUtil.equalsIgnoreCase((CharSequence)object.getString("id"), (CharSequence)basicdataList.get(i))) continue;
                    formView.getModel().setValue("basicdatatype", (Object)basicdataList.get(i));
                    basicdatatypeNoDefault = false;
                    break;
                }
                if (basicdatatypeNoDefault) {
                    formView.getModel().setValue("basicdatatype", (Object)basicdataList.get(0));
                }
                boolean targetNoDefault = true;
                List<String> argetObjectIdTypeFilterList = this.getTargetObjectIdTypeFilterList();
                for (int i = 0; i < argetObjectIdTypeFilterList.size(); ++i) {
                    DynamicObject targetobjectidObject = formView.getModel().getDataEntity().getDynamicObject("targetobjectid");
                    if (null == targetobjectidObject || !StringUtil.equalsIgnoreCase((CharSequence)targetobjectidObject.getString("id"), (CharSequence)argetObjectIdTypeFilterList.get(i))) continue;
                    formView.getModel().setValue("targetobjectid", (Object)argetObjectIdTypeFilterList.get(i));
                    targetNoDefault = false;
                    break;
                }
                if (targetNoDefault) {
                    formView.getModel().setValue("targetobjectid", (Object)argetObjectIdTypeFilterList.get(0));
                }
            }
        }

        @Override
        public QFilter dealTargetValueFilter(IFormView formView) {
            DynamicObject row = formView.getModel().getDataEntity();
            if (StringUtil.equalsIgnoreCase((CharSequence)formView.getModel().getDataEntity().getString("targettype"), (CharSequence)"basedata") && null != row.getDynamicObject("targetobjectid")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"tcvat_ncp_declare_name", (CharSequence)row.getDynamicObject("targetobjectid").getString("id"))) {
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id", (QFilter[])new QFilter[]{new QFilter("nametype", "=", (Object)"hymc")});
                    List list = collection.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                    return new QFilter("id", "in", list);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"tpo_tcvat_assist_entry", (CharSequence)row.getDynamicObject("targetobjectid").getString("id"))) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"tpo_tcvat_assist", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ncpmc")});
                    return new QFilter("pid", "=", dynamicObject.getPkValue());
                }
            }
            return null;
        }
    };

    private String sceneNumber;
    private List<String> basicDataTypeFilterList;
    private List<String> targetObjectIdTypeFilterList;

    public void dealEnable(IFormView formView) {
        formView.setEnable(Boolean.TRUE, new String[]{"sourcetype", "targettype"});
    }

    public void setSourceTargetTypeDefaultValue(IFormView formView) {
    }

    public QFilter dealTargetValueFilter(IFormView formView) {
        return null;
    }

    public String getSceneNumber() {
        return this.sceneNumber;
    }

    public List<String> getBasicDataTypeFilterList() {
        return this.basicDataTypeFilterList;
    }

    public List<String> getTargetObjectIdTypeFilterList() {
        return this.targetObjectIdTypeFilterList;
    }

    private TtcValueRulesSceneidEnum(String sceneNumber) {
        this.sceneNumber = sceneNumber;
        this.basicDataTypeFilterList = null;
        this.targetObjectIdTypeFilterList = null;
    }

    private TtcValueRulesSceneidEnum(String sceneNumber, List<String> basicDataTypeFilterList, List<String> targetObjectIdTypeFilterList) {
        this.sceneNumber = sceneNumber;
        this.basicDataTypeFilterList = basicDataTypeFilterList;
        this.targetObjectIdTypeFilterList = targetObjectIdTypeFilterList;
    }

    public static TtcValueRulesSceneidEnum getEnumBySceneNumber(String sceneNumber) {
        for (TtcValueRulesSceneidEnum ttcValueRulesSceneidEnum : TtcValueRulesSceneidEnum.values()) {
            if (!ttcValueRulesSceneidEnum.getSceneNumber().equals(sceneNumber)) continue;
            return ttcValueRulesSceneidEnum;
        }
        return DEFAULT;
    }
}

