/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.bos.orgrelation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import org.apache.commons.collections4.CollectionUtils;

public class OrgRelationDataServiceHelper {
    public static TaxResult<List<Long>> getAccountingOrgIdByTaxcOrgId(Long taxOrgId) {
        List list = new ArrayList(8);
        if (null != taxOrgId) {
            list = OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)taxOrgId, (String)"10", (boolean)true);
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, list);
    }

    public static TaxResult<List<Long>> getAccountingOrgIdByTaxcOrgIds(List<Long> taxcOrgIds) {
        ArrayList list = new ArrayList(8);
        if (null != taxcOrgIds) {
            taxcOrgIds.stream().forEach(taxcOrgId -> {
                List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)taxcOrgId, (String)"10");
                if (CollectionUtils.isNotEmpty((Collection)fromOrgs)) {
                    list.addAll(fromOrgs);
                }
            });
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, list);
    }

    public static TaxResult<Long> getDefaultAccountingOrgIdByTaxcOrgId(Long taxOrgId) {
        Long orgId = null;
        if (null != taxOrgId) {
            List data;
            List allOrgByViewNumber = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"10", (boolean)false);
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(taxOrgId.longValue());
            param.setToViewType("40");
            param.setFromViewType("10");
            param.setIncludeSelf(false);
            Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
            if (orgRelation != null && orgRelation.get("data") != null && CollectionUtils.isNotEmpty((Collection)(data = (List)orgRelation.get("data")))) {
                Optional<Map> isDefault = data.stream().filter(o -> (Boolean)o.get("isDefault") != false && allOrgByViewNumber.contains(o.get("orgId"))).findFirst();
                if (isDefault.isPresent()) {
                    orgId = (Long)isDefault.get().get("orgId");
                }
                if (orgId == null && (isDefault = data.stream().filter(o -> allOrgByViewNumber.contains(o.get("orgId"))).findFirst()).isPresent()) {
                    orgId = (Long)isDefault.get().get("orgId");
                }
            }
            if (orgId == null && allOrgByViewNumber.contains(taxOrgId)) {
                orgId = taxOrgId;
            }
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, orgId);
    }

    public static TaxResult<List<Map<String, Object>>> getTaxOrgByAccountingOrgId(Long accountingOrgId) {
        List data = null;
        if (null != accountingOrgId) {
            List orgIds;
            List allOrgByViewNumber = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(accountingOrgId.longValue());
            param.setToViewType("40");
            param.setFromViewType("10");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
            if (orgRelation != null && orgRelation.get("data") != null && CollectionUtils.isNotEmpty(data = (List)orgRelation.get("data")) && CollectionUtils.isNotEmpty((Collection)(orgIds = (List)orgRelation.get("orgId"))) && !orgIds.contains(accountingOrgId) && allOrgByViewNumber.contains(accountingOrgId)) {
                HashMap<String, Comparable<Boolean>> orgMap = new HashMap<String, Comparable<Boolean>>();
                orgMap.put("isDefault", Boolean.valueOf(false));
                orgMap.put("orgId", accountingOrgId);
                data.add(orgMap);
            }
            if (CollectionUtils.isEmpty(data)) {
                data = new ArrayList();
                if (allOrgByViewNumber.contains(accountingOrgId)) {
                    HashMap<String, Comparable<Boolean>> orgMap = new HashMap<String, Comparable<Boolean>>();
                    orgMap.put("isDefault", Boolean.valueOf(false));
                    orgMap.put("orgId", accountingOrgId);
                    data.add(orgMap);
                }
            }
        }
        return ServiceInvokeUtils.buildTaxResult(Map.class, data);
    }

    public static TaxResult<List<Long>> getTaxcOrgIdByAccountingOrgId(Long accountingOrgId) {
        ArrayList list = new ArrayList(8);
        list.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountingOrgId));
        return ServiceInvokeUtils.buildTaxResult(Long.class, list);
    }

    public static TaxResult<List<Long>> getTaxcOrgIdByAccountingOrgIds(List<Long> accountingOrgIds) {
        ArrayList list = new ArrayList(8);
        if (null != accountingOrgIds) {
            accountingOrgIds.stream().forEach(accountingOrgId -> list.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountingOrgId, (boolean)true)));
        }
        return ServiceInvokeUtils.buildTaxResult(Long.class, list);
    }

    public static List<Long> getOrgTakeRelation(List<Long> taxOrgId, Date startdate, Date enddate) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getOrgTakeRelation", (Object[])new Object[]{taxOrgId, startdate, enddate});
    }

    public static Map<String, List<Long>> getOrgRelationMapByTaxOrgs(List<Long> taxOrgs, Date start, Date end) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        for (Long org : taxOrgs) {
            for (OrgFuncEnum orgFuncEnum : OrgFuncEnum.values()) {
                HashSet<Long> set = new HashSet<Long>(8);
                ArrayList<Long> list = new ArrayList<Long>(8);
                switch (orgFuncEnum) {
                    case TAX: {
                        break;
                    }
                    case ACCOUNT: {
                        List<Long> orgTakeRelation = OrgRelationDataServiceHelper.getOrgTakeRelation(Collections.singletonList(org), start, end);
                        set.addAll(orgTakeRelation);
                        break;
                    }
                }
                list.addAll(set);
                resultMap.put(OrgRelationDataServiceHelper.getRelationMapKey(org, orgFuncEnum.getNumber()), list);
            }
        }
        return resultMap;
    }

    public static Map<String, Object> getOrgRelationTaxToAccount(Long orgId, boolean queryTax) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setToViewType("10");
        param.setFromViewType("40");
        param.setIncludeSelf(false);
        if (queryTax) {
            param.setDirectViewType("fromorg");
        } else {
            param.setDirectViewType("toorg");
        }
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        return orgRelation;
    }

    public static Map<String, Object> getOrgRelationAccountToTax(Long orgId, boolean queryTax) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setToViewType("40");
        param.setFromViewType("10");
        param.setIncludeSelf(false);
        if (queryTax) {
            param.setDirectViewType("toorg");
        } else {
            param.setDirectViewType("fromorg");
        }
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        return orgRelation;
    }

    private static String getRelationMapKey(Long org, String orgFuncEnumNumber) {
        return org.toString() + "_" + orgFuncEnumNumber;
    }
}

