/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tctb.provision;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.login.actions.SerializationUtils;
import kd.taxc.bdtaxr.business.TaxcDataLoadBusiness;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleAmountDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleFetchDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleQueryDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleResultDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionRuleDataServiceHelper {
    /*
     * WARNING - void declaration
     */
    public static TaxResult<List<ProvisionRuleResultDto>> getProvisionRules(List<ProvisionRuleQueryDto> queryDtos) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbService(Map.class, "ProvisionRuleMService", "getProvisionRules", queryDtos);
        if (!result.isSuccess()) {
            return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
        }
        ArrayList<Object> resultDtos = new ArrayList<Object>(10);
        if (ObjectUtils.isNotEmpty(result.getData())) {
            void var5_5;
            JSONArray jsonArray = JSONArray.parseArray((String)String.valueOf(result.getData()));
            boolean bl = false;
            int size = jsonArray.size();
            while (var5_5 < size) {
                ProvisionRuleResultDto resultDto = (ProvisionRuleResultDto)SerializationUtils.fromJsonString((String)jsonArray.get((int)var5_5).toString(), ProvisionRuleResultDto.class);
                resultDtos.add(resultDto);
                ++var5_5;
            }
        }
        HashSet<Long> allRuleIds = new HashSet<Long>(10);
        for (ProvisionRuleResultDto provisionRuleResultDto : resultDtos) {
            allRuleIds.addAll(provisionRuleResultDto.getRuleIds());
        }
        Map<Object, Object> ruleMap = new HashMap(10);
        if (allRuleIds.size() > 0) {
            List<DynamicObject> list = TaxcDataLoadBusiness.load(new ArrayList<Long>(allRuleIds), "tctb_jtgz_rules", "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,org,entryentity,ruletype,rulepurpose,issystem,provistonitem,datasource,generatecondition,remark,filterjson,filterjson_tag,taxtype,entryentity.seq,entryentity.bizname,entryentity.table,entryentity.absolute,entryentity.datatype,entryentity.datadirection,entryentity.filtercondition,entryentity.advancedconf,entryentity.conditionjson,entryentity.advancedconfjson,entryentity.vatrate,entryentity.basedatatype,entryentity.amountfield,entryentity.datasourcetext,entryentity.composite,entryentity.compositejson,entryentity.compositejson_tag,provistonitem.taxtype");
            ruleMap = list.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        Object var5_8 = null;
        for (ProvisionRuleResultDto provisionRuleResultDto : resultDtos) {
            List<Long> list = provisionRuleResultDto.getRuleIds();
            for (Long ruleId : list) {
                if (ruleMap.get(ruleId) == null) continue;
                provisionRuleResultDto.getRules().add((DynamicObject)ruleMap.get(ruleId));
            }
        }
        return ServiceInvokeUtils.buildTaxResult(List.class, resultDtos);
    }

    public static TaxResult<List<ProvisionRuleAmountDto>> getProvisionRuleAmount(List<ProvisionRuleFetchDto> fetchDtos) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbService(Map.class, "ProvisionRuleMService", "getProvisionRuleAmount", fetchDtos);
        if (!result.isSuccess()) {
            return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
        }
        ArrayList<ProvisionRuleAmountDto> resultDtos = new ArrayList<ProvisionRuleAmountDto>(10);
        if (ObjectUtils.isNotEmpty(result.getData())) {
            JSONArray jsonArray = JSONArray.parseArray((String)String.valueOf(result.getData()));
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                ProvisionRuleAmountDto resultDto = (ProvisionRuleAmountDto)SerializationUtils.fromJsonString((String)jsonArray.get(i).toString(), ProvisionRuleAmountDto.class);
                resultDtos.add(resultDto);
            }
        }
        return ServiceInvokeUtils.buildTaxResult(List.class, resultDtos);
    }
}

