/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tctb.taxcmain;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.enums.TaxcTaxTypeFieldsMappingEnum;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxcMainDataServiceHelper {
    public static TaxResult<Boolean> isTaxcMainByOrgNum(String orgNum) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainByOrgNum", orgNum, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainByUnifiedsocialcode(String unifiedsocialcode) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainByUnifiedsocialcode", unifiedsocialcode, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainByOrgIdAndIsTaxpayer(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainByOrgIdAndIsTaxpayer", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIds(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIds(List<Long> orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIds", orgIds, taxationsysId, isIncludeTaxationsys);
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgIdAndIsTaxpayer(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdAndIsTaxpayer", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIdsAndIsTaxpayer(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdsAndIsTaxpayer", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdsAndIsTaxpayer", orgIds, taxationsysId);
    }

    public static TaxResult<DynamicObject> queryTaxcMainByTaxpayer(String taxpayer) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByTaxpayer", taxpayer, TaxationsysMappingEnum.CHN.getId());
    }

    @Deprecated
    public static TaxResult<DynamicObject> queryTaxcMainByTaxpayer(String taxpayer, TaxationsysMappingEnum taxationsys) {
        if (taxationsys == null) {
            taxationsys = TaxationsysMappingEnum.CHN;
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByTaxpayer", taxpayer, taxationsys.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByTaxpayer(String taxpayer, Long taxationsysId) {
        if (taxationsysId == null) {
            taxationsysId = TaxationsysMappingEnum.CHN.getId();
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByTaxpayer", taxpayer, taxationsysId);
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgName(String orgName, Long taxationsysId) {
        if (taxationsysId == null) {
            taxationsysId = TaxationsysMappingEnum.CHN.getId();
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgName", orgName, taxationsysId);
    }

    public static TaxResult<Boolean> queryTaxcMainByOrgIdAndWhereJson(Long orgId, String whereJson) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && result.getData() != null) {
            DynamicObjectCollection obj = TaxcMainBusiness.queryTaxcMainByIdAndWhereJson((Long)result.getData(), TaxcMainConstant.BASE_FILEDS, whereJson);
            return ServiceInvokeUtils.buildTaxResult(Boolean.class, obj != null && obj.size() > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return ServiceInvokeUtils.createTaxResult(Boolean.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), Boolean.FALSE));
    }

    public static TaxResult<DynamicObject> queryTaxcMainByTaxOfficeId(Long taxofficeId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByTaxOfficeId", taxofficeId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByTaxOfficeIds(List<Long> taxofficeIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByTaxOfficeIds", taxofficeIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgNum(String orgNum) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNum", orgNum, TaxationsysMappingEnum.CHN.getId());
    }

    @Deprecated
    public static TaxResult<DynamicObject> queryTaxcMainByOrgNum(String orgNum, TaxationsysMappingEnum taxationsys) {
        if (taxationsys == null) {
            taxationsys = TaxationsysMappingEnum.CHN;
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNum", orgNum, taxationsys.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByOrgNum(String orgNum, Long taxationsysId) {
        if (taxationsysId == null) {
            taxationsysId = TaxationsysMappingEnum.CHN.getId();
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNum", orgNum, taxationsysId);
    }

    @Deprecated
    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgNums(List<String> orgNums, TaxationsysMappingEnum taxationsys) {
        if (taxationsys == null) {
            taxationsys = TaxationsysMappingEnum.CHN;
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNums", orgNums, taxationsys.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgNums(List<String> orgNums, Long taxationsysId) {
        if (taxationsysId == null) {
            taxationsysId = TaxationsysMappingEnum.CHN.getId();
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNums", orgNums, taxationsysId);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgNums(List<String> orgNums) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNums", orgNums, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByUnifiedsocialCode(String unifiedsocialcode) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCode", unifiedsocialcode, TaxationsysMappingEnum.CHN.getId());
    }

    @Deprecated
    public static TaxResult<DynamicObject> queryTaxcMainByUnifiedsocialCode(String unifiedsocialcode, TaxationsysMappingEnum taxationsys) {
        if (taxationsys == null) {
            taxationsys = TaxationsysMappingEnum.CHN;
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCode", unifiedsocialcode, taxationsys.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByUnifiedsocialCode(String unifiedsocialcode, Long taxationsysId) {
        if (taxationsysId == null) {
            taxationsysId = TaxationsysMappingEnum.CHN.getId();
        }
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCode", unifiedsocialcode, taxationsysId);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByUnifiedsocialCodes(List<String> unifiedsocialcodes) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCodes", unifiedsocialcodes, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcMainByUnifiedsocialCodeAndTrasAndIsTaxpayer(String unifiedsocialcode) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCodeAndTras", unifiedsocialcode, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByUnifiedsocialCodesAndTrasAndIsTaxpayer(List<String> unifiedsocialcodes) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByUnifiedsocialCodesAndTras", unifiedsocialcodes, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByIsTaxpayer() {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByIsTaxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByIsTaxpayer(Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByIsTaxpayer", taxationsysId);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMain() {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMain", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIdsAndTaxpayer(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdsAndTaxpayer", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgIdsWithNoStatus(List<Long> orgIds, Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdsWithNoStatus", orgIds, taxationsysId);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainByOrgNumbersWithNoStatus(List<String> orgNumbers, Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "queryTaxcMainByOrgNumbersWithNoStatus", orgNumbers, taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxOfficeIdByOrgId(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxOfficeIdByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByOrgAttrIds(List<Long> orgAttrIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByOrgAttrIds", orgAttrIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByOrgIdsAndOrgAttrIds(List<Long> orgIds, List<Long> orgAttrIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByOrgIdsAndOrgAttrIds", orgIds, orgAttrIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainIdByOrgIds(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainIdByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxOfficeIdByOrgNums(List<String> orgNums) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxOfficeIdByOrgNums", orgNums, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByUnifiedsocialCodes(List<String> unifiedsocialcodes) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByUnifiedsocialCodes", unifiedsocialcodes, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByFinancialStatementAndIsTaxpayer() {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByFinancialStatementAndIsTaxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByOrgIdAndIsTaxpayer", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr(List<Long> orgIds) {
        TaxResult taxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainByOrgIdsAndIsTaxpayer", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            return ServiceInvokeUtils.buildTaxResult(Long.class, TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)taxResult.getData()));
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(taxResult.isSuccess(), taxResult.getCode(), taxResult.getMessage(), null));
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByOrgIds(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIds() {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIds", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByIsTaxpayer() {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByIsTaxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByIsTaxpayer(Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByIsTaxpayer", taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByIsTaxpayer(Long taxationsysId, boolean isIncludeTaxationsys) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByIsTaxpayer", taxationsysId, isIncludeTaxationsys);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdByOrgIdsAndIsTaxpayer", orgIds, taxationsysId, isIncludeTaxationsys);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIds(Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIds", taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByIsTaxpayerForHws(Long taxationsysId, Long categoryId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByIsTaxpayerForHws", taxationsysId, categoryId, Boolean.TRUE);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByTaxpayer() {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByTaxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByTaxpayer(Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcMainMService", "queryTaxcMainOrgIdsByTaxpayer", taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxcMainOrgIdsByOrgIdsForZzs(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainZzsByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            return ServiceInvokeUtils.buildTaxResult(Long.class, DyoToDtoUtils.dyoToLong(data.toArray(new DynamicObject[0]), "taxorg"));
        }
        return ServiceInvokeUtils.createTaxResult(Long.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainSzysByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainSzysByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_SZYS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainQysdsByOrgIds(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainQysdsByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_QYSDS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainQysdsByOrgNums(List<String> orgNums) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainQysdsByOrgNums", orgNums, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_QYSDS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainZzsByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainZzsByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory((List)result.getData(), TaxcMainConstant.TAXTYPE_ZZS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainYhsByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_YHS, "TaxcMainMService", "queryTaxcMainYhsByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_YHS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainXfsByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_XFS, "TaxcMainMService", "queryTaxcMainXfsByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_XFS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainHjbhsByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HJBHS, "TaxcMainMService", "queryTaxcMainHjbhsByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_HJBHS);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainQtsfByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_QTSF, "TaxcMainMService", "queryTaxcMainQtsfByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_QTSF);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainFjsfByOrgId(List<Long> orgIds) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainFjsfByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, TaxcMainConstant.TAXTYPE_FJSF);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), Collections.EMPTY_LIST));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainCategoryByOrgIdsAndTaxtype(List<Long> orgIds, String taxtype) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcTaxTypeFieldsMappingEnum.getFieldsByTaxType(taxtype), "TaxcMainMService", "queryTaxcMainByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, taxtype);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<List<DynamicObject>> queryBatchTaxcMainByOrgIds(List<Long> orgIds, List<Long> taxationsysIds, List<Long> categoryIds, List<Long> taxAreaIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryBatchTaxcMainByOrgIds", orgIds, taxationsysIds, categoryIds, taxAreaIds);
    }

    public static TaxResult<String> queryTaxcMainCategoryByOrgId(Long orgId, Long taxationsysId, Long categoryId) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryTaxcMainCategoryByOrgId", Collections.singletonList(orgId), taxationsysId, categoryId, true);
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ServiceInvokeUtils.buildTaxResult(String.class, TaxcMainBusiness.queryTaxcMainCategoryFieldForHws((DynamicObject)((List)result.getData()).get(0), categoryId, "hwsdeadline"));
        }
        return ServiceInvokeUtils.createTaxResult(String.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), null));
    }

    public static TaxResult<List<String>> queryHwsTaxlimitByOrgId(Long orgId, Long taxationsysId, Long categoryId, Long taxAreaId) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryTaxcMainCategoryByOrgId", Collections.singletonList(orgId), taxationsysId, null, true);
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ServiceInvokeUtils.buildTaxResult(String.class, TaxcMainBusiness.queryTaxcMainCategoryFieldForHws((DynamicObject)((List)result.getData()).get(0), categoryId, taxAreaId, "hwsdeadline", Boolean.TRUE));
        }
        return ServiceInvokeUtils.createTaxResult(String.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), null));
    }

    public static TaxResult<List<String>> queryHwsTaxlimitByOrgId(Long orgId, Long taxationsysId, Long categoryId, Long taxAreaId, boolean isIncludDisable) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryTaxcMainCategoryByOrgId", Collections.singletonList(orgId), taxationsysId, null, true);
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ServiceInvokeUtils.buildTaxResult(String.class, TaxcMainBusiness.queryTaxcMainCategoryFieldForHws((DynamicObject)((List)result.getData()).get(0), categoryId, taxAreaId, "hwsdeadline", isIncludDisable));
        }
        return ServiceInvokeUtils.createTaxResult(String.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), null));
    }

    public static TaxResult<DynamicObject> queryHwsCategoryByOrgId(Long orgId, Long taxationsysId) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryTaxcMainCategoryByOrgId", Collections.singletonList(orgId), taxationsysId, null, true);
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            DynamicObject data = (DynamicObject)((List)result.getData()).get(0);
            TaxcMainBusiness.queryCategoryForHws(data, null, Boolean.FALSE);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), null));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(List<Long> orgIds, Long taxationsysId, Long categoryId) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, "TaxcMainMService", "queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws", orgIds, taxationsysId, categoryId, Boolean.TRUE);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcMainAndCategoryByOrgIdsAndTaxtype(List<Long> orgIds, String taxtype) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_CARD_FILED, "TaxcMainMService", "queryTaxcMainCategoryByOrgIdsAndTaxtype", orgIds, taxtype, TaxationsysMappingEnum.CHN.getId());
        if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            TaxcMainBusiness.queryTaxcMainCategory(data, taxtype);
            return ServiceInvokeUtils.buildTaxResult(DynamicObject.class, data);
        }
        return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(result.isSuccess(), result.getCode(), result.getMessage(), result.getData()));
    }

    public static TaxResult<Boolean> isTaxcMainZzsEnableByOrgId(long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainZzsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> queryTaxcMainZzsTaxpayerTypeByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "queryTaxcMainZzsTaxpayerTypeByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainQysdsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainQysdsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainSzysEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainSzysEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainXfsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainXfsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainHjbhsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainHjbhsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainYhsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainYhsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainFcsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainFcsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainFjsfEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainFjsfEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainQtsfEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainQtsfEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcMainTdzzsEnableByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainTdzzsEnableByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Map<Long, Map<String, Boolean>>> isTaxcMainCategoryEnableByOrgIds(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcMainMService", "isTaxcMainCategoryEnableByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Map<String, String>> checkTaxPayersMustInput(List<Long> orgIds, Long taxationsysId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Map.class, "TaxcMainMService", "checkTaxPayersMustInput", orgIds, taxationsysId);
    }

    public static TaxResult<DynamicObjectCollection> queryTaxcMainByCustomFilter(List<Long> orgIds, Long taxationsysId, String selectFields, QFilter[] customFilters, String orderBy) {
        DynamicObjectCollection result = TaxcMainBusiness.queryTaxcMainByCustomFilter(orgIds, taxationsysId, selectFields, customFilters, orderBy);
        return ServiceInvokeUtils.buildTaxResult(DynamicObjectCollection.class, result);
    }

    @Deprecated
    public static TaxResult<DynamicObject> queryTaxVerByOrgId(Long orgId, String tax, Date date) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj("tctb_tax_ver_normal", "id,modifydate,modifier,org,taxtype,ver,entryentity,entryentity.seq,entryentity.modifycontexbeforecode,entryentity.modifycontexaftercode,entryentity.modifycontexttitleysjbs,entryentity.modifycontexafter,entryentity.modifycontexbefore,entryentity.modifycontexttitle", "TaxcMainMService", "getTaxVer", orgId, tax, date);
    }

    public static TaxResult<List<DynamicObject>> filterIsRegistedAddress(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "filterIsRegistedAddress", orgIds);
    }

    public static TaxResult<List<DynamicObject>> filterAllIsRegistedAddress() {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj(TaxcMainConstant.ENTITYNAME, TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, "TaxcMainMService", "filterAllIsRegistedAddress", new Object[0]);
    }
}

