/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tpo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.business.tpo.DeclareMainTableBusiness;
import kd.taxc.bdtaxr.common.dto.DeclareMainTableQueryDto;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.MultiCreateRequest;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnumBase;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.enums.tpo.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareBaseDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class MultiDeclareDataServiceHelper {
    private static final Log logger = LogFactory.getLog(MultiDeclareDataServiceHelper.class);

    public static TaxResult<DynamicObject> create(MultiCreateRequest multiCreateRequest) {
        DeclareTable pair = MultiTableEnumBase.getDeclareTable(multiCreateRequest.getModelId());
        String entityName = pair.getMainTable();
        String allFields = MetadataUtil.getAllFieldString(entityName);
        String request = SerializationUtils.toJsonString((Object)multiCreateRequest);
        return ServiceInvokeUtils.invokeTaxcTpoServiceWithObj(entityName, allFields, "MultiDeclareDataMService", "create", request);
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainByIds(List<Long> ids) {
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        List<DynamicObject> model3List = DeclareMainServiceHelper.queryDeclareMainByIds(modelId, ids).getData();
        List<DynamicObject> model2List = DeclareMainServiceHelper.queryDeclareMainByIds(null, ids).getData();
        List<DynamicObject> result = MultiDeclareDataServiceHelper.transferData(model3List, model2List);
        return ServiceInvokeUtils.buildTaxResult(List.class, result);
    }

    private static List<DynamicObject> transferData(List<DynamicObject> model3List, List<DynamicObject> model2List) {
        if (CollectionUtils.isEmpty(model3List) && CollectionUtils.isEmpty(model2List)) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (DynamicObject declare : model3List) {
            result.add(declare);
        }
        for (DynamicObject declare : model2List) {
            result.add(DeclareMainTableBusiness.transferModel2ToModel3(declare));
        }
        return result;
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainTableByCreateTimeAndStatus(Date startDate, Date endDate, List<String> declareStatus, List<String> payStatus) {
        DeclareMainTableQueryDto queryDto = new DeclareMainTableQueryDto();
        queryDto.setCreateTime(new Date[]{startDate, endDate});
        queryDto.setDeclareStatus(declareStatus);
        queryDto.setPayStatus(payStatus);
        queryDto.setBillStatus(Lists.newArrayList((Object[])new String[]{"C"}));
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        List<DynamicObject> model3List = DeclareMainServiceHelper.queryDeclareMainTable(modelId, queryDto).getData();
        List<DynamicObject> model2List = DeclareMainServiceHelper.queryDeclareMainTable(null, queryDto).getData();
        List<DynamicObject> result = MultiDeclareDataServiceHelper.transferData(model3List, model2List);
        return ServiceInvokeUtils.buildTaxResult(List.class, result);
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainTableBySbrqAndStatus(Date startDate, Date endDate, List<String> declareStatus, List<String> payStatus) {
        DeclareMainTableQueryDto queryDto = new DeclareMainTableQueryDto();
        queryDto.setSbrq(new Date[]{startDate, endDate});
        queryDto.setDeclareStatus(declareStatus);
        queryDto.setPayStatus(payStatus);
        queryDto.setBillStatus(Lists.newArrayList((Object[])new String[]{"C"}));
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        List<DynamicObject> model3List = DeclareMainServiceHelper.queryDeclareMainTable(modelId, queryDto).getData();
        List<DynamicObject> model2List = DeclareMainServiceHelper.queryDeclareMainTable(null, queryDto).getData();
        List<DynamicObject> result = MultiDeclareDataServiceHelper.transferData(model3List, model2List);
        return ServiceInvokeUtils.buildTaxResult(List.class, result);
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainTableByStatus(List<String> declareStatus, List<String> payStatus) {
        DeclareMainTableQueryDto queryDto = new DeclareMainTableQueryDto();
        queryDto.setDeclareStatus(declareStatus);
        queryDto.setPayStatus(payStatus);
        queryDto.setBillStatus(Lists.newArrayList((Object[])new String[]{"C"}));
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        List<DynamicObject> model3List = DeclareMainServiceHelper.queryDeclareMainTable(modelId, queryDto).getData();
        List<DynamicObject> model2List = DeclareMainServiceHelper.queryDeclareMainTable(null, queryDto).getData();
        List<DynamicObject> result = MultiDeclareDataServiceHelper.transferData(model3List, model2List);
        return ServiceInvokeUtils.buildTaxResult(List.class, result);
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainTableByPayDateAndStatus(Date startDate, Date endDate, List<String> declareStatus, List<String> payStatus) {
        DeclareMainTableQueryDto queryDto = new DeclareMainTableQueryDto();
        queryDto.setPayDate(new Date[]{startDate, endDate});
        queryDto.setDeclareStatus(declareStatus);
        queryDto.setPayStatus(payStatus);
        queryDto.setBillStatus(Lists.newArrayList((Object[])new String[]{"C"}));
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        List<DynamicObject> model3List = DeclareMainServiceHelper.queryDeclareMainTable(modelId, queryDto).getData();
        List<DynamicObject> model2List = DeclareMainServiceHelper.queryDeclareMainTable(null, queryDto).getData();
        List<DynamicObject> result = MultiDeclareDataServiceHelper.transferData(model3List, model2List);
        return ServiceInvokeUtils.buildTaxResult(List.class, result);
    }

    public static TaxResult queryDeclareDataById(Long id) {
        Map<Long, String> modelVersionIdMap = DeclareMainServiceHelper.queryModelVersionByIds(Collections.singletonList(id)).getData();
        if (CollectionUtils.isEmpty(modelVersionIdMap)) {
            return ServiceInvokeUtils.createTaxResult(DynamicObject.class, ServiceResultUtils.returnResultHandler(false, "-1", "queryDeclareDataById failure.", null));
        }
        String modelVersion = modelVersionIdMap.entrySet().iterator().next().getValue();
        if (ModelVersionEnum.MODEL2.getVersion().equalsIgnoreCase(modelVersion)) {
            return DeclareDataServiceHelper.queryDeclareData(null, id);
        }
        Long modelId = DeclareBaseDataServiceHelper.queryModelIdByNumber(MultiTableEnum.TSCOO1.getModel()).getData();
        return DeclareDataServiceHelper.queryDeclareData(modelId, id);
    }

    public static TaxResult updateDeclareMainTable(List<DynamicObject> declares, DeclareOperationEnum operate, String source) {
        return DeclareMainTableBusiness.updateDeclareMainTable(declares, operate, source);
    }

    public static TaxResult<Map<Long, ModelVersionEnum>> queryModelVersionByIds(List<Long> ids) {
        Map<Long, String> versionMap = DeclareMainServiceHelper.queryModelVersionByIds(ids).getData();
        HashMap<Long, ModelVersionEnum> result = new HashMap<Long, ModelVersionEnum>(16);
        if (!CollectionUtils.isEmpty(versionMap)) {
            for (Map.Entry<Long, String> entry : versionMap.entrySet()) {
                result.put(entry.getKey(), ModelVersionEnum.getEnumByKey(entry.getValue()));
            }
        }
        return ServiceInvokeUtils.buildTaxResult(Map.class, result);
    }

    public static TaxResult<Map<Long, ModelVersionEnum>> queryModelVersionByObjs(List<DynamicObject> declares) {
        HashMap<Long, ModelVersionEnum> result = new HashMap<Long, ModelVersionEnum>(16);
        if (!CollectionUtils.isEmpty(declares)) {
            DynamicObject declare = null;
            int size = declares.size();
            for (int i = 0; i < size; ++i) {
                declare = declares.get(i);
                if (StringUtil.isBlank((CharSequence)declare.getString("sourcebillno"))) {
                    result.put(declare.getLong("id"), ModelVersionEnum.MODEL3);
                    continue;
                }
                result.put(declare.getLong("id"), ModelVersionEnum.MODEL2);
            }
        }
        return ServiceInvokeUtils.buildTaxResult(Map.class, result);
    }

    public static TaxResult<Map<String, ModelVersionEnum>> queryModelVersionByTypes(List<String> types) {
        Map<String, String> versionMap = DeclareMainServiceHelper.queryModelVersionByTypes(types).getData();
        HashMap<String, ModelVersionEnum> result = new HashMap<String, ModelVersionEnum>(16);
        if (!CollectionUtils.isEmpty(versionMap)) {
            for (Map.Entry<String, String> entry : versionMap.entrySet()) {
                result.put(entry.getKey(), ModelVersionEnum.getEnumByKey(entry.getValue()));
            }
        }
        return ServiceInvokeUtils.buildTaxResult(Map.class, result);
    }

    public static TaxResult<Boolean> syncModel2DataToModel3(List<Long> ids, DeclareOperationEnum operate) {
        return DeclareMainServiceHelper.syncModel2DataToModel3(ids, operate);
    }
}

