/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPUtils {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";

    public static byte[] compress(String str) {
        return GZIPUtils.compress(str, GZIP_ENCODE_UTF_8);
    }

    public static byte[] compress(String str, String encoding) {
        if (str != null && str.length() != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = null;
            try {
                gzip = new GZIPOutputStream(out);
                gzip.write(str.getBytes(encoding));
                gzip.close();
            }
            catch (IOException var5) {
                IOException e = var5;
                throw new RuntimeException("gzip compress error.", e);
            }
            finally {
                if (gzip != null) {
                    try {
                        gzip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return out.toByteArray();
        }
        return null;
    }

    public static byte[] uncompress(byte[] bytes) {
        if (bytes != null && bytes.length != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            GZIPInputStream ungzip = null;
            try {
                int n;
                ungzip = new GZIPInputStream(in);
                byte[] buffer = new byte[256];
                while ((n = ungzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
            }
            catch (IOException var6) {
                IOException e = var6;
                throw new RuntimeException("gzip uncompress error.", e);
            }
            finally {
                if (ungzip != null) {
                    try {
                        ungzip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return out.toByteArray();
        }
        return null;
    }

    public static String uncompressToString(byte[] bytes) {
        return GZIPUtils.uncompressToString(bytes, GZIP_ENCODE_UTF_8);
    }

    public static String uncompressToString(byte[] bytes, String encoding) {
        if (bytes != null && bytes.length != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            GZIPInputStream ungzip = null;
            try {
                int n;
                ungzip = new GZIPInputStream(in);
                byte[] buffer = new byte[256];
                while ((n = ungzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
                String string = out.toString(encoding);
                return string;
            }
            catch (IOException var7) {
                IOException e = var7;
                throw new RuntimeException("gzip uncompress to string error.", e);
            }
            finally {
                if (ungzip != null) {
                    try {
                        ungzip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

