/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.enums.DateFlagEnum;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;

public class DateUtils {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMM_CHINESE = DateUtils.getYyyymmChinese();
    public static final String YYYYMMDD_CHINESE = DateUtils.getYyyymmddChinese();
    public static final String MMDD_CHINESE = DateUtils.getMmddChinese();
    public static final String DD_CHINESE = DateUtils.getDdChinese();
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSSSS = "yyyyMMddHHmmssSS";
    public static final List<String> seasonStartMonth = Collections.unmodifiableList(Arrays.asList("1", "4", "7", "10"));
    public static final List<String> seasonEndMonth = Collections.unmodifiableList(Arrays.asList("3", "6", "9", "12"));
    public static final List<String> halfyearStartMonth = Collections.unmodifiableList(Arrays.asList("1", "7"));
    public static final List<String> halfyearEndMonth = Collections.unmodifiableList(Arrays.asList("6", "12"));

    private static String getYyyymmChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"DateUtils_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getYyyymmddChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateUtils_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getMmddChinese() {
        return ResManager.loadKDString((String)"MM\u6708dd\u65e5", (String)"DateUtils_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getDdChinese() {
        return ResManager.loadKDString((String)"dd\u65e5", (String)"DateUtils_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    public static int getMonthOfDate(Date date) {
        int m = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        m = cd.get(2);
        return m + 1;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String formatHMS(Date date) {
        return DateUtils.format(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getDayFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date stringToDate(String datestr) {
        Date date;
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%s", (String)"DateUtils_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), YYYY_MM_DD), e);
        }
        return date;
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 23:59:59";
        return DateUtils.stringToDate(str);
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addTime(Date date, int year, int month, int day) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, year);
        cd.add(2, month);
        cd.add(5, day);
        return cd.getTime();
    }

    public static Date getDayLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date trunc(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: %s", (String)"DateUtils_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), format), e);
        }
    }

    public static String formatTime(Long time) {
        Long hours = TimeUnit.MILLISECONDS.toHours(time);
        Long minutes = TimeUnit.MILLISECONDS.toMinutes(time) % 60L;
        Long seconds = TimeUnit.MILLISECONDS.toSeconds(time) % 60L;
        Long milliseconds = time % 1000L;
        String hoursStr = hours < 10L ? "0" + hours : "" + hours;
        String minutesStr = minutes < 10L ? "0" + minutes : "" + minutes;
        String secondsStr = seconds < 10L ? "0" + seconds : "" + seconds;
        String millisecondsStr = "" + milliseconds;
        return hoursStr + ":" + minutesStr + ":" + secondsStr + ":" + millisecondsStr;
    }

    public static Date[] getIntersectionDate(Date beginTime, Date endTime, Date startDate, Date endDate) {
        Date[] date = new Date[2];
        if (null == endTime && null == endDate) {
            if (null == beginTime && null != startDate) {
                date[0] = startDate;
            } else if (null != beginTime && null == startDate) {
                date[0] = beginTime;
            } else if (null != beginTime && null != startDate) {
                date[0] = beginTime.getTime() <= startDate.getTime() ? startDate : beginTime;
            }
        } else if (null == endTime && null != endDate) {
            if (null == beginTime && null == startDate) {
                date[1] = endDate;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime()) {
                date[0] = beginTime;
                date[1] = endDate;
            } else if (null == beginTime && null != startDate) {
                date[0] = startDate;
                date[1] = endDate;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() <= startDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endDate;
                } else if (beginTime.getTime() >= startDate.getTime() && beginTime.getTime() <= endDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endDate;
                }
            }
        } else if (null != endTime && null == endDate) {
            if (null == beginTime && null == startDate) {
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime()) {
                date[0] = startDate;
                date[1] = endTime;
            } else if (null != beginTime && null == startDate) {
                date[0] = beginTime;
                date[1] = endTime;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() >= startDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endTime;
                } else if (beginTime.getTime() <= startDate.getTime() && startDate.getTime() <= endTime.getTime()) {
                    date[0] = startDate;
                    date[1] = endTime;
                }
            }
        } else if (null != endTime && null != endDate) {
            if (null == beginTime && null == startDate && endTime.getTime() <= endDate.getTime()) {
                date[0] = endTime;
                date[1] = endDate;
            } else if (null == beginTime && null == startDate && endDate.getTime() <= endTime.getTime()) {
                date[0] = endDate;
                date[1] = endTime;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime() && endDate.getTime() <= endTime.getTime()) {
                date[0] = beginTime;
                date[1] = endDate;
            } else if (null != beginTime && null == startDate && beginTime.getTime() <= endDate.getTime() && endTime.getTime() <= endDate.getTime()) {
                date[0] = beginTime;
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime() && endTime.getTime() <= endDate.getTime()) {
                date[0] = startDate;
                date[1] = endTime;
            } else if (null == beginTime && null != startDate && startDate.getTime() <= endTime.getTime() && endDate.getTime() <= endTime.getTime()) {
                date[0] = startDate;
                date[1] = endDate;
            } else if (null != beginTime && null != startDate) {
                if (beginTime.getTime() <= startDate.getTime() && endTime.getTime() >= endDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endDate;
                } else if (beginTime.getTime() >= startDate.getTime() && endTime.getTime() <= endDate.getTime()) {
                    date[0] = beginTime;
                    date[1] = endTime;
                } else if (beginTime.getTime() >= startDate.getTime() && beginTime.getTime() <= endDate.getTime() && endDate.getTime() <= endTime.getTime()) {
                    date[0] = beginTime;
                    date[1] = endDate;
                } else if (beginTime.getTime() <= startDate.getTime() && startDate.getTime() <= endTime.getTime() && endTime.getTime() <= endDate.getTime()) {
                    date[0] = startDate;
                    date[1] = endTime;
                }
            }
        }
        if (null == date[0] && null == date[1]) {
            return null;
        }
        return date;
    }

    public static int getMonthSpan(Date d1, Date d2) {
        Date end;
        Date start;
        if (d1.after(d2)) {
            start = d2;
            end = d1;
        } else {
            start = d1;
            end = d2;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(start);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(end);
        int year1 = c1.get(1);
        int moth1 = c1.get(2);
        int year2 = c2.get(1);
        int moth2 = c2.get(2);
        return (year2 - year1) * 12 + (moth2 - moth1) + 1;
    }

    public static boolean isSameDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        String s1 = DateUtils.format(d1, YYYY_MM_DD);
        String s2 = DateUtils.format(d2, YYYY_MM_DD);
        return s1.equals(s2);
    }

    public static Date[] getDateRangeByFlag(String dayflag) {
        DateFlagEnum dayFlagEnum = DateFlagEnum.getInstance(dayflag);
        if (dayFlagEnum == null) {
            return null;
        }
        Date[] dateRange = new Date[2];
        Calendar calendar = null;
        switch (dayFlagEnum.getFlag()) {
            case "1": {
                dateRange[0] = DateUtils.getFirstPreDayOfDay();
                dateRange[1] = DateUtils.getLastPreDayOfDay();
                break;
            }
            case "2": {
                dateRange[0] = DateUtils.getFirstDayOfWeek();
                dateRange[1] = DateUtils.getLastDayOfWeek();
                break;
            }
            case "3": {
                calendar = Calendar.getInstance();
                dateRange[0] = DateUtils.getFirstDateOfMonth(calendar.getTime());
                dateRange[1] = DateUtils.getLastDateOfMonth(calendar.getTime());
                break;
            }
            case "4": {
                calendar = Calendar.getInstance();
                calendar.add(2, -1);
                dateRange[0] = DateUtils.getFirstDateOfMonth(calendar.getTime());
                dateRange[1] = DateUtils.getLastDateOfMonth(calendar.getTime());
                break;
            }
            case "5": {
                dateRange[0] = DateUtils.getLastMouthOfDay(-1);
                dateRange[1] = DateUtils.getLastDayOfDay();
                break;
            }
            case "6": {
                dateRange[0] = DateUtils.getLastMouthOfDay(-3);
                dateRange[1] = DateUtils.getLastDayOfDay();
            }
        }
        return dateRange;
    }

    public static Date getFirstPreDayOfDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastPreDayOfDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getLastDayOfDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getFirstDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(4, 0);
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, cal.getActualMaximum(7));
        cal.add(7, 1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getLastMouthOfDay(int span) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, span);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isDateRangeWithin(Date start1, Date end1, Date start2, Date end2) {
        start1 = start1 == null ? new Date(Long.MIN_VALUE) : start1;
        end1 = end1 == null ? new Date(Long.MAX_VALUE) : end1;
        start2 = start2 == null ? new Date(Long.MIN_VALUE) : start2;
        end2 = end2 == null ? new Date(Long.MAX_VALUE) : end2;
        start1 = DateUtils.toStartOfDay(start1);
        end1 = DateUtils.toStartOfDay(end1);
        start2 = DateUtils.toStartOfDay(start2);
        end2 = DateUtils.toStartOfDay(end2);
        return !start1.before(start2) && !end1.after(end2);
    }

    private static Date toStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

