/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils.job;

import java.util.Map;
import java.util.UUID;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class JobUtils {
    public static void dispatch(Map<String, Object> params, String appId, String taskName, String taskClassName, Long userId) {
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.BIZ);
        job.setName(taskName);
        job.setRunByUserId(userId.longValue());
        job.setId(UUID.randomUUID().toString());
        job.setTaskClassname(taskClassName);
        job.setParams(params);
        job.setAppId(appId);
        JobClient.dispatch((JobInfo)job);
    }

    public static void dispatchRealTime(Map<String, Object> params, String appId, String taskName, String taskClassName, Long userId) {
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.REALTIME);
        job.setName(taskName);
        job.setRunByUserId(userId.longValue());
        job.setId(UUID.randomUUID().toString());
        job.setTaskClassname(taskClassName);
        job.setParams(params);
        job.setAppId(appId);
        JobClient.dispatch((JobInfo)job);
    }

    public static void dispatch(IFormView formview, Map<String, Object> params, String taskName, String taskClassName, String callbackId, String callBackClassName, String clickClassName) {
        JobFormInfo jobFormInfo = JobUtils.createJobFormInfo(formview, params, taskName, taskClassName, callbackId, callBackClassName, clickClassName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formview);
    }

    public static void dispatch(IFormView formview, Map<String, Object> params, String taskName, String taskClassName, String callbackId, String callBackClassName, String clickClassName, Long userId) {
        JobFormInfo jobFormInfo = JobUtils.createJobFormInfo(formview, params, taskName, taskClassName, callbackId, callBackClassName, clickClassName);
        jobFormInfo.getJobInfo().setRunByUserId(userId.longValue());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formview);
    }

    public static JobFormInfo createJobFormInfo(IFormView formview, Map<String, Object> params, String taskName, String taskClassName, String callbackId, String callBackClassName, String clickClassName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formview.getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(params);
        jobInfo.setRunByLang(Lang.get());
        params.put("isSync", "1");
        CloseCallBack closeCallBack = new CloseCallBack(callBackClassName, callbackId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        if (StringUtil.isNotBlank((CharSequence)clickClassName)) {
            jobFormInfo.setClickClassName(clickClassName);
        }
        return jobFormInfo;
    }

    public static String dispatch(IFormView formview, Map<String, Object> params, String taskName, String taskClassName) {
        JobInfo jobInfo = JobUtils.createJoInfo(formview, params, taskName, taskClassName);
        return JobClient.dispatch((JobInfo)jobInfo);
    }

    public static JobInfo createJoInfo(IFormView formview, Map<String, Object> params, String taskName, String taskClassName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(formview.getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setRunConcurrently(false);
        jobInfo.setParams(params);
        return jobInfo;
    }
}

