/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.utils.metadata.domain.EntityInfo;
import org.apache.commons.lang3.StringUtils;

public class MetadataUtil {
    public static EntityInfo getEntityById(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                DecimalProp decProp;
                EntityField entityField = new EntityField();
                entityField.setEntityId(entityid);
                entityField.setEntityName(entity.getEntityName());
                entityField.setFieldId(property.getName());
                if (property.getDisplayName() != null) {
                    entityField.setFieldName(property.getDisplayName().getLocaleValue());
                }
                if (property instanceof FieldProp) {
                    FieldProp field = (FieldProp)property;
                    entityField.setMustInput(field.isMustInput());
                }
                entityField.setColumnName(property.getAlias());
                entityField.setFieldType(property.getClass().getSimpleName().replaceAll("Prop", ""));
                if (property instanceof DecimalProp) {
                    decProp = (DecimalProp)property;
                    entityField.setPrecision(decProp.getPrecision());
                    entityField.setScale(decProp.getScale());
                    if ("gtcp_rus_vat_draft".equals(entityid) || "tcvat_ybnsr_zb".equals(entityid)) {
                        entityField.setScale(2);
                        entityField.setFieldType("Decimal");
                    }
                } else if (property instanceof BasedataProp) {
                    decProp = (BasedataProp)property;
                    entityField.setBaseEntityId(decProp.getBaseEntityId());
                    entityField.setDisplayProp(decProp.getDisplayProp());
                } else if (property instanceof ComboProp) {
                    entityField.setComboItems(((ComboProp)property).getComboItems());
                } else if (property instanceof TextProp) {
                    entityField.setMaxLength(((TextProp)property).getMaxLenth());
                } else if (property instanceof DateTimeProp) {
                    entityField.setFormat(((DateTimeProp)property).getDateFormat());
                }
                entity.addField(entityField);
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            entity.setAllFields(sb.toString());
            return entity;
        }
        return null;
    }

    public static String getAllFieldString(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            return sb.toString();
        }
        return " * ";
    }

    public static String getAllFieldStringNoCollection(String entityid) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                if (StringUtils.isEmpty((CharSequence)property.getAlias()) || property instanceof DynamicCollectionProperty) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            return sb.toString();
        }
        return " * ";
    }

    public static List<ValueMapItem> getComboItems(String entityId, String fieldId) {
        DataEntityPropertyCollection mainPros;
        IDataEntityProperty property;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null && (property = (IDataEntityProperty)(mainPros = mainEntityType.getProperties()).get((Object)fieldId)) instanceof ComboProp) {
            return ((ComboProp)property).getComboItems();
        }
        return null;
    }

    public static Map<String, String> getComboItemsMap(String entityId, String fieldId) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            IDataEntityProperty property = null;
            if (fieldId.contains(".")) {
                Map allEntities = mainEntityType.getAllEntities();
                String[] splits = fieldId.split("\\.");
                property = ((EntityType)allEntities.get(splits[0])).getProperty(splits[1]);
            } else {
                DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
                property = (IDataEntityProperty)mainPros.get((Object)fieldId);
            }
            if (property instanceof ComboProp) {
                List items = ((ComboProp)property).getComboItems();
                for (ValueMapItem item : items) {
                    itemMap.put(item.getValue(), item.getName().getLocaleValue());
                }
            }
        }
        return itemMap;
    }

    public static Map<String, String> getSubComboItemsMap(String entityId, String fieldId) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                DataEntityPropertyCollection mainPros = value.getProperties();
                IDataEntityProperty property = (IDataEntityProperty)mainPros.get((Object)fieldId);
                if (property == null || !(property instanceof ComboProp)) continue;
                List items = ((ComboProp)property).getComboItems();
                for (ValueMapItem item : items) {
                    itemMap.put(item.getValue(), item.getName().getLocaleValue());
                }
            }
        }
        return itemMap;
    }

    public static String getOrgFun(String entityId, String entityKey, String fieldName) {
        OrgProp orgProp = MetadataUtil.getOrgProp(entityId, entityKey, fieldName);
        return orgProp != null ? orgProp.getOrgFunc() : null;
    }

    public static OrgProp getOrgProp(String entityId, String entityKey, String fieldName) {
        DynamicProperty property;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Map allEntities = mainEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(entityKey);
        if (entityType != null && (property = entityType.getProperty(fieldName)) instanceof OrgProp) {
            return (OrgProp)property;
        }
        return null;
    }

    public static EntityInfo getEntityAllById(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            ArrayList<String> names = new ArrayList<String>(32);
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                DataEntityPropertyCollection mainPros = value.getProperties();
                for (IDataEntityProperty property : mainPros) {
                    String refIdType;
                    DecimalProp decProp;
                    String parentName = property.getParent().getName();
                    if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                    String name = property.getName();
                    if (!entityid.equals(parentName)) {
                        name = entityid.equals(value.getParent().getName()) ? parentName + "." + name : value.getParent().getName() + "." + parentName + "." + name;
                    }
                    EntityField entityField = new EntityField();
                    entityField.setEntityId(entityid);
                    entityField.setEntityName(entity.getEntityName());
                    entityField.setFieldId(name);
                    if (property.getDisplayName() != null) {
                        entityField.setFieldName(property.getDisplayName().getLocaleValue());
                    }
                    if (property instanceof FieldProp) {
                        FieldProp field = (FieldProp)property;
                        entityField.setMustInput(field.isMustInput());
                    }
                    entityField.setColumnName(property.getAlias());
                    entityField.setFieldType(property.getClass().getSimpleName().replaceAll("Prop", ""));
                    if (property instanceof DecimalProp) {
                        decProp = (DecimalProp)property;
                        entityField.setPrecision(decProp.getPrecision());
                        entityField.setScale(decProp.getScale());
                    } else if (property instanceof MulBasedataProp) {
                        decProp = (MulBasedataProp)property;
                        refIdType = decProp.getRefIdProp().getClass().getSimpleName().replaceAll("Prop", "");
                        entityField.setRefIdType(refIdType);
                        entityField.setBaseEntityId(decProp.getBaseEntityId());
                        entityField.setDisplayProp(decProp.getDisplayProp());
                    } else if (property instanceof BasedataProp) {
                        decProp = (BasedataProp)property;
                        refIdType = decProp.getRefIdProp().getClass().getSimpleName().replaceAll("Prop", "");
                        entityField.setRefIdType(refIdType);
                        entityField.setBaseEntityId(decProp.getBaseEntityId());
                        entityField.setDisplayProp(decProp.getDisplayProp());
                    } else if (property instanceof ComboProp) {
                        entityField.setComboItems(((ComboProp)property).getComboItems());
                    } else if (property instanceof TextProp) {
                        entityField.setMaxLength(((TextProp)property).getMaxLenth());
                    } else if (property instanceof DateTimeProp) {
                        entityField.setFormat(((DateTimeProp)property).getDateFormat());
                    }
                    entity.addField(entityField);
                    names.add(name);
                }
            }
            entity.setAllFields(names.stream().collect(Collectors.joining(",")));
            return entity;
        }
        return null;
    }

    public static EntityInfo getEntityAllById2(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            StringBuilder sb = new StringBuilder();
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                ArrayList<Object> mainPros = new ArrayList<Object>();
                mainPros.addAll(value.getFields().values());
                mainPros.add(value.getPrimaryKey());
                for (IDataEntityProperty iDataEntityProperty : mainPros) {
                    DecimalProp decProp;
                    String parentName = iDataEntityProperty.getParent().getName();
                    if (StringUtils.isEmpty((CharSequence)iDataEntityProperty.getAlias())) continue;
                    String name = iDataEntityProperty.getName();
                    if (entityid.equals(parentName)) {
                        sb.append(name);
                    } else {
                        name = parentName + "." + name;
                    }
                    EntityField entityField = new EntityField();
                    entityField.setEntityId(entityid);
                    entityField.setEntityName(entity.getEntityName());
                    entityField.setFieldId(name);
                    if (iDataEntityProperty.getDisplayName() != null) {
                        entityField.setFieldName(iDataEntityProperty.getDisplayName().getLocaleValue());
                    }
                    if (iDataEntityProperty instanceof FieldProp) {
                        FieldProp field = (FieldProp)iDataEntityProperty;
                        entityField.setMustInput(field.isMustInput());
                    }
                    entityField.setColumnName(iDataEntityProperty.getAlias());
                    entityField.setFieldType(iDataEntityProperty.getClass().getSimpleName().replaceAll("Prop", ""));
                    if (iDataEntityProperty instanceof DecimalProp) {
                        decProp = (DecimalProp)iDataEntityProperty;
                        entityField.setPrecision(decProp.getPrecision());
                        entityField.setScale(decProp.getScale());
                    } else if (iDataEntityProperty instanceof BasedataProp) {
                        decProp = (BasedataProp)iDataEntityProperty;
                        entityField.setBaseEntityId(decProp.getBaseEntityId());
                        entityField.setDisplayProp(decProp.getDisplayProp());
                    } else if (iDataEntityProperty instanceof ComboProp) {
                        entityField.setComboItems(((ComboProp)iDataEntityProperty).getComboItems());
                    } else if (iDataEntityProperty instanceof TextProp) {
                        entityField.setMaxLength(((TextProp)iDataEntityProperty).getMaxLenth());
                    } else if (iDataEntityProperty instanceof DateTimeProp) {
                        entityField.setFormat(((DateTimeProp)iDataEntityProperty).getDateFormat());
                    }
                    entity.addField(entityField);
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(name);
                }
            }
            entity.setAllFields(sb.toString());
            return entity;
        }
        return null;
    }

    public static String getAllSubFieldString(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            StringBuilder sb = new StringBuilder();
            Map allFieldsMap = mainEntityType.getAllFields();
            Map allEntities = mainEntityType.getAllEntities();
            allEntities.forEach((a, b) -> {
                ISimpleProperty primaryKey = b.getPrimaryKey();
                if (Objects.equals(b.getName(), entityid)) {
                    allFieldsMap.put(primaryKey.getName(), primaryKey);
                } else {
                    allFieldsMap.put(b.getName() + "." + primaryKey.getName(), primaryKey);
                    DynamicProperty seq = b.getProperty("seq");
                    allFieldsMap.put(b.getName() + "." + seq.getName(), seq);
                }
            });
            Collection allFields = allFieldsMap.values();
            for (IDataEntityProperty property : allFields) {
                IDataEntityType parent = property.getParent();
                String parentName = parent.getName();
                if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                String name = property.getName();
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (entityid.equals(parentName)) {
                    sb.append(name);
                    continue;
                }
                if (parent.getParent() != null && !entityid.equals(parent.getParent().getName())) {
                    sb.append(parent.getParent().getName());
                    sb.append(".");
                    sb.append(parentName);
                    sb.append(".");
                    sb.append(name);
                    continue;
                }
                sb.append(parentName);
                sb.append(".");
                sb.append(name);
            }
            return sb.toString();
        }
        return " * ";
    }

    public static String getFiledLocalStr(String entityId, String fieldId) {
        DynamicProperty property;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null && (property = mainEntityType.getProperty(fieldId)) != null) {
            return property.getDisplayName().getLocaleValue();
        }
        return null;
    }

    public static IDataEntityProperty findProp(String entityname, String key_field) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityname);
        if (mainEntityType != null) {
            Map allEntities = mainEntityType.getAllEntities();
            if (key_field.contains(".")) {
                String[] split = key_field.split("\\.");
                if (split.length == 2) {
                    EntityType entityType = (EntityType)allEntities.get(split[0]);
                    Map fields = entityType.getFields();
                    return (IDataEntityProperty)fields.get(split[1]);
                }
                if (split.length == 3) {
                    EntityType entityType = (EntityType)allEntities.get(split[1]);
                    Map fields = entityType.getFields();
                    return (IDataEntityProperty)fields.get(split[2]);
                }
            } else {
                EntityType entityType = (EntityType)allEntities.get(entityname);
                Map fields = entityType.getFields();
                return (IDataEntityProperty)fields.get(key_field);
            }
        }
        return null;
    }
}

