/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.accessconfig;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.AssistantProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.dto.CompareTypeAndValDto;
import kd.taxc.bdtaxr.common.enums.tdm.InvoiceTypeEnum;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.utils.json.JsonUtil;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.utils.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class AbstractBillFilterOperPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    public static final String BillFilter_entityNumber = "entityNumber";
    public static final String BillFilter_entityId = "entityId";
    public static final String CustParamKey_FilterJson = "filterJson";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";
    private static final String BOS_ORG = "bos_org";
    private static final Set<String> ref_entity_ids = new HashSet<String>(){
        {
            this.add("bd_accountview");
        }
    };
    public static final String INVOICE_TYPE = "invoice_type";
    private static final String REPLACE_MAP_KEY = "replaceMap";
    private static final Set<String> compareTypes_need_merge = new HashSet<String>(){
        {
            this.add(AbstractBillFilterOperPlugin.EQUEAL);
            this.add(AbstractBillFilterOperPlugin.NOT_EQUEAL);
            this.add(AbstractBillFilterOperPlugin.CONTAIN);
            this.add(AbstractBillFilterOperPlugin.NOT_CONTAIN);
            this.add(AbstractBillFilterOperPlugin.START_WITH);
            this.add(AbstractBillFilterOperPlugin.END_WITH);
        }
    };
    private static final Set<String> compareTypes_stay_same = new HashSet<String>(){
        {
            this.add(AbstractBillFilterOperPlugin.IN);
            this.add(AbstractBillFilterOperPlugin.NOT_IN);
        }
    };
    private static final Map<String, String> cnNameToSymbol = new LinkedHashMap<String, String>(){
        {
            this.put(AbstractBillFilterOperPlugin.getNotInCn(), AbstractBillFilterOperPlugin.NOT_IN);
            this.put(AbstractBillFilterOperPlugin.getInCn(), AbstractBillFilterOperPlugin.IN);
            this.put(AbstractBillFilterOperPlugin.getNotEqualCn(), AbstractBillFilterOperPlugin.NOT_EQUEAL);
            this.put(AbstractBillFilterOperPlugin.getEqualCn(), AbstractBillFilterOperPlugin.EQUEAL);
            this.put(AbstractBillFilterOperPlugin.getNotContainCn(), AbstractBillFilterOperPlugin.NOT_CONTAIN);
            this.put(AbstractBillFilterOperPlugin.getContainCn(), AbstractBillFilterOperPlugin.CONTAIN);
            this.put(AbstractBillFilterOperPlugin.getStartWithCn(), AbstractBillFilterOperPlugin.START_WITH);
            this.put(AbstractBillFilterOperPlugin.getEndWithCn(), AbstractBillFilterOperPlugin.END_WITH);
        }
    };
    private static final String EQUEAL = "67";
    private static final String NOT_EQUEAL = "83";
    private static final String IN = "17";
    private static final String NOT_IN = "34";
    private static final String START_WITH = "60";
    private static final String END_WITH = "211";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    private static final String PERCENT = "%";
    private static final String GL_VOUCHER = "gl_voucher";
    private static final String GL_BALANCE = "gl_balance";
    private static final String ACCOUNT_TYPE = "bd_accountbookstype";
    private static final String BOOK_TYPE_DEFAULT_VALUE = "1";
    private static final String STATUS_DEFAULT_VALUE = "C";
    private static final List<String> jsNumbers = Lists.newArrayList((Object[])new String[]{"701020601", "701020602", "701020603", "701020604", "701020605", "701020606", "701020607", "701020608", "701020609", "701020610", "701020611", "701020612", "701020613", "701020614", "701020615", "701020616", "701020617"});
    private static final List<String> suzclbNumber = Lists.newArrayList((Object[])new String[]{"701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "701020201", "701020202", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "701020401", "701020402", "701020403", "701020404", "701020405", "701020501", "701020502"});

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        QFilter userQfilter;
        Object ruletype;
        String fieldName = evt.getFieldName();
        HashMap hashMap = Maps.newHashMap();
        if ("jszjtxlx.number".equals(fieldName) || "jszjtxlx.name".equals(fieldName)) {
            Object entityNumber = this.getView().getFormShowParameter().getCustomParams().get(BillFilter_entityNumber);
            if ("tccit_tax_acce_diff".equals(entityNumber)) {
                hashMap.put("type", "acce");
            } else {
                hashMap.put("type", "zcajust");
                hashMap.put("ptNumbers", jsNumbers);
                hashMap.put("isSpeed", "yes");
            }
            evt.setCustomParams((Map)hashMap);
        }
        if ("taxassetstype.number".equals(fieldName) || "taxassetstype.name".equals(fieldName)) {
            hashMap.put("type", "zcajust");
            hashMap.put("suzclbNumber", suzclbNumber);
            evt.setCustomParams((Map)hashMap);
        }
        if (fieldName.endsWith("assettype.number") || fieldName.endsWith("assettype.projectname")) {
            hashMap.put("parentNum", BOOK_TYPE_DEFAULT_VALUE);
            evt.setCustomParams((Map)hashMap);
        } else if (fieldName.endsWith("investtype.number") || fieldName.endsWith("investtype.projectname")) {
            hashMap.put("parentNum", "2");
            evt.setCustomParams((Map)hashMap);
        } else if (fieldName.endsWith("transtype.number") || fieldName.endsWith("transtype.projectname")) {
            hashMap.put("parentNum", "3");
            hashMap.put("containParent", Boolean.TRUE);
            hashMap.put("caption", ResManager.loadKDString((String)"\u6295\u8d44\u8d44\u4ea7\u5904\u7f6e\u4ea4\u6613\u7c7b\u578b", (String)"AbstractBillFilterOperPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            evt.setCustomParams((Map)hashMap);
        }
        if (fieldName.startsWith("row.")) {
            hashMap.put("caption", ResManager.loadKDString((String)"\u884c\u7ef4\u6210\u5458\u9009\u62e9", (String)"AbstractBillFilterOperPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            evt.setCustomParams((Map)hashMap);
        }
        if (fieldName.startsWith("itemclassfield.")) {
            // empty if block
        }
        if ("public".equals(ruletype = this.getView().getFormShowParameter().getCustomParams().get("ruletype")) && "tdm_account".equals(evt.getRefEntityId())) {
            evt.setRefEntityId("tdm_account_summary");
        }
        if ("bd_invoicetype".equals(evt.getRefEntityId())) {
            String no_special;
            if (StringUtil.isNotBlank((CharSequence)this.getPageCache().get(INVOICE_TYPE))) {
                QFilter q = new QFilter("number", "in", Arrays.asList(this.getPageCache().get(INVOICE_TYPE).split(",")));
                evt.addCustomQFilter(q);
            }
            if (Objects.equals(no_special = (String)this.getView().getFormShowParameter().getCustomParam("NO_SPECIAL"), "true")) {
                QFilter q = new QFilter("number", "not in", Arrays.asList("2", "4", "27"));
                evt.addCustomQFilter(q);
            }
        }
        if ("tpo_tcsd_taxrateentrytree".equals(evt.getRefEntityId()) && fieldName.startsWith("vouchertype.")) {
            evt.addCustomQFilter(new QFilter("isleaf", "=", (Object)BOOK_TYPE_DEFAULT_VALUE));
        }
        if ("tpo_tcvat_bizdef".equals(evt.getRefEntityId()) && fieldName.startsWith("deductiontypebase.")) {
            hashMap.put("group.number", "VAT_JXDK_BQDK");
            hashMap.put("dataSourceFilter", true);
            evt.setCustomParams((Map)hashMap);
        }
        boolean isAddExtendFilter = false;
        String orgid = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
        if (StringUtil.isNotBlank((CharSequence)orgid) && (userQfilter = BaseDataServiceHelper.getBaseDataFilter((String)evt.getRefEntityId(), (Long)Long.parseLong(orgid))) != null) {
            evt.getCustomQFilters().add(userQfilter);
            isAddExtendFilter = true;
        }
        if ("bos_assistantdata_detail".equalsIgnoreCase(evt.getRefEntityId())) {
            AssistantProp assistantProp;
            String assttypeId;
            QFilter userQfilter2;
            String baseDataField;
            MainEntityType mainEntityType;
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get(BillFilter_entityNumber);
            if (StringUtil.isNotBlank((CharSequence)orgid) && StringUtils.isNotBlank((CharSequence)entityNumber) && (mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)).findProperty(baseDataField = fieldName.split("\\.")[0]) instanceof AssistantProp && (userQfilter2 = AssistantDataServiceHelper.getAssistantDataFilter((Long)ObjectUtils.toLong(assttypeId = (assistantProp = (AssistantProp)mainEntityType.findProperty(baseDataField)).getAsstTypeId()), (Long)ObjectUtils.toLong(orgid))) != null) {
                userQfilter2.and(new QFilter("group.id", "=", (Object)ObjectUtils.toLong(assttypeId)));
                evt.getCustomQFilters().add(userQfilter2);
                isAddExtendFilter = true;
            }
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        int rowIndex = evt.getRowIndex();
        if (rowIndex > filteList.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u4e4b\u524d\u5b58\u5728\u914d\u7f6e\u884c\u672a\u914d\u7f6e\u6570\u636e\u7684\u60c5\u51b5\uff0c\u8bf7\u5148\u914d\u7f6e\u597d\u3002", (String)"AbstractBillFilterOperPlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), rowIndex + 1));
            evt.setCancel(true);
        } else {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            if (rowIndex != filteList.size()) {
                SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filteList.get(rowIndex);
                List value = simpleFilterRow.getValue();
                QFilter q1 = new QFilter(evt.getRefPropKey(), "in", value.stream().map(FilterValue::getValue).collect(Collectors.toList()));
                qFilterList.add(q1);
            }
            QFilter q2 = null;
            String refEntityId = evt.getRefEntityId();
            if (!("public".equals(ruletype) && "tdm_account_summary".equals(evt.getRefEntityId()) || isAddExtendFilter)) {
                EntityInfo entityById = MetadataUtil.getEntityById(refEntityId);
                List<EntityField> fieldList = entityById.getFieldList();
                for (EntityField entityField : fieldList) {
                    if (!StringUtil.isNotEmpty((CharSequence)entityField.getColumnName()) || !BOS_ORG.equals(entityField.getBaseEntityId()) || StringUtil.isBlank((CharSequence)orgid)) continue;
                    q2 = new QFilter(entityField.getFieldId(), "=", (Object)Long.parseLong(orgid));
                    qFilterList.add(q2);
                    evt.addCustomQFilter(q2);
                    break;
                }
            }
            QFilter[] qFilters = new QFilter[qFilterList.size()];
            for (int i = 0; i < qFilters.length; ++i) {
                qFilters[i] = (QFilter)qFilterList.get(i);
            }
            DynamicObjectCollection ids = QueryServiceHelper.query((String)refEntityId, (String)"id", (QFilter[])qFilters);
            evt.setSelectedIds(ids.stream().map(e -> e.get("id")).toArray());
        }
    }

    private void addExtendFilter(BeforeFilterF7SelectEvent evt, Object ruletype) {
        if (ref_entity_ids.contains(evt.getRefEntityId())) {
            QFilter userQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgid")));
            evt.getCustomQFilters().add(userQfilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        this.getPageCache().put(INVOICE_TYPE, InvoiceTypeEnum.getEnumByEntityId(entityNumber));
        Long entityid = (Long)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityId);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        this.initFilterCondition(entityid, entityNumber);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FilterJson);
        if ((GL_VOUCHER.equals(entityNumber) || GL_BALANCE.equals(entityNumber)) && StringUtils.isBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = new FilterCondition();
            ArrayList<SimpleFilterRow> filteList = new ArrayList<SimpleFilterRow>(2);
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)this.getMainBookId());
            filteList.add(new SimpleFilterRow("", EQUEAL, "booktype.number", "", "0", Collections.singletonList(filterValue)));
            if (GL_VOUCHER.equals(entityNumber)) {
                FilterValue filterValue1 = new FilterValue();
                filterValue1.setValue((Object)STATUS_DEFAULT_VALUE);
                filteList.add(new SimpleFilterRow("", "105", "billstatus", "", "0", Collections.singletonList(filterValue1)));
            }
            String modelType = "DynamicFormModel";
            DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
            DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
            binder.setWriteInheritFlag(true);
            filterCondition.setFilterRow(filteList);
            Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
            filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        }
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson, entityNumber);
        }
    }

    private void initFilterCondition(Long entityid, String entityNumber) {
        String appId;
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (GL_BALANCE.equals(entityNumber)) {
            ((DynamicProperty)entityType.getFields().get("org")).setAlias("forgid");
            ((DynamicProperty)entityType.getFields().get("booktype")).setAlias("fbooktypeid");
            ((DynamicProperty)entityType.getFields().get("period")).setAlias("FPERIODID");
            ((DynamicProperty)entityType.getFields().get("endperiod")).setAlias("FENDPERIODID");
            ((DynamicProperty)entityType.getFields().get("accounttable")).setAlias("faccounttableid");
            ((DynamicProperty)entityType.getFields().get("account")).setAlias("FACCOUNTID");
            ((DynamicProperty)entityType.getFields().get("assgrp")).setAlias("fassgrpid");
            ((DynamicProperty)entityType.getFields().get("currency")).setAlias("FCURRENCYID");
            ((DynamicProperty)entityType.getFields().get("measureunit")).setAlias("FMEASUREUNITID");
        }
        if (StringUtil.equals((CharSequence)"itp", (CharSequence)(appId = this.getView().getFormShowParameter().getAppId())) && StringUtil.equals((CharSequence)"tdm_finance_lrb", (CharSequence)entityNumber)) {
            ((DynamicProperty)entityType.getFields().get("accountbookstype")).setAlias("faccountbookstype");
        }
        if (EntityV3Constant.ENTITY_V3.containsKey(entityNumber) && entityType.getFields().containsKey("fetchitemtype") && entityType.getFields().containsKey("fetchitem")) {
            ((DynamicProperty)entityType.getFields().get("fetchitemtype")).setAlias("fetchitemtype");
            ((DynamicProperty)entityType.getFields().get("fetchitem")).setAlias("fetchitem");
        }
        List list = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        QFilter tableIdQfilter = new QFilter("tableid", "=", (Object)entityid);
        QFilter wherestateQfilter = new QFilter("wherestate", "=", (Object)BOOK_TYPE_DEFAULT_VALUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_datasource_entry", (String)"fieldname,bizsubname,fieldsubname", (QFilter[])new QFilter[]{tableIdQfilter, wherestateQfilter});
        HashMap replaceMap = new HashMap();
        ArrayList filterColumns = new ArrayList();
        list.stream().forEach(filterColumn -> {
            String type = (String)filterColumn.get("type");
            String fieldName = (String)filterColumn.get("fieldName");
            dynamicObjects.stream().forEach(dynamicObject -> {
                String bizsubname = dynamicObject.getString("bizsubname");
                this.buildFilterColumn(entityNumber, replaceMap, filterColumns, (Map<String, Object>)filterColumn, type, fieldName, (DynamicObject)dynamicObject, bizsubname);
            });
        });
        this.getPageCache().put(REPLACE_MAP_KEY, SerializationUtils.toJsonString(replaceMap));
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        this.getView().updateView(Key_filtergridap);
    }

    private void buildFilterColumn(String entityNumber, Map<String, String> replaceMap, List<Map<String, Object>> filterColumns, Map<String, Object> filterColumn, String type, String fieldName, DynamicObject dynamicObject, String bizsubname) {
        Boolean baseDataNew = fieldName.split("\\.").length > 1;
        if ("basedata".equals(type) || "enum".equals(type) || baseDataNew.booleanValue()) {
            if (fieldName.equals(dynamicObject.getString("fieldname")) || fieldName.split("\\.").length == 2 && fieldName.split("\\.")[0].equals(dynamicObject.getString("fieldname"))) {
                String oldCaption = (String)filterColumn.get("fieldCaption");
                if (entityNumber.equals("tccit_invest_dispose")) {
                    String newCaption = fieldName.startsWith("transtype.") || fieldName.startsWith("assetlosstype.") ? oldCaption.split("\\.")[1] : oldCaption.split("\\.")[0];
                    boolean anyMatch = filterColumns.stream().anyMatch(s -> s.get("fieldCaption").equals(newCaption));
                    if (!anyMatch) {
                        filterColumn.put("fieldCaption", newCaption);
                        filterColumns.add(filterColumn);
                    }
                } else if (fieldName.startsWith("row.")) {
                    boolean anyMatch;
                    boolean bl = anyMatch = fieldName.endsWith(".longnumber") || fieldName.endsWith(".fullname");
                    if (!anyMatch) {
                        ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals(EQUEAL));
                        filterColumns.add(filterColumn);
                    }
                } else {
                    if ("assetdata.assetclass".equals(filterColumn.get("fieldName")) || "assetdata.assetcode".equals(filterColumn.get("fieldName"))) {
                        return;
                    }
                    String newCaption = oldCaption;
                    if (newCaption.startsWith(ResManager.loadKDString((String)"\u5206\u5f55\u4f53", (String)"AbstractBillFilterOperPlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0])) || newCaption.startsWith(ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"AbstractBillFilterOperPlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]))) {
                        newCaption = newCaption.substring(4);
                    }
                    if ((entityNumber.equals("sim_vatinvoice") || entityNumber.equals("sim_vatinvoice_vehicles")) && "taxrate".equals(dynamicObject.getString("fieldname"))) {
                        if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("NO_TAXRATE"), "true")) {
                            return;
                        }
                        newCaption = ResManager.loadKDString((String)"\u7a0e\u7387", (String)"AbstractBillFilterOperPlugin_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                    }
                    filterColumn.put("fieldCaption", newCaption);
                    replaceMap.put(oldCaption, newCaption);
                    filterColumns.add(filterColumn);
                }
            }
        } else if (fieldName.equals(dynamicObject.getString("fieldname"))) {
            replaceMap.put((String)filterColumn.get("fieldCaption"), bizsubname);
            filterColumn.put("fieldCaption", bizsubname);
            if (fieldName.equals("assgrp") && (GL_VOUCHER.equals(entityNumber) || GL_BALANCE.equals(entityNumber))) {
                ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals(IN) && !dto.getId().equals(NOT_IN));
            }
            if (fieldName.equals("swczsyss") && "tccit_invest_dispose".equals(entityNumber)) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams.get("ruleCode").equals("RULE-CIT-HJ-SRTZ-TZZCCZSY")) {
                    ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals(BOOK_TYPE_DEFAULT_VALUE));
                } else if (customParams.get("ruleCode").equals("RULE-CIT-HJ-ZCTZ-ZCSS-01")) {
                    ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals("2"));
                }
            }
            filterColumns.add(filterColumn);
        }
    }

    private void setDataFilter(String dataFilter, String entityNumber) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        this.updateAssgrpToOrigin(filterCondition, entityNumber);
        filterGrid.SetValue(filterCondition);
    }

    private void updateAssgrpToOrigin(FilterCondition filterCondition, String entityNumber) {
        if (!GL_VOUCHER.equals(entityNumber) && !GL_BALANCE.equals(entityNumber)) {
            return;
        }
        String description = (String)this.getView().getFormShowParameter().getCustomParam("description");
        List<CompareTypeAndValDto> dtos = this.getCompareTypeAndValDtos(description, filterCondition.getFilterRow());
        int i = 0;
        for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
            if (!"assgrp".equals(filterRow.getFieldName()) || i >= dtos.size()) continue;
            CompareTypeAndValDto dto = dtos.get(i);
            filterRow.setValue(dto.getValue());
            filterRow.setCompareType(dto.getCompareType());
            ++i;
        }
    }

    private List<CompareTypeAndValDto> getCompareTypeAndValDtos(String description, List<SimpleFilterRow> filterRows) {
        if (null == description) {
            return new ArrayList<CompareTypeAndValDto>();
        }
        LinkedList<CompareTypeAndValDto> result = new LinkedList<CompareTypeAndValDto>();
        String[] filterDescs = description.split(ResManager.loadKDString((String)"\u6216\u8005|\u5e76\u4e14", (String)"AbstractBillFilterOperPlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        block0: for (int i = 0; i < filterDescs.length; ++i) {
            if (!filterDescs[i].contains(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"AbstractBillFilterOperPlugin_7", (String)"taxc-bdtaxr-base", (Object[])new Object[0])) && !filterDescs[i].contains(ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee", (String)"AbstractBillFilterOperPlugin_8", (String)"taxc-bdtaxr-base", (Object[])new Object[0]))) continue;
            String desc = this.getTrimedDesc(filterDescs[i], filterRows.get(i));
            for (Map.Entry<String, String> entry : cnNameToSymbol.entrySet()) {
                if (!desc.contains(entry.getKey())) continue;
                String[] parts = desc.split(entry.getKey());
                if (parts.length != 2) continue block0;
                CompareTypeAndValDto dto = new CompareTypeAndValDto();
                dto.setCompareType(entry.getValue());
                ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>();
                dto.setValue(filterValues);
                String input = parts[1].trim();
                if (input.contains(";") && (entry.getValue().equals(NOT_IN) || entry.getValue().equals(IN))) {
                    String[] vals;
                    for (String val : vals = input.split(";")) {
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)val);
                        filterValues.add(filterValue);
                    }
                } else {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setValue((Object)input);
                    filterValues.add(filterValue);
                }
                result.add(dto);
                continue block0;
            }
        }
        return result;
    }

    private String getTrimedDesc(String filterDesc, SimpleFilterRow filterRow) {
        String leftBracket = filterRow.getLeftBracket();
        String rightBracket = filterRow.getRightBracket();
        filterDesc = filterDesc.trim();
        return filterDesc.substring(leftBracket.length(), filterDesc.length() - rightBracket.length()).trim();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            List filteList = filterCondition.getFilterRow();
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
            if (EntityV3Constant.ENTITY_V3.containsKey(entityNumber)) {
                long count = filteList.stream().filter(o -> null != o.getFieldName() && o.getFieldName().startsWith("row.")).count();
                if (count == 0L) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u884c\u7ef4\u5fc5\u586b", (String)"AbstractBillFilterOperPlugin_9", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                if (count > 1L) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u884c\u7ef4\u53ea\u53ef\u5f55\u5165\u4e00\u884c", (String)"AbstractBillFilterOperPlugin_10", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), new Object[0]));
                    return;
                }
            }
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_FILTER_VALUE, "");
        data.put(KEY_FILTERDESCRIPTION, "");
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        this.setDefaultFilter(filterGrid, filteList, errors);
        if (errors.size() != 0) {
            this.getView().getParentView().showTipNotification((String)errors.get(0));
        }
        if (filteList == null || filteList.isEmpty()) {
            return data;
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        for (FilterRow f : filterBuilder.getFilterObject().getFilterRows()) {
            if (!f.getFilterField().getFieldName().equals("assgrp")) continue;
            f.getFilterField().setFieldType(-9);
        }
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        String filter = filterBuilder.getFilterObject().getFilter();
        String replaceMapStr = this.getPageCache().get(REPLACE_MAP_KEY);
        if (StringUtils.isNotBlank((CharSequence)replaceMapStr)) {
            Map replaceMap = (Map)SerializationUtils.fromJsonString((String)replaceMapStr, Map.class);
            ArrayList entryList = new ArrayList(replaceMap.entrySet());
            entryList.sort((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length());
            for (Map.Entry entry : entryList) {
                String msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b", (String)"AbstractBillFilterOperPlugin_11", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                if (filter.contains(msg)) {
                    filter = filter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    break;
                }
                filter = filter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        this.getPageCache().remove(REPLACE_MAP_KEY);
        data.put(KEY_FILTER_VALUE, filterJson);
        data.put(KEY_FILTERDESCRIPTION, filter);
        return data;
    }

    private void setDefaultFilter(FilterGrid filterGrid, List<SimpleFilterRow> filteList, List<String> errors) {
        if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) || GL_BALANCE.equals(filterGrid.getEntityNumber())) {
            FilterValue filterValue;
            boolean isSetBookType = false;
            boolean isSetBillStatus = false;
            for (SimpleFilterRow filterRow : filteList) {
                if (null == filterRow.getFieldName()) continue;
                if (filterRow.getFieldName().startsWith("booktype")) {
                    isSetBookType = true;
                    continue;
                }
                if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) && filterRow.getFieldName().startsWith("billstatus")) {
                    isSetBillStatus = true;
                    continue;
                }
                if (!GL_BALANCE.equals(filterGrid.getEntityNumber()) && !GL_VOUCHER.equals(filterGrid.getEntityNumber()) || !filterRow.getFieldName().equals("assgrp")) continue;
                this.packageFilter(filterRow, errors);
            }
            if (!isSetBookType) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)this.getMainBookId());
                filteList.add(new SimpleFilterRow("", EQUEAL, "booktype.number", "", "0", Collections.singletonList(filterValue)));
            }
            if (!isSetBillStatus && GL_VOUCHER.equals(filterGrid.getEntityNumber())) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)STATUS_DEFAULT_VALUE);
                filteList.add(new SimpleFilterRow("", "105", "billstatus", "", "0", Collections.singletonList(filterValue)));
            }
        }
    }

    private String getMainBookId() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ACCOUNT_TYPE, (String)"number", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)BOOK_TYPE_DEFAULT_VALUE)});
        return null == dynamicObject ? null : dynamicObject.getString("number");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void packageFilter(SimpleFilterRow filterRow, List<String> errors) {
        String compareType = filterRow.getCompareType();
        if (!compareTypes_need_merge.contains(compareType) && !compareTypes_stay_same.contains(compareType)) {
            return;
        }
        List content = filterRow.getValue();
        ArrayList<FilterValue> cache = new ArrayList<FilterValue>();
        HashSet<String> oldCaptionSet = new HashSet<String>();
        StringBuilder values = new StringBuilder();
        Iterator iterator = content.iterator();
        block2: while (true) {
            if (!iterator.hasNext()) {
                if (oldCaptionSet.size() == 0) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"AbstractBillFilterOperPlugin_15", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                }
                return;
            }
            FilterValue filter = (FilterValue)iterator.next();
            String inputValue = (String)filter.getValue();
            String[] subAssgrp = inputValue.split(";");
            int index = 0;
            while (true) {
                String valusSource;
                if (index >= subAssgrp.length) continue block2;
                values.append(subAssgrp[index]).append(";");
                if (!subAssgrp[index].contains(":")) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"AbstractBillFilterOperPlugin_14", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                String[] assgrpAndDetail = subAssgrp[index].split(":");
                if (assgrpAndDetail.length != 2) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"AbstractBillFilterOperPlugin_14", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                String assgrpName = assgrpAndDetail[0];
                String detailName = assgrpAndDetail[1];
                DynamicObject assgrp = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource,disprops,valuetype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)assgrpName)});
                if (null == assgrp) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"AbstractBillFilterOperPlugin_12", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection detail = null;
                String string = valusSource = assgrp.getString("valuetype").equals("2") ? "bos_assistantdata_detail" : assgrp.getString("valuesource");
                if (!StringUtil.isEmpty((CharSequence)valusSource)) {
                    block18: {
                        QFilter qFilter = this.getFilterByDisplayproperty(assgrp.getString("disprops"), detailName);
                        try {
                            detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            if (null != detail && detail.size() != 0) break block18;
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                break block18;
                            }
                            if (!qFilter.getProperty().equals("longnumber")) break block18;
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else {
                                qFilter = new QFilter("number", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                        }
                        catch (Throwable e) {
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                            if (!qFilter.getProperty().equals("longnumber")) {
                                filterRow.setValue(cache);
                                errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"AbstractBillFilterOperPlugin_12", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                                return;
                            }
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                            qFilter = new QFilter("number", "=", (Object)detailName);
                            detail = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                    }
                    if (null == detail || detail.size() == 0) {
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u53f3\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"AbstractBillFilterOperPlugin_13", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                        return;
                    }
                }
                this.upDateCacheByAssgrpIds(detail, assgrp, CONTAIN, filterRow, detailName, oldCaptionSet, cache, index);
                ++index;
            }
            break;
        }
    }

    private void upDateCacheByAssgrpIds(DynamicObjectCollection detail, DynamicObject assgrp, String compareType, SimpleFilterRow filterRow, String detailName, Set<String> oldCaptionSet, List<FilterValue> cache, int index) {
        DynamicObjectCollection assgrpAssists;
        String Qcp = this.getQcp(filterRow, compareType);
        switch (assgrp.getString("valuetype")) {
            case "1": 
            case "2": {
                LinkedHashMap<String, Long> queryJson = new LinkedHashMap<String, Long>();
                QFilter qFilter = null;
                if (null == detail) {
                    return;
                }
                for (DynamicObject dynamicObject : detail) {
                    queryJson.put(assgrp.getString("flexfield"), dynamicObject.getLong("id"));
                    String tempJson = this.packageQueryJson(queryJson, compareType);
                    if (null == qFilter) {
                        qFilter = new QFilter("assvals", Qcp, (Object)tempJson);
                    } else {
                        qFilter.or(new QFilter("assvals", Qcp, (Object)tempJson));
                    }
                    queryJson.clear();
                }
                String propertyName = "id,assvals";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist", (String)propertyName, (QFilter[])new QFilter[]{qFilter});
                List idList = detail.stream().map(d -> d.getString("id")).collect(Collectors.toList());
                assgrpAssists = assgrpAssists.parallelStream().filter(a -> {
                    String assvals = a.getString("assvals");
                    String[] kvArray = assvals.substring(1, assvals.length() - 1).split(",");
                    for (int i = 0; i < kvArray.length; ++i) {
                        String s = kvArray[i].split(":")[1];
                        if (!idList.contains(s)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toCollection(DynamicObjectCollection::new));
                break;
            }
            case "3": {
                QFilter nameFilter = new QFilter("asstype", Qcp, (Object)assgrp.getString("flexfield"));
                QFilter valFilter = new QFilter("assval", Qcp, (Object)detailName);
                String propertyName = "hg as id";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist_txt", (String)propertyName, (QFilter[])new QFilter[]{nameFilter, valFilter});
                break;
            }
            default: {
                return;
            }
        }
        if (null != assgrpAssists && assgrpAssists.size() != 0) {
            HashSet<String> currentIds = new HashSet<String>();
            for (DynamicObject dynamicObject : assgrpAssists) {
                currentIds.add(String.valueOf(dynamicObject.getLong("id")));
            }
            if (index > 0) {
                oldCaptionSet.retainAll(currentIds);
            } else {
                oldCaptionSet.addAll(currentIds);
            }
        }
    }

    private QFilter getFilterByDisplayproperty(String displayproperty, String value) {
        String disprop;
        QFilter qFilter = new QFilter("fullname", "=", (Object)value);
        if (StringUtil.isEmpty((CharSequence)displayproperty)) {
            return qFilter;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)displayproperty, Map.class);
        if (null == map || null == map.get("disp") || null == ((Map)map.get("disp")).get("dispprop")) {
            return qFilter;
        }
        switch (disprop = (String)((Map)map.get("disp")).get("dispprop")) {
            case "1": {
                qFilter = new QFilter("longnumber", "=", (Object)value);
                break;
            }
            case "2": {
                qFilter = new QFilter("fullname", "=", (Object)value);
                break;
            }
            case "3": {
                String[] subs = value.split(",");
                if (subs.length != 2) break;
                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
            }
        }
        return qFilter;
    }

    private String packageQueryJson(Map<String, Long> map, String compareType) {
        String json = JsonUtil.toJson(map);
        if (START_WITH.equals(compareType)) {
            json = json.substring(0, json.length() - 1);
            return json + PERCENT;
        }
        if (END_WITH.equals(compareType)) {
            json = json.substring(1);
            return PERCENT + json;
        }
        if (CONTAIN.equals(compareType) || NOT_CONTAIN.equals(compareType)) {
            json = json.substring(1, json.length() - 1);
            return PERCENT + json + PERCENT;
        }
        return JsonUtil.toJson(map);
    }

    private String getQcp(SimpleFilterRow filterRow, String compareType) {
        switch (compareType) {
            case "17": {
                return "=";
            }
            case "34": {
                return "=";
            }
            case "67": {
                return "=";
            }
            case "83": {
                return "=";
            }
            case "58": {
                return "not like";
            }
            case "59": {
                return "like";
            }
            case "60": {
                return "like";
            }
            case "211": {
                return "like";
            }
        }
        return null;
    }

    private static String getEqualCn() {
        return ResManager.loadKDString((String)" \u7b49\u4e8e", (String)"AbstractBillFilterOperPlugin_16", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getNotEqualCn() {
        return ResManager.loadKDString((String)" \u4e0d\u7b49\u4e8e", (String)"AbstractBillFilterOperPlugin_17", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getContainCn() {
        return ResManager.loadKDString((String)" \u5305\u542b", (String)"AbstractBillFilterOperPlugin_18", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getNotContainCn() {
        return ResManager.loadKDString((String)" \u4e0d\u5305\u542b", (String)"AbstractBillFilterOperPlugin_19", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getStartWithCn() {
        return ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u5f00\u59cb", (String)"AbstractBillFilterOperPlugin_20", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getEndWithCn() {
        return ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u7ed3\u675f", (String)"AbstractBillFilterOperPlugin_21", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getInCn() {
        return ResManager.loadKDString((String)" \u5728\u2026\u2026\u4e2d", (String)"AbstractBillFilterOperPlugin_22", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }

    private static String getNotInCn() {
        return ResManager.loadKDString((String)" \u4e0d\u5728\u2026\u2026\u4e2d", (String)"AbstractBillFilterOperPlugin_23", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
    }
}

