/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang.ArrayUtils;

public class ChangeModelPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ItemClickListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final String TOOBARAP = "toobarap";
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String FORMID_REGISETERPLUGIN = "ide_registerplugin";
    private static final String CUSTPARAM_TREENODES = "treenodes";
    private static final String TBAR_MAPPINGENTITY = "tbar_mappingentity";
    private static final String BTN_AUTOMATCHFIELD = "btn_automatchfield";
    private static final String TBAR_PLUGIN = "tbar_plugin";
    public static final String BARADDPLUGIN = "baraddplugin";
    public static final String BARADDJSPLUGIN = "baraddjsplugin";
    public static final String BARMODIFYPLUGIN = "barmodifyplugin";
    public static final String BARDELPLUGIN = "bardelplugin";
    public static final String BARUPPLUGIN = "barupplugin";
    public static final String BARDOWNPLUGIN = "bardownplugin";
    public static final String TBAR_VALID = "tbar_validcondition";
    public static final String TBAR_CUSPARM = "tbar_cusparm";
    public static final String TBAR_REVISENTITY = "tbar_revisentity";
    public static final String ADDREVISENTRY = "addrevisentry";
    public static final String REFRESHRENTRY = "refreshrentry";
    private static final String PLUGINPARAM_CLASSNAME = "ClassName";
    private static final String PLUGINPARAM_DESCRIPTION = "Description";
    private static final String PLUGINPARAM_ENABLED = "Enabled";
    private static final String CALLBACK_SOURCEFIELD = "sourcefieldcallback";
    private static final String CALLBACK_ADDPLUGIN = "addplugincallback";
    private static final String CALLBACK_MODIFYPLUGIN = "modifyplugincallback";
    private static final String CUSTPARAM_ROWKEY = "rowKey";
    private static final String CUSTPARAM_PLUGIN = "plugin";
    private static final String FORM_VALIDEDIT = "bdtaxr_validationedit";
    private static final String CALLBACK_NEWVALID = "newValidCallBack";
    private static final String CALLBACK_EDITVALID = "editValidCallBack";
    public static final String META_CONTEXT = "MetaContext";
    public static final String CUSTOMPARAMETER_TAG = "customparameter_tag";
    public static final String CUSTOMPARAMETER = "customparameter";
    public static final String CLEAR = "clear";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block14: for (int i = 0; i < valueSet.length; ++i) {
            if (!ChangeModelUtil.isRealChanged(valueSet[i])) continue;
            Object newValue = valueSet[i].getNewValue();
            IDataModel model = this.getView().getModel();
            switch (fieldName) {
                case "xbill": {
                    this.getModel().deleteEntryData("mappingentity");
                    this.getModel().deleteEntryData("validentity");
                    if (newValue == null) {
                        return;
                    }
                    Object srcBill = model.getValue("srcbill");
                    if (ChangeModelUtil.isNull(srcBill)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u66f4\u5355\u524d\uff0c\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u3002", (String)"ChangeModelPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    }
                    this.createMappingEntity((String)((DynamicObject)newValue).getPkValue());
                    this.buildMetaContext(newValue);
                    continue block14;
                }
                case "srcbill": {
                    this.clearDatas();
                    continue block14;
                }
                case "isenable": {
                    if (!(newValue instanceof Boolean) || this.getModel().getValue("validconditionjson_tag", valueSet[i].getRowIndex()) == null) continue block14;
                    String validjson = (String)this.getModel().getValue("validconditionjson_tag", valueSet[i].getRowIndex());
                    Map rule = (Map)SerializationUtils.fromJsonString((String)validjson, Map.class);
                    rule.put(PLUGINPARAM_ENABLED, newValue);
                    this.getModel().setValue("validconditionjson_tag", (Object)SerializationUtils.toJsonString((Object)rule), valueSet[i].getRowIndex());
                    continue block14;
                }
                case "sourcefieldname": {
                    if (!ChangeModelUtil.isNull(newValue)) continue block14;
                    this.getModel().setValue("sourcefield", null, valueSet[i].getRowIndex());
                    continue block14;
                }
                case "canrevise": {
                    this.getModel().setValue("canreviselog", newValue, valueSet[i].getRowIndex());
                    continue block14;
                }
            }
        }
    }

    private void clearDatas() {
        this.getModel().setValue("xbill", null);
        this.getModel().setValue("mul_areaconditiondesc", null);
        this.getModel().setValue("areaconditionjson_tag", null);
        if (this.getModel().getEntryEntity("pluginentity") != null) {
            this.getModel().deleteEntryData("pluginentity");
        }
        if (this.getModel().getEntryEntity("billtypeentity") != null) {
            this.getModel().deleteEntryData("billtypeentity");
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        FilterCondition condition = new FilterCondition();
        filterGrid.SetValue(condition);
        DynamicObject srcBillObj = (DynamicObject)this.getModel().getValue("srcbill");
        if (srcBillObj == null) {
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(Collections.emptyList());
            this.getView().updateView("areafilter");
            return;
        }
        String srcbill = (String)srcBillObj.getPkValue();
        filterGrid.setEntityNumber(srcbill);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)srcbill);
        String entityNumber = dataEntityType.getName();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            this.getView().updateView("areafilter");
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid validentryGrid;
        BasedataEdit xBillTypeEdit;
        BasedataEdit srcBillTypeEdit;
        BasedataEdit xBillEdit;
        BasedataEdit srcBillEdit = (BasedataEdit)this.getView().getControl("srcbill");
        if (srcBillEdit != null) {
            srcBillEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((xBillEdit = (BasedataEdit)this.getView().getControl("xbill")) != null) {
            xBillEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((srcBillTypeEdit = (BasedataEdit)this.getView().getControl("srcbilltype")) != null) {
            srcBillTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((xBillTypeEdit = (BasedataEdit)this.getView().getControl("xbilltype")) != null) {
            xBillTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"sourcefieldname"});
        this.addItemClickListeners(new String[]{TBAR_MAPPINGENTITY, TBAR_PLUGIN, TBAR_VALID, TOOBARAP, TBAR_CUSPARM, TBAR_REVISENTITY});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("mappingentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((validentryGrid = (EntryGrid)this.getView().getControl("validentity")) != null) {
            validentryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "sourcefieldname": {
                this.openSrcFieldList();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String barItemKey;
        switch (barItemKey = evt.getItemKey()) {
            case "barenable": 
            case "bardisable": {
                OperationStatus ostatus = this.getView().getFormShowParameter().getStatus();
                if (ostatus != OperationStatus.ADDNEW) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002", (String)"ChangeModelPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "addrevisentry": {
                DynamicObject srcBill = (DynamicObject)this.getModel().getValue("srcbill");
                if (srcBill != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u3002", (String)"ChangeModelPlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String barItemKey = evt.getItemKey();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("validentity");
        int rowKey = grid.getEntryState().getFocusRow();
        switch (barItemKey) {
            case "btn_automatchfield": {
                this.autoMatchFields();
                break;
            }
            case "baraddplugin": {
                this.showAddPlugForm();
                break;
            }
            case "baraddjsplugin": {
                this.showAddJSPlugForm();
                break;
            }
            case "barmodifyplugin": {
                this.showModifyPlugForm();
                break;
            }
            case "btnadd": {
                DynamicObject validBill = null;
                validBill = (DynamicObject)this.getModel().getValue("srcbill");
                if (validBill == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u3002", (String)"ChangeModelPlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter addValidRulePara = new FormShowParameter();
                addValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                addValidRulePara.setFormId(FORM_VALIDEDIT);
                ArrayList<List<Map<String, Object>>> formContext = new ArrayList<List<Map<String, Object>>>();
                formContext.add(this.buildDesignContext(validBill));
                addValidRulePara.setCustomParam(META_CONTEXT, formContext);
                addValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_NEWVALID));
                this.getView().showForm(addValidRulePara);
                break;
            }
            case "btnedit": {
                DynamicObject bill = (DynamicObject)this.getModel().getValue("srcbill");
                if (bill == null) {
                    return;
                }
                FormShowParameter editValidRulePara = new FormShowParameter();
                editValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                editValidRulePara.setFormId(FORM_VALIDEDIT);
                if (rowKey <= -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u3002", (String)"ChangeModelPlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                if (rowKey >= 0) {
                    editValidRulePara.setCustomParam("Rule", this.getModel().getValue("validconditionjson_tag", rowKey));
                }
                ArrayList<List<Map<String, Object>>> editFormContext = new ArrayList<List<Map<String, Object>>>();
                editFormContext.add(this.buildDesignContext(bill));
                editValidRulePara.setCustomParam(META_CONTEXT, editFormContext);
                editValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDITVALID));
                this.getView().showForm(editValidRulePara);
                break;
            }
            case "barcusparm": {
                FormShowParameter customParameter = new FormShowParameter();
                customParameter.getOpenStyle().setShowType(ShowType.Modal);
                customParameter.setFormId("bdtaxr_customparameter");
                String customParameterStr = (String)this.getModel().getValue(CUSTOMPARAMETER_TAG);
                if (!ChangeModelUtil.isNull(customParameterStr)) {
                    List customParameterList = SerializationUtils.fromJsonStringToList((String)customParameterStr, Map.class);
                    customParameter.setCustomParam(CUSTOMPARAMETER, (Object)customParameterList);
                } else {
                    String xbilldtstr = "";
                    if (this.getModel().getValue("xbill") != null && ((DynamicObject)this.getModel().getValue("xbill")).getPkValue() != null) {
                        xbilldtstr = (String)((DynamicObject)this.getModel().getValue("xbill")).getPkValue();
                        MainEntityType xBillDt = MetadataServiceHelper.getDataEntityType((String)xbilldtstr);
                        List<EntityType> xBillentryEntitys = ChangeModelBusiness.getChildEntities((IDataEntityType)xBillDt);
                        ArrayList customParameterList = new ArrayList(16);
                        for (EntityType xBillentryEntity : xBillentryEntitys) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (xBillentryEntity.getName().endsWith("_lk")) continue;
                            map.put("name", xBillentryEntity.getName());
                            map.put("type", "jsonarray");
                            map.put("val", "{\"entry_toolbar\":\"\",\"btn_add\":\"\",\"btn_modify\":\"\",\"srcid\":\"\",\"changetype\":\"\",\"btn_delete\":\"\",\"entity\":\"" + xBillentryEntity.getName() + "\"}");
                            customParameterList.add(map);
                        }
                        customParameter.setCustomParam(CUSTOMPARAMETER, customParameterList);
                    }
                }
                customParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOMPARAMETER));
                this.getView().showForm(customParameter);
                break;
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        super.entryRowDoubleClick(e);
        EntryGrid entry = (EntryGrid)e.getSource();
        String entrykey = entry.getEntryKey();
        int row = e.getRow();
        switch (entrykey) {
            case "validentity": {
                DynamicObject bill = (DynamicObject)this.getModel().getValue("xbill");
                if (bill == null) {
                    return;
                }
                FormShowParameter editValidRulePara = new FormShowParameter();
                editValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                editValidRulePara.setFormId(FORM_VALIDEDIT);
                if (row <= -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u3002", (String)"ChangeModelPlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                if (row >= 0) {
                    editValidRulePara.setCustomParam("Rule", this.getModel().getValue("validconditionjson_tag", row));
                }
                ArrayList<List<Map<String, Object>>> editFormContext = new ArrayList<List<Map<String, Object>>>();
                editFormContext.add(this.buildDesignContext(bill));
                editValidRulePara.setCustomParam(META_CONTEXT, editFormContext);
                editValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDITVALID));
                this.getView().showForm(editValidRulePara);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        Object srcBill = model.getValue("srcbill");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "xbill": {
                if (ChangeModelUtil.isNull(srcBill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u66f4\u5355\u524d\uff0c\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u3002", (String)"ChangeModelPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                String srcBillId = MetadataDao.getIdByNumber((String)((DynamicObject)srcBill).getPkValue().toString(), (MetaCategory)MetaCategory.Entity);
                QFilter qf1 = new QFilter("inheritpath", "ftlike", (Object)srcBillId);
                QFilter qf2 = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
                DynamicObjectCollection dyos = QueryServiceHelper.query((String)"bos_formmeta", (String)"number", (QFilter[])new QFilter[]{qf1.and(qf2)});
                if (!ChangeModelUtil.isNull(dyos)) {
                    HashSet<String> ids = new HashSet<String>();
                    for (DynamicObject dyo : dyos) {
                        ids.add(dyo.getString("number"));
                    }
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u5148\u9009\u62e9\u6b63\u786e\u7684\u53d8\u66f4\u5355\u636e\u3002", (String)"ChangeModelPlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void createMappingEntity(String billId) {
        if (StringUtils.isBlank((CharSequence)billId)) {
            return;
        }
        MainEntityType xBillEntity = MetadataServiceHelper.getDataEntityType((String)billId);
        Map fields = xBillEntity.getFields();
        int rowIndex = 0;
        for (Map.Entry field : fields.entrySet()) {
            String fieldKey = (String)field.getKey();
            if ("billtype".equalsIgnoreCase(fieldKey) || "billstatus".equalsIgnoreCase(fieldKey) || "creator".equalsIgnoreCase(fieldKey) || "createtime".equalsIgnoreCase(fieldKey) || "modifier".equalsIgnoreCase(fieldKey) || "modifytime".equalsIgnoreCase(fieldKey) || "auditor".equalsIgnoreCase(fieldKey) || "auditdate".equalsIgnoreCase(fieldKey)) continue;
            rowIndex = this.getModel().createNewEntryRow("mappingentity");
            this.getModel().setValue("targetfield", (Object)fieldKey, rowIndex);
            DynamicProperty findProperty = (DynamicProperty)xBillEntity.findProperty(fieldKey);
            this.getModel().setValue("targetfieldname", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"ChangeModelPlugin_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), findProperty.getDisplayName()), rowIndex);
            this.getModel().setValue("clearsourcefield", (Object)CLEAR, rowIndex);
        }
        Map entityTypes = xBillEntity.getAllEntities();
        for (EntityType entityType : entityTypes.values()) {
            if (!(entityType instanceof EntryType) || entityType.getName().endsWith("_lk")) continue;
            fields = entityType.getFields();
            for (Map.Entry entity : fields.entrySet()) {
                String fieldKey = (String)entity.getKey();
                rowIndex = this.getModel().createNewEntryRow("mappingentity");
                this.getModel().setValue("targetfield", (Object)fieldKey, rowIndex);
                DynamicProperty findProperty = (DynamicProperty)xBillEntity.findProperty(fieldKey);
                this.getModel().setValue("targetfieldname", (Object)(entityType.getDisplayName() + "." + findProperty.getDisplayName()), rowIndex);
                this.getModel().setValue("clearsourcefield", (Object)CLEAR, rowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sourcefieldcallback": {
                String fieldId = returnData.toString();
                int row = this.getModel().getEntryCurrentRowIndex("mappingentity");
                DynamicObject srcBill = (DynamicObject)this.getModel().getValue("srcbill");
                String srcBillId = (String)srcBill.getPkValue();
                MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
                String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
                String[] sourceItems = fieldId.split("\\.");
                if (sourceItems.length > 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5c5e\u6027\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc73\u7ea7\u3002", (String)"ChangeModelPlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                    return;
                }
                if (sourceItems.length > 1) {
                    IDataEntityProperty findProperty = srcbillMainType.findProperty(sourceItems[0]);
                    String parentName = findProperty.getParent().getName();
                    if (!srcBillId.equals(parentName)) {
                        fieldId = parentName.concat(".").concat(sourceItems[0]).concat(".").concat(sourceItems[1]);
                    }
                } else {
                    IDataEntityProperty findProperty = srcbillMainType.findProperty(fieldId);
                    if (findProperty == null) break;
                    String parentName = findProperty.getParent().getName();
                    if (!srcBillId.equals(parentName)) {
                        fieldId = parentName.concat(".").concat(fieldId);
                    }
                }
                this.getModel().setValue("sourcefield", (Object)fieldId, row);
                this.getModel().setValue("sourcefieldname", (Object)fieldCaption, row);
                break;
            }
            case "addplugincallback": {
                if (!(returnData instanceof Map)) break;
                this.receiveNewPlug((Map)returnData);
                break;
            }
            case "modifyplugincallback": {
                if (!(returnData instanceof Map)) break;
                this.receiveModifyPlug((Map)returnData);
                break;
            }
            case "newValidCallBack": {
                if (!(returnData instanceof ConditionValidation)) break;
                ConditionValidation validnew = (ConditionValidation)returnData;
                validnew.setEnabled(true);
                int rowKey = this.getModel().createNewEntryRow("validentity");
                if (rowKey < 0) break;
                this.getModel().setValue("desc", validnew.getDescription().getItem(Lang.get().toString()), rowKey);
                DcJsonSerializer ds = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList()));
                ds.setIsLocaleValueFull(true);
                this.getModel().setValue("validconditionjson_tag", (Object)ds.serializeToString((Object)validnew, null), rowKey);
                break;
            }
            case "editValidCallBack": {
                if (!(returnData instanceof ConditionValidation)) break;
                ConditionValidation validedit = (ConditionValidation)returnData;
                AbstractGrid grid = (AbstractGrid)this.getView().getControl("validentity");
                int selrowkey = grid.getEntryState().getFocusRow();
                if (selrowkey < 0) break;
                validedit.setEnabled(((Boolean)this.getModel().getValue("isenable")).booleanValue());
                this.getModel().setValue("desc", validedit.getDescription().getItem(Lang.get().toString()), selrowkey);
                DcJsonSerializer ds = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList()));
                ds.setIsLocaleValueFull(true);
                this.getModel().setValue("validconditionjson_tag", (Object)ds.serializeToString((Object)validedit, null), selrowkey);
                break;
            }
            case "customparameter": {
                List methodParameterList = (List)returnData;
                if (methodParameterList != null && methodParameterList.size() > 0) {
                    String methodParameterListStr = SerializationUtils.toJsonString((Object)methodParameterList);
                    this.getModel().setValue(CUSTOMPARAMETER_TAG, (Object)SerializationUtils.toJsonString((Object)methodParameterList));
                    if (methodParameterListStr.length() > 512) {
                        methodParameterListStr = methodParameterListStr.substring(0, 500).concat("...");
                    }
                    this.getModel().setValue(CUSTOMPARAMETER, (Object)methodParameterListStr);
                } else {
                    this.getModel().setValue(CUSTOMPARAMETER_TAG, null);
                    this.getModel().setValue(CUSTOMPARAMETER, null);
                }
                this.getView().updateView(CUSTOMPARAMETER_TAG);
                this.getView().updateView(CUSTOMPARAMETER);
                break;
            }
        }
    }

    private void openSrcFieldList() {
        TreeNode srcBillNode;
        int row = this.getModel().getEntryCurrentRowIndex("mappingentity");
        Object srcBill = this.getModel().getValue("srcbill");
        Object xBill = this.getModel().getValue("xbill");
        String targetFieldValue = (String)this.getModel().getValue("targetfield", row);
        if (ChangeModelUtil.isNull(srcBill) || ChangeModelUtil.isNull(targetFieldValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u3001\u53d8\u66f4\u5355\u548c\u53d8\u66f4\u5355\u5b57\u6bb5\u3002", (String)"ChangeModelPlugin_7", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        if (ChangeModelUtil.isNull(xBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u3002", (String)"ChangeModelPlugin_8", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        String srcBillId = (String)((DynamicObject)srcBill).getPkValue();
        String xBillId = (String)((DynamicObject)xBill).getPkValue();
        MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        MainEntityType xBillMainType = MetadataServiceHelper.getDataEntityType((String)xBillId);
        IDataEntityProperty targetProperty = xBillMainType.findProperty(targetFieldValue);
        if (targetProperty instanceof BigIntProp) {
            PropTreeBuildOption optionid = new PropTreeBuildOption(null, BigIntProp.class);
            optionid.setIncludeParentEntity(true);
            optionid.setIncludeChildEntity(true);
            optionid.setIncludePKField(true);
            optionid.addMatchedClassTypes(LongProp.class);
            srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcbillMainType, (PropTreeBuildOption)optionid);
        } else {
            PropTreeBuildOption option = new PropTreeBuildOption(null, targetProperty);
            option.setIncludeParentEntity(true);
            option.setIncludeChildEntity(true);
            option.setIncludePKField(true);
            srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcbillMainType, (PropTreeBuildOption)option);
        }
        this.showSrcFieldForm(srcBillNode, CALLBACK_SOURCEFIELD);
    }

    private void showSrcFieldForm(TreeNode srcBillNode, String callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put(CUSTPARAM_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBack));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void autoMatchFields() {
        Object srcBill = this.getModel().getValue("srcbill");
        Object xBill = this.getModel().getValue("xbill");
        if (ChangeModelUtil.isNull(srcBill) || ChangeModelUtil.isNull(xBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u5355\u636e\u548c\u53d8\u66f4\u5355\u3002", (String)"ChangeModelPlugin_9", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        String srcBillId = (String)((DynamicObject)srcBill).getPkValue();
        String xBillId = (String)((DynamicObject)xBill).getPkValue();
        MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        MainEntityType xBillMainType = MetadataServiceHelper.getDataEntityType((String)xBillId);
        int rowCount = this.getModel().getEntryRowCount("mappingentity");
        HashMap<String, Integer> delFieldMap = new HashMap<String, Integer>(16);
        HashSet<String> stayFieldSet = new HashSet<String>(16);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String targetFieldKey = (String)this.getModel().getValue("targetfield", rowIndex);
            DynamicProperty targetField = (DynamicProperty)xBillMainType.findProperty(targetFieldKey);
            if (targetField == null) {
                delFieldMap.put(targetFieldKey, rowIndex);
                continue;
            }
            stayFieldSet.add(targetFieldKey);
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)targetField);
            this.getModel().setValue("targetfieldname", (Object)targetFieldName, rowIndex);
            String sourceOldFieldKey = (String)this.getModel().getValue("sourcefield", rowIndex);
            if (!ChangeModelUtil.isNull(sourceOldFieldKey)) {
                DynamicProperty sourceOldField = (DynamicProperty)srcbillMainType.findProperty(sourceOldFieldKey);
                if (sourceOldField == null) continue;
                String sourceOldFieldNewName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)sourceOldField);
                this.getModel().setValue("sourcefieldname", (Object)sourceOldFieldNewName, rowIndex);
                continue;
            }
            DynamicProperty sourceNewField = (DynamicProperty)srcbillMainType.findProperty(targetFieldKey);
            if (sourceNewField == null) continue;
            String sourceNewFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)sourceNewField);
            this.getModel().setValue("sourcefield", (Object)sourceNewField.getName(), rowIndex);
            this.getModel().setValue("sourcefieldname", (Object)sourceNewFieldName, rowIndex);
        }
        this.buildDiffMappingEntity(xBillId, srcBillId, stayFieldSet, delFieldMap);
    }

    private void buildDiffMappingEntity(String xBillId, String srcBillId, Set<String> stayFieldSet, Map<String, Integer> delFieldsMap) {
        if (delFieldsMap != null && delFieldsMap.size() > 0) {
            int[] delrow = ArrayUtils.toPrimitive((Integer[])delFieldsMap.values().toArray(new Integer[0]));
            this.getModel().deleteEntryRows("mappingentity", delrow);
            delFieldsMap.clear();
        }
        MainEntityType xBillEntity = MetadataServiceHelper.getDataEntityType((String)xBillId);
        MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
        Map fields = xBillEntity.getFields();
        for (Map.Entry field : fields.entrySet()) {
            String fieldKey = (String)field.getKey();
            if ("billtype".equalsIgnoreCase(fieldKey) || "billstatus".equalsIgnoreCase(fieldKey) || "creator".equalsIgnoreCase(fieldKey) || "createtime".equalsIgnoreCase(fieldKey) || "modifier".equalsIgnoreCase(fieldKey) || "modifytime".equalsIgnoreCase(fieldKey) || "auditor".equalsIgnoreCase(fieldKey) || "auditdate".equalsIgnoreCase(fieldKey) || "lastupdateuser".equalsIgnoreCase(fieldKey) || "lastupdatetime".equalsIgnoreCase(fieldKey) || stayFieldSet.contains(fieldKey)) continue;
            int newRowIndex = this.getModel().createNewEntryRow("mappingentity");
            DynamicProperty findProperty = (DynamicProperty)xBillEntity.findProperty(fieldKey);
            String targetFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)findProperty);
            this.getModel().setValue("targetfield", (Object)fieldKey, newRowIndex);
            this.getModel().setValue("targetfieldname", (Object)targetFieldName, newRowIndex);
            this.getModel().setValue("clearsourcefield", (Object)CLEAR, newRowIndex);
            DynamicProperty sourceField = (DynamicProperty)srcbillMainType.findProperty(fieldKey);
            if (sourceField == null) continue;
            String sourceFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)sourceField);
            this.getModel().setValue("sourcefield", (Object)sourceField.getName(), newRowIndex);
            this.getModel().setValue("sourcefieldname", (Object)sourceFieldName, newRowIndex);
        }
        Map entityTypes = xBillEntity.getAllEntities();
        for (EntityType entityType : entityTypes.values()) {
            if (!(entityType instanceof EntryType) || entityType.getName().endsWith("_lk")) continue;
            Map entryFields = entityType.getFields();
            for (Map.Entry entryField : entryFields.entrySet()) {
                String entryFieldKey = (String)entryField.getKey();
                if (stayFieldSet.contains(entryFieldKey)) continue;
                int newentryRowIndex = this.getModel().createNewEntryRow("mappingentity");
                this.getModel().setValue("targetfield", (Object)entryFieldKey, newentryRowIndex);
                DynamicProperty findEntryProperty = (DynamicProperty)xBillEntity.findProperty(entryFieldKey);
                String targetEntryFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)findEntryProperty);
                this.getModel().setValue("targetfieldname", (Object)targetEntryFieldName, newentryRowIndex);
                this.getModel().setValue("clearsourcefield", (Object)CLEAR, newentryRowIndex);
                DynamicProperty sourceEntryField = (DynamicProperty)srcbillMainType.findProperty(entryFieldKey);
                if (sourceEntryField == null) continue;
                String sourceEntryFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)sourceEntryField);
                this.getModel().setValue("sourcefield", (Object)sourceEntryField.getName(), newentryRowIndex);
                this.getModel().setValue("sourcefieldname", (Object)sourceEntryFieldName, newentryRowIndex);
            }
        }
        this.getView().updateView("mappingentity");
    }

    private void showAddPlugForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_REGISETERPLUGIN);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ADDPLUGIN));
        this.getView().showForm(showParameter);
    }

    private void showAddJSPlugForm() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u6ca1\u6709\u652f\u6301\u811a\u672c\u63d2\u4ef6\uff0c\u8bf7\u7559\u6b65...", (String)"ChangeModelPlugin_10", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
    }

    private void showModifyPlugForm() {
        int row;
        IDataModel model = this.getView().getModel();
        String pluginJson = (String)model.getValue("pluginjson", row = model.getEntryCurrentRowIndex("pluginentity"));
        if (StringUtils.isBlank((CharSequence)pluginJson)) {
            return;
        }
        CRPlugin crPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)pluginJson, CRPlugin.class);
        boolean enabled = (Boolean)model.getValue("pluginenable", row);
        crPlugin.setEnabled(enabled);
        if (crPlugin.getType() == 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(FORMID_REGISETERPLUGIN);
            Map<String, Object> crPluginMap = this.convertToParams(crPlugin);
            parameter.setCustomParam(CUSTPARAM_ROWKEY, (Object)row);
            parameter.setCustomParam(CUSTPARAM_PLUGIN, crPluginMap);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_MODIFYPLUGIN));
            this.getView().showForm(parameter);
        }
    }

    private Map<String, Object> convertToParams(CRPlugin crPlugin) {
        HashMap<String, Object> plugParams = new HashMap<String, Object>();
        plugParams.put(PLUGINPARAM_CLASSNAME, crPlugin.getClassName());
        plugParams.put(PLUGINPARAM_ENABLED, crPlugin.isEnabled());
        plugParams.put(PLUGINPARAM_DESCRIPTION, crPlugin.getDescription());
        return plugParams;
    }

    private void receiveNewPlug(Map<String, Object> plugParams) {
        CRPlugin crPlugin = this.convertToPlugin(plugParams);
        String pluginJson = SerializationUtils.toJsonString((Object)crPlugin);
        IDataModel model = this.getView().getModel();
        int row = model.createNewEntryRow("pluginentity");
        model.setValue("pluginenable", (Object)crPlugin.isEnabled(), row);
        model.setValue("classname", (Object)crPlugin.getClassName(), row);
        model.setValue("pluginjson", (Object)pluginJson, row);
        model.setValue("plugintype", (Object)String.valueOf(crPlugin.getType()), row);
    }

    private CRPlugin convertToPlugin(Map<String, Object> plugParams) {
        CRPlugin crPlugin = new CRPlugin();
        crPlugin.setClassName((String)plugParams.get(PLUGINPARAM_CLASSNAME));
        crPlugin.setEnabled(((Boolean)plugParams.get(PLUGINPARAM_ENABLED)).booleanValue());
        crPlugin.setType(0);
        crPlugin.setDescription((String)plugParams.get(PLUGINPARAM_DESCRIPTION));
        return crPlugin;
    }

    private void receiveModifyPlug(Map<String, Object> plugParams) {
        if (plugParams != null) {
            CRPlugin crPlugin = this.convertToPlugin(plugParams);
            String pluginJson = SerializationUtils.toJsonString((Object)crPlugin);
            IDataModel model = this.getView().getModel();
            int row = model.getEntryCurrentRowIndex("pluginentity");
            model.setValue("pluginenable", (Object)crPlugin.isEnabled(), row);
            model.setValue("classname", (Object)crPlugin.getClassName(), row);
            model.setValue("pluginjson", (Object)pluginJson, row);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldKey = e.getFieldName();
        int row = e.getRowIndex();
        switch (fieldKey) {
            case "clearsourcefield": {
                this.getModel().setValue("sourcefield", (Object)"", row);
                this.getModel().setValue("sourcefieldname", (Object)"", row);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
            FilterCondition areaCondition = filterGrid.getFilterGridState().getFilterCondition();
            String areaConditionJsonStr = SerializationUtils.toJsonString((Object)areaCondition);
            this.getModel().setValue("areaconditionjson_tag", (Object)areaConditionJsonStr);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFilterGrid();
    }

    public void afterBindData(EventObject e) {
        int validrowcount;
        super.afterBindData(e);
        this.initAreaConditionToFilterGrid();
        if (this.getModel().getValue("xbill") != null) {
            this.buildMetaContext((DynamicObject)this.getModel().getValue("xbill"));
        }
        if ((validrowcount = this.getModel().getEntryEntity("validentity").getRowCount()) > 0) {
            IDataModel model = this.getModel();
            for (int i = 0; i < validrowcount; ++i) {
                String validjson = model.getValue("validconditionjson_tag", i).toString();
                if (StringUtils.isBlank((CharSequence)validjson)) continue;
                Map rule = (Map)SerializationUtils.fromJsonString((String)validjson, Map.class);
                model.setValue("isenable", (Object)((Boolean)rule.get(PLUGINPARAM_ENABLED)), i);
                if (rule.get(PLUGINPARAM_DESCRIPTION) instanceof Map) {
                    model.setValue("desc", ((Map)rule.get(PLUGINPARAM_DESCRIPTION)).get(Lang.get().toString()), i);
                    continue;
                }
                model.setValue("desc", (Object)rule.get(PLUGINPARAM_DESCRIPTION).toString(), i);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void setFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        Object srcbillObj = this.getModel().getValue("srcbill");
        if (srcbillObj == null) {
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(Collections.emptyList());
            return;
        }
        DynamicObject sourceBill = (DynamicObject)srcbillObj;
        String srcbill = (String)sourceBill.getPkValue();
        filterGrid.setEntityNumber(srcbill);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)srcbill);
        String entityNumber = dataEntityType.getName();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            this.getView().updateView("areafilter");
        }
    }

    private void initAreaConditionToFilterGrid() {
        String areaCondition = (String)this.getModel().getValue("areaconditionjson_tag");
        FilterCondition condition = null;
        condition = StringUtils.isBlank((CharSequence)areaCondition) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)areaCondition, FilterCondition.class);
        FilterGrid areaFilter = (FilterGrid)this.getControl("areafilter");
        areaFilter.SetValue(condition);
    }

    private void buildMetaContext(Object entityBill) {
        if (entityBill instanceof DynamicObject) {
            ArrayList<List<Map<String, Object>>> formContext = new ArrayList<List<Map<String, Object>>>();
            formContext.add(this.buildDesignContext((DynamicObject)entityBill));
            this.getView().getFormShowParameter().getCustomParams().put(META_CONTEXT, formContext);
        }
    }

    private List<Map<String, Object>> buildDesignContext(DynamicObject entityBill) {
        ArrayList<Map<String, Object>> metaItems = new ArrayList<Map<String, Object>>(10);
        String entityBillId = MetadataDao.getIdByNumber((String)entityBill.getPkValue().toString(), (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityBillId, (MetaCategory)MetaCategory.Entity);
        for (EntityItem item : entityMetadata.getItems()) {
            HashMap<String, String> entityItem = new HashMap<String, String>(16);
            entityItem.put("_Type_", item.getClass().getSimpleName());
            entityItem.put("Id", item.getId());
            entityItem.put("ParentId", item.getParentId());
            entityItem.put("Key", item.getKey());
            entityItem.put("Name", item.getName().toString());
            metaItems.add(entityItem);
        }
        return metaItems;
    }
}

