/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.BindingContext;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import org.apache.commons.lang3.StringUtils;

public class ChangeResumeDetailPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String PREVIOUSPAGE = "previouspage";
    private static final String KEY_UPDATE = "*";
    private static final String KEY_ADD = "+";
    private static final String KEY_DELETE = "-";
    private static final String KEY_EQUAL = "=";
    public static final String KEY_OLDVALUE = "o";
    public static final String KEY_NEWVALUE = "n";
    public static final String KEY_FIELDNAME = "c";
    public static final String KEY_ISEQUALS = "e";
    public static final String CURRENTPAGENUM = "currentpagenum";
    public static final String PAGECOUNT = "pagecount";
    public static final String CURRENTPAGE = "currentpage";
    public static final String FIRSTPAGE = "firstpage";
    public static final String LASTPAGE = "lastpage";
    public static final String NEXTPAGE = "nextpage";
    public static final String ENTRYKEY = "_entrykey";
    public static final String XBILL_ENTRY_JSON = "xbillEntryJson";
    public static final String SEQ_ENTRY = "seq_entry";
    public static final String NEWVALUE_ENTRY = "newvalue_entry";
    int rowCount = 10;

    public void afterBindData(EventObject e) {
        String xbillEntryJson;
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        String xbillHeardJson = (String)dataModel.getValue("crdheadjson_tag");
        if (!ChangeModelUtil.isNull(xbillHeardJson)) {
            this.setXBillHead(xbillHeardJson);
        }
        if (!ChangeModelUtil.isNull(xbillEntryJson = (String)dataModel.getValue("crdentryjson_tag"))) {
            this.getView().getPageCache().put(XBILL_ENTRY_JSON, xbillEntryJson);
            LinkedHashMap xbillEntryJsonMap = (LinkedHashMap)JSON.parseObject((String)xbillEntryJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            this.countLabel(xbillEntryJsonMap);
            for (int i = 0; i < 6; ++i) {
                String treeentryEntityKey = "treeentryentity" + i;
                String entrykey = this.getView().getPageCache().get(treeentryEntityKey + ENTRYKEY);
                if (ChangeModelUtil.isNull(entrykey)) continue;
                Object obj = xbillEntryJsonMap.get(entrykey);
                this.batchSetEntry(obj, String.valueOf(i), 1);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(treeentryEntityKey);
                if (!entryGrid.isStopUpdateCell()) continue;
                entryGrid.setStopUpdateCell(false);
                entryGrid.bindData(new BindingContext((Object)dataModel.getEntryEntity(treeentryEntityKey)));
            }
        }
        if (ChangeModelUtil.isNull(xbillHeardJson)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entity"});
        }
        if (ChangeModelUtil.isNull(xbillEntryJson)) {
            for (int i = 0; i < 6; ++i) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entity" + i});
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"fs_xinfo"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"billxinfo"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 0; i < 6; ++i) {
            Label nextPageLabel = (Label)this.getView().getControl(NEXTPAGE + i);
            nextPageLabel.addClickListener((ClickListener)this);
            Label lastPageLabel = (Label)this.getView().getControl(LASTPAGE + i);
            lastPageLabel.addClickListener((ClickListener)this);
            Label previousPageLabel = (Label)this.getView().getControl(PREVIOUSPAGE + i);
            previousPageLabel.addClickListener((ClickListener)this);
            Label firstPageLabel = (Label)this.getView().getControl(FIRSTPAGE + i);
            firstPageLabel.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (control instanceof Label && key.contains("page")) {
            String entryNum = String.valueOf(key.charAt(key.length() - 1));
            String pageLabelKey = key.substring(0, key.length() - 1);
            String currentPageText = this.getView().getPageCache().get(CURRENTPAGE + entryNum);
            String pageCountText = this.getView().getPageCache().get(PAGECOUNT + entryNum);
            if (!ChangeModelUtil.isNull(currentPageText) && !ChangeModelUtil.isNull(pageCountText)) {
                int currentPage = Integer.parseInt(currentPageText);
                int pageCount = Integer.parseInt(pageCountText);
                String xbillEntryJson = this.getView().getPageCache().get(XBILL_ENTRY_JSON);
                if (ChangeModelUtil.isNull(xbillEntryJson)) {
                    xbillEntryJson = (String)this.getModel().getValue("crdentryjson_tag");
                }
                LinkedHashMap xbillEntryJsonMap = (LinkedHashMap)JSON.parseObject((String)xbillEntryJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                String treeentryEntityKey = "treeentryentity" + entryNum;
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(treeentryEntityKey);
                String entrykey = this.getView().getPageCache().get(treeentryEntityKey + ENTRYKEY);
                if (!ChangeModelUtil.isNull(entrykey)) {
                    Object entry = xbillEntryJsonMap.get(entrykey);
                    switch (pageLabelKey) {
                        case "nextpage": {
                            if (currentPage == pageCount) break;
                            if (++currentPage == pageCount) {
                                this.getView().setEnable(Boolean.FALSE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                            }
                            this.getView().setEnable(Boolean.TRUE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                            this.getModel().setValue(CURRENTPAGENUM + entryNum, (Object)currentPage);
                            this.batchSetEntry(entry, entryNum, currentPage);
                            this.getView().getPageCache().put(CURRENTPAGE + entryNum, String.valueOf(currentPage));
                            break;
                        }
                        case "lastpage": {
                            if (currentPage == pageCount) break;
                            this.getView().setEnable(Boolean.TRUE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                            this.getView().setEnable(Boolean.FALSE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                            this.batchSetEntry(entry, entryNum, pageCount);
                            this.getModel().setValue(CURRENTPAGENUM + entryNum, (Object)pageCount);
                            this.getView().getPageCache().put(CURRENTPAGE + entryNum, pageCountText);
                            break;
                        }
                        case "previouspage": {
                            if (currentPage == 1) break;
                            if (--currentPage == 1) {
                                this.getView().setEnable(Boolean.FALSE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                            }
                            this.getView().setEnable(Boolean.TRUE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                            this.batchSetEntry(entry, entryNum, currentPage);
                            this.getModel().setValue(CURRENTPAGENUM + entryNum, (Object)currentPage);
                            this.getView().getPageCache().put(CURRENTPAGE + entryNum, String.valueOf(currentPage));
                            break;
                        }
                        case "firstpage": {
                            if (currentPage == 1) break;
                            currentPage = 1;
                            this.getView().setEnable(Boolean.TRUE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                            this.getView().setEnable(Boolean.FALSE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                            this.batchSetEntry(entry, entryNum, currentPage);
                            this.getModel().setValue(CURRENTPAGENUM + entryNum, (Object)currentPage);
                            this.getView().getPageCache().put(CURRENTPAGE + entryNum, String.valueOf(currentPage));
                            break;
                        }
                    }
                    if (entryGrid.isStopUpdateCell()) {
                        entryGrid.setStopUpdateCell(false);
                        entryGrid.bindData(new BindingContext((Object)this.getModel().getEntryEntity(treeentryEntityKey)));
                    }
                }
            }
        }
    }

    public void countLabel(LinkedHashMap<String, Object> xbillEntryJsonMap) {
        int treeEntryNum = 0;
        if (!ChangeModelUtil.isNull(xbillEntryJsonMap)) {
            for (Map.Entry<String, Object> entry : xbillEntryJsonMap.entrySet()) {
                Object entryJSONArray = entry.getValue();
                if (!(entryJSONArray instanceof JSONArray)) continue;
                int sum = 0;
                int upSum = 0;
                int newSum = 0;
                int delSum = 0;
                String entryName = "";
                JSONArray treeEntrys = (JSONArray)entryJSONArray;
                if (treeEntryNum > 5) {
                    treeEntryNum = 5;
                }
                block11: for (Object entryjson : treeEntrys) {
                    Map lineEntryjsonmap;
                    if (!(entryjson instanceof Map) || ChangeModelUtil.isNull(lineEntryjsonmap = (Map)entryjson)) continue;
                    String lineChangeType = (String)lineEntryjsonmap.get("f");
                    entryName = ChangeResumeDetailPlugin.getTransString((String)lineEntryjsonmap.get(KEY_NEWVALUE));
                    if (ChangeModelUtil.isNull(lineChangeType)) continue;
                    switch (lineChangeType) {
                        case "+": {
                            ++newSum;
                            break;
                        }
                        case "-": {
                            ++delSum;
                            ++sum;
                            continue block11;
                        }
                        case "*": {
                            ++upSum;
                            break;
                        }
                    }
                    if (!KEY_EQUAL.equals(lineChangeType)) {
                        ++sum;
                    }
                    if (!KEY_EQUAL.equals(lineChangeType)) continue;
                    for (Object fieldjson : lineEntryjsonmap.values()) {
                        if (!(fieldjson instanceof JSONArray)) continue;
                        JSONArray childEntrys = (JSONArray)fieldjson;
                        String childChangeType = KEY_EQUAL;
                        for (Object childEntryjson : childEntrys) {
                            Map childMaps;
                            if (!(childEntryjson instanceof Map) || ChangeModelUtil.isNull(childMaps = (Map)childEntryjson) || KEY_EQUAL.equals(childMaps.get("f"))) continue;
                            childChangeType = KEY_UPDATE;
                            break;
                        }
                        if (!KEY_UPDATE.equals(childChangeType)) continue;
                        ++sum;
                        ++upSum;
                    }
                }
                if (sum == 0) continue;
                String treeentryEntityKey = "treeentryentity" + treeEntryNum;
                this.getView().getPageCache().put(treeentryEntityKey + ENTRYKEY, entry.getKey());
                this.setCountLabel(sum, upSum, newSum, delSum, treeEntryNum);
                this.setEntryName("entity" + treeEntryNum, entryName);
                this.isNeedPaged(sum, String.valueOf(treeEntryNum));
                ++treeEntryNum;
            }
        }
        for (int i = treeEntryNum; i < 6; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entity" + i});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (fieldName.contains(CURRENTPAGENUM)) {
            String currentPageText;
            String pageCountText;
            String entryNum = String.valueOf(fieldName.charAt(fieldName.length() - 1));
            int currentPage = (Integer)this.getModel().getValue(fieldName);
            if (currentPage < 1) {
                currentPage = 1;
                this.getModel().setValue(fieldName, (Object)1);
            }
            if (StringUtils.isEmpty((CharSequence)(pageCountText = this.getView().getPageCache().get(PAGECOUNT + entryNum)))) {
                return;
            }
            int pageCountNum = Integer.parseInt(pageCountText);
            if (currentPage > pageCountNum) {
                currentPage = pageCountNum;
                this.getModel().setValue(fieldName, (Object)currentPage);
            }
            if (StringUtils.isEmpty((CharSequence)(currentPageText = this.getView().getPageCache().get(CURRENTPAGE + entryNum)))) {
                return;
            }
            int currentPageNum = Integer.parseInt(currentPageText);
            if (currentPage == currentPageNum) {
                return;
            }
            String xbillEntryJson = this.getView().getPageCache().get(XBILL_ENTRY_JSON);
            if (ChangeModelUtil.isNull(xbillEntryJson)) {
                xbillEntryJson = (String)this.getModel().getValue("crdentryjson_tag");
            }
            LinkedHashMap xbillEntryJsonMap = (LinkedHashMap)JSON.parseObject((String)xbillEntryJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            String treeentryEntityKey = "treeentryentity" + entryNum;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(treeentryEntityKey);
            String entrykey = this.getView().getPageCache().get(treeentryEntityKey + ENTRYKEY);
            Object entry = xbillEntryJsonMap.get(entrykey);
            if (currentPage == 1) {
                this.getView().setEnable(Boolean.TRUE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                this.getView().setEnable(Boolean.FALSE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                this.batchSetEntry(entry, entryNum, currentPage);
                this.getView().getPageCache().put(CURRENTPAGE + entryNum, String.valueOf(currentPage));
            } else if (currentPage == pageCountNum) {
                this.getView().setEnable(Boolean.TRUE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                this.getView().setEnable(Boolean.FALSE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                this.batchSetEntry(entry, entryNum, currentPage);
                this.getView().getPageCache().put(CURRENTPAGE + entryNum, pageCountText);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{PREVIOUSPAGE + entryNum, FIRSTPAGE + entryNum});
                this.getView().setEnable(Boolean.TRUE, new String[]{LASTPAGE + entryNum, NEXTPAGE + entryNum});
                this.batchSetEntry(entry, entryNum, currentPage);
                this.getView().getPageCache().put(CURRENTPAGE + entryNum, String.valueOf(currentPage));
            }
            if (entryGrid.isStopUpdateCell()) {
                entryGrid.setStopUpdateCell(false);
                entryGrid.bindData(new BindingContext((Object)this.getModel().getEntryEntity(treeentryEntityKey)));
            }
        }
    }

    public void setXBillHead(String xbillHeardJson) {
        LinkedHashMap billHeadChangeJson = (LinkedHashMap)JSON.parseObject((String)xbillHeardJson, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
        if (billHeadChangeJson == null) {
            return;
        }
        String entryName = (String)billHeadChangeJson.get(KEY_NEWVALUE);
        if (!ChangeModelUtil.isNull(entryName)) {
            this.setEntryName("entity", entryName);
        }
        EntryGrid billHeardEntry = (EntryGrid)this.getView().getControl("billxinfo");
        billHeardEntry.setSplitPage(false);
        String lineChangeType = (String)billHeadChangeJson.get("f");
        if (KEY_EQUAL.equals(lineChangeType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billxinfo"});
        }
        int upSum = 0;
        for (Object entry : billHeadChangeJson.values()) {
            String fieldIsequal;
            Map billHeardFieldMap;
            if (!(entry instanceof Map) || ChangeModelUtil.isNull(billHeardFieldMap = (Map)entry) || KEY_EQUAL.equals(fieldIsequal = (String)billHeardFieldMap.get(KEY_ISEQUALS))) continue;
            int row = this.getModel().createNewEntryRow("billxinfo");
            if (!ChangeModelUtil.isNull(billHeardFieldMap.get(KEY_FIELDNAME))) {
                this.getModel().setValue("fieldname", (Object)ChangeResumeDetailPlugin.getTransString((String)billHeardFieldMap.get(KEY_FIELDNAME)), row);
            }
            if (!ChangeModelUtil.isNull(billHeardFieldMap.get(KEY_OLDVALUE))) {
                this.getModel().setValue("oldvalue", (Object)ChangeResumeDetailPlugin.getTransString((String)billHeardFieldMap.get(KEY_OLDVALUE)), row);
            }
            if (!ChangeModelUtil.isNull(billHeardFieldMap.get(KEY_NEWVALUE))) {
                this.getModel().setValue("newvalue", (Object)ChangeResumeDetailPlugin.getTransString((String)billHeardFieldMap.get(KEY_NEWVALUE)), row);
                ArrayList<CellStyle> csList = new ArrayList<CellStyle>(1);
                CellStyle cs = new CellStyle();
                cs.setForeColor("#ff0000");
                cs.setFieldKey("newvalue");
                cs.setRow(row);
                csList.add(cs);
                billHeardEntry.setCellStyle(csList);
            }
            this.getModel().setValue("changetype", (Object)BizChangeTypeEnum.UPDATE.getName(), row);
            if (KEY_UPDATE.equals(fieldIsequal)) {
                this.getModel().setValue("isrealchange", (Object)Boolean.TRUE, row);
                ++upSum;
            }
            billHeardEntry.setRowBackcolor("#ecf6ff", new int[]{row});
        }
        Label xsum = (Label)this.getView().getControl("xsum");
        xsum.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"ChangeResumeDetailPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), upSum));
        Label xupdate = (Label)this.getView().getControl("xupdate");
        xupdate.setText(BizChangeTypeEnum.UPDATE.getName() + "(" + upSum + ")");
        if (upSum == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entity"});
        }
    }

    public void batchSetEntry(Object entry, String treeEntryNum, int currentPage) {
        if (!ChangeModelUtil.isNull(entry) && !ChangeModelUtil.isNull(treeEntryNum)) {
            String entryKeyName = "treeentryentity" + treeEntryNum;
            if (entry instanceof JSONArray) {
                IDataModel dataModel = this.getModel();
                int startIndex = this.rowCount * (currentPage - 1);
                if (startIndex == 0) {
                    startIndex = -1;
                }
                int endIndex = this.rowCount * currentPage;
                int sum = 0;
                JSONArray treeEntrys = (JSONArray)entry;
                TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(entryKeyName);
                this.getModel().deleteEntryData(entryKeyName);
                entryGrid.setStopUpdateCell(true);
                for (Object entryjson : treeEntrys) {
                    Map lineEntryjsonmap;
                    if (!(entryjson instanceof Map) || ChangeModelUtil.isNull(lineEntryjsonmap = (Map)entryjson)) continue;
                    String lineColor = "#ecf6ff";
                    String lineChangeType = (String)lineEntryjsonmap.get("f");
                    String entryName = ChangeResumeDetailPlugin.getTransString((String)lineEntryjsonmap.get(KEY_NEWVALUE));
                    if (ChangeModelUtil.isNull(lineChangeType)) continue;
                    switch (lineChangeType) {
                        case "+": {
                            lineColor = "#d5fbe2";
                            break;
                        }
                        case "-": {
                            lineColor = "#fef1d0";
                            break;
                        }
                        case "*": {
                            lineColor = "#ecf6ff";
                            break;
                        }
                    }
                    int rowNum = -1;
                    if (!KEY_EQUAL.equals(lineChangeType)) {
                        if (startIndex < ++sum && endIndex >= sum) {
                            Map fieldMap;
                            ArrayList<JSONArray> jsonArrayList = new ArrayList<JSONArray>(1024);
                            ArrayList<Map> fields = new ArrayList<Map>();
                            for (Object fieldjson : lineEntryjsonmap.values()) {
                                if (fieldjson instanceof Map) {
                                    fieldMap = (Map)fieldjson;
                                    if (ChangeModelUtil.isNull(fieldMap)) continue;
                                    if (rowNum == -1) {
                                        rowNum = dataModel.createNewEntryRow(entryKeyName);
                                        dataModel.setValue(SEQ_ENTRY + treeEntryNum, (Object)(entryName + lineEntryjsonmap.get("l")), rowNum);
                                        dataModel.setValue("changetype_entry" + treeEntryNum, (Object)this.getChangeType(lineChangeType), rowNum);
                                        entryGrid.setRowBackcolor(lineColor, new int[]{rowNum});
                                    }
                                    fields.add(fieldMap);
                                    continue;
                                }
                                if (!(fieldjson instanceof JSONArray)) continue;
                                jsonArrayList.add((JSONArray)fieldjson);
                            }
                            int[] lines = dataModel.batchInsertEntryRow(entryKeyName, rowNum, fields.size());
                            for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                                fieldMap = (Map)fields.get(lineNum);
                                this.setEntryValue(treeEntryNum, fieldMap, lines[lineNum]);
                                String isequals = (String)fieldMap.get(KEY_ISEQUALS);
                                if (!KEY_UPDATE.equals(lineChangeType) || ChangeModelUtil.isNull(isequals) || KEY_EQUAL.equals(isequals)) continue;
                                ArrayList<CellStyle> csList = new ArrayList<CellStyle>(1);
                                CellStyle cs = new CellStyle();
                                cs.setForeColor("#ff0000");
                                cs.setFieldKey(NEWVALUE_ENTRY + treeEntryNum);
                                cs.setRow(lines[lineNum]);
                                csList.add(cs);
                                entryGrid.setCellStyle(csList);
                            }
                            entryGrid.setRowBackcolor(lineColor, lines);
                            for (JSONArray childTreeEntry : jsonArrayList) {
                                int r = dataModel.insertEntryRow(entryKeyName, rowNum);
                                entryGrid.setRowBackcolor(lineColor, new int[]{r});
                                this.childTreeEntrys(childTreeEntry, r, treeEntryNum, lineEntryjsonmap, (EntryGrid)entryGrid);
                            }
                        } else if (sum > endIndex) {
                            return;
                        }
                    }
                    if (startIndex < sum && endIndex >= sum) {
                        if (!KEY_EQUAL.equals(lineChangeType)) continue;
                        for (Object fieldjson : lineEntryjsonmap.values()) {
                            if (!(fieldjson instanceof JSONArray)) continue;
                            JSONArray childEntrys = (JSONArray)fieldjson;
                            String childChangeType = KEY_EQUAL;
                            for (Object childEntryjson : childEntrys) {
                                Map childMaps;
                                if (!(childEntryjson instanceof Map) || ChangeModelUtil.isNull(childMaps = (Map)childEntryjson) || KEY_EQUAL.equals(childMaps.get("f"))) continue;
                                childChangeType = KEY_UPDATE;
                                break;
                            }
                            if (!KEY_UPDATE.equals(childChangeType)) continue;
                            if (startIndex < ++sum && endIndex >= sum) {
                                rowNum = dataModel.createNewEntryRow(entryKeyName);
                                dataModel.setValue(SEQ_ENTRY + treeEntryNum, (Object)(entryName + lineEntryjsonmap.get("l")), rowNum);
                                dataModel.setValue("changetype_entry" + treeEntryNum, (Object)this.getChangeType(lineChangeType), rowNum);
                                int row = dataModel.insertEntryRow(entryKeyName, rowNum);
                                entryGrid.setRowBackcolor("#ecf6ff", new int[]{rowNum, row});
                                this.childTreeEntrys(childEntrys, row, treeEntryNum, lineEntryjsonmap, (EntryGrid)entryGrid);
                                continue;
                            }
                            if (sum <= endIndex) continue;
                            return;
                        }
                        continue;
                    }
                    if (endIndex >= sum) continue;
                    return;
                }
            }
        }
    }

    public void childTreeEntrys(JSONArray childTreeEntry, int rowNum, String treeEntryNum, Map<String, Object> jsonmap, EntryGrid entryGrid) {
        IDataModel dataModel = this.getModel();
        String treeentryentity = "treeentryentity" + treeEntryNum;
        int sum = 0;
        for (Object childEntryjson : childTreeEntry) {
            String lineChangeType;
            Object lineChildEntryMaps;
            if (!(childEntryjson instanceof Map) || ChangeModelUtil.isNull(lineChildEntryMaps = (Map)childEntryjson) || ChangeModelUtil.isNull(lineChangeType = (String)lineChildEntryMaps.get("f"))) continue;
            switch (lineChangeType) {
                case "+": 
                case "-": 
                case "*": {
                    ++sum;
                    break;
                }
            }
        }
        if (sum == 0) {
            dataModel.deleteEntryRow(treeentryentity, rowNum);
            return;
        }
        int[] lineNums = dataModel.batchInsertEntryRow(treeentryentity, rowNum, sum);
        int lineSign = 0;
        block26: for (Object childEntryjson : childTreeEntry) {
            String lineChangeType;
            Map lineChildEntryMaps;
            if (!(childEntryjson instanceof Map) || ChangeModelUtil.isNull(lineChildEntryMaps = (Map)childEntryjson) || !ChangeModelUtil.isNull(lineChangeType = (String)lineChildEntryMaps.get("f")) && KEY_EQUAL.equals(lineChangeType)) continue;
            int rows = lineNums[lineSign];
            ++lineSign;
            if (!ChangeModelUtil.isNull(lineChangeType)) {
                switch (lineChangeType) {
                    case "-": 
                    case "=": {
                        continue block26;
                    }
                }
            }
            ArrayList<Map> fields = new ArrayList<Map>();
            for (Object entry : lineChildEntryMaps.values()) {
                String childFieldIsequals;
                Map childFieldMap;
                if (!(entry instanceof Map) || ChangeModelUtil.isNull(childFieldMap = (Map)entry) || !ChangeModelUtil.isNull(childFieldIsequals = (String)childFieldMap.get(KEY_ISEQUALS)) && KEY_EQUAL.equals(childFieldIsequals)) continue;
                fields.add(childFieldMap);
            }
            int[] childLineNums = dataModel.batchInsertEntryRow(treeentryentity, rows, fields.size());
            if (lineNums.length <= lineSign || childLineNums.length <= 0) continue;
            lineNums[lineSign] = lineNums[lineSign - 1] + childLineNums.length + 1;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(treeentryentity);
        lineSign = 0;
        int deleteSum = 0;
        int updateSum = 0;
        int newSum = 0;
        String childEntryName = null;
        block28: for (Object childEntryjson : childTreeEntry) {
            String lineChangeType;
            Map lineChildEntryMaps;
            if (!(childEntryjson instanceof Map) || ChangeModelUtil.isNull(lineChildEntryMaps = (Map)childEntryjson) || !ChangeModelUtil.isNull(lineChangeType = (String)lineChildEntryMaps.get("f")) && KEY_EQUAL.equals(lineChangeType)) continue;
            if (lineNums.length <= lineSign) {
                return;
            }
            int rows = lineNums[lineSign];
            ++lineSign;
            childEntryName = ChangeResumeDetailPlugin.getTransString((String)lineChildEntryMaps.get(KEY_NEWVALUE));
            DynamicObject rowsEntryObj = (DynamicObject)dynamicObjects.get(rows);
            rowsEntryObj.set(SEQ_ENTRY + treeEntryNum, (Object)(childEntryName + lineChildEntryMaps.get("l") + "_" + this.getChangeType(lineChangeType)));
            String childLineColor = null;
            if (!ChangeModelUtil.isNull(lineChangeType)) {
                switch (lineChangeType) {
                    case "+": {
                        childLineColor = "#d5fbe2";
                        ++newSum;
                        break;
                    }
                    case "-": {
                        ++deleteSum;
                        childLineColor = "#fef1d0";
                        entryGrid.setRowBackcolor(childLineColor, new int[]{rows});
                        continue block28;
                    }
                    case "*": {
                        childLineColor = "#ecf6ff";
                        ++updateSum;
                        break;
                    }
                }
            }
            entryGrid.setRowBackcolor(childLineColor, new int[]{rows});
            ArrayList<Map> fields = new ArrayList<Map>(1024);
            for (Object entry : lineChildEntryMaps.values()) {
                String childFieldIsequals;
                Map childFieldMap;
                if (!(entry instanceof Map) || ChangeModelUtil.isNull(childFieldMap = (Map)entry) || ChangeModelUtil.isNull(childFieldIsequals = (String)childFieldMap.get(KEY_ISEQUALS)) || KEY_EQUAL.equals(childFieldIsequals)) continue;
                fields.add(childFieldMap);
            }
            int lineNum = 0;
            int[] rowBackcolors = new int[fields.size()];
            for (int x = 0; x < dynamicObjects.size(); ++x) {
                DynamicObject childRowsEntry = (DynamicObject)dynamicObjects.get(x);
                if (((Long)rowsEntryObj.getPkValue()).longValue() != childRowsEntry.getLong("pid")) continue;
                rowBackcolors[lineNum] = x;
                String fieldName = (String)((Map)fields.get(lineNum)).get(KEY_FIELDNAME);
                String oldValue = (String)((Map)fields.get(lineNum)).get(KEY_OLDVALUE);
                String newValue = (String)((Map)fields.get(lineNum)).get(KEY_NEWVALUE);
                childRowsEntry.set("fieldname_entry" + treeEntryNum, (Object)fieldName);
                childRowsEntry.set("oldvalue_entry" + treeEntryNum, (Object)oldValue);
                childRowsEntry.set(NEWVALUE_ENTRY + treeEntryNum, (Object)newValue);
                ++lineNum;
            }
            entryGrid.setRowBackcolor(childLineColor, rowBackcolors);
        }
        if (deleteSum == 0 && updateSum == 0 && newSum == 0) {
            dataModel.deleteEntryRow(treeentryentity, rowNum);
        } else {
            dataModel.setValue(SEQ_ENTRY + treeEntryNum, (Object)((String)jsonmap.get(KEY_NEWVALUE) + jsonmap.get("l") + "_" + childEntryName + "(" + BizChangeTypeEnum.DELETE.getName() + deleteSum + "\u3001" + BizChangeTypeEnum.UPDATE.getName() + updateSum + "\u3001" + BizChangeTypeEnum.ADDNEW.getName() + newSum + ")"), rowNum);
        }
    }

    public void setEntryName(String entryen, String name) {
        HashMap<String, LocaleString> map1 = new HashMap<String, LocaleString>();
        map1.put("text", new LocaleString(name));
        this.getView().updateControlMetadata(entryen, map1);
    }

    public void setEntryValue(String treeEntryNum, Map<String, Object> entryMap, int rows) {
        if (ChangeModelUtil.isNull(entryMap) || ChangeModelUtil.isNull(rows)) {
            return;
        }
        String fieldName = (String)entryMap.get(KEY_FIELDNAME);
        String oldValue = (String)entryMap.get(KEY_OLDVALUE);
        String newValue = (String)entryMap.get(KEY_NEWVALUE);
        if (!ChangeModelUtil.isNull(fieldName)) {
            this.getModel().setValue("fieldname_entry" + treeEntryNum, (Object)ChangeResumeDetailPlugin.getTransString(fieldName), rows);
        }
        if (!ChangeModelUtil.isNull(oldValue)) {
            this.getModel().setValue("oldvalue_entry" + treeEntryNum, (Object)ChangeResumeDetailPlugin.getTransString(oldValue), rows);
        }
        if (!ChangeModelUtil.isNull(newValue)) {
            this.getModel().setValue(NEWVALUE_ENTRY + treeEntryNum, (Object)ChangeResumeDetailPlugin.getTransString(newValue), rows);
        }
    }

    public String getChangeType(String f) {
        if (ChangeModelUtil.isNull(f)) {
            return "";
        }
        if (KEY_ADD.equals(f)) {
            return BizChangeTypeEnum.ADDNEW.getName();
        }
        if (KEY_DELETE.equals(f)) {
            return BizChangeTypeEnum.DELETE.getName();
        }
        if (KEY_UPDATE.equals(f)) {
            return BizChangeTypeEnum.UPDATE.getName();
        }
        return f;
    }

    public void setCountLabel(int sum, int upSum, int newSum, int delSum, int treeEntryNum) {
        Label xsum = (Label)this.getView().getControl("sum" + treeEntryNum);
        xsum.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"ChangeResumeDetailPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), sum));
        Label updatesum = (Label)this.getView().getControl("update" + treeEntryNum);
        updatesum.setText(BizChangeTypeEnum.UPDATE.getName() + "(" + upSum + ")");
        Label newsum = (Label)this.getView().getControl("new" + treeEntryNum);
        newsum.setText(BizChangeTypeEnum.ADDNEW.getName() + "(" + newSum + ")");
        Label deletesum = (Label)this.getView().getControl("delete" + treeEntryNum);
        deletesum.setText(BizChangeTypeEnum.DELETE.getName() + "(" + delSum + ")");
    }

    public static String getTransString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            if (str.contains("&#123;")) {
                str = str.replaceAll("&#123;", "\\\\");
            }
            if (str.contains("&#124;")) {
                str = str.replaceAll("&#124;", "\"");
            }
        } else {
            str = "";
        }
        return str;
    }

    public void isNeedPaged(int sum, String treeEntryNum) {
        if (sum > this.rowCount) {
            int pageCount = sum / this.rowCount + (sum % this.rowCount > 0 ? 1 : 0);
            Label pageCountLabel = (Label)this.getView().getControl(PAGECOUNT + treeEntryNum);
            pageCountLabel.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"ChangeResumeDetailPlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), pageCount));
            Label yeLabel = (Label)this.getView().getControl("ye" + treeEntryNum);
            yeLabel.setText("/" + pageCount);
            this.getView().getPageCache().put(PAGECOUNT + treeEntryNum, String.valueOf(pageCount));
            Label nextPageLabel = (Label)this.getView().getControl(NEXTPAGE + treeEntryNum);
            nextPageLabel.setText(">");
            Label lastPageLabel = (Label)this.getView().getControl(LASTPAGE + treeEntryNum);
            lastPageLabel.setText(">|");
            Label previousPageLabel = (Label)this.getView().getControl(PREVIOUSPAGE + treeEntryNum);
            previousPageLabel.setText("<");
            Label firstPageLabel = (Label)this.getView().getControl(FIRSTPAGE + treeEntryNum);
            firstPageLabel.setText("|<");
            this.getModel().setValue(CURRENTPAGENUM + treeEntryNum, (Object)1);
            this.getView().getPageCache().put(CURRENTPAGE + treeEntryNum, String.valueOf(1));
            this.getView().setEnable(Boolean.FALSE, new String[]{PREVIOUSPAGE + treeEntryNum, FIRSTPAGE + treeEntryNum});
            this.getView().setEnable(Boolean.FALSE, new String[]{"treeentryentity" + treeEntryNum});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pageflexpanelap" + treeEntryNum});
            this.getView().setEnable(Boolean.FALSE, new String[]{"treeentryentity" + treeEntryNum});
        }
    }
}

