/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class ChangeResumeListPlugin
extends AbstractListPlugin {
    public static final String CARDFLEXPANELAP = "cardflexpanelap";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object srcBillId = showParameter.getCustomParam("srcbillid");
        if (!ChangeModelUtil.isNull(srcBillId)) {
            QFilter qFilter1 = new QFilter("srcbillid", "=", srcBillId);
            QFilter qFilter2 = QFilter.isNotNull((String)"xbillentity");
            QFilter qFilter3 = new QFilter("xbillentity", "!=", (Object)"");
            List listFilter = e.getQFilters();
            listFilter.add(qFilter1);
            listFilter.add(qFilter2);
            listFilter.add(qFilter3);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection dynamicObjects = e.getPageData();
        IListView listview = (IListView)this.getView();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billInfo = dynamicObject.get("xbillid") + "," + dynamicObject.get("xbillentity");
            if (ChangeModelUtil.isNull(billInfo)) continue;
            listview.getPageCache().put(String.valueOf(dynamicObject.getPkValue()), billInfo);
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object xbillIdObj = showParameter.getCustomParam("xbillid");
        if (dynamicObjects.size() > 0) {
            Object pkValue;
            int row = 0;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            if (!ChangeModelUtil.isNull(xbillIdObj)) {
                for (DynamicObject dynamicObj : dynamicObjects) {
                    if (xbillIdObj.equals(dynamicObj.get("xbillid"))) {
                        dynamicObject = dynamicObj;
                        break;
                    }
                    ++row;
                }
            }
            if (!ChangeModelUtil.isNull(pkValue = dynamicObject.getPkValue())) {
                this.getView().getPageCache().put(CARDFLEXPANELAP, String.valueOf(pkValue));
            }
            long xbillId = (Long)dynamicObject.get("xbillid");
            this.showChangeDetails(xbillId);
            this.showBillinfo(xbillId, (String)dynamicObject.get("xbillentity"));
            BillList billList = (BillList)this.getControl("billlistap");
            billList.selectRows(row);
        } else {
            IFormView formView = this.getView().getParentView();
            formView.setVisible(Boolean.FALSE, new String[]{"change_tabap"});
            formView.setVisible(Boolean.FALSE, new String[]{"billinfo"});
            this.getView().sendFormAction(formView);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container billList2 = (Container)this.getView().getControl(CARDFLEXPANELAP);
        billList2.addClickListener((ClickListener)this);
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (CARDFLEXPANELAP.equals(key)) {
            DynamicObject data;
            String[] xbillinfo;
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            Long selectId = (Long)row.getPrimaryKeyValue();
            String rowID = this.getView().getPageCache().get(CARDFLEXPANELAP);
            if (!ChangeModelUtil.isNull(rowID) && rowID.equals(String.valueOf(selectId))) {
                return;
            }
            this.getView().getPageCache().put(CARDFLEXPANELAP, String.valueOf(selectId));
            IListView listview = (IListView)this.getView();
            long billID = 0L;
            String billentity = null;
            String xbill = listview.getPageCache().get(String.valueOf(selectId));
            if (!ChangeModelUtil.isNull(xbill) && (xbillinfo = xbill.split(",")).length == 2) {
                if (!ChangeModelUtil.isNull(xbillinfo[0])) {
                    billID = Long.parseLong(xbillinfo[0]);
                }
                billentity = xbillinfo[1];
            }
            if ((ChangeModelUtil.isNull(billentity) || billID == 0L) && (data = ChangeResumeBusiness.getChangeResumeById(billID)) != null) {
                billentity = (String)data.get("xbillentity");
                billID = (Long)data.get("xbillid");
            }
            this.showBillinfo(billID, billentity);
            this.showChangeDetails(billID);
        }
    }

    public void showChangeDetails(long billID) {
        DynamicObject dys = ChangeResumeBusiness.getChangeResumeDetailByXBillId(billID);
        IFormView formView = this.getView().getParentView();
        if (dys != null) {
            Object canResumeCardID = dys.getPkValue();
            if (!ChangeModelUtil.isNull(canResumeCardID)) {
                long xbilllogtplID = (Long)canResumeCardID;
                Tab tab = (Tab)formView.getControl("tabap");
                if (tab == null) {
                    return;
                }
                tab.activeTab("change_tabap");
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("xbilllogtpl");
                showParameter.setFormId("bdtaxr_changeresumedetail");
                showParameter.setPkId((Object)xbilllogtplID);
                showParameter.setBillStatus(BillOperationStatus.EDIT);
                formView.showForm((FormShowParameter)showParameter);
                formView.setVisible(Boolean.TRUE, new String[]{"change_tabap"});
                formView.updateView("change_tabap");
            } else {
                formView.setVisible(Boolean.FALSE, new String[]{"change_tabap"});
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"change_tabap"});
            Tab tab = (Tab)formView.getControl("tabap");
            tab.activeTab("billinfo_tabap");
        }
        this.getView().sendFormAction(formView);
    }

    public void showBillinfo(long billID, String billentity) {
        IFormView formView = this.getView().getParentView();
        if (billID != 0L && !ChangeModelUtil.isNull(billentity)) {
            if (ChangeResumeBusiness.existsChangeResumeByXBillId(billID)) {
                formView.setVisible(Boolean.TRUE, new String[]{"billinfo"});
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("billinfo");
                showParameter.setFormId(billentity);
                showParameter.setPkId((Object)billID);
                showParameter.setBillStatus(BillOperationStatus.VIEW);
                formView.showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ChangeResumeListPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                formView.setVisible(Boolean.FALSE, new String[]{"billinfo"});
            }
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"billinfo"});
        }
        this.getView().sendFormAction(formView);
    }
}

