/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.pojo.MethodParameter;

public class CustomParameterPlugin
extends AbstractFormPlugin {
    public static final String PARMVALUE = "parmvalue";
    public static final String PARMTYPE = "parmtype";
    public static final String DESCRIPTION = "description";
    public static final String PARMNAME = "parmname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARMVALUE, "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customParameter = this.getView().getFormShowParameter().getCustomParam("customparameter");
        IDataModel model = this.getModel();
        if (!(customParameter instanceof List)) {
            return;
        }
        List customParameterList = (List)customParameter;
        customParameterList.forEach(methodParameter -> {
            int rowId = model.createNewEntryRow("entryentity");
            model.setValue(PARMNAME, methodParameter.get("name"), rowId);
            model.setValue(PARMTYPE, methodParameter.get("type"), rowId);
            model.setValue(PARMVALUE, methodParameter.get("val"), rowId);
            model.setValue(DESCRIPTION, methodParameter.get(DESCRIPTION), rowId);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (PARMVALUE.equals(key)) {
            String parmtype = (String)this.getModel().getValue(PARMTYPE);
            if (!"jsonarray".equals(parmtype)) {
                return;
            }
            FormShowParameter jsonParameter = new FormShowParameter();
            jsonParameter.getOpenStyle().setShowType(ShowType.Modal);
            jsonParameter.setFormId("bdtaxr_customjson");
            jsonParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customjson"));
            jsonParameter.setHasRight(true);
            String parmValue = (String)this.getModel().getValue(PARMVALUE);
            if (!"".equals(parmValue)) {
                jsonParameter.setCustomParam("jsonparameter", JSON.parseObject((String)parmValue, Map.class));
            }
            this.getView().showForm(jsonParameter);
        } else if ("btnok".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List entryList = entryEntity.stream().map(row -> new MethodParameter(row.getString(PARMNAME), row.getString(PARMTYPE), row.getString(PARMVALUE), row.getString(DESCRIPTION))).collect(Collectors.toList());
            this.getView().returnDataToParent(entryList);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (!"customjson".equals(actionId)) {
            return;
        }
        Map result = (Map)evt.getReturnData();
        if (result == null || result.size() <= 0) {
            return;
        }
        this.getModel().setValue(PARMVALUE, (Object)SerializationUtils.toJsonString((Object)result));
    }
}

